/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.common.ALEipConstants;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.modules.screens.RawScreen;
import org.apache.turbine.util.RunData;

public abstract class ALCSVScreen
extends RawScreen {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALCSVScreen.class.getName());
    private static final String CONTENT_TYPE = "text/json;charset=" + ALEipConstants.DEF_CONTENT_ENCODING;
    public static final String DEF_CSV_FILE_ENCODING = "Shift_JIS";
    private String csvFileEncoding = "Shift_JIS";

    protected void doOutput(RunData rundata) throws Exception {
        ServletOutputStream out = null;
        try {
            String result = this.getCSVString(rundata);
            String fileName = this.getFileName();
            HttpServletResponse response = rundata.getResponse();
            response.setHeader("Content-disposition", "attachment; filename=\"" + fileName + "\"");
            response.setHeader("Cache-Control", "aipo");
            response.setHeader("Pragma", "aipo");
            out = response.getOutputStream();
            out.write(result.getBytes(this.csvFileEncoding));
            out.flush();
            out.close();
        }
        catch (Exception e) {
            logger.error((Object)"[ERROR]", (Throwable)e);
        }
    }

    protected String makeOutputItem(String str) {
        String res = "";
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\"') {
                res = res + ch;
            }
            res = res + ch;
        }
        return res;
    }

    protected String getContentType(RunData rundata) {
        return CONTENT_TYPE;
    }

    protected void setCsvEncoding(String encoding) {
        this.csvFileEncoding = encoding;
    }

    protected abstract String getCSVString(RunData var1) throws Exception;

    protected abstract String getFileName();
}

