/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.parameters;

import java.util.Arrays;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.ecs.Element;
import org.apache.ecs.html.Option;
import org.apache.ecs.html.Select;
import org.apache.jetspeed.modules.parameters.ParameterPresentationStyle;
import org.apache.turbine.util.RunData;

public class ListBox
extends ParameterPresentationStyle {
    public static final String SORT = "sort";
    public static final String ITEMS = "items";
    public static final String VALUES = "values";
    public static final String LAYOUT = "layout";
    public static final String LAYOUT_COMBO = "$combo";
    public static final String LAYOUT_LIST = "$list";
    public static final String LIST_SIZE = "listsize";
    public static final String MULTIPLE_CHOICE = "multiplechoice";
    public static final String NULL_IF_EMPTY = "null-if-empty";
    protected String layout = null;
    protected String[] items = null;
    protected String[] values = null;
    protected String size = null;
    protected boolean multiple = false;

    public String getContent(RunData data, String name, String value, Map parms) {
        this.init(data);
        Select select = null;
        select = this.layout.equalsIgnoreCase(LAYOUT_LIST) ? new Select(name, Integer.valueOf(this.size).intValue()) : new Select(name);
        if (this.multiple) {
            select.setMultiple(this.multiple);
        }
        if (this.items != null) {
            boolean sort = Boolean.valueOf((String)this.getParm(SORT, "false"));
            if (sort) {
                Arrays.sort(this.items);
            }
            for (int i = 0; i < this.items.length; ++i) {
                Option option = new Option(this.items[i]).addElement(this.values[i]);
                if (this.multiple) {
                    option.setSelected(value.indexOf(this.items[i]) >= 0);
                } else {
                    option.setSelected(this.items[i].equalsIgnoreCase(value));
                }
                select.addElement((Element)option);
            }
        }
        boolean nullIfEmpty = Boolean.valueOf((String)this.getParm(NULL_IF_EMPTY, "false"));
        if (this.items == null || nullIfEmpty && this.items.length == 0) {
            return null;
        }
        return select.toString();
    }

    protected void init(RunData data) {
        this.layout = (String)this.getParm(LAYOUT, LAYOUT_COMBO);
        this.items = this.getItems(data);
        this.values = this.getValues(data);
        this.size = (String)this.getParm(LIST_SIZE, "1");
        this.multiple = Boolean.valueOf((String)this.getParm(MULTIPLE_CHOICE, "false"));
    }

    protected String[] getItems(RunData data) {
        String[] result = null;
        String list = (String)this.getParm(ITEMS, "");
        StringTokenizer it = new StringTokenizer(list, ",");
        int size = it.countTokens();
        if (size > 0) {
            result = new String[size];
            int i = 0;
            while (it.hasMoreTokens()) {
                String item;
                result[i] = item = it.nextToken();
                ++i;
            }
        }
        return result;
    }

    protected String[] getValues(RunData data) {
        String[] result = null;
        String list = (String)this.getParm(VALUES, "");
        StringTokenizer it = new StringTokenizer(list, ",");
        int size = it.countTokens();
        if (size > 0) {
            result = new String[size];
            int i = 0;
            while (it.hasMoreTokens()) {
                String item;
                result[i] = item = it.nextToken();
                ++i;
            }
        }
        return result;
    }
}

