/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.actions;

import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.orgutils.ALOrgUtilsFactoryService;
import com.aimluck.eip.util.orgutils.ALOrgUtilsHandler;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import org.apache.jetspeed.modules.actions.JetspeedSessionValidator;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.customlocalization.CustomLocalizationService;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.LoginException;
import org.apache.jetspeed.services.security.UnknownUserException;
import org.apache.jetspeed.util.ServiceUtil;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;
import org.apache.velocity.context.Context;

public class ALSessionValidator
extends JetspeedSessionValidator {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALSessionValidator.class.getName());

    public void doPerform(RunData data) throws Exception {
        CustomLocalizationService locService;
        Locale locale;
        JetspeedUser user;
        try {
            super.doPerform(data);
        }
        catch (Throwable other) {
            data.setScreenTemplate(JetspeedResources.getString((String)"template.error"));
            String message = other.getMessage() != null ? other.getMessage() : other.toString();
            data.setMessage(message);
            data.setStackTrace(StringUtils.stackTrace((Throwable)other), other);
            return;
        }
        Context context = TurbineVelocity.getContext((RunData)data);
        ALOrgUtilsHandler handler = ALOrgUtilsFactoryService.getInstance().getOrgUtilsHandler();
        Map<String, String> attribute = handler.getParameters(DatabaseOrmService.getInstance().getOrgId(data));
        for (Map.Entry<String, String> e : attribute.entrySet()) {
            context.put(e.getKey(), (Object)e.getValue());
        }
        context.put("utils", (Object)new ALCommonUtils());
        JetspeedUser loginuser = (JetspeedUser)data.getUser();
        if (loginuser == null || !loginuser.hasLoggedIn()) {
            String username = data.getParameters().getString("username", "");
            String password = data.getParameters().getString("password", "");
            if (username.length() > 0) {
                try {
                    JetspeedUser juser = JetspeedSecurity.login((String)username, (String)password);
                    if (juser != null && "F".equals(juser.getDisabled())) {
                        JetspeedSecurity.saveUser((JetspeedUser)juser);
                    } else {
                        data.setUser((User)JetspeedSecurity.getAnonymousUser());
                        data.setMessage("\u3053\u306e\u30e6\u30fc\u30b6\u30fc\u306f\u73fe\u5728\u7121\u52b9\u5316\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u62c5\u5f53\u8005\u69d8\u306b\u3054\u78ba\u8a8d\u304f\u3060\u3055\u3044\u3002");
                        data.getUser().setHasLoggedIn(Boolean.valueOf(false));
                    }
                }
                catch (LoginException e) {
                    // empty catch block
                }
            }
        }
        if (((user = (JetspeedUser)data.getUser()) == null || !user.hasLoggedIn()) && JetspeedResources.getBoolean((String)"automatic.logon.enable", (boolean)false)) {
            if (data.getRequest().getCookies() != null) {
                String userName = data.getCookies().getString("username", "");
                String loginCookieValue = data.getCookies().getString("logincookie", "");
                if (userName.length() > 0 && loginCookieValue.length() > 0) {
                    try {
                        user = JetspeedSecurity.getUser((String)userName);
                        if (user.getPerm("logincookie", (Object)"").equals(loginCookieValue)) {
                            data.setUser((User)user);
                            user.setHasLoggedIn(Boolean.valueOf(true));
                            user.updateLastLogin();
                            data.save();
                        }
                    }
                    catch (LoginException noSuchUser) {
                    }
                    catch (UnknownUserException unknownUser) {
                        logger.warn((Object)("Username from the cookie was not found: " + userName));
                    }
                    catch (Exception other) {
                        logger.error((Object)other);
                    }
                }
            }
        } else if (!(user != null && user.hasLoggedIn() || JetspeedResources.getBoolean((String)"automatic.logon.enable", (boolean)false))) {
            String uri = data.getRequest().getRequestURI().trim();
            String servername = data.getServletConfig().getServletName();
            String template = data.getScreenTemplate();
            Class<?> cls = null;
            try {
                cls = Class.forName(new StringBuffer().append("com.aimluck.eip.modules.screens.").append(template).toString());
            }
            catch (Exception e) {
                cls = null;
            }
            String newTemplate = null;
            if (cls != null) {
                if (Class.forName("com.aimluck.eip.modules.screens.ALJSONScreen").isAssignableFrom(cls)) {
                    newTemplate = "ALJSONTimeoutScreen";
                } else if (Class.forName("com.aimluck.eip.modules.screens.ALVelocityScreen").isAssignableFrom(cls)) {
                    newTemplate = "ALVelocityTimeoutScreen";
                }
            }
            if (newTemplate != null) {
                data.setScreenTemplate(newTemplate);
                if (data.getSession() != null) {
                    try {
                        data.getSession().invalidate();
                    }
                    catch (IllegalStateException ex) {
                        logger.debug((Object)"\u30bb\u30c3\u30b7\u30e7\u30f3\u306f\u65e2\u306b\u524a\u9664\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
                    }
                }
            } else if (!uri.equals("/" + servername + "/portal/") && !uri.equals("/" + servername + "/portal")) {
                data.setScreenTemplate("Timeout");
                StringBuffer sb = new StringBuffer(uri);
                int count = 0;
                String key = null;
                Enumeration enu = data.getRequest().getParameterNames();
                if (enu.hasMoreElements()) {
                    sb.append("?");
                }
                while (enu.hasMoreElements()) {
                    if (count != 0) {
                        sb.append("&");
                    }
                    key = (String)enu.nextElement();
                    sb.append(key).append("=").append(data.getRequest().getParameter(key));
                    ++count;
                }
                data.getUser().setTemp("redirect", (Object)sb.toString());
                data.getUser().setTemp("alEipUtils", (Object)new ALEipUtils());
                data.getUser().setTemp("alEipManager", (Object)ALEipManager.getInstance());
                if (data.getSession() != null) {
                    try {
                        data.getSession().invalidate();
                    }
                    catch (IllegalStateException ex) {
                        logger.debug((Object)"\u30bb\u30c3\u30b7\u30e7\u30f3\u306f\u65e2\u306b\u524a\u9664\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
                    }
                }
            }
        }
        JetspeedRunData jdata = null;
        try {
            jdata = (JetspeedRunData)data;
        }
        catch (ClassCastException e) {
            logger.error((Object)"The RunData object does not implement the expected interface, please verify the RunData factory settings", (Throwable)e);
            return;
        }
        String language = data.getRequest().getParameter("js_language");
        if (null != language) {
            user.setPerm("language", (Object)language);
        }
        if ((locale = (locService = (CustomLocalizationService)ServiceUtil.getServiceByName((String)"LocalizationService")).getLocale(data)) == null) {
            locale = new Locale(TurbineResources.getString((String)"locale.default.language", (String)"en"), TurbineResources.getString((String)"locale.default.country", (String)"US"));
        }
        data.getUser().setTemp("locale", (Object)locale);
        String paramPortlet = jdata.getParameters().getString("js_peid");
        if (paramPortlet != null && paramPortlet.length() > 0) {
            jdata.setJs_peid(paramPortlet);
        }
    }
}

