/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.actions;

import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import javax.servlet.http.Cookie;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.modules.ActionEvent;
import org.apache.turbine.util.RunData;

public class ALJLogoutUser
extends ActionEvent {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALJLogoutUser.class.getName());

    public void doPerform(RunData data) throws Exception {
        ALEipUser logoutuser;
        String username = data.getParameters().getString("user");
        if (JetspeedResources.getBoolean((String)"automatic.logon.enable", (boolean)false)) {
            Cookie userName = new Cookie("username", "");
            Cookie loginCookie = new Cookie("logincookie", "");
            String comment = JetspeedResources.getString((String)"automatic.logon.cookie.comment", (String)"");
            String domain = JetspeedResources.getString((String)"automatic.logon.cookie.domain");
            String path = JetspeedResources.getString((String)"automatic.logon.cookie.path", (String)"/");
            if (domain == null) {
                String server = data.getServerName();
                domain = "." + server;
            }
            userName.setMaxAge(0);
            userName.setComment(comment);
            userName.setDomain(domain);
            userName.setPath(path);
            loginCookie.setMaxAge(0);
            loginCookie.setComment(comment);
            loginCookie.setDomain(domain);
            loginCookie.setPath(path);
            data.getResponse().addCookie(userName);
            data.getResponse().addCookie(loginCookie);
            if (data.getRequest().getCookies() != null) {
                data.getCookies().remove("logincookie");
                data.getCookies().remove("username");
            }
        }
        if (JetspeedResources.getBoolean((String)"automatic.logout.save", (boolean)false)) {
            JetspeedSecurity.saveUser((JetspeedUser)((JetspeedUser)data.getUserFromSession()));
        }
        JetspeedSecurity.logout();
        if (username != null && !"".equals(username) && (logoutuser = ALEipUtils.getALEipUser(username)) != null) {
            int logoutUserId = (int)logoutuser.getUserId().getValue();
            ALEventlogFactoryService.getInstance().getEventlogHandler().logLogout(logoutUserId);
        }
        data.setMessage(JetspeedResources.getString((String)"logout.message"));
        JetspeedLink jsLink = null;
        data.setScreen(JetspeedResources.getString((String)"screen.homepage"));
        try {
            jsLink = JetspeedLinkFactory.getInstance((RunData)data);
        }
        catch (Exception e) {
            logger.error((Object)"Error getting jsLink", (Throwable)e);
        }
        if (ALEipUtils.isCellularPhone(data)) {
            data.setRedirectURI(jsLink.getHomePage().addQueryData("logout", "T").toString());
        } else {
            data.setRedirectURI(jsLink.getHomePage().toString());
        }
        JetspeedLinkFactory.putInstance((JetspeedLink)jsLink);
        jsLink = null;
        if (data.getSession() != null) {
            try {
                data.getSession().invalidate();
            }
            catch (IllegalStateException ex) {
                logger.debug((Object)"\u30bb\u30c3\u30b7\u30e7\u30f3\u306f\u65e2\u306b\u524a\u9664\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
            }
        }
    }
}

