/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.actions;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALCellularUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.servlet.http.Cookie;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.AccountExpiredException;
import org.apache.jetspeed.services.security.CredentialExpiredException;
import org.apache.jetspeed.services.security.FailedLoginException;
import org.apache.jetspeed.services.security.LoginException;
import org.apache.jetspeed.services.security.nosecurity.FakeJetspeedUser;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.modules.ActionEvent;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.localization.Localization;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;

public class ALJLoginUser
extends ActionEvent {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALJLoginUser.class.getName());
    public static String KEY_MYGROUP = "mygroup";

    public void doPerform(RunData rundata) throws Exception {
        try {
            String message;
            JetspeedRunData data = (JetspeedRunData)rundata;
            String username = data.getParameters().getString("username", "");
            String password = data.getParameters().getString("password", "");
            boolean newUserApproval = JetspeedResources.getBoolean((String)"newuser.approval.enable", (boolean)false);
            String secretkey = data.getParameters().getString("secretkey", null);
            if (secretkey != null) {
                String button1 = data.getParameters().getString("submit1", null);
                if (button1 != null && button1.equalsIgnoreCase("Cancel")) {
                    data.setScreenTemplate(TurbineTemplate.getDefaultScreen());
                    return;
                }
                JetspeedUser user = JetspeedSecurity.getUser((String)username);
                if (user == null) {
                    logger.warn((Object)"JLogin User: Unexpected condition : user is NULL");
                    return;
                }
                String confirm_value = user.getConfirmed();
                if (!secretkey.equals(confirm_value) && !confirm_value.equals("CONFIRMED")) {
                    if (newUserApproval) {
                        data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_KEYNOTVALID"));
                        return;
                    }
                    if (user.getConfirmed().equals("REJECTED")) {
                        data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_KEYNOTVALID"));
                        return;
                    }
                    data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_KEYNOTVALID"));
                    return;
                }
                user.setConfirmed("CONFIRMED");
                data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_WELCOME"));
                JetspeedSecurity.saveUser((JetspeedUser)user);
            }
            JetspeedUser user = null;
            try {
                if (ALCellularUtils.isCellularPhone((RunData)data)) {
                    String key = data.getParameters().getString("key", "").trim();
                    if (key != null && key.length() > 0 && key.contains("_")) {
                        username = key.substring(0, key.lastIndexOf("_"));
                        String base64value = key.substring(key.lastIndexOf("_") + 1);
                        ALStringField tmpname = new ALStringField();
                        tmpname.setTrim(true);
                        tmpname.setNotNull(true);
                        tmpname.setCharacterType(19);
                        tmpname.limitMaxLength(16);
                        tmpname.setValue(username);
                        boolean valid = tmpname.validate(new ArrayList());
                        int length = username.length();
                        for (int i1 = 0; i1 < length; ++i1) {
                            if (!this.isSymbol(username.charAt(i1)) || username.charAt(i1) == "_".charAt(0) || username.charAt(i1) == "-".charAt(0) || username.charAt(i1) == ".".charAt(0)) continue;
                            valid = false;
                            break;
                        }
                        if (valid) {
                            ALEipUser eipuser = ALEipUtils.getALEipUser(username);
                            if (eipuser != null) {
                                if (!ALCellularUtils.getCheckValueForCellLogin(username, eipuser.getUserId().toString()).equals(base64value)) {
                                    username = "";
                                }
                            } else {
                                username = "";
                            }
                        } else {
                            username = "";
                        }
                    }
                    String celluid = ALCellularUtils.getCellularUid(rundata);
                    password = "cellularuid_" + celluid;
                }
                user = JetspeedSecurity.login((String)username, (String)password);
                JetspeedSecurity.saveUser((JetspeedUser)user);
                int loginUserId = Integer.parseInt(user.getUserId());
                ALEventlogFactoryService.getInstance().getEventlogHandler().logLogin(loginUserId);
            }
            catch (LoginException e) {
                message = e.getMessage() != null ? e.getMessage() : e.toString();
                data.setMessage(message);
                data.setUser((User)JetspeedSecurity.getAnonymousUser());
                data.getUser().setHasLoggedIn(Boolean.valueOf(false));
                if (e instanceof FailedLoginException) {
                    if (!this.disableCheck(data)) {
                        logger.info((Object)("JLoginUser: Credential Failure on login for user: " + username));
                        data.setMessage(Localization.getString((RunData)rundata, (String)"PASSWORDFORM_FAILED_MSG"));
                    }
                } else if (e instanceof AccountExpiredException) {
                    logger.info((Object)("JLoginUser: Account Expired for user " + username));
                } else if (e instanceof CredentialExpiredException) {
                    logger.info((Object)("JLoginUser: Credentials expired for user: " + username));
                    data.setMessage(Localization.getString((RunData)rundata, (String)"PASSWORDFORM_EXPIRED_MSG"));
                    data.getParameters().setString("username", username);
                }
                return;
            }
            catch (Throwable other) {
                message = other.getMessage() != null ? other.getMessage() : other.toString();
                data.setMessage(message);
                data.setStackTrace(StringUtils.stackTrace((Throwable)other), other);
                FakeJetspeedUser juser = new FakeJetspeedUser(JetspeedSecurity.getAnonymousUserName(), false);
                data.setUser((User)juser);
                return;
            }
            if ("T".equals(user.getDisabled())) {
                data.setUser((User)JetspeedSecurity.getAnonymousUser());
                data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_ACCOUNT_DISABLED"));
                data.getUser().setHasLoggedIn(Boolean.valueOf(false));
                return;
            }
            if ("N".equals(user.getDisabled())) {
                data.setUser((User)JetspeedSecurity.getAnonymousUser());
                data.setMessage("\u3053\u306e\u30e6\u30fc\u30b6\u30fc\u306f\u73fe\u5728\u7121\u52b9\u5316\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u62c5\u5f53\u8005\u69d8\u306b\u3054\u78ba\u8a8d\u304f\u3060\u3055\u3044\u3002");
                data.getUser().setHasLoggedIn(Boolean.valueOf(false));
                return;
            }
            if (data.getUser().hasLoggedIn()) {
                String redirectUrl;
                boolean userRequestsRememberMe;
                String confirmed;
                if (JetspeedSecurity.isDisableAccountCheckEnabled()) {
                    JetspeedSecurity.resetDisableAccountCheck((String)data.getParameters().getString("username", ""));
                }
                if ((confirmed = data.getUser().getConfirmed()) == null || !confirmed.equals("CONFIRMED")) {
                    if (confirmed != null && confirmed.equals("REJECTED")) {
                        data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_KEYNOTVALID"));
                        data.getUser().setHasLoggedIn(Boolean.valueOf(false));
                        return;
                    }
                    data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_CONFIRMFIRST"));
                    data.getUser().setHasLoggedIn(Boolean.valueOf(false));
                    return;
                }
                boolean automaticLogonEnabled = JetspeedResources.getBoolean((String)"automatic.logon.enable", (boolean)false);
                if (automaticLogonEnabled && (userRequestsRememberMe = data.getParameters().getBoolean("rememberme", false))) {
                    int maxage = JetspeedResources.getInt((String)"automatic.logon.cookie.maxage", (int)-1);
                    String comment = JetspeedResources.getString((String)"automatic.logon.cookie.comment", (String)"");
                    String domain = JetspeedResources.getString((String)"automatic.logon.cookie.domain");
                    String path = JetspeedResources.getString((String)"automatic.logon.cookie.path", (String)"/");
                    if (domain == null) {
                        String server = data.getServerName();
                        domain = "." + server;
                    }
                    String loginCookieValue = null;
                    if (JetspeedResources.getString((String)"automatic.logon.cookie.generation", (String)"everylogon").equals("everylogon")) {
                        loginCookieValue = "" + Math.random();
                        data.getUser().setPerm("logincookie", (Object)loginCookieValue);
                        JetspeedSecurity.saveUser((JetspeedUser)data.getJetspeedUser());
                    } else {
                        loginCookieValue = (String)data.getUser().getPerm("logincookie");
                        if (loginCookieValue == null || loginCookieValue.length() == 0) {
                            loginCookieValue = "" + Math.random();
                            data.getUser().setPerm("logincookie", (Object)loginCookieValue);
                            JetspeedSecurity.saveUser((JetspeedUser)data.getJetspeedUser());
                        }
                    }
                    Cookie userName = new Cookie("username", data.getUser().getUserName());
                    Cookie loginCookie = new Cookie("logincookie", loginCookieValue);
                    userName.setMaxAge(maxage);
                    userName.setComment(comment);
                    userName.setDomain(domain);
                    userName.setPath(path);
                    loginCookie.setMaxAge(maxage);
                    loginCookie.setComment(comment);
                    loginCookie.setDomain(domain);
                    loginCookie.setPath(path);
                    data.getResponse().addCookie(userName);
                    data.getResponse().addCookie(loginCookie);
                }
                if ((redirectUrl = data.getParameters().getString("redirect", "")) != null && !"".equals(redirectUrl)) {
                    JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)data);
                    data.setRedirectURI(redirectUrl);
                    data.getResponse().sendRedirect(redirectUrl);
                    JetspeedLinkFactory.putInstance((JetspeedLink)jsLink);
                    jsLink = null;
                }
                if (ALCellularUtils.isCellularPhone((RunData)data)) {
                    JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
                    rundata.setRedirectURI(jsLink.getPortletById("").addQueryData("action", "controls.Restore").toString());
                    rundata.getResponse().sendRedirect(rundata.getRedirectURI());
                    JetspeedLinkFactory.putInstance((JetspeedLink)jsLink);
                    jsLink = null;
                }
            } else {
                this.disableCheck(data);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    protected boolean isSymbol(char ch) {
        byte[] chars;
        try {
            chars = Character.valueOf(ch).toString().getBytes("shift_jis");
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
        return chars != null && chars.length != 2 && !Character.isDigit(ch) && !Character.isLetter(ch);
    }

    private boolean disableCheck(JetspeedRunData data) {
        boolean disabled = false;
        if (JetspeedSecurity.isDisableAccountCheckEnabled() && (disabled = JetspeedSecurity.checkDisableAccount((String)data.getParameters().getString("username", "")))) {
            data.setMessage(Localization.getString((RunData)data, (String)"JLOGINUSER_ACCOUNT_DISABLED"));
            data.setScreenTemplate(JetspeedResources.getString((String)"logon.disabled.form"));
            data.getUser().setHasLoggedIn(Boolean.valueOf(false));
        }
        return disabled;
    }
}

