/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.common;

import com.aimluck.eip.cayenne.om.account.EipMCompany;
import com.aimluck.eip.cayenne.om.account.EipMPosition;
import com.aimluck.eip.cayenne.om.account.EipMPost;
import com.aimluck.eip.common.ALEipCompany;
import com.aimluck.eip.common.ALEipPosition;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.DatabaseOrmService;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.DataContext;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ALEipManager {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALEipManager.class.getName());
    private static ALEipManager manager = new ALEipManager();
    private JetspeedRunDataService runDataService = null;
    private final Map<String, Map<Integer, ALEipCompany>> companysMap = new LinkedHashMap<String, Map<Integer, ALEipCompany>>();
    private final Map<String, Map<Integer, ALEipPost>> postsMap = new LinkedHashMap<String, Map<Integer, ALEipPost>>();
    private final Map<String, Map<Integer, ALEipPosition>> positionsMap = new LinkedHashMap<String, Map<Integer, ALEipPosition>>();

    private ALEipManager() {
        this.runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
        this.initCompany();
        this.initPost();
        this.initPosition();
    }

    public static ALEipManager getInstance() {
        return manager;
    }

    private void initCompany() {
        this.companysMap.clear();
        String org_id = null;
        List<String> org_list = DatabaseOrmService.getInstance().getOrgKeys();
        Iterator<String> iter = org_list.iterator();
        while (iter.hasNext()) {
            try {
                LinkedHashMap<Integer, ALEipCompany> companyMap = new LinkedHashMap<Integer, ALEipCompany>();
                org_id = iter.next();
                DataContext dataContext = DataContext.createDataContext((String)org_id);
                List<EipMCompany> list = Database.query(dataContext, EipMCompany.class).fetchList();
                for (EipMCompany record : list) {
                    ALEipCompany company = new ALEipCompany();
                    company.initField();
                    company.setCompanyId(record.getCompanyId());
                    company.setCompanyName(record.getCompanyName());
                    companyMap.put(record.getCompanyId(), company);
                }
                this.companysMap.put(org_id, companyMap);
            }
            catch (Exception e) {
                logger.error((Object)("[" + org_id + ":ALEipManager]"), (Throwable)e);
            }
        }
    }

    private void initPost() {
        this.postsMap.clear();
        String org_id = null;
        List<String> org_list = DatabaseOrmService.getInstance().getOrgKeys();
        Iterator<String> iter = org_list.iterator();
        while (iter.hasNext()) {
            try {
                LinkedHashMap<Integer, ALEipPost> postMap = new LinkedHashMap<Integer, ALEipPost>();
                org_id = iter.next();
                DataContext dataContext = DataContext.createDataContext((String)org_id);
                List<EipMPost> list = Database.query(dataContext, EipMPost.class).fetchList();
                Collections.sort(list, new Comparator<EipMPost>(){

                    @Override
                    public int compare(EipMPost l1, EipMPost l2) {
                        return l1.getPostName().compareTo(l2.getPostName());
                    }
                });
                for (EipMPost record : list) {
                    ALEipPost post = new ALEipPost();
                    post.initField();
                    post.setPostId(record.getPostId());
                    post.setPostName(record.getPostName());
                    post.setGroupName(record.getGroupName());
                    postMap.put(record.getPostId(), post);
                }
                this.postsMap.put(org_id, postMap);
            }
            catch (Exception e) {
                logger.error((Object)("[" + org_id + ":ALEipManager]"), (Throwable)e);
            }
        }
    }

    private void initPosition() {
        this.positionsMap.clear();
        String org_id = null;
        List<String> org_list = DatabaseOrmService.getInstance().getOrgKeys();
        Iterator<String> iter = org_list.iterator();
        while (iter.hasNext()) {
            try {
                LinkedHashMap<Integer, ALEipPosition> positionMap = new LinkedHashMap<Integer, ALEipPosition>();
                org_id = iter.next();
                DataContext dataContext = DataContext.createDataContext((String)org_id);
                List<EipMPosition> list = Database.query(dataContext, EipMPosition.class).fetchList();
                for (EipMPosition record : list) {
                    ALEipPosition position = new ALEipPosition();
                    position.initField();
                    position.setPositionId(record.getPositionId());
                    position.setPositionName(record.getPositionName());
                    positionMap.put(record.getPositionId(), position);
                }
                this.positionsMap.put(org_id, positionMap);
            }
            catch (Exception e) {
                logger.error((Object)("[" + org_id + ":ALEipManager]"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadCompany() {
        String org_id = "";
        Map<String, Map<Integer, ALEipCompany>> map = this.companysMap;
        synchronized (map) {
            try {
                org_id = DatabaseOrmService.getInstance().getOrgId((RunData)this.getRunData());
                List<EipMCompany> list = Database.query(EipMCompany.class).fetchList();
                Map<Integer, ALEipCompany> companyMap = this.companysMap.remove(org_id);
                if (companyMap == null) {
                    companyMap = new LinkedHashMap<Integer, ALEipCompany>();
                } else {
                    companyMap.clear();
                }
                for (EipMCompany record : list) {
                    ALEipCompany company = new ALEipCompany();
                    company.initField();
                    company.setCompanyId(record.getCompanyId());
                    company.setCompanyName(record.getCompanyName());
                    companyMap.put(record.getCompanyId(), company);
                }
                this.companysMap.put(org_id, companyMap);
            }
            catch (Exception e) {
                logger.error((Object)("[" + org_id + ":ALEipManager]"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadPost() {
        String org_id = "";
        Map<String, Map<Integer, ALEipPost>> map = this.postsMap;
        synchronized (map) {
            try {
                org_id = DatabaseOrmService.getInstance().getOrgId((RunData)this.getRunData());
                List<EipMPost> list = Database.query(EipMPost.class).fetchList();
                Collections.sort(list, new Comparator<EipMPost>(){

                    @Override
                    public int compare(EipMPost l1, EipMPost l2) {
                        return l1.getPostName().compareTo(l2.getPostName());
                    }
                });
                Map<Integer, ALEipPost> postMap = this.postsMap.remove(org_id);
                if (postMap == null) {
                    postMap = new LinkedHashMap<Integer, ALEipPost>();
                } else {
                    postMap.clear();
                }
                for (EipMPost record : list) {
                    ALEipPost post = new ALEipPost();
                    post.initField();
                    post.setPostId(record.getPostId());
                    post.setPostName(record.getPostName());
                    post.setGroupName(record.getGroupName());
                    postMap.put(record.getPostId(), post);
                }
                this.postsMap.put(org_id, postMap);
            }
            catch (Exception e) {
                logger.error((Object)("[" + org_id + ":ALEipManager]"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadPosition() {
        String org_id = "";
        Map<String, Map<Integer, ALEipPosition>> map = this.positionsMap;
        synchronized (map) {
            try {
                org_id = DatabaseOrmService.getInstance().getOrgId((RunData)this.getRunData());
                List<EipMPosition> list = Database.query(EipMPosition.class).fetchList();
                Map<Integer, ALEipPosition> positionMap = this.positionsMap.remove(org_id);
                if (positionMap == null) {
                    positionMap = new LinkedHashMap<Integer, ALEipPosition>();
                } else {
                    positionMap.clear();
                }
                for (EipMPosition record : list) {
                    ALEipPosition position = new ALEipPosition();
                    position.initField();
                    position.setPositionId(record.getPositionId());
                    position.setPositionName(record.getPositionName());
                    positionMap.put(record.getPositionId(), position);
                }
                this.positionsMap.put(org_id, positionMap);
            }
            catch (Exception e) {
                logger.error((Object)("[" + org_id + ":ALEipManager]"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, ALEipCompany> getCompanyMap() {
        Map<String, Map<Integer, ALEipCompany>> map = this.companysMap;
        synchronized (map) {
            String org_id = DatabaseOrmService.getInstance().getOrgId((RunData)this.getRunData());
            if (!this.companysMap.containsKey(org_id)) {
                this.reloadCompany();
                if (!this.companysMap.containsKey(org_id)) {
                    return null;
                }
                return this.companysMap.get(org_id);
            }
            return this.companysMap.get(org_id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, ALEipPost> getPostMap() {
        Map<String, Map<Integer, ALEipPost>> map = this.postsMap;
        synchronized (map) {
            String org_id = DatabaseOrmService.getInstance().getOrgId((RunData)this.getRunData());
            if (!this.postsMap.containsKey(org_id)) {
                this.reloadPost();
                if (!this.postsMap.containsKey(org_id)) {
                    return null;
                }
                return this.postsMap.get(org_id);
            }
            return this.postsMap.get(org_id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, ALEipPosition> getPositionMap() {
        Map<String, Map<Integer, ALEipPosition>> map = this.positionsMap;
        synchronized (map) {
            String org_id = DatabaseOrmService.getInstance().getOrgId((RunData)this.getRunData());
            if (!this.positionsMap.containsKey(org_id)) {
                this.reloadPosition();
                if (!this.positionsMap.containsKey(org_id)) {
                    return null;
                }
                return this.positionsMap.get(org_id);
            }
            return this.positionsMap.get(org_id);
        }
    }

    protected JetspeedRunData getRunData() {
        JetspeedRunData rundata = null;
        if (this.runDataService != null) {
            rundata = this.runDataService.getCurrentRunData();
        }
        return rundata;
    }
}

