/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.common;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALCsvTokenizer;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import java.io.File;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.upload.FileItem;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ALCsvAbstractUploadFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALCsvAbstractUploadFormData.class.getName());
    private final int FIELD_ATTACHMENT_MAX_LEN = 128;
    private FileItem attachmentItem = null;
    private ALStringField attachmentName = null;
    protected int page_count;
    protected int line_count;

    @Override
    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.page_count = 0;
        this.line_count = 0;
    }

    public abstract String getTempFilePath();

    @Override
    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        ParameterParser parser = rundata.getParameters();
        this.attachmentItem = parser.getFileItem("attachment");
        if (this.attachmentItem != null) {
            if (this.attachmentItem.getSize() > 0L) {
                File file = new File(this.attachmentItem.getName());
                this.attachmentName.setValue(file.getName());
                return true;
            }
            msgList.add("\u30b5\u30a4\u30ba\u304c 0KB \u306e\u30d5\u30a1\u30a4\u30eb\u3092\u8ffd\u52a0\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
            return false;
        }
        msgList.add("\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
        return false;
    }

    @Override
    protected void setValidator() {
        this.attachmentName.setNotNull(true);
        this.attachmentName.limitMaxLength(128);
        this.attachmentName.setCharacterType(0);
    }

    @Override
    protected boolean validate(List<String> msgList) {
        this.attachmentName.validate(msgList);
        return msgList.size() == 0;
    }

    @Override
    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        return true;
    }

    @Override
    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    @Override
    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            String filepath = this.getTempFilePath();
            File file = new File(filepath);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            this.attachmentItem.write(file.getAbsolutePath());
            ALCsvTokenizer reader = new ALCsvTokenizer();
            if (!reader.init(filepath)) {
                return false;
            }
            try {
                this.page_count = 0;
                this.line_count = 0;
                while (reader.eof != -1) {
                    for (int i = 0; i < 1000; ++i) {
                        while (reader.eof != -1) {
                            reader.nextToken();
                            if (reader.eof != -1 && !reader.line) continue;
                        }
                        if (reader.eof == -1) break;
                        ++this.line_count;
                    }
                    ++this.page_count;
                }
            }
            catch (Exception e) {
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    @Override
    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            File file = new File(this.getTempFilePath());
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    @Override
    public void initField() {
        this.attachmentName = new ALStringField();
        this.attachmentName.setFieldName("CSV\u30d5\u30a1\u30a4\u30eb\u540d");
        this.attachmentName.setTrim(true);
    }

    public int getPageCount() {
        return this.page_count;
    }

    public int getLineCount() {
        return this.line_count;
    }
}

