/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.common;

import com.aimluck.commons.field.ALAbstractField;
import com.aimluck.commons.field.ALDateContainer;
import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ALAbstractFormData
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALAbstractFormData.class.getName());
    private String mode;
    protected boolean hasAuthority;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        if (ALEipUtils.isMatch(rundata, context) && rundata.getParameters().containsKey((Object)"entityid")) {
            if (rundata.getParameters().getString("entityid").equals("new")) {
                ALEipUtils.removeTemp(rundata, context, "entityid");
            } else {
                ALEipUtils.setTemp(rundata, context, "entityid", rundata.getParameters().getString("entityid"));
            }
        }
    }

    public String getFieldName(String argString) {
        String fieldName = null;
        try {
            Field f = this.getClass().getDeclaredField(argString);
            f.setAccessible(true);
            ALAbstractField field = (ALAbstractField)f.get(this);
            fieldName = field.getFieldName();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return fieldName;
    }

    public boolean doViewForm(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            boolean isedit = ALEipUtils.getTemp(rundata, context, "entityid") != null;
            int aclType = 4;
            if (isedit) {
                aclType = 8;
            }
            this.doCheckAclPermission(rundata, context, aclType);
            action.setMode(isedit ? "edit_form" : "new_form");
            this.mode = action.getMode();
            ArrayList<String> msgList = new ArrayList<String>();
            boolean res = isedit ? this.loadFormData(rundata, context, msgList) : this.setFormData(rundata, context, msgList);
            action.setResultData(this);
            if (!msgList.isEmpty()) {
                action.addErrorMessages(msgList);
            }
            action.putData(rundata, context);
            return res;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError(rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound(rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError(rundata);
            return false;
        }
    }

    public boolean doInsert(ALAction action, RunData rundata, Context context) {
        try {
            boolean res;
            if (!this.doCheckSecurity(rundata, context)) {
                return false;
            }
            this.init(action, rundata, context);
            this.doCheckAclPermission(rundata, context, 4);
            action.setMode("insert");
            this.mode = action.getMode();
            rundata.getParameters().add("mode", "insert");
            ArrayList<String> msgList = new ArrayList<String>();
            this.setValidator();
            boolean bl = res = this.setFormData(rundata, context, msgList) && this.validate(msgList) && this.insertFormData(rundata, context, msgList);
            if (!res) {
                action.setMode("new_form");
                this.mode = action.getMode();
            }
            action.setResultData(this);
            if (!msgList.isEmpty()) {
                action.addErrorMessages(msgList);
            }
            action.putData(rundata, context);
            return res;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError(rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound(rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError(rundata);
            return false;
        }
    }

    public boolean doUpdate(ALAction action, RunData rundata, Context context) {
        try {
            boolean res;
            if (!this.doCheckSecurity(rundata, context)) {
                return false;
            }
            this.init(action, rundata, context);
            this.doCheckAclPermission(rundata, context, 8);
            action.setMode("update");
            this.mode = action.getMode();
            rundata.getParameters().add("mode", "update");
            ArrayList<String> msgList = new ArrayList<String>();
            this.setValidator();
            boolean bl = res = this.setFormData(rundata, context, msgList) && this.validate(msgList) && this.updateFormData(rundata, context, msgList);
            if (!res) {
                action.setMode("edit_form");
                this.mode = action.getMode();
            }
            action.setResultData(this);
            if (!msgList.isEmpty()) {
                action.addErrorMessages(msgList);
            }
            action.putData(rundata, context);
            return res;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError(rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound(rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError(rundata);
            return false;
        }
    }

    public boolean doDelete(ALAction action, RunData rundata, Context context) {
        try {
            if (!this.doCheckSecurity(rundata, context)) {
                return false;
            }
            this.init(action, rundata, context);
            this.doCheckAclPermission(rundata, context, 16);
            action.setMode("delete");
            this.mode = action.getMode();
            rundata.getParameters().add("mode", "delete");
            ArrayList<String> msgList = new ArrayList<String>();
            boolean res = this.deleteFormData(rundata, context, msgList);
            action.setResultData(this);
            if (!msgList.isEmpty()) {
                action.addErrorMessages(msgList);
            }
            action.putData(rundata, context);
            return res;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError(rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound(rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError(rundata);
            return false;
        }
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            Field[] fields = this.getClass().getDeclaredFields();
            int length = fields.length;
            for (int i = 0; i < length; ++i) {
                String dayString;
                String monthString;
                String yearString;
                ALDateTimeField field;
                fields[i].setAccessible(true);
                String name = fields[i].getName();
                Object obj = fields[i].get(this);
                if (obj instanceof ALDateTimeField) {
                    field = (ALDateTimeField)obj;
                    yearString = new StringBuffer().append(name).append("_year").toString();
                    monthString = new StringBuffer().append(name).append("_month").toString();
                    dayString = new StringBuffer().append(name).append("_day").toString();
                    String hourString = new StringBuffer().append(name).append("_hour").toString();
                    String minitusString = new StringBuffer().append(name).append("_minute").toString();
                    if (!rundata.getParameters().containsKey((Object)yearString)) continue;
                    int year = rundata.getParameters().getInt(yearString);
                    if (!rundata.getParameters().containsKey((Object)monthString)) continue;
                    int month = rundata.getParameters().getInt(monthString) - 1;
                    if (!rundata.getParameters().containsKey((Object)dayString)) continue;
                    int day = rundata.getParameters().getInt(dayString);
                    if (!rundata.getParameters().containsKey((Object)hourString)) continue;
                    int hour = rundata.getParameters().getInt(hourString);
                    if (!rundata.getParameters().containsKey((Object)minitusString)) continue;
                    int minitue = rundata.getParameters().getInt(minitusString);
                    Calendar cal = Calendar.getInstance();
                    cal.set(year, month, day, hour, minitue);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    field.setValue(cal.getTime());
                    continue;
                }
                if (obj instanceof ALDateField) {
                    field = (ALDateField)obj;
                    yearString = new StringBuffer().append(name).append("_year").toString();
                    monthString = new StringBuffer().append(name).append("_month").toString();
                    dayString = new StringBuffer().append(name).append("_day").toString();
                    ALDateContainer con = new ALDateContainer();
                    if (!rundata.getParameters().containsKey((Object)yearString)) continue;
                    con.setYear(rundata.getParameters().getString(yearString));
                    if (!rundata.getParameters().containsKey((Object)monthString)) continue;
                    con.setMonth(rundata.getParameters().getString(monthString));
                    if (!rundata.getParameters().containsKey((Object)dayString)) continue;
                    con.setDay(rundata.getParameters().getString(dayString));
                    field.setValue(con);
                    continue;
                }
                if (!(obj instanceof ALAbstractField)) continue;
                field = (ALAbstractField)obj;
                if (!rundata.getParameters().containsKey((Object)name)) continue;
                field.setValue(rundata.getParameters().getString(name));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected abstract void setValidator() throws ALPageNotFoundException, ALDBErrorException;

    protected abstract boolean validate(List<String> var1) throws ALPageNotFoundException, ALDBErrorException;

    protected abstract boolean loadFormData(RunData var1, Context var2, List<String> var3) throws ALPageNotFoundException, ALDBErrorException;

    protected abstract boolean insertFormData(RunData var1, Context var2, List<String> var3) throws ALPageNotFoundException, ALDBErrorException;

    protected abstract boolean updateFormData(RunData var1, Context var2, List<String> var3) throws ALPageNotFoundException, ALDBErrorException;

    protected abstract boolean deleteFormData(RunData var1, Context var2, List<String> var3) throws ALPageNotFoundException, ALDBErrorException;

    protected boolean doCheckSecurity(RunData rundata, Context context) {
        String reqSecid = rundata.getParameters().getString("secid");
        String sessionSecid = (String)rundata.getUser().getTemp("secid");
        return reqSecid != null && reqSecid.equals(sessionSecid);
    }

    protected boolean doCheckAclPermission(RunData rundata, Context context, int defineAclType) throws ALPermissionException {
        if (defineAclType == 0) {
            return true;
        }
        String pfeature = this.getAclPortletFeature();
        if (pfeature == null || "".equals(pfeature)) {
            return true;
        }
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAuthority = aclhandler.hasAuthority(ALEipUtils.getUserId(rundata), pfeature, defineAclType);
        if (!this.hasAuthority) {
            throw new ALPermissionException();
        }
        return true;
    }

    public boolean hasAuthority() {
        return this.hasAuthority;
    }

    public String getAclPortletFeature() {
        return null;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String string) {
        this.mode = string;
    }
}

