/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.common;

import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALAbstractCheckList.class.getName());
    protected boolean hasAuthority;

    public boolean doMultiAction(ALAction action, RunData rundata, Context context) {
        try {
            if (!this.doCheckSecurity(rundata, context)) {
                return false;
            }
            this.doCheckAclPermission(rundata, context, this.getDefineAclType());
            ArrayList<String> values = new ArrayList<String>();
            ArrayList<String> msgList = new ArrayList<String>();
            boolean res = false;
            Object[] objs = rundata.getParameters().getKeys();
            int length = objs.length;
            for (int i = 0; i < length; ++i) {
                if (!objs[i].toString().startsWith("check")) continue;
                String str = rundata.getParameters().getString(objs[i].toString());
                values.add(str);
                res = true;
            }
            if (res) {
                res = this.action(rundata, context, values, msgList);
            }
            action.setResultData(this);
            action.setErrorMessages(msgList);
            action.putData(rundata, context);
            return res;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError(rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound(rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError(rundata);
            return false;
        }
    }

    protected abstract boolean action(RunData var1, Context var2, List<String> var3, List<String> var4) throws ALPageNotFoundException, ALDBErrorException;

    protected boolean doCheckSecurity(RunData rundata, Context context) {
        String reqSecid = rundata.getParameters().getString("secid");
        String sessionSecid = (String)rundata.getUser().getTemp("secid");
        return reqSecid != null && reqSecid.equals(sessionSecid);
    }

    protected boolean doCheckAclPermission(RunData rundata, Context context, int defineAclType) throws ALPermissionException {
        if (defineAclType == 0) {
            return true;
        }
        String pfeature = this.getAclPortletFeature();
        if (pfeature == null || "".equals(pfeature)) {
            return true;
        }
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAuthority = aclhandler.hasAuthority(ALEipUtils.getUserId(rundata), pfeature, defineAclType);
        if (!this.hasAuthority) {
            throw new ALPermissionException();
        }
        return true;
    }

    public boolean hasAuthority() {
        return this.hasAuthority;
    }

    protected int getDefineAclType() {
        return 0;
    }

    public String getAclPortletFeature() {
        return null;
    }
}

