/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.webmail.util;

import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.portlet.EipTMail;
import com.aimluck.eip.mail.ALFolder;
import com.aimluck.eip.mail.ALMailFactoryService;
import com.aimluck.eip.mail.ALMailHandler;
import com.aimluck.eip.mail.ALMailMessage;
import com.aimluck.eip.mail.ALMailReceiverContext;
import com.aimluck.eip.mail.ALPop3MailReceiveThread;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.mail.util.ALStaticObject;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.om.security.User;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WebMailUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WebMailUtils.class.getName());
    public static final String TAB_RECEIVE = "receive";
    public static final String TAB_SENT = "sent";
    public static final String DATE_TIME_FORMAT = "yyyy/MM/dd HH:mm";
    public static final String CREATED_DATE_FORMAT = "yyyy/MM/dd";
    public static final String ACCOUNT_ID = "accountid";
    public static final String ACCOUNT_NAME = "accountname";
    public static final String MAIL_TYPE = "mailtype";
    public static final String CONFIRM_LAST_TIME = "confirmlasttime";
    public static final String LAST_TIME = "lasttime";
    public static final String UNREAD_NUM = "unread_num";
    public static final ArrayList flagList = new ArrayList();

    public static final List getMailAccountNameList(int userId) {
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        SelectQuery query = new SelectQuery(EipMMailAccount.class);
        query.addCustomDbAttribute("ACCOUNT_ID");
        query.addCustomDbAttribute("ACCOUNT_NAME");
        Expression exp = ExpressionFactory.matchExp((String)"userId", (Object)userId);
        query.setQualifier(exp);
        return dataContext.performQuery((Query)query);
    }

    public static final ALMailMessage getSelectedLocalMailMessage(RunData rundata, Context context, int mailType) throws Exception {
        String org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
        int uid = ALEipUtils.getUserId((RunData)rundata);
        int accountId = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)ACCOUNT_ID));
        String mailid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        if (mailid == null || Integer.valueOf(mailid) == null) {
            logger.debug((Object)"[Mail] Empty ID...");
            return null;
        }
        String currentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tab");
        int type_mail = TAB_RECEIVE.equals(currentTab) ? 1 : 2;
        ALMailHandler handler = ALMailFactoryService.getInstance().getMailHandler();
        ALFolder folder = handler.getALFolder(type_mail, org_id, uid, accountId);
        ALMailMessage msg = folder.getMail(Integer.valueOf(mailid).intValue());
        if (1 == mailType) {
            return ALMailUtils.getReplyMessage((ALMailMessage)msg);
        }
        if (2 == mailType) {
            return ALMailUtils.getForwardMessage((ALMailMessage)msg);
        }
        return msg;
    }

    public static boolean checkAddress(String argstr, String delim) {
        if (argstr == null || argstr.trim().length() == 0) {
            return false;
        }
        String[] addresses = ALMailUtils.getTokens((String)argstr, (String)delim);
        for (int i = 0; i < addresses.length; ++i) {
            String str = addresses[i].trim();
            if (str.length() == 0) continue;
            if (str.charAt(str.length() - 1) == '>') {
                int idx = str.indexOf("<");
                if (idx == -1) {
                    return false;
                }
                String address = str.substring(idx + 1, str.length() - 1);
                if (ALStringUtil.isCellPhoneMailAddress((String)address)) continue;
                return false;
            }
            if (ALStringUtil.isCellPhoneMailAddress((String)str)) continue;
            return false;
        }
        return true;
    }

    public static String checkUnusualChar(String str) {
        ArrayList<Character> unusualChars = new ArrayList<Character>();
        char[] unusualchars = new char[]{'\u2460', '\u2461', '\u2462', '\u2463', '\u2464', '\u2465', '\u2466', '\u2467', '\u2468', '\u2469', '\u246a', '\u246b', '\u246c', '\u246d', '\u246e', '\u246f', '\u2470', '\u2471', '\u2472', '\u2473', '\u2160', '\u2161', '\u2162', '\u2163', '\u2164', '\u2165', '\u2166', '\u2167', '\u2168', '\u2169', '\u3349', '\u3314', '\u3322', '\u334d', '\u3318', '\u3327', '\u3303', '\u3336', '\u3351', '\u3357', '\u330d', '\u30fb', '\u3323', '\u332b', '\u334a', '\u333b', '\u339c', '\u339d', '\u339e', '\u338e', '\u338f', '\u33c4', '\u33a1', '\u337b', '\u301d', '\u301f', '\u2116', '\u33cd', '\u2121', '\u32a4', '\u32a5', '\u32a6', '\u32a7', '\u32a8', '\u3231', '\u3232', '\u3239', '\u337e', '\u337d', '\u337c', '\u222e', '\u2211', '\u221f', '\u22bf'};
        int unusuallen = unusualchars.length;
        int length = str.length();
        Character cha = null;
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < unusuallen; ++j) {
                if (str.charAt(i) != unusualchars[j] || unusualChars.contains(cha = Character.valueOf(unusualchars[j]))) continue;
                unusualChars.add(cha);
            }
        }
        StringBuffer sb = new StringBuffer();
        if (unusualChars.size() < 1) {
            return null;
        }
        length = unusualChars.size() - 1;
        for (int i = 0; i < length; ++i) {
            sb.append("\"").append(unusualChars.get(i)).append("\"").append(",");
        }
        sb.append("\"").append(unusualChars.get(length)).append("\"");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void receiveMailsThread(RunData rundata, Context context) throws Exception {
        Integer n = ALPop3MailReceiveThread.KEY_SYNCHRONIZED_LOCK;
        synchronized (n) {
            ALStaticObject ob;
            JetspeedRunData jdata = (JetspeedRunData)rundata;
            JetspeedUser user = (JetspeedUser)jdata.getUser();
            int accountId = 0;
            try {
                accountId = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)ACCOUNT_ID));
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (accountId <= 0) {
                return;
            }
            if (!ALPop3MailReceiveThread.isProcessing((User)user, (int)accountId) && (ob = ALStaticObject.getInstance()).receivable(accountId)) {
                String orgId = DatabaseOrmService.getInstance().getOrgId(rundata);
                ob.addAccountId(accountId);
                Thread mailthread = new Thread((Runnable)new ALPop3MailReceiveThread(orgId, user, accountId, 1));
                mailthread.start();
            }
        }
    }

    public static int getNewMailNumThread(String orgId, JetspeedUser user, int accountId) throws Exception {
        if (!ALPop3MailReceiveThread.isProcessing((User)user, (int)accountId)) {
            Thread mailthread = new Thread((Runnable)new ALPop3MailReceiveThread(orgId, user, accountId, 2));
            mailthread.start();
        }
        return ALPop3MailReceiveThread.getNewMailNum((User)user, (int)accountId);
    }

    public static int getStatThread(String orgId, JetspeedUser user, int accountId) throws Exception {
        if (ALPop3MailReceiveThread.isProcessing((User)user, (int)accountId)) {
            return -100;
        }
        return ALPop3MailReceiveThread.getReceiveMailResult((User)user, (int)accountId);
    }

    public static String getStatStrThread(String orgId, JetspeedUser user, int accountId) throws Exception {
        return ALPop3MailReceiveThread.getReceiveMailResultStr((User)user, (int)accountId);
    }

    public static int getUnreadMailNumber(RunData rundata, int userId, int accountId) {
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)userId);
        Expression exp2 = ExpressionFactory.matchExp((String)"accountId", (Object)accountId);
        Expression exp3 = ExpressionFactory.matchExp((String)"type", (Object)"R");
        Expression exp4 = ExpressionFactory.matchExp((String)"readFlg", (Object)"F");
        SelectQuery query = new SelectQuery(EipTMail.class, exp1.andExp(exp2).andExp(exp3).andExp(exp4));
        List list = dataContext.performQuery((Query)query);
        return list.size();
    }

    public static boolean isNewMessage(RunData rundata, Context context) {
        String accountId = rundata.getParameters().getString(ACCOUNT_ID);
        if (accountId == null || "".equals(accountId)) {
            return true;
        }
        EipMMailAccount account = ALMailUtils.getMailAccount((int)ALEipUtils.getUserId((RunData)rundata), (int)Integer.parseInt(accountId));
        String orgId = DatabaseOrmService.getInstance().getOrgId(rundata);
        ALMailHandler handler = ALMailFactoryService.getInstance().getMailHandler();
        ALMailReceiverContext rcontext = ALMailUtils.getALPop3MailReceiverContext((String)orgId, (EipMMailAccount)account);
        int res = -1;
        try {
            res = handler.getNewMailSum(rcontext);
        }
        catch (Exception e) {
            res = -1;
            e.printStackTrace();
        }
        return res > 0;
    }
}

