/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.webmail;

import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.ALFolder;
import com.aimluck.eip.mail.ALLocalMailMessage;
import com.aimluck.eip.mail.ALMailFactoryService;
import com.aimluck.eip.mail.ALMailHandler;
import com.aimluck.eip.mail.ALPop3MailReceiveThread;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.WebMailIndexRowResultData;
import com.aimluck.eip.webmail.WebMailResultData;
import com.aimluck.eip.webmail.beans.WebmailAccountLiteBean;
import com.aimluck.eip.webmail.util.WebMailUtils;
import com.sk_jp.mail.MailUtility;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import javax.mail.Address;
import javax.mail.Message;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.om.security.User;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WebMailSelectData
extends ALAbstractSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WebMailSelectData.class.getName());
    private String currentTab = null;
    JetspeedUser user = null;
    private int userId = -1;
    private int accountId = -1;
    private int mailSum = -1;
    private int unreadMailSum = -1;
    private String finalAccessDateStr = null;
    private String org_id;
    private DataContext dataContext;
    private ALFolder folder;
    private ArrayList mailAccountList;
    private int unreadNum = 0;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort_type;
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-sort"));
        }
        this.org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        this.userId = ALEipUtils.getUserId((RunData)rundata);
        this.user = (JetspeedUser)((JetspeedRunData)rundata).getUser();
        String tabParam = rundata.getParameters().getString("tab");
        this.currentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tab");
        if (tabParam == null && this.currentTab == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)"receive");
            this.currentTab = "receive";
        } else if (tabParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)tabParam);
            this.currentTab = tabParam;
        }
        String tmpAccoundId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"accountid");
        if (tmpAccoundId == null || "".equals(tmpAccoundId)) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"accountid", (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p3a-accounts"));
        }
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"accountid")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"accountid", (String)rundata.getParameters().getString("accountid"));
        }
        try {
            this.accountId = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"accountid"));
        }
        catch (Exception e) {
            this.accountId = 0;
        }
        if (this.accountId == 0) {
            try {
                Expression exp = ExpressionFactory.matchExp((String)"userId", (Object)this.userId);
                SelectQuery query = new SelectQuery(EipMMailAccount.class, exp);
                query.addCustomDbAttribute("ACCOUNT_ID");
                List accounts = this.dataContext.performQuery((Query)query);
                if (accounts != null && accounts.size() > 0) {
                    DataRow dataRow = (DataRow)accounts.get(0);
                    this.accountId = (Integer)dataRow.get((Object)"ACCOUNT_ID");
                    ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"accountid", (String)Integer.toString(this.accountId));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.accountId > 0) {
            int type_mail = "receive".equals(this.currentTab) ? 1 : 2;
            ALMailHandler handler = ALMailFactoryService.getInstance().getMailHandler();
            this.folder = handler.getALFolder(type_mail, this.org_id, this.userId, Integer.valueOf(this.accountId).intValue());
            this.folder.setRowsNum(super.getRowsNum());
        }
        super.init(action, rundata, context);
        if ("date".equals(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR)) && ((sort_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR)) == null || sort_type.equals(""))) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR, (String)"desc");
        }
        this.unreadNum = WebMailUtils.getUnreadMailNumber(rundata, this.userId, this.accountId);
    }

    public void loadMailAccountList(RunData rundata, Context context) {
        try {
            this.mailAccountList = new ArrayList();
            List aList = WebMailUtils.getMailAccountNameList(ALEipUtils.getUserId((RunData)rundata));
            if (aList == null) {
                return;
            }
            WebmailAccountLiteBean bean = null;
            DataRow dataRow2 = null;
            for (DataRow dataRow2 : aList) {
                bean = new WebmailAccountLiteBean();
                bean.initField();
                bean.setAccountId((Integer)ALEipUtils.getObjFromDataRow((DataRow)dataRow2, (String)"ACCOUNT_ID"));
                bean.setAccountName((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow2, (String)"ACCOUNT_NAME"));
                this.mailAccountList.add(bean);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
    }

    protected List selectList(RunData rundata, Context context) {
        try {
            if (this.folder == null) {
                return null;
            }
            return this.folder.getIndexRows(rundata, context);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object selectDetail(RunData rundata, Context context) {
        String mailid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        if (mailid == null || Integer.valueOf(mailid) == null) {
            logger.debug((Object)"[Mail] Empty ID...");
            return null;
        }
        return this.folder.getMail(Integer.valueOf(mailid).intValue());
    }

    protected Object getResultData(Object obj) {
        DataRow dataRow = (DataRow)obj;
        WebMailIndexRowResultData rd = new WebMailIndexRowResultData();
        rd.initField();
        rd.setMailId(((Integer)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"MAIL_ID")).toString());
        String isRead = (String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"READ_FLG");
        if ("T".equals(isRead)) {
            rd.setReadImage("images/webmail/webmail_readmail.gif");
            rd.setReadImageDescription("\u65e2\u8aad");
        } else {
            rd.setReadImage("images/webmail/webmail_unreadmail.gif");
            rd.setReadImageDescription("\u672a\u8aad");
        }
        rd.setSubject(ALCommonUtils.compressString((String)MailUtility.decodeText((String)((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"SUBJECT"))), (int)this.getStrLength()));
        rd.setPerson(MailUtility.decodeText((String)((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"PERSON"))));
        rd.setDate((Date)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"EVENT_DATE"));
        rd.setFileVolume(((Integer)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"FILE_VOLUME")).toString());
        boolean hasAttachments = "T".equals((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"HAS_FILES"));
        if (hasAttachments) {
            rd.setWithFilesImage("images/webmail/webmail_withfiles.gif");
            rd.setWithFilesImageDescription("\u6dfb\u4ed8\u6709");
        }
        rd.hasAttachments(hasAttachments);
        return rd;
    }

    protected Object getResultDataDetail(Object obj) {
        WebMailResultData rd = null;
        try {
            ALLocalMailMessage msg = (ALLocalMailMessage)obj;
            String date = "";
            Date sentDate = msg.getSentDate();
            date = sentDate == null ? "Unknown" : ALMailUtils.translateDate((Date)sentDate);
            rd = new WebMailResultData();
            rd.initField();
            rd.setHeaders(msg.getHeaderArray());
            rd.setSubject(msg.getSubject());
            rd.setFrom(ALMailUtils.getAddressString((Address[])msg.getFrom()));
            rd.setTo(ALMailUtils.getAddressString((Address[])msg.getRecipients(Message.RecipientType.TO)));
            rd.setDate(date);
            rd.setBody(msg.getBodyText());
            rd.setAttachmentFileNames(msg.getAttachmentFileNameArray());
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
        }
        return rd;
    }

    public String getCurrentTab() {
        return this.currentTab;
    }

    protected Attributes getColumnMap() {
        return null;
    }

    public List getMailAccountList() {
        return this.mailAccountList;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public int getNewMailSum() {
        try {
            return WebMailUtils.getNewMailNumThread(this.org_id, this.user, this.accountId);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public int getUnReadMailSum() {
        return this.unreadMailSum;
    }

    public String getFinalAccessDate() {
        return this.finalAccessDateStr;
    }

    public int getRowsNum() {
        return this.folder.getRowsNum();
    }

    public int getCount() {
        return this.folder.getCount();
    }

    public int getPagesNum() {
        return this.folder.getPagesNum();
    }

    public int getCurrentPage() {
        return this.folder.getCurrentPage();
    }

    public String getCurrentSort() {
        return this.folder.getCurrentSort();
    }

    public String getCurrentSortType() {
        return this.folder.getCurrentSortType();
    }

    public int getStart() {
        return this.folder.getStart();
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public String getStatStr() {
        try {
            String tmp = WebMailUtils.getStatStrThread(this.org_id, this.user, this.accountId);
            return tmp;
        }
        catch (Exception ex) {
            return "";
        }
    }

    public String getError() {
        int tmp = ALPop3MailReceiveThread.getStat((User)this.user, (int)this.accountId);
        String msg = null;
        if (tmp == -101) {
            msg = "";
            return msg;
        }
        if (tmp == -100) {
            msg = "\u30e1\u30fc\u30eb\u3092\u53d7\u4fe1\u3057\u3066\u3044\u307e\u3059";
            return msg;
        }
        if (tmp == 0) {
            int res = ALPop3MailReceiveThread.getReceiveMailResult((User)this.user, (int)this.accountId);
            msg = res == -101 ? "" : (res == -1 ? "\u30e1\u30fc\u30eb\u3092\u53d7\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u30e1\u30fc\u30eb\u30a2\u30ab\u30a6\u30f3\u30c8\u306e\u8a2d\u5b9a\u3092\u3054\u78ba\u8a8d\u304f\u3060\u3055\u3044\u3002" : (res == -2 ? "\u30e1\u30fc\u30eb\u306e\u53d7\u4fe1\u4e2d\u3001\u3082\u3057\u304f\u306f\u3001\u30e1\u30f3\u30c6\u30ca\u30f3\u30b9\u4e2d\u3067\u3059\u3002\u3057\u3070\u3089\u304f\u3057\u3066\u304b\u3089\u3001\u300e\u30e1\u30fc\u30eb\u4e00\u89a7\u300f\u30dc\u30bf\u30f3\u3092\u62bc\u3057\u3066\u304f\u3060\u3055\u3044\u3002" : (res == -3 ? "7MB \u3088\u308a\u3082\u5927\u304d\u3044\u30b5\u30a4\u30ba\u306e\u30e1\u30fc\u30eb\u304c\u3042\u308a\u307e\u3057\u305f\u30027MB\u3092\u8d85\u3048\u305f\u30e1\u30fc\u30eb\u306e\u5834\u5408\u306f\u3001\u9001\u4fe1\u8005\u306a\u3069\u306e\u60c5\u5831\u306e\u307f\u53d7\u4fe1\u3057\u3001\u672c\u6587\u306f\u53d7\u4fe1\u3057\u307e\u305b\u3093\u3002" : (res == -4 ? "\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u53d7\u4fe1\u30b5\u30fc\u30d0\uff08POP3\uff09\u3068\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" : (res == -5 ? "\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u53d7\u4fe1\u30b5\u30fc\u30d0\uff08POP3\uff09\u3078\u306e\u30ed\u30b0\u30a4\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" : (res == -6 ? "\u30b7\u30b9\u30c6\u30e0\u4e0a\u306e\u554f\u984c\u306b\u3088\u308a\u3001\u30e1\u30fc\u30eb\u3092\u53d7\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff08Exception \u30a8\u30e9\u30fc\uff09\u3002" : (res == -7 ? "\u30b7\u30b9\u30c6\u30e0\u4e0a\u306e\u554f\u984c\u306b\u3088\u308a\u3001\u30e1\u30fc\u30eb\u3092\u53d7\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff08OutOfMemory \u30a8\u30e9\u30fc\uff09\u3002" : (this.unreadNum > 0 ? this.unreadNum + "\u4ef6\u306e\u672a\u8aad\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u3042\u308a\u307e\u3059\u3002" : ""))))))));
            return msg;
        }
        return "\u539f\u56e0\u4e0d\u660e\u306e\u30a8\u30e9\u30fc";
    }
}

