/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.webmail;

import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.ALMailFactoryService;
import com.aimluck.eip.mail.ALMailHandler;
import com.aimluck.eip.mail.ALMailReceiverContext;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.WebMailAccountDetailResultData;
import com.aimluck.eip.webmail.WebMailAccountResultData;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WebMailAccountSelectData
extends ALAbstractSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WebMailAccountSelectData.class.getName());
    private String org_id;
    private DataContext dataContext;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2b-sort"));
        }
        this.org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        super.init(action, rundata, context);
    }

    protected List selectList(RunData rundata, Context context) {
        try {
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List list = this.dataContext.performQuery((Query)query);
            return this.buildPaginatedList(list);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipMMailAccount.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.noMatchExp((String)"accountType", (Object)2);
        query.andQualifier(exp2);
        return query;
    }

    protected Object selectDetail(RunData rundata, Context context) {
        int userId = ALEipUtils.getUserId((RunData)rundata);
        EipMMailAccount account = null;
        if (userId == 1) {
            account = ALMailUtils.getEipMMailAccountForAdmin();
        } else {
            int accountId = rundata.getParameters().getInt("accountid", -1);
            account = ALMailUtils.getMailAccount((int)userId, (int)accountId);
        }
        return account;
    }

    protected Object getResultData(Object obj) {
        try {
            EipMMailAccount record = (EipMMailAccount)obj;
            WebMailAccountResultData rd = new WebMailAccountResultData();
            rd.initField();
            rd.setAccountId(record.getAccountId());
            rd.setAccountName(record.getAccountName());
            rd.setMailAddress(record.getMailAddress());
            ALMailHandler handler = ALMailFactoryService.getInstance().getMailHandler();
            ALMailReceiverContext rcontext = ALMailUtils.getALPop3MailReceiverContext((String)this.org_id, (EipMMailAccount)record);
            rd.setCountUnRead(handler.getUnReadMailSum(rcontext));
            Date finalAccessDate = record.getLastReceivedDate();
            rd.setFinalAccessDate(ALMailUtils.translateDate((Date)finalAccessDate));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            EipMMailAccount record = (EipMMailAccount)obj;
            WebMailAccountDetailResultData rd = new WebMailAccountDetailResultData();
            rd.initField();
            rd.setAccountId(record.getAccountId());
            rd.setAccountName(record.getAccountName());
            rd.setSmtpserverName(record.getSmtpserverName());
            rd.setPop3serverName(record.getPop3serverName());
            rd.setPop3userName(record.getPop3userName());
            rd.setPop3Password("******");
            rd.setMailUserName(record.getMailUserName());
            rd.setMailAddress(record.getMailAddress());
            rd.setSmtpPort(Integer.parseInt(record.getSmtpPort()));
            rd.setPop3Port(Integer.parseInt(record.getPop3Port()));
            rd.setAuthSendFlg(Integer.parseInt(record.getAuthSendFlg()));
            rd.setAuthSendUserId(record.getAuthSendUserId());
            rd.setAuthSendUserPassword("******");
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("account_name", "accountName");
        return map;
    }
}

