/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.memo.util;

import com.aimluck.eip.cayenne.om.portlet.EipTMemo;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Parameter;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileException;
import org.apache.jetspeed.om.profile.psml.PsmlParameter;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MemoUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MemoUtils.class.getName());

    public static EipTMemo getEipTMemo(RunData rundata, Context context) throws ALPageNotFoundException {
        String memoid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if ((memoid == null || "".equals(memoid) || Integer.valueOf(memoid) == null) && ((memoid = rundata.getParameters().getString("entityid")) == null || "".equals(memoid) || Integer.valueOf(memoid) == null)) {
                logger.debug((Object)"[MemoUtils] Empty ID...");
                return null;
            }
            EipTMemo memo = MemoUtils.getEipTMemo(rundata, context, Integer.valueOf(memoid));
            return memo;
        }
        catch (ALPageNotFoundException pageNotFound) {
            throw pageNotFound;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static boolean saveMemoSelection(RunData rundata, String entityid) {
        String portletEntryId = rundata.getParameters().getString("js_peid", null);
        if (portletEntryId == null || "".equals(portletEntryId)) {
            return false;
        }
        String MEMO_IDX = "p1a-memos";
        try {
            Profile profile = ((JetspeedRunData)rundata).getProfile();
            Portlets portlets = profile.getDocument().getPortlets();
            if (portlets == null) {
                return false;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return false;
            }
            PsmlParameter param = null;
            int length = portletList.length;
            block3: for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    if (!entries[j].getId().equals(portletEntryId)) continue;
                    boolean hasParam = false;
                    Parameter[] params = entries[j].getParameter();
                    int param_len = params.length;
                    for (int k = 0; k < param_len; ++k) {
                        if (!params[k].getName().equals(MEMO_IDX)) continue;
                        params[k].setValue(entityid);
                        entries[j].setParameter(k, params[k]);
                        hasParam = true;
                    }
                    if (hasParam) continue block3;
                    param = new PsmlParameter();
                    param.setName(MEMO_IDX);
                    param.setValue(entityid);
                    entries[j].addParameter((Parameter)param);
                    continue block3;
                }
            }
            profile.store();
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            logger.error((Object)e);
        }
        catch (ProfileException e) {
            logger.error((Object)e);
        }
        return false;
    }

    public static EipTMemo getEipTMemo(RunData rundata, Context context, Integer memoid) throws ALPageNotFoundException {
        int uid = ALEipUtils.getUserId((RunData)rundata);
        try {
            if (memoid == null) {
                logger.debug((Object)"[MemoUtils] Empty ID...");
                return null;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTMemo.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"MEMO_ID", (Object)memoid);
            exp.andExp(ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata)));
            query.setQualifier(exp);
            List memos = dataContext.performQuery((Query)query);
            if (memos == null || memos.size() == 0) {
                logger.debug((Object)"[MemoUtils] Not found ID...");
                return null;
            }
            EipTMemo memo = (EipTMemo)memos.get(0);
            if (uid != memo.getOwnerId()) {
                logger.debug((Object)"[MemoUtils] Invalid user access...");
                throw new ALPageNotFoundException();
            }
            return (EipTMemo)memos.get(0);
        }
        catch (ALPageNotFoundException pageNotFound) {
            logger.error((Object)pageNotFound);
            throw pageNotFound;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }
}

