/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.memo;

import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTMemo;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.memo.MemoLiteResultData;
import com.aimluck.eip.memo.MemoResultData;
import com.aimluck.eip.memo.util.MemoUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MemoSelectData
extends ALAbstractSelectData
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MemoSelectData.class.getName());
    private int memoSum;
    private ArrayList memoLiteList;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-sort"));
        }
    }

    public void loadMemoIdList(RunData rundata, Context context) {
        try {
            this.memoLiteList = new ArrayList();
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTMemo.class);
            query.addCustomDbAttribute("MEMO_ID");
            query.addCustomDbAttribute("MEMO_NAME");
            Expression exp = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp);
            query.setDistinct(true);
            List aList = dataContext.performQuery((Query)query);
            DataRow dataRow = null;
            MemoLiteResultData rd = null;
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                dataRow = (DataRow)aList.get(i);
                rd = new MemoLiteResultData();
                rd.initField();
                rd.setMemoId(((Integer)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"MEMO_ID")).longValue());
                rd.setMemoName((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"MEMO_NAME"));
                this.memoLiteList.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
    }

    public List selectList(RunData rundata, Context context) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List list = dataContext.performQuery((Query)query);
            this.memoSum = list.size();
            return this.buildPaginatedList(list);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipTMemo.class);
        query.addCustomDbAttribute("MEMO_ID");
        query.addCustomDbAttribute("MEMO_NAME");
        query.addCustomDbAttribute("UPDATE_DATE");
        query.addCustomDbAttribute("CREATE_DATE");
        Expression exp = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
        query.setQualifier(exp);
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    protected Object getResultData(Object obj) {
        try {
            DataRow dataRow = (DataRow)obj;
            MemoResultData rd = new MemoResultData();
            rd.initField();
            rd.setMemoId(((Integer)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"MEMO_ID")).longValue());
            rd.setMemoName((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"MEMO_NAME"));
            rd.setNote((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"MEMO_NOTE"));
            rd.setUpdateDate(ALDateUtil.format((Date)((Date)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"UPDATE_DATE")), (String)"yyyy\u5e74M\u6708d\u65e5"));
            rd.setCreateDate(ALDateUtil.format((Date)((Date)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"CREATE_DATE")), (String)"yyyy\u5e74M\u6708d\u65e5"));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public Object selectDetail(RunData rundata, Context context) throws ALPageNotFoundException {
        EipTMemo memo = MemoUtils.getEipTMemo(rundata, context);
        return memo;
    }

    protected Object getResultDataDetail(Object obj) {
        try {
            EipTMemo record = (EipTMemo)obj;
            MemoResultData rd = new MemoResultData();
            rd.initField();
            rd.setMemoId(record.getMemoId().intValue());
            rd.setMemoName(record.getMemoName());
            rd.setNote(record.getNote());
            rd.setCreateDate(ALDateUtil.format((Date)record.getCreateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            rd.setUpdateDate(ALDateUtil.format((Date)record.getUpdateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public int getMemoSum() {
        return this.memoSum;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("memo_name", "memoName");
        map.putValue("update_date", "updateDate");
        map.putValue("create_date", "createDate");
        return map;
    }

    public List getMemoLiteList() {
        return this.memoLiteList;
    }
}

