/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.memo;

import com.aimluck.eip.cayenne.om.portlet.EipTMemo;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MemoMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MemoMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, ArrayList values, ArrayList msgList) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            ArrayList<Integer> ids = new ArrayList<Integer>();
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                ids.add(Integer.valueOf((String)values.get(i)));
            }
            SelectQuery query = new SelectQuery(EipTMemo.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.inDbExp((String)"MEMO_ID", ids);
            query.andQualifier(exp2);
            List memos = dataContext.performQuery((Query)query);
            if (memos == null || memos.size() == 0) {
                return false;
            }
            int lsize = memos.size();
            for (int i = 0; i < lsize; ++i) {
                EipTMemo memo = (EipTMemo)memos.get(i);
                dataContext.deleteObject((Persistent)memo);
                dataContext.commitChanges();
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(memo.getMemoId().intValue(), 170, memo.getMemoName());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }
}

