/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.memo;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTMemo;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.memo.util.MemoUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MemoFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MemoFormData.class.getName());
    private ALStringField memo_name;
    private ALStringField note;
    private DataContext dataContext;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
    }

    public void initField() {
        this.memo_name = new ALStringField();
        this.memo_name.setFieldName("\u30e1\u30e2\u540d");
        this.memo_name.setTrim(true);
        this.note = new ALStringField();
        this.note.setFieldName("\u5185\u5bb9");
        this.note.setTrim(false);
    }

    protected void setValidator() {
        this.memo_name.setNotNull(true);
        this.memo_name.limitMaxLength(50);
        this.note.limitMaxLength(10000);
    }

    protected boolean validate(ArrayList msgList) {
        this.memo_name.validate(msgList);
        this.note.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTMemo memo = MemoUtils.getEipTMemo(rundata, context);
            if (memo == null) {
                return false;
            }
            this.memo_name.setValue(memo.getMemoName());
            this.note.setValue(memo.getNote());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTMemo memo = MemoUtils.getEipTMemo(rundata, context);
            if (memo == null) {
                return false;
            }
            this.dataContext.deleteObject((Persistent)memo);
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(memo.getMemoId().intValue(), 170, memo.getMemoName());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTMemo memo = (EipTMemo)this.dataContext.createAndRegisterNewObject(EipTMemo.class);
            Date now = Calendar.getInstance().getTime();
            memo.setMemoName(this.memo_name.getValue());
            memo.setOwnerId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
            memo.setNote(this.note.getValue());
            memo.setCreateDate(now);
            memo.setUpdateDate(now);
            this.dataContext.commitChanges();
            MemoUtils.saveMemoSelection(rundata, memo.getMemoId().toString());
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(memo.getMemoId().intValue(), 170, memo.getMemoName());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTMemo memo = MemoUtils.getEipTMemo(rundata, context);
            if (memo == null) {
                return false;
            }
            Date now = Calendar.getInstance().getTime();
            memo.setMemoName(this.memo_name.getValue());
            memo.setOwnerId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
            memo.setNote(this.note.getValue());
            memo.setUpdateDate(now);
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(memo.getMemoId().intValue(), 170, memo.getMemoName());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public ALStringField getMemoName() {
        return this.memo_name;
    }
}

