/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.commons.field;

import com.aimluck.commons.field.ALAbstractField;
import com.aimluck.commons.utils.ALStringUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class ALStringField
extends ALAbstractField {
    public static final int TYPE_ALL = 0;
    public static final int TYPE_ALPHABET = 1;
    public static final int TYPE_NUMBER = 2;
    public static final int TYPE_ALPHABET_NUMBER = 3;
    public static final int TYPE_HANKAKUKANA = 4;
    public static final int TYPE_ALPHABET_NUMBER_HANKAKUKANA = 7;
    public static final int TYPE_MULTIBYTE = 8;
    public static final int TYPE_SYMBOL = 16;
    public static final int TYPE_ASCII = 19;
    protected int characterType = 0;
    protected boolean limitLength = false;
    protected int minLength = 0;
    protected int maxLength = Integer.MAX_VALUE;
    protected String value = null;
    protected boolean isTrimValue = true;

    public ALStringField() {
        this(null);
    }

    public ALStringField(String str) {
        this.setValue(str);
    }

    public int getCharacterType() {
        return this.characterType;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public String getValue() {
        return this.value;
    }

    public void setCharacterType(int i) {
        this.characterType = i;
    }

    public boolean isLimitLength() {
        return this.limitLength;
    }

    public void setValue(String str) {
        this.value = str != null && this.isTrimValue ? ALStringField.removeSpace(str) : str;
    }

    public void limitLength(int min, int max) {
        if (max < min) {
            throw new IllegalArgumentException();
        }
        this.minLength = min;
        this.maxLength = max;
        this.limitLength = true;
    }

    public void limitMinLength(int min) {
        if (this.maxLength < min) {
            throw new IllegalArgumentException();
        }
        this.minLength = min;
        this.limitLength = true;
    }

    public void limitMaxLength(int max) {
        if (max < this.minLength) {
            throw new IllegalArgumentException();
        }
        this.maxLength = max;
        this.limitLength = true;
    }

    public void setTrim(boolean bool) {
        this.isTrimValue = bool;
    }

    public boolean isTrim() {
        return this.isTrimValue;
    }

    public boolean validate(ArrayList msgList) {
        if (msgList == null) {
            msgList = new ArrayList<String>();
        }
        if (!this.isNotNullValue()) {
            if (this.isNotNull()) {
                msgList.add("\u300e <span class='em'>" + this.fieldName + "</span> \u300f\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                return false;
            }
        } else {
            if (!this.isValidCharacterType()) {
                msgList.add("\u300e <span class='em'>" + this.fieldName + "</span> \u300f\u306f" + this.getCharTypeByName() + "\u3067\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                return false;
            }
            if (this.isLimitLength()) {
                int len = this.value.length();
                if (len < this.getMinLength()) {
                    msgList.add("\u300e <span class='em'>" + this.fieldName + "</span> \u300f\u306f" + this.getMinLength() + "\u6587\u5b57\u4ee5\u4e0a\u3067\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    return false;
                }
                if (len > this.getMaxLength()) {
                    msgList.add("\u300e <span class='em'>" + this.fieldName + "</span> \u300f\u306f" + this.getMaxLength() + "\u6587\u5b57\u4ee5\u4e0b\u3067\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean isValidCharacterType() {
        if (this.getCharacterType() == 0) {
            return true;
        }
        if (!this.isNotNullValue()) {
            return true;
        }
        int length = this.value.length();
        for (int i1 = 0; i1 < length; ++i1) {
            if ((this.getType(this.value.charAt(i1)) & this.getCharacterType()) != 0) continue;
            return false;
        }
        return true;
    }

    protected int getType(char ch) {
        byte[] chars;
        try {
            chars = Character.valueOf(ch).toString().getBytes("shift_jis");
        }
        catch (UnsupportedEncodingException ex) {
            return 0;
        }
        if (chars == null) {
            return 0;
        }
        if (chars.length == 2) {
            return 8;
        }
        if (Character.isDigit(ch)) {
            return 2;
        }
        if (Character.isLetter(ch)) {
            return 1;
        }
        return 16;
    }

    protected int valueByteLength() {
        int len = 0;
        if (this.value == null) {
            return len;
        }
        try {
            len = this.value.getBytes("shift_jis").length;
        }
        catch (UnsupportedEncodingException ex) {
            len = 0;
        }
        return len;
    }

    protected boolean isNotNullValue() {
        return this.value != null && this.value.length() > 0;
    }

    protected String getCharTypeByName() {
        switch (this.characterType) {
            case 1: {
                return "\u534a\u89d2\u82f1\u5b57";
            }
            case 2: {
                return "\u534a\u89d2\u6570\u5b57";
            }
            case 4: {
                return "\u534a\u89d2\u30ab\u30ca";
            }
            case 8: {
                return "\u5168\u89d2\u6587\u5b57";
            }
            case 3: {
                return "\u534a\u89d2\u82f1\u6570\u5b57";
            }
            case 7: {
                return "\u534a\u89d2\u82f1\u6570\u5b57\u30ab\u30ca";
            }
            case 16: {
                return "\u534a\u89d2\u8a18\u53f7";
            }
            case 19: {
                return "\u534a\u89d2\u82f1\u6570\u5b57";
            }
        }
        return "";
    }

    private static String removeSpace(String str) {
        int st;
        int len = str.length();
        char[] val = str.toCharArray();
        for (st = 0; st < len && (val[st] <= ' ' || val[st] == '\u3000'); ++st) {
        }
        while (st < len && (val[len - 1] <= ' ' || val[len - 1] == '\u3000')) {
            --len;
        }
        return st > 0 || len < str.length() ? str.substring(st, len) : str;
    }

    public String toString() {
        return ALStringUtil.sanitizing(this.value);
    }
}

