/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.commons.field;

import com.aimluck.commons.field.ALAbstractField;
import com.aimluck.commons.utils.ALStringUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class ALNumberField
extends ALAbstractField {
    protected boolean limitValue = false;
    protected long minValue = Long.MIN_VALUE;
    protected long maxValue = Long.MAX_VALUE;
    protected String value = null;

    public ALNumberField() {
    }

    public ALNumberField(long value) {
        this.setValue(value);
    }

    public ALNumberField(String str) {
        this.setValue(str);
    }

    public void setValue(long value) {
        this.value = Long.toString(value);
    }

    public void setValue(String str) {
        if (str == null) {
            this.value = null;
            return;
        }
        this.value = str.trim();
    }

    public long getValue() {
        long longValue = 0L;
        if (this.isNumberValue()) {
            try {
                longValue = Long.valueOf(this.value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return longValue;
    }

    public String getValueAsString() {
        return this.value;
    }

    public boolean isLimitValue() {
        return this.limitValue;
    }

    public void limitValue(long min, long max) {
        if (max < min) {
            throw new IllegalArgumentException();
        }
        this.minValue = min;
        this.maxValue = max;
        this.limitValue = true;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public void limitMinValue(long min) {
        if (this.getMaxValue() < min) {
            throw new IllegalArgumentException();
        }
        this.minValue = min;
        this.limitValue = true;
    }

    public void limitMaxValue(long max) {
        if (max < this.getMinValue()) {
            throw new IllegalArgumentException();
        }
        this.maxValue = max;
        this.limitValue = true;
    }

    public boolean validate(ArrayList msgList) {
        if (msgList == null) {
            msgList = new ArrayList<String>();
        }
        if (!this.isNotNullValue()) {
            if (this.isNotNull()) {
                msgList.add("\u300e <span class='em'>" + this.fieldName + "</span> \u300f\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                return false;
            }
        } else {
            if (!this.isNumberValue()) {
                msgList.add("\u300e <span class='em'>" + this.fieldName + "</span> \u300f\u306b\u6b63\u3057\u3044\u6570\u5024\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                return false;
            }
            if (this.isLimitValue()) {
                long longValue = this.getValue();
                if (longValue < this.getMinValue()) {
                    msgList.add("\u300e <span class='em'>" + this.fieldName + "</span> \u300f\u306b\u306f" + this.getMinValue() + "\u4ee5\u4e0a\u306e\u5024\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    return false;
                }
                if (longValue > this.getMaxValue()) {
                    msgList.add("\u300e <span class='em'>" + this.fieldName + "</span> \u300f\u306b\u306f" + this.getMaxValue() + "\u4ee5\u4e0b\u306e\u5024\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean isNotNullValue() {
        return this.value != null && this.value.trim().length() > 0;
    }

    protected boolean isNumberValue() {
        if (this.value == null) {
            return false;
        }
        try {
            int len = this.value.length();
            for (int i = 0; i < len; ++i) {
                byte[] chars = Character.valueOf(this.value.charAt(i)).toString().getBytes("shift_jis");
                if (chars.length <= 1) continue;
                return false;
            }
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
        try {
            Long.valueOf(this.value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    public String toString() {
        return ALStringUtil.sanitizing(this.value);
    }
}

