/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.commons.field;

import com.aimluck.commons.field.ALAbstractField;
import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.commons.utils.ALStringUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class ALDateTimeField
extends ALAbstractField {
    public static final String DEFAULT_DATE_TIME_FORMAT = "yyyy/MM/dd HH:mm";
    public static final String DEFAULT_DATE_FORMAT = "yyyy/MM/dd";
    protected Calendar calendar = null;
    protected String format = null;
    protected String year = null;
    protected String month = null;
    protected String day = null;
    protected String hour = null;
    protected String minute = null;

    public ALDateTimeField() {
        this.format = DEFAULT_DATE_FORMAT;
    }

    public ALDateTimeField(String dateFormat) {
        this.format = dateFormat == null ? DEFAULT_DATE_FORMAT : dateFormat;
    }

    public void setValue(String str) {
        this.setValue(this.translateDate(str, this.format));
    }

    public void setValue(Date date) {
        if (date == null) {
            return;
        }
        if (this.calendar == null) {
            this.calendar = new GregorianCalendar();
        }
        this.calendar.setTime(date);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        try {
            this.year = Integer.toString(this.calendar.get(1));
            this.month = Integer.toString(this.calendar.get(2) + 1);
            this.day = Integer.toString(this.calendar.get(5));
            this.hour = Integer.toString(this.calendar.get(11));
            this.minute = Integer.toString(this.calendar.get(12));
        }
        catch (Throwable ex) {
            this.year = null;
            this.month = null;
            this.day = null;
            this.hour = null;
            this.minute = null;
        }
    }

    public Date getValue() {
        return this.calendar.getTime();
    }

    public boolean validate(ArrayList msgList) {
        if (msgList == null) {
            msgList = new ArrayList<String>();
        }
        if (!this.isNotNullValue()) {
            if (this.isNotNull()) {
                msgList.add("\u300e\t<span class='em'>" + this.fieldName + "</span> \u300f\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                return false;
            }
        } else {
            String dateStr = this.translateDate(this.calendar.getTime(), this.format);
            if (dateStr == null) {
                msgList.add("\u300e <span class='em'>" + this.fieldName + "</span> \u300f\u3092\u6b63\u3057\u3044\u65e5\u4ed8\u5f62\u5f0f\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                return false;
            }
        }
        return true;
    }

    public boolean isNullYear() {
        return this.isNullDateTime(this.year);
    }

    public boolean isNullMonth() {
        return this.isNullDateTime(this.month);
    }

    public boolean isNullDay() {
        return this.isNullDateTime(this.day);
    }

    public boolean isNullHour() {
        return this.isNullDateTime(this.hour);
    }

    public boolean isNullMinute() {
        return this.isNullDateTime(this.minute);
    }

    private boolean isNullDateTime(String str) {
        if (this.calendar != null) {
            return false;
        }
        return str == null || str.trim().length() == 0;
    }

    public String toStringYear() {
        if (this.calendar == null || this.isNullYear()) {
            return ALStringUtil.sanitizing(null);
        }
        return ALStringUtil.sanitizing(this.year);
    }

    public String toStringMonth() {
        if (this.calendar == null || this.isNullMonth()) {
            return ALStringUtil.sanitizing(null);
        }
        return ALStringUtil.sanitizing(this.month);
    }

    public String toStringDay() {
        if (this.calendar == null || this.isNullDay()) {
            return ALStringUtil.sanitizing(null);
        }
        return ALStringUtil.sanitizing(this.day);
    }

    public String toStringHour() {
        if (this.calendar == null || this.isNullHour()) {
            return ALStringUtil.sanitizing(null);
        }
        return ALStringUtil.sanitizing(this.hour);
    }

    public String toStringMinute() {
        if (this.calendar == null || this.isNullMinute()) {
            return ALStringUtil.sanitizing(null);
        }
        return ALStringUtil.sanitizing(this.minute);
    }

    public String toStringDayOfWeek() {
        if (this.calendar == null || this.isNullYear() || this.isNullMonth() || this.isNullDay()) {
            return ALStringUtil.sanitizing(null);
        }
        return ALStringUtil.sanitizing(ALDateUtil.getDayOfWeek(this.calendar));
    }

    public String getYear() {
        return this.toStringYear();
    }

    public String getMonth() {
        return this.toStringMonth();
    }

    public String getDay() {
        return this.toStringDay();
    }

    public String getHour() {
        return this.toStringHour();
    }

    public String getMinute() {
        return this.toStringMinute();
    }

    public String getDayOfWeek() {
        return this.toStringDayOfWeek();
    }

    protected boolean isNotNullValue() {
        return this.calendar != null;
    }

    protected String translateDate(Date date, String dateFormat) {
        if (date == null) {
            return "Unknown";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        sdf.setTimeZone(TimeZone.getTimeZone("JST"));
        return sdf.format(date);
    }

    protected Date translateDate(String dateStr, String dateFormat) {
        if (dateStr == null || dateStr.equals("")) {
            return null;
        }
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        sdf.setTimeZone(TimeZone.getTimeZone("JST"));
        try {
            date = sdf.parse(dateStr);
        }
        catch (Exception e) {
            return null;
        }
        return date;
    }

    public String toString() {
        if (this.calendar == null) {
            return ALStringUtil.sanitizing(null);
        }
        return ALStringUtil.sanitizing(this.translateDate(this.getValue(), this.format));
    }
}

