/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.commons.field;

import com.aimluck.commons.field.ALIllegalDateException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.GregorianCalendar;

public class ALDateContainer
implements Serializable {
    protected Date date = null;
    protected String year = null;
    protected String month = null;
    protected String day = null;

    public boolean isNotNullValue() {
        return this.isNullYear() && this.isNullMonth() && this.isNullDay();
    }

    public void setYear(String str) {
        this.year = str;
    }

    public void setYear(int i) {
        this.year = Integer.toString(i);
    }

    public void setMonth(String str) {
        this.month = str;
    }

    public void setMonth(int i) {
        this.month = Integer.toString(i);
    }

    public void setDay(String str) {
        this.day = str;
    }

    public void setDay(int i) {
        this.day = Integer.toString(i);
    }

    public void setDate(Date date) {
        this.date = date;
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            this.year = Integer.toString(calendar.get(1));
            this.month = Integer.toString(calendar.get(2) + 1);
            this.day = Integer.toString(calendar.get(5));
        }
        catch (Throwable ex) {
            this.year = null;
            this.month = null;
            this.day = null;
        }
    }

    public String toStringYear() {
        return this.year;
    }

    public String toStringMonth() {
        return this.month;
    }

    public String toStringDay() {
        return this.day;
    }

    public boolean isNullYear() {
        if (this.date != null) {
            return false;
        }
        return this.year == null || this.year.trim().length() == 0;
    }

    public boolean isNullMonth() {
        if (this.date != null) {
            return false;
        }
        return this.month == null || this.month.trim().length() == 0;
    }

    public boolean isNullDay() {
        if (this.date != null) {
            return false;
        }
        return this.day == null || this.day.trim().length() == 0;
    }

    public int getYear() throws NumberFormatException, ALIllegalDateException {
        if (!this.isNarrow(this.year)) {
            throw new ALIllegalDateException("Year = " + this.year);
        }
        int yearNum = Integer.parseInt(this.year);
        if (yearNum < 0) {
            throw new ALIllegalDateException("Year = " + this.year);
        }
        return yearNum;
    }

    public int getMonth() throws NumberFormatException, ALIllegalDateException {
        if (!this.isNarrow(this.month)) {
            throw new ALIllegalDateException("Month = " + this.month);
        }
        int monthNum = Integer.parseInt(this.month);
        if (monthNum < 1 || monthNum > 12) {
            throw new ALIllegalDateException("Month = " + this.month);
        }
        return monthNum;
    }

    public int getDay() throws NumberFormatException, ALIllegalDateException {
        if (!this.isNarrow(this.day)) {
            throw new ALIllegalDateException("Day = " + this.day);
        }
        int dayNum = Integer.parseInt(this.day);
        if (dayNum < 1 || dayNum > 31) {
            throw new ALIllegalDateException("Day = " + this.day);
        }
        return dayNum;
    }

    public Date getDate() throws NumberFormatException, ALIllegalDateException {
        if (this.date != null) {
            return this.date;
        }
        int yearNum = this.getYear();
        int monthNum = this.getMonth() - 1;
        int dayNum = this.getDay();
        try {
            GregorianCalendar calendar = new GregorianCalendar(yearNum, monthNum, dayNum);
            calendar.setLenient(false);
            this.date = calendar.getTime();
            return this.date;
        }
        catch (IllegalArgumentException ex) {
            throw new ALIllegalDateException("Year = " + this.year + ", Month = " + this.month + ", Day = " + this.day);
        }
    }

    protected boolean isNarrow(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        try {
            for (int i = 0; i < length; ++i) {
                byte[] chars = Character.valueOf(str.charAt(i)).toString().getBytes("shift_jis");
                if (chars.length <= 1) continue;
                return false;
            }
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(this.toStringYear()).append("/").append(this.toStringMonth()).append("/").append(this.toStringDay());
        }
        catch (Throwable ex) {
            return "";
        }
        return sb.toString();
    }
}

