/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule.util;

import com.aimluck.commons.field.ALAbstractField;
import com.aimluck.commons.field.ALCellDateField;
import com.aimluck.commons.field.ALCellDateTimeField;
import com.aimluck.commons.field.ALCellStringField;
import com.aimluck.commons.field.ALDateContainer;
import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALIllegalDateException;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.category.util.CommonCategoryUtils;
import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipTCommonCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.schedule.AjaxScheduleResultData;
import com.aimluck.eip.schedule.AjaxTermScheduleWeekContainer;
import com.aimluck.eip.schedule.ScheduleResultData;
import com.aimluck.eip.schedule.ScheduleTermWeekContainer;
import com.aimluck.eip.schedule.ScheduleToDoResultData;
import com.aimluck.eip.schedule.ScheduleToDoWeekContainer;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.userfacility.beans.UserFacilityLiteBean;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whatsnew.util.WhatsNewUtils;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ScheduleUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ScheduleUtils.class.getName());
    public static final String SCHEDULEMAP_TYPE_USER = "U";
    public static final String SCHEDULEMAP_TYPE_FACILITY = "F";
    public static final String TARGET_FACILITY_ID = "f";

    public static EipTSchedule getEipTSchedule(RunData rundata, Context context, boolean isOwner) throws ALPageNotFoundException, ALDBErrorException {
        return ScheduleUtils.getEipTSchedule(rundata, context, isOwner, ALEipUtils.getUserId((RunData)rundata));
    }

    public static EipTSchedule getEipTSchedule(RunData rundata, int scheduleid, boolean isOwner, int userid) throws ALPageNotFoundException, ALDBErrorException {
        try {
            List schedules;
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTSchedule.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"SCHEDULE_ID", (Object)scheduleid);
            query.setQualifier(exp1);
            if (isOwner) {
                Expression exp2 = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
                query.andQualifier(exp2);
            }
            if ((schedules = dataContext.performQuery((Query)query)) == null || schedules.size() == 0) {
                logger.error((Object)"[ScheduleUtils] Not found record.");
                throw new ALPageNotFoundException();
            }
            EipTSchedule record = (EipTSchedule)schedules.get(0);
            SelectQuery mapquery = new SelectQuery(EipTScheduleMap.class);
            Expression mapexp1 = ExpressionFactory.matchExp((String)"scheduleId", (Object)record.getScheduleId());
            mapquery.setQualifier(mapexp1);
            Expression mapexp2 = ExpressionFactory.matchExp((String)"userId", (Object)userid);
            mapquery.andQualifier(mapexp2);
            Expression mapexp3 = ExpressionFactory.matchExp((String)"userId", (Object)userid);
            mapquery.andQualifier(mapexp3);
            List schedulemaps = dataContext.performQuery((Query)mapquery);
            boolean is_member = schedulemaps != null && schedulemaps.size() > 0;
            boolean is_public = "O".equals(record.getPublicFlag());
            if (!is_member && !is_public) {
                logger.error((Object)"[ScheduleUtils] Cannnot access this record. ");
                throw new ALPageNotFoundException();
            }
            return (EipTSchedule)schedules.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[ScheduleUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static EipTSchedule getEipTSchedule(RunData rundata, Context context, boolean isOwner, int userid) throws ALPageNotFoundException, ALDBErrorException {
        String scheduleid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (scheduleid == null || Integer.valueOf(scheduleid) == null) {
                logger.error((Object)"[ScheduleUtils] ENTITYID is empty.");
                throw new ALPageNotFoundException();
            }
        }
        catch (NumberFormatException ex) {
            logger.error((Object)"[ScheduleUtils] NumberFormatException: ENTITYID is wrong.");
            throw new ALPageNotFoundException();
        }
        try {
            List schedules;
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTSchedule.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"SCHEDULE_ID", (Object)scheduleid);
            query.setQualifier(exp1);
            if (isOwner) {
                Expression exp2 = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
                query.andQualifier(exp2);
            }
            if ((schedules = dataContext.performQuery((Query)query)) == null || schedules.size() == 0) {
                logger.error((Object)"[ScheduleUtils] Not found record.");
                throw new ALPageNotFoundException();
            }
            EipTSchedule record = (EipTSchedule)schedules.get(0);
            SelectQuery mapquery = new SelectQuery(EipTScheduleMap.class);
            Expression mapexp1 = ExpressionFactory.matchExp((String)"scheduleId", (Object)record.getScheduleId());
            mapquery.setQualifier(mapexp1);
            Expression mapexp21 = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
            Expression mapexp22 = ExpressionFactory.matchExp((String)"eipTSchedule.createUserId", (Object)ALEipUtils.getUserId((RunData)rundata));
            mapquery.andQualifier(mapexp21.orExp(mapexp22));
            List schedulemaps = dataContext.performQuery((Query)mapquery);
            boolean is_member = schedulemaps != null && schedulemaps.size() > 0;
            int loginuser_id = ALEipUtils.getUserId((RunData)rundata);
            boolean is_owner = record.getOwnerId() == loginuser_id;
            boolean is_createuser = loginuser_id == record.getCreateUserId();
            boolean is_public = "O".equals(record.getPublicFlag());
            if (!(is_public || is_member || is_createuser || is_owner)) {
                ALEipUtils.redirectPermissionError((RunData)rundata);
            }
            return (EipTSchedule)schedules.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[ScheduleUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static EipTSchedule getEipTScheduleDetail(RunData rundata, Context context, boolean isOwner, int id, String type) throws ALPageNotFoundException, ALDBErrorException {
        String scheduleid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (scheduleid == null || Integer.valueOf(scheduleid) == null) {
                logger.error((Object)"[ScheduleUtils] ENTITYID is empty.");
                throw new ALPageNotFoundException();
            }
        }
        catch (NumberFormatException ex) {
            logger.error((Object)"[ScheduleUtils] NumberFormatException: ENTITYID is wrong.", (Throwable)ex);
            throw new ALPageNotFoundException();
        }
        try {
            WhatsNewUtils.shiftWhatsNewReadFlag((int)6, (int)Integer.parseInt(scheduleid), (int)ALEipUtils.getUserId((RunData)rundata));
        }
        catch (NumberFormatException e) {
            logger.error((Object)"[ScheduleUtils]", (Throwable)e);
        }
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTSchedule.class);
            query.setRefreshingObjects(true);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"SCHEDULE_ID", (Object)scheduleid);
            query.setQualifier(exp1);
            if (isOwner) {
                Expression exp2 = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
                query.andQualifier(exp2);
            }
            Expression exp3 = ExpressionFactory.matchExp((String)"eipTScheduleMaps.type", (Object)type);
            query.andQualifier(exp3);
            List schedules = dataContext.performQuery((Query)query);
            if (schedules == null || schedules.size() == 0) {
                logger.error((Object)"[ScheduleUtils] Not found record.");
                throw new ALPageNotFoundException();
            }
            EipTSchedule record = (EipTSchedule)schedules.get(0);
            SelectQuery mapquery = new SelectQuery(EipTScheduleMap.class);
            Expression mapexp1 = ExpressionFactory.matchExp((String)"scheduleId", (Object)record.getScheduleId());
            mapquery.setQualifier(mapexp1);
            Expression mapexp21 = ExpressionFactory.matchExp((String)"userId", (Object)Integer.toString(ALEipUtils.getUserId((RunData)rundata)));
            Expression mapexp22 = ExpressionFactory.matchExp((String)"eipTSchedule.createUserId", (Object)ALEipUtils.getUserId((RunData)rundata));
            mapquery.andQualifier(mapexp21.orExp(mapexp22));
            Expression mapexp3 = ExpressionFactory.matchExp((String)"type", (Object)type);
            mapquery.andQualifier(mapexp3);
            List schedulemaps = dataContext.performQuery((Query)mapquery);
            boolean is_member = schedulemaps != null && schedulemaps.size() > 0;
            int loginuser_id = ALEipUtils.getUserId((RunData)rundata);
            boolean is_owner = record.getOwnerId() == loginuser_id;
            boolean is_createuser = loginuser_id == record.getCreateUserId();
            boolean is_public = "O".equals(record.getPublicFlag());
            if (!(type.equals(SCHEDULEMAP_TYPE_FACILITY) || is_public || is_member || is_createuser || is_owner)) {
                ALEipUtils.redirectPermissionError((RunData)rundata);
            }
            return (EipTSchedule)schedules.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[ScheduleUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static EipTScheduleMap getEipTScheduleMap(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String scheduleid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (scheduleid == null || Integer.valueOf(scheduleid) == null) {
                logger.error((Object)"[ScheduleUtils] ENTITYID is empty.");
                throw new ALPageNotFoundException();
            }
        }
        catch (NumberFormatException ex) {
            logger.error((Object)"[ScheduleUtils] NumberFormatException: ENTITYID is wrong.", (Throwable)ex);
            throw new ALPageNotFoundException();
        }
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTScheduleMap.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"scheduleId", (Object)scheduleid);
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.andQualifier(exp2);
            List schedules = dataContext.performQuery((Query)query);
            if (schedules == null || schedules.size() == 0) {
                logger.error((Object)"[ScheduleUtils] Not found record.");
                throw new ALPageNotFoundException();
            }
            return (EipTScheduleMap)schedules.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[ScheduleUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static List getEipTScheduleMaps(EipTSchedule schedule) throws ALPageNotFoundException, ALDBErrorException {
        Integer scheduleid = schedule.getScheduleId();
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTScheduleMap.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"scheduleId", (Object)scheduleid);
            query.setQualifier(exp1);
            List schedules = dataContext.performQuery((Query)query);
            if (schedules == null || schedules.size() == 0) {
                logger.error((Object)"[ScheduleUtils] Not found record.");
                throw new ALPageNotFoundException();
            }
            return schedules;
        }
        catch (Exception ex) {
            logger.error((Object)"[ScheduleUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static List getUsers(RunData rundata, Context context, boolean includeLoginUser) throws ALPageNotFoundException, ALDBErrorException {
        ArrayList<ALEipUser> list = new ArrayList<ALEipUser>();
        String scheduleid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (scheduleid == null || Integer.valueOf(scheduleid) == null) {
                logger.error((Object)"[ScheduleUtils] ENTITYID is empty.");
                throw new ALPageNotFoundException();
            }
        }
        catch (NumberFormatException ex) {
            logger.error((Object)"[ScheduleUtils] NumberFormatException: ENTITYID is wrong.", (Throwable)ex);
            throw new ALPageNotFoundException();
        }
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery mapquery = new SelectQuery(EipTScheduleMap.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"scheduleId", (Object)Integer.valueOf(scheduleid));
            mapquery.setQualifier(exp1);
            if (!includeLoginUser) {
                Expression exp2 = ExpressionFactory.noMatchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
                mapquery.andQualifier(exp2);
            }
            List schedulemaps = dataContext.performQuery((Query)mapquery);
            ArrayList<Integer> uidlist = new ArrayList<Integer>();
            EipTScheduleMap map = null;
            int mapsize = schedulemaps.size();
            for (int i = 0; i < mapsize; ++i) {
                map = (EipTScheduleMap)schedulemaps.get(i);
                if (uidlist.contains(map.getUserId())) continue;
                uidlist.add(map.getUserId());
            }
            SelectQuery userquery = new SelectQuery(TurbineUser.class);
            Expression userexp = ExpressionFactory.inDbExp((String)"USER_ID", uidlist);
            userquery.setQualifier(userexp);
            ArrayList<Ordering> orders = new ArrayList<Ordering>();
            orders.add(new Ordering("lastNameKana", true));
            orders.add(new Ordering("firstNameKana", true));
            userquery.addOrderings(orders);
            List ulist = dataContext.performQuery((Query)userquery);
            for (int j = 0; j < ulist.size(); ++j) {
                TurbineUser tuser = (TurbineUser)ulist.get(j);
                ALEipUser user = new ALEipUser();
                user.initField();
                user.setUserId(tuser.getUserId().intValue());
                user.setName(tuser.getLoginName());
                user.setAliasName(tuser.getFirstName(), tuser.getLastName());
                list.add(user);
            }
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleUtils]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return list;
    }

    public static int[] getFacilityIds(EipTSchedule schedule) throws ALPageNotFoundException, ALDBErrorException {
        List list = schedule.getEipTScheduleMaps();
        ArrayList<Integer> flist = new ArrayList<Integer>();
        EipTScheduleMap map = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            map = (EipTScheduleMap)list.get(i);
            if (!SCHEDULEMAP_TYPE_FACILITY.equals(map.getType())) continue;
            flist.add(map.getUserId());
        }
        int fsize = flist.size();
        int[] ids = new int[fsize];
        for (int i = 0; i < fsize; ++i) {
            ids[i] = (Integer)flist.get(i);
        }
        return ids;
    }

    public static boolean isView(ALDateTimeField date, String ptn, Date startDate, Date limitDate) {
        int count = 0;
        boolean is_repeat = true;
        boolean result = false;
        Calendar cal = Calendar.getInstance();
        cal.setTime(date.getValue());
        if (ptn.charAt(0) == 'D') {
            result = true;
            count = 1;
        } else if (ptn.charAt(0) == 'W') {
            int dow = cal.get(7);
            switch (dow) {
                case 1: {
                    result = ptn.charAt(1) != '0';
                    break;
                }
                case 2: {
                    result = ptn.charAt(2) != '0';
                    break;
                }
                case 3: {
                    result = ptn.charAt(3) != '0';
                    break;
                }
                case 4: {
                    result = ptn.charAt(4) != '0';
                    break;
                }
                case 5: {
                    result = ptn.charAt(5) != '0';
                    break;
                }
                case 6: {
                    result = ptn.charAt(6) != '0';
                    break;
                }
                case 7: {
                    result = ptn.charAt(7) != '0';
                    break;
                }
                default: {
                    result = false;
                }
            }
            count = 8;
        } else if (ptn.charAt(0) == 'M') {
            int mday = Integer.parseInt(ptn.substring(1, 3));
            result = Integer.parseInt(date.getDay()) == mday;
            count = 3;
        } else {
            return true;
        }
        if (result && ptn.charAt(count) == 'L') {
            result = ScheduleUtils.equalsToDate(startDate, date.getValue(), false) || ScheduleUtils.equalsToDate(limitDate, date.getValue(), false) ? true : result && startDate.before(cal.getTime()) && limitDate.after(cal.getTime());
        }
        return result;
    }

    public static String getPortletURIinPersonalConfigPane(RunData rundata, String portletEntryName) {
        try {
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return null;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return null;
            }
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    if (!entries[j].getParent().equals(portletEntryName)) continue;
                    JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
                    DynamicURI duri = jsLink.getLink(101, null, null, 101, null);
                    duri = duri.addPathInfo("js_pane", portletList[i].getId() + "," + entries[j].getId()).addQueryData("action", "controls.Restore");
                    return duri.toString();
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
        return null;
    }

    public static String getPortletURItoTodoDetailPane(RunData rundata, String portletEntryName, long entityid, String schedulePortletId) {
        return ScheduleUtils.getPortletURItoTodoModePane(rundata, portletEntryName, entityid, schedulePortletId, "detail");
    }

    public static String getPortletURItoTodoPublicDetailPane(RunData rundata, String portletEntryName, long entityid, String schedulePortletId) {
        return ScheduleUtils.getPortletURItoTodoModePane(rundata, portletEntryName, entityid, schedulePortletId, "public_detail");
    }

    public static String getPortletURItoTodoModePane(RunData rundata, String portletEntryName, long entityid, String schedulePortletId, String mode) {
        if (mode == null || "".equals(mode)) {
            return null;
        }
        try {
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return null;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return null;
            }
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    if (!entries[j].getParent().equals(portletEntryName)) continue;
                    JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
                    DynamicURI duri = jsLink.getLink(101, null, null, 101, null);
                    duri = duri.addPathInfo("js_pane", portletList[i].getId()).addPathInfo("js_peid", entries[j].getId()).addQueryData("action", "controls.Maximize").addQueryData("mode", mode).addQueryData("entityid", entityid).addQueryData("sch", schedulePortletId);
                    int jmode = ((JetspeedRunData)rundata).getMode();
                    if (jmode == 2) {
                        duri.addQueryData("prev", 2);
                    } else {
                        duri.addQueryData("prev", 0);
                    }
                    return duri.toString();
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
        return null;
    }

    public static String getPortletURItoTodoDetailPaneForCell(RunData rundata, String portletEntryName, long entityid, String schedulePortletId) {
        return ScheduleUtils.getPortletURItoTodoModePaneForCell(rundata, portletEntryName, entityid, schedulePortletId, "detail");
    }

    public static String getPortletURItoTodoModePaneForCell(RunData rundata, String portletEntryName, long entityid, String schedulePortletId, String mode) {
        if (mode == null || "".equals(mode)) {
            return null;
        }
        try {
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return null;
            }
            Entry[] entries = portlets.getEntriesArray();
            if (entries == null || entries.length <= 0) {
                return null;
            }
            int ent_length = entries.length;
            for (int j = 0; j < ent_length; ++j) {
                if (!entries[j].getParent().equals(portletEntryName)) continue;
                JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
                DynamicURI duri = jsLink.getLink(101, null, null, 101, null);
                duri = duri.addPathInfo("js_peid", entries[j].getId()).addQueryData("action", "controls.Maximize").addQueryData("mode", mode).addQueryData("entityid", entityid).addQueryData("sch", schedulePortletId);
                return duri.toString();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
        return null;
    }

    public static boolean equalsToDate(Date date1, Date date2, boolean checkTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        int date1Year = cal.get(1);
        int date1Month = cal.get(2) + 1;
        int date1Day = cal.get(5);
        int date1Hour = cal.get(10);
        int date1Minute = cal.get(12);
        cal.setTime(date2);
        int date2Year = cal.get(1);
        int date2Month = cal.get(2) + 1;
        int date2Day = cal.get(5);
        int date2Hour = cal.get(10);
        int date2Minute = cal.get(12);
        return checkTime ? date1Year == date2Year && date1Month == date2Month && date1Day == date2Day && date1Hour == date2Hour && date1Minute == date2Minute : date1Year == date2Year && date1Month == date2Month && date1Day == date2Day;
    }

    public static int compareToDate(Date date1, Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        int date1Year = cal.get(1);
        int date1Month = cal.get(2) + 1;
        int date1Day = cal.get(5);
        cal.setTime(date2);
        int date2Year = cal.get(1);
        int date2Month = cal.get(2) + 1;
        int date2Day = cal.get(5);
        if (date1Year == date2Year && date1Month == date2Month && date1Day == date2Day) {
            return 0;
        }
        if (date1Year < date2Year) {
            return 1;
        }
        if (date2Year > date1Year) {
            return -1;
        }
        if (date1Month < date2Month) {
            return 1;
        }
        if (date2Month > date1Month) {
            return -1;
        }
        if (date1Day < date2Day) {
            return 1;
        }
        return -1;
    }

    public static int compareTime(Date date1, Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        int date1Hour = cal.get(11);
        int date1Minute = cal.get(12);
        cal.setTime(date2);
        int date2Hour = cal.get(11);
        int date2Minute = cal.get(12);
        if (date1Hour == date2Hour && date1Minute == date2Minute) {
            return 0;
        }
        if (date1Hour < date2Hour) {
            return 1;
        }
        if (date1Hour > date2Hour) {
            return -1;
        }
        if (date1Minute < date2Minute) {
            return 1;
        }
        return -1;
    }

    public static boolean isMsieBrowser(RunData rundata) {
        String os = "Win";
        String browserNames = "MSIE";
        String userAgent = rundata.getRequest().getHeader("User-Agent");
        if (userAgent == null || userAgent.equals("")) {
            return false;
        }
        if (userAgent.indexOf("Win") < 0) {
            return false;
        }
        return userAgent.indexOf(browserNames) > 0;
    }

    public static void insertDummySchedule(EipTSchedule schedule, int ownerid, Date startDate, Date endDate, int[] memberIdList, int[] facilityIdList) throws ALDBErrorException {
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        EipTSchedule dummySchedule = (EipTSchedule)dataContext.createAndRegisterNewObject(EipTSchedule.class);
        dummySchedule.setParentId(schedule.getScheduleId());
        dummySchedule.setName("dummy");
        dummySchedule.setPlace("");
        dummySchedule.setNote("");
        dummySchedule.setPublicFlag("P");
        dummySchedule.setEditFlag(SCHEDULEMAP_TYPE_FACILITY);
        dummySchedule.setOwnerId(Integer.valueOf(ownerid));
        Date now2 = new Date();
        dummySchedule.setCreateDate(now2);
        dummySchedule.setCreateUserId(Integer.valueOf(ownerid));
        dummySchedule.setUpdateDate(now2);
        dummySchedule.setUpdateUserId(Integer.valueOf(ownerid));
        dummySchedule.setRepeatPattern("N");
        dummySchedule.setStartDate(startDate);
        dummySchedule.setEndDate(endDate);
        EipTCommonCategory category = CommonCategoryUtils.getEipTCommonCategory((DataContext)dataContext, (Long)1L);
        int size = memberIdList.length;
        for (int i = 0; i < size; ++i) {
            EipTScheduleMap map = (EipTScheduleMap)dataContext.createAndRegisterNewObject(EipTScheduleMap.class);
            int userid = memberIdList[i];
            map.setEipTSchedule(dummySchedule);
            map.setUserId(Integer.valueOf(userid));
            map.setStatus("D");
            map.setType(SCHEDULEMAP_TYPE_USER);
            map.setCommonCategoryId(Integer.valueOf(1));
            map.setEipTCommonCategory(category);
        }
        if (facilityIdList != null && facilityIdList.length > 0) {
            int fsize = facilityIdList.length;
            for (int i = 0; i < fsize; ++i) {
                EipTScheduleMap map = (EipTScheduleMap)dataContext.createAndRegisterNewObject(EipTScheduleMap.class);
                int fid = facilityIdList[i];
                map.setEipTSchedule(dummySchedule);
                map.setUserId(Integer.valueOf(fid));
                map.setStatus("D");
                map.setType(SCHEDULEMAP_TYPE_FACILITY);
                map.setCommonCategoryId(Integer.valueOf(1));
                map.setEipTCommonCategory(category);
            }
        }
        dataContext.commitChanges();
    }

    public static void insertDummySchedule(EipTSchedule schedule, int ownerid, Date startDate, Date endDate, int[] memberIdList) throws ALDBErrorException {
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        EipTSchedule dummySchedule = (EipTSchedule)dataContext.createAndRegisterNewObject(EipTSchedule.class);
        dummySchedule.setParentId(schedule.getScheduleId());
        dummySchedule.setName("dummy");
        dummySchedule.setPlace("");
        dummySchedule.setNote("");
        dummySchedule.setPublicFlag("P");
        dummySchedule.setEditFlag(SCHEDULEMAP_TYPE_FACILITY);
        dummySchedule.setOwnerId(Integer.valueOf(ownerid));
        Date now2 = new Date();
        dummySchedule.setCreateDate(now2);
        dummySchedule.setCreateUserId(Integer.valueOf(ownerid));
        dummySchedule.setUpdateDate(now2);
        dummySchedule.setUpdateUserId(Integer.valueOf(ownerid));
        dummySchedule.setRepeatPattern("N");
        dummySchedule.setStartDate(startDate);
        dummySchedule.setEndDate(endDate);
        EipTCommonCategory category = CommonCategoryUtils.getEipTCommonCategory((DataContext)dataContext, (Long)1L);
        int size = memberIdList.length;
        for (int i = 0; i < size; ++i) {
            EipTScheduleMap map = (EipTScheduleMap)dataContext.createAndRegisterNewObject(EipTScheduleMap.class);
            int userid = memberIdList[i];
            map.setEipTSchedule(dummySchedule);
            map.setUserId(Integer.valueOf(userid));
            map.setStatus("D");
            map.setType(SCHEDULEMAP_TYPE_USER);
            map.setCommonCategoryId(Integer.valueOf(1));
            map.setEipTCommonCategory(category);
        }
        dataContext.commitChanges();
    }

    public static void insertDummySchedule(EipTSchedule schedule, int ownerid, Date startDate, Date endDate, List memberIdList, List facilityIdList) throws ALDBErrorException {
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        EipTSchedule dummySchedule = (EipTSchedule)dataContext.createAndRegisterNewObject(EipTSchedule.class);
        dummySchedule.setParentId(schedule.getScheduleId());
        dummySchedule.setName("dummy");
        dummySchedule.setPlace("");
        dummySchedule.setNote("");
        dummySchedule.setPublicFlag("P");
        dummySchedule.setEditFlag(SCHEDULEMAP_TYPE_FACILITY);
        dummySchedule.setOwnerId(Integer.valueOf(ownerid));
        Date now2 = new Date();
        dummySchedule.setCreateDate(now2);
        dummySchedule.setCreateUserId(Integer.valueOf(ownerid));
        dummySchedule.setUpdateDate(now2);
        dummySchedule.setUpdateUserId(Integer.valueOf(ownerid));
        dummySchedule.setRepeatPattern("N");
        dummySchedule.setStartDate(startDate);
        dummySchedule.setEndDate(endDate);
        EipTCommonCategory category = CommonCategoryUtils.getEipTCommonCategory((DataContext)dataContext, (Long)1L);
        int size = memberIdList.size();
        for (int i = 0; i < size; ++i) {
            EipTScheduleMap map = (EipTScheduleMap)dataContext.createAndRegisterNewObject(EipTScheduleMap.class);
            int userid = (Integer)memberIdList.get(i);
            map.setEipTSchedule(dummySchedule);
            map.setUserId(Integer.valueOf(userid));
            map.setStatus("D");
            map.setType(SCHEDULEMAP_TYPE_USER);
            map.setCommonCategoryId(Integer.valueOf(1));
            map.setEipTCommonCategory(category);
        }
        if (facilityIdList != null) {
            int fsize = facilityIdList.size();
            for (int i = 0; i < fsize; ++i) {
                EipTScheduleMap map = (EipTScheduleMap)dataContext.createAndRegisterNewObject(EipTScheduleMap.class);
                int fid = (Integer)facilityIdList.get(i);
                map.setEipTSchedule(dummySchedule);
                map.setUserId(Integer.valueOf(fid));
                map.setStatus("D");
                map.setType(SCHEDULEMAP_TYPE_FACILITY);
                map.setCommonCategoryId(Integer.valueOf(1));
                map.setEipTCommonCategory(category);
            }
        }
        dataContext.commitChanges();
    }

    public static List sortByDummySchedule(List list) {
        ArrayList<EipTScheduleMap> dummyList = new ArrayList<EipTScheduleMap>();
        ArrayList<EipTScheduleMap> normalList = new ArrayList<EipTScheduleMap>();
        EipTScheduleMap map = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            map = (EipTScheduleMap)list.get(i);
            if ("D".equals(map.getStatus())) {
                dummyList.add(map);
                continue;
            }
            normalList.add(map);
        }
        list.clear();
        list.addAll(dummyList);
        list.addAll(normalList);
        return list;
    }

    public static String getCurrentTab(RunData rundata, Context context) {
        String tmpCurrentTab;
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"tab")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)rundata.getParameters().getString("tab"));
        }
        String currentTab = (tmpCurrentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tab")) == null || !tmpCurrentTab.equals("oneday") && !tmpCurrentTab.equals("weekly") && !tmpCurrentTab.equals("monthly") && !tmpCurrentTab.equals("oneday-group") && !tmpCurrentTab.equals("weekly-group") ? "oneday" : tmpCurrentTab;
        return currentTab;
    }

    public static String translateDate(Date date, String dateFormat) {
        if (date == null) {
            return "Unknown";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        sdf.setTimeZone(TimeZone.getTimeZone("JST"));
        return sdf.format(date);
    }

    public static boolean includeWeek(int selectedWeek, int startWeek, int endWeek) {
        if (startWeek <= endWeek) {
            return startWeek <= selectedWeek && selectedWeek <= endWeek;
        }
        return selectedWeek >= startWeek || endWeek >= selectedWeek;
    }

    public static boolean isContains(List memberIdList, int userId) {
        int size = memberIdList.size();
        Integer tmpInt = null;
        for (int i = 0; i < size; ++i) {
            tmpInt = (Integer)memberIdList.get(i);
            if (userId != tmpInt) continue;
            return true;
        }
        return false;
    }

    public static boolean isContains(List memberList, ALEipUser user) {
        int size = memberList.size();
        long userid = user.getUserId().getValue();
        ALEipUser member = null;
        for (int i = 0; i < size; ++i) {
            member = (ALEipUser)memberList.get(i);
            if (member.getUserId().getValue() != userid) continue;
            return true;
        }
        return false;
    }

    public static boolean removeUser(List memberList, ALEipUser user) {
        if (memberList == null || memberList.size() == 0 || user == null) {
            return false;
        }
        int index = -1;
        int size = memberList.size();
        long userid = user.getUserId().getValue();
        ALEipUser member = null;
        for (int i = 0; i < size; ++i) {
            member = (ALEipUser)memberList.get(i);
            if (member.getUserId().getValue() != userid) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            memberList.remove(index);
            return true;
        }
        return false;
    }

    public static EipTScheduleMap getScheduleMap(List scheduleMaps, int userid) {
        EipTScheduleMap map = null;
        int size = scheduleMaps.size();
        for (int i = 0; i < size; ++i) {
            map = (EipTScheduleMap)scheduleMaps.get(i);
            if (map.getUserId() != userid) continue;
            return map;
        }
        return null;
    }

    public static boolean setFormDataDelegate(RunData rundata, Context context, ALAbstractFormData formdata, Field[] fields, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        if (fields == null || fields.length == 0) {
            return false;
        }
        boolean res = false;
        try {
            String FORMAT_DATE = "yyyyMMdd";
            String FORMAT_TIME = "HHmm";
            int FORMAT_DATE_LEN = FORMAT_DATE.length();
            int FORMAT_TIME_LEN = FORMAT_TIME.length();
            int length = fields.length;
            for (int i = 0; i < length; ++i) {
                ALCellDateField field;
                fields[i].setAccessible(true);
                String name = fields[i].getName();
                Object obj = fields[i].get(formdata);
                if (obj instanceof ALCellDateTimeField) {
                    String dateString = new StringBuffer().append(name).append("_date").toString();
                    String timeString = new StringBuffer().append(name).append("_time").toString();
                    ALCellDateTimeField field2 = (ALCellDateTimeField)obj;
                    String dateStr = null;
                    String timeStr = null;
                    Calendar cal = Calendar.getInstance();
                    if (!rundata.getParameters().containsKey((Object)dateString)) continue;
                    dateStr = rundata.getParameters().getString(dateString);
                    if (!rundata.getParameters().containsKey((Object)timeString)) continue;
                    timeStr = rundata.getParameters().getString(timeString);
                    if (dateStr.length() != FORMAT_DATE_LEN) {
                        msgList.add("\u300e\u65e5\u4ed8\u300f\u3067\u5165\u529b\u3055\u308c\u305f\u5e74\u6708\u65e5\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                        continue;
                    }
                    if (timeStr.length() != FORMAT_TIME_LEN) {
                        msgList.add("\u300e\u6642\u9593\u300f\u3067\u5165\u529b\u3055\u308c\u305f\u6642\u9593\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                        continue;
                    }
                    ArrayList tmpList = new ArrayList();
                    ALCellStringField sf = new ALCellStringField(dateStr);
                    sf.setTrim(true);
                    sf.setCharacterType(2);
                    sf.setValue(dateStr);
                    sf.validate(tmpList);
                    if (tmpList.size() != 0) {
                        msgList.add("\u300e\u65e5\u4ed8\u300f\u3067\u5165\u529b\u3055\u308c\u305f\u5e74\u6708\u65e5\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                        continue;
                    }
                    sf = new ALCellStringField(timeStr);
                    sf.setTrim(true);
                    sf.setCharacterType(2);
                    sf.setValue(dateStr);
                    sf.validate(tmpList);
                    if (tmpList.size() != 0) {
                        msgList.add("\u300e\u6642\u9593\u300f\u3067\u5165\u529b\u3055\u308c\u305f\u6642\u9593\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                        continue;
                    }
                    Date date = null;
                    SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_DATE);
                    sdf.setLenient(false);
                    sdf.setTimeZone(TimeZone.getTimeZone("JST"));
                    if (dateStr.equals("")) continue;
                    try {
                        date = sdf.parse(dateStr);
                    }
                    catch (Exception e) {
                        msgList.add("\u300e\u65e5\u4ed8\u300f\u3067\u5165\u529b\u3055\u308c\u305f\u5e74\u6708\u65e5\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                        continue;
                    }
                    Date time = null;
                    SimpleDateFormat sdf2 = new SimpleDateFormat(FORMAT_TIME);
                    sdf2.setLenient(false);
                    sdf2.setTimeZone(TimeZone.getTimeZone("JST"));
                    if (timeStr.equals("")) continue;
                    try {
                        time = sdf2.parse(timeStr);
                    }
                    catch (Exception e) {
                        msgList.add("\u300e\u6642\u9593\u300f\u3067\u5165\u529b\u3055\u308c\u305f\u6642\u9593\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                        continue;
                    }
                    date.setHours(time.getHours());
                    date.setMinutes(time.getMinutes());
                    cal.setLenient(false);
                    cal.setTime(date);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    field2.setValue(cal.getTime());
                    continue;
                }
                if (obj instanceof ALCellDateField) {
                    field = (ALCellDateField)obj;
                    Date date = null;
                    ALDateContainer con = new ALDateContainer();
                    String dateString = new StringBuffer().append(name).toString();
                    String dateStr = null;
                    if (!rundata.getParameters().containsKey((Object)name) || (dateStr = rundata.getParameters().getString(dateString)) == null || dateStr.equals("")) continue;
                    if (dateStr.length() != FORMAT_DATE_LEN) {
                        msgList.add("\u300e\u65e5\u4ed8\u300f\u3067\u5165\u529b\u3055\u308c\u305f\u5e74\u6708\u65e5\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                        continue;
                    }
                    ArrayList tmpList = new ArrayList();
                    ALCellStringField sf = new ALCellStringField(dateStr);
                    sf.setTrim(true);
                    sf.setCharacterType(2);
                    sf.setValue(dateStr);
                    sf.validate(tmpList);
                    if (tmpList.size() != 0) {
                        msgList.add("\u300e\u65e5\u4ed8\u300f\u3067\u5165\u529b\u3055\u308c\u305f\u5e74\u6708\u65e5\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                        continue;
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_DATE);
                    sdf.setLenient(false);
                    sdf.setTimeZone(TimeZone.getTimeZone("JST"));
                    try {
                        date = sdf.parse(dateStr);
                    }
                    catch (Exception e) {
                        msgList.add("\u300e\u65e5\u4ed8\u300f\u3067\u5165\u529b\u3055\u308c\u305f\u5e74\u6708\u65e5\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                        continue;
                    }
                    date.setHours(0);
                    date.setMinutes(0);
                    Calendar cal = Calendar.getInstance();
                    cal.setLenient(false);
                    cal.setTime(date);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    con.setYear(cal.get(1));
                    con.setMonth(cal.get(2) + 1);
                    con.setDay(cal.get(5));
                    field.setValue(con);
                    continue;
                }
                if (!(obj instanceof ALAbstractField)) continue;
                field = (ALAbstractField)obj;
                if (!rundata.getParameters().containsKey((Object)name)) continue;
                field.setValue(rundata.getParameters().getString(name));
            }
            res = true;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return res;
    }

    public static void loadParametersDelegate(RunData rundata, Context context, String tmpStart, String tmpEnd, String tmpView) {
        ALDateTimeField dummy = new ALDateTimeField("yyyy-MM-dd-HH-mm");
        dummy.setNotNull(true);
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            Calendar cal = Calendar.getInstance();
            int min = cal.get(12);
            if (min <= 15) {
                cal.set(12, 15);
            } else if (min <= 30) {
                cal.set(12, 30);
            } else if (min <= 45) {
                cal.set(12, 45);
            } else {
                cal.set(12, 60);
            }
            Date now = cal.getTime();
            if (rundata.getParameters().containsKey((Object)"form_start")) {
                tmpStart = rundata.getParameters().getString("form_start");
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpStart", (String)tmpStart);
                dummy.setValue(tmpStart);
                if (!dummy.validate(new ArrayList())) {
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"form_start");
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"form_end");
                    logger.debug((Object)"[ScheduleFormData] Parameter cannot validate");
                    ALEipUtils.redirectPageNotFound((RunData)rundata);
                    return;
                }
            } else {
                dummy.setValue(now);
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpStart", (String)dummy.toString());
            }
            if (rundata.getParameters().containsKey((Object)"form_end")) {
                tmpEnd = rundata.getParameters().getString("form_end");
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpEnd", (String)tmpEnd);
                dummy.setValue(tmpEnd);
                if (!dummy.validate(new ArrayList())) {
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"form_start");
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"form_end");
                    logger.debug((Object)"[ScheduleFormData] Parameter cannot validate");
                    ALEipUtils.redirectPageNotFound((RunData)rundata);
                    return;
                }
            } else {
                dummy.setValue(now);
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpEnd", (String)dummy.toString());
            }
        }
        tmpStart = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tmpStart");
        ScheduleUtils.loadParametersViewDate(rundata, context, tmpStart, tmpView);
    }

    public static void loadParametersViewDate(RunData rundata, Context context, String tmpStart, String tmpView) {
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            if (rundata.getParameters().containsKey((Object)"view_date")) {
                ALDateTimeField dummy = new ALDateTimeField("yyyy-MM-dd");
                tmpView = rundata.getParameters().getString("view_date");
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpView", (String)tmpView);
                dummy.setValue(tmpView);
                if (!dummy.validate(new ArrayList())) {
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"tmpView");
                    logger.debug((Object)"[ScheduleFormData] Parameter cannot validate");
                    ALEipUtils.redirectPageNotFound((RunData)rundata);
                    return;
                }
            } else if ((tmpView == null || tmpView.equals("")) && tmpStart != null && !tmpStart.equals("")) {
                tmpView = tmpStart;
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpView", (String)tmpView);
            }
        }
    }

    public static boolean validateDelegate(ALDateTimeField start_date, ALDateTimeField end_date, ALStringField repeat_type, boolean is_repeat, boolean is_span, ALStringField week_0, ALStringField week_1, ALStringField week_2, ALStringField week_3, ALStringField week_4, ALStringField week_5, ALStringField week_6, ALStringField limit_flag, ALDateField limit_start_date, ALDateField limit_end_date, ALNumberField month_day, ALEipUser login_user, String entityid, ArrayList msgList) throws ALDBErrorException, ALPageNotFoundException {
        int startyear;
        int YEAR_FIRST = 2004;
        int YEAR_END = 2016;
        if (!is_repeat && !is_span) {
            start_date.validate(msgList);
            startyear = start_date.getValue().getYear() + 1900;
            if (startyear < YEAR_FIRST || startyear > YEAR_END) {
                msgList.add("\u300e\u65e5\u4ed8\u300f\u306f" + YEAR_FIRST + "\u5e74\u304b\u3089" + YEAR_END + "\u5e74\u306e\u9593\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
            if ((double)start_date.getValue().getMinutes() % 15.0 != 0.0) {
                msgList.add("\u300e\u6642\u9593\u300f\u306f15\u5206\u5358\u4f4d\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
            end_date.validate(msgList);
            if ((double)end_date.getValue().getMinutes() % 15.0 != 0.0) {
                msgList.add("\u300e\u6642\u9593\u300f\u306f15\u5206\u5358\u4f4d\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        }
        if (end_date.getValue().before(start_date.getValue())) {
            msgList.add("\u300e\u7d42\u4e86\u65e5\u6642\u300f\u306f\u300e\u958b\u59cb\u65e5\u6642\u300f\u4ee5\u964d\u306e\u65e5\u4ed8\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (is_repeat) {
            try {
                int limitendyear;
                int limitstartyear;
                if ("W".equals(repeat_type.getValue())) {
                    if (week_0.getValue() == null && week_1.getValue() == null && week_2.getValue() == null && week_3.getValue() == null && week_4.getValue() == null && week_5.getValue() == null && week_6.getValue() == null) {
                        msgList.add("\u300e\u6bce\u9031\u300f\u306f\u66dc\u65e5\u3092\u3072\u3068\u3064\u4ee5\u4e0a\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    } else if ("ON".equals(limit_flag.getValue())) {
                        long deltaDay;
                        limitstartyear = limit_start_date.getValue().getDate().getYear() + 1900;
                        if (limitstartyear < YEAR_FIRST || limitstartyear > YEAR_END) {
                            msgList.add("\u300e\u671f\u9650\u306e\u958b\u59cb\u65e5\u6642\u300f\u306f" + YEAR_FIRST + "\u5e74\u304b\u3089" + YEAR_END + "\u5e74\u306e\u9593\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                        }
                        if ((limitendyear = limit_end_date.getValue().getDate().getYear() + 1900) < YEAR_FIRST || limitendyear > YEAR_END) {
                            msgList.add("\u300e\u671f\u9650\u306e\u7d42\u4e86\u65e5\u6642\u300f\u306f" + YEAR_FIRST + "\u5e74\u304b\u3089" + YEAR_END + "\u5e74\u306e\u9593\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                        }
                        if ((deltaDay = (limit_end_date.getValue().getDate().getTime() - limit_start_date.getValue().getDate().getTime()) / 86400000L) < 6L) {
                            Calendar limitStartCal = Calendar.getInstance();
                            limitStartCal.setTime(limit_start_date.getValue().getDate());
                            Calendar limitEndCal = Calendar.getInstance();
                            limitEndCal.setTime(limit_end_date.getValue().getDate());
                            int limitStartDayOfWeek = limitStartCal.get(7);
                            int limitEndDayOfWeek = limitEndCal.get(7);
                            boolean hasWeek = true;
                            if (week_0.getValue() != null) {
                                hasWeek &= ScheduleUtils.includeWeek(1, limitStartDayOfWeek, limitEndDayOfWeek);
                            }
                            if (week_1.getValue() != null) {
                                hasWeek &= ScheduleUtils.includeWeek(2, limitStartDayOfWeek, limitEndDayOfWeek);
                            }
                            if (week_2.getValue() != null) {
                                hasWeek &= ScheduleUtils.includeWeek(3, limitStartDayOfWeek, limitEndDayOfWeek);
                            }
                            if (week_3.getValue() != null) {
                                hasWeek &= ScheduleUtils.includeWeek(4, limitStartDayOfWeek, limitEndDayOfWeek);
                            }
                            if (week_4.getValue() != null) {
                                hasWeek &= ScheduleUtils.includeWeek(5, limitStartDayOfWeek, limitEndDayOfWeek);
                            }
                            if (week_5.getValue() != null) {
                                hasWeek &= ScheduleUtils.includeWeek(6, limitStartDayOfWeek, limitEndDayOfWeek);
                            }
                            if (week_6.getValue() != null) {
                                hasWeek &= ScheduleUtils.includeWeek(7, limitStartDayOfWeek, limitEndDayOfWeek);
                            }
                            if (!hasWeek) {
                                msgList.add("\u300e\u6bce\u9031\u300f\u3067\u9078\u629e\u3059\u308b\u66dc\u65e5\u306f\u3001\u300e\u671f\u9650\u300f\u306e\u7bc4\u56f2\u5185\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                            }
                        }
                    }
                } else if ("M".equals(repeat_type.getValue())) {
                    if (month_day.getValue() == 0L) {
                        msgList.add("\u300e\u6bce\u6708\u300f\u306f\u65e5\u306b\u3061\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    } else {
                        month_day.validate(msgList);
                        if ("ON".equals(limit_flag.getValue())) {
                            limitstartyear = limit_start_date.getValue().getDate().getYear() + 1900;
                            if (limitstartyear < YEAR_FIRST || limitstartyear > YEAR_END) {
                                msgList.add("\u300e\u671f\u9650\u306e\u958b\u59cb\u65e5\u6642\u300f\u306f" + YEAR_FIRST + "\u5e74\u304b\u3089" + YEAR_END + "\u5e74\u306e\u9593\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                            }
                            if ((limitendyear = limit_end_date.getValue().getDate().getYear() + 1900) < YEAR_FIRST || limitendyear > YEAR_END) {
                                msgList.add("\u300e\u671f\u9650\u306e\u7d42\u4e86\u65e5\u6642\u300f\u306f" + YEAR_FIRST + "\u5e74\u304b\u3089" + YEAR_END + "\u5e74\u306e\u9593\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                            }
                            Calendar limitStartCal = Calendar.getInstance();
                            limitStartCal.setTime(limit_start_date.getValue().getDate());
                            Calendar limitEndCal = Calendar.getInstance();
                            limitEndCal.setTime(limit_end_date.getValue().getDate());
                            int limitStartYear = limitStartCal.get(1);
                            int limitEndYear = limitEndCal.get(1);
                            int limitStartMonth = limitStartCal.get(2);
                            int limitEndMonth = limitEndCal.get(2);
                            if (limitStartYear >= limitEndYear) {
                                if (limitStartMonth >= limitEndMonth) {
                                    if ((long)limit_start_date.getValue().getDay() > month_day.getValue() || (long)limit_end_date.getValue().getDay() < month_day.getValue()) {
                                        msgList.add("\u300e\u6bce\u6708\u300f\u306f\u300e\u671f\u9650\u300f\u306e\u7bc4\u56f2\u5185\u306e\u65e5\u4ed8\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                                    }
                                } else if ((long)limit_start_date.getValue().getDay() > month_day.getValue() && (long)limit_end_date.getValue().getDay() < month_day.getValue()) {
                                    msgList.add("\u300e\u6bce\u6708\u300f\u306f\u300e\u671f\u9650\u300f\u306e\u7bc4\u56f2\u5185\u306e\u65e5\u4ed8\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                                }
                            }
                        }
                    }
                } else if ("ON".equals(limit_flag.getValue())) {
                    limitstartyear = limit_start_date.getValue().getDate().getYear() + 1900;
                    if (limitstartyear < YEAR_FIRST || limitstartyear > YEAR_END) {
                        msgList.add("\u300e\u671f\u9650\u306e\u958b\u59cb\u65e5\u6642\u300f\u306f" + YEAR_FIRST + "\u5e74\u304b\u3089" + YEAR_END + "\u5e74\u306e\u9593\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    }
                    if ((limitendyear = limit_end_date.getValue().getDate().getYear() + 1900) < YEAR_FIRST || limitendyear > YEAR_END) {
                        msgList.add("\u300e\u671f\u9650\u306e\u7d42\u4e86\u65e5\u6642\u300f\u306f" + YEAR_FIRST + "\u5e74\u304b\u3089" + YEAR_END + "\u5e74\u306e\u9593\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    }
                }
                if ("ON".equals(limit_flag.getValue())) {
                    Date limitEndDate = limit_end_date.getValue().getDate();
                    if (!ScheduleUtils.equalsToDate(limit_start_date.getValue().getDate(), limit_end_date.getValue().getDate(), false) && limit_start_date.getValue().getDate().after(limit_end_date.getValue().getDate())) {
                        msgList.add("\u300e\u671f\u9650\u306e\u7d42\u4e86\u65e5\u6642\u300f\u306f\u300e\u671f\u9650\u306e\u958b\u59cb\u65e5\u6642\u300f\u4ee5\u964d\u306e\u65e5\u4ed8\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    }
                }
            }
            catch (NumberFormatException nfe) {
                logger.error((Object)"[ScheduleFormData] NumberFormatException: Limit Date is wrong.");
                throw new ALPageNotFoundException();
            }
            catch (ALIllegalDateException ad) {
                logger.error((Object)"[ScheduleFormData] ALIllegalDateException: Limit Date is wrong.");
                throw new ALPageNotFoundException();
            }
        }
        if (is_span) {
            start_date.validate(msgList);
            startyear = start_date.getValue().getYear() + 1900;
            if (startyear < YEAR_FIRST || startyear > YEAR_END) {
                msgList.add("\u300e\u958b\u59cb\u65e5\u6642\u300f\u306f" + YEAR_FIRST + "\u5e74\u304b\u3089" + YEAR_END + "\u5e74\u306e\u9593\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
            end_date.validate(msgList);
            int endyear = end_date.getValue().getYear() + 1900;
            if (endyear < YEAR_FIRST || endyear > YEAR_END) {
                msgList.add("\u300e\u7d42\u4e86\u65e5\u6642\u300f\u306f" + YEAR_FIRST + "\u5e74\u304b\u3089" + YEAR_END + "\u5e74\u306e\u9593\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
            try {
                List list;
                String tmpScheduleId = entityid;
                boolean is_update = true;
                int id = 0;
                try {
                    if (tmpScheduleId == null || !ALStringUtil.isNumber((String)tmpScheduleId)) {
                        is_update = false;
                    } else {
                        is_update = true;
                        id = Integer.valueOf(tmpScheduleId);
                    }
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)"[ScheduleFormData] NumberFormatException: ENTITYID is wrong.");
                    throw new ALPageNotFoundException();
                }
                DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
                SelectQuery query = new SelectQuery(EipTScheduleMap.class);
                Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)((int)login_user.getUserId().getValue()));
                query.setQualifier(exp1);
                Expression exp2 = ExpressionFactory.greaterOrEqualExp((String)"eipTSchedule.endDate", (Object)start_date.getValue());
                query.andQualifier(exp2);
                Expression exp3 = ExpressionFactory.lessOrEqualExp((String)"eipTSchedule.startDate", (Object)end_date.getValue());
                query.andQualifier(exp3);
                Expression exp4 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)"S");
                query.andQualifier(exp4);
                if (is_update) {
                    Expression mapexp = ExpressionFactory.noMatchExp((String)"scheduleId", (Object)id);
                    query.andQualifier(mapexp);
                }
                int count = (list = dataContext.performQuery((Query)query)) != null && list.size() > 0 ? list.size() : 0;
            }
            catch (Exception e) {
                logger.error((Object)"[ScheduleFormData]", (Throwable)e);
                throw new ALDBErrorException();
            }
        }
        return msgList.size() == 0;
    }

    public static void addToDo(List weekConList, Date viewStartDate, int index, ScheduleToDoResultData rd) {
        try {
            boolean success = false;
            if (weekConList.size() > 0) {
                ScheduleToDoWeekContainer tmpWeekCon = null;
                int size = weekConList.size();
                for (int i = 0; i < size; ++i) {
                    tmpWeekCon = (ScheduleToDoWeekContainer)weekConList.get(i);
                    success = tmpWeekCon.canAddTodo(rd);
                    if (!success) continue;
                    tmpWeekCon.addToDoResultData(index, rd);
                    break;
                }
            }
            if (!success) {
                Calendar cal2 = Calendar.getInstance();
                cal2.setTime(viewStartDate);
                ScheduleToDoWeekContainer weekCon = new ScheduleToDoWeekContainer();
                weekCon.initField();
                weekCon.setViewStartDate(cal2);
                weekCon.addToDoResultData(index, rd);
                weekConList.add(weekCon);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
        }
    }

    public static boolean isZeroLength(String[] strs) {
        if (strs == null || strs.length <= 0) {
            return true;
        }
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            if (strs[i] != null && !"".equals(strs[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isSpanDuplicate(int user_id, Date start_date, Date end_date, Integer update_id) {
        List list;
        SelectQuery query = new SelectQuery(EipTScheduleMap.class);
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)user_id);
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.greaterOrEqualExp((String)"eipTSchedule.endDate", (Object)start_date);
        query.andQualifier(exp2);
        Expression exp3 = ExpressionFactory.lessOrEqualExp((String)"eipTSchedule.startDate", (Object)end_date);
        query.andQualifier(exp3);
        Expression exp4 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)"S");
        query.andQualifier(exp4);
        if (update_id != null) {
            Expression mapexp = ExpressionFactory.noMatchExp((String)"scheduleId", (Object)update_id);
            query.andQualifier(mapexp);
        }
        int count = (list = dataContext.performQuery((Query)query)) != null && list.size() > 0 ? list.size() : 0;
        return count > 0;
    }

    public static ArrayList getALEipUsers(String[] ids) throws ALDBErrorException {
        Expression exp;
        SelectQuery query;
        int ids_len = ids.length;
        Integer tmp_id = null;
        ArrayList<Integer> tmp_ids = new ArrayList<Integer>();
        for (int i = 0; i < ids_len; ++i) {
            try {
                tmp_id = Integer.valueOf(ids[i]);
                if (tmp_id <= 3) continue;
                tmp_ids.add(tmp_id);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        List users = dataContext.performQuery((Query)(query = new SelectQuery(TurbineUser.class, exp = ExpressionFactory.inDbExp((String)"USER_ID", tmp_ids))));
        if (users.size() == 0) {
            return null;
        }
        ArrayList<ALEipUser> uList = new ArrayList<ALEipUser>();
        TurbineUser tuser = null;
        ALEipUser user = null;
        int len = users.size();
        for (int i = 0; i < len; ++i) {
            tuser = (TurbineUser)users.get(i);
            user = new ALEipUser();
            user.initField();
            user.setUserId(tuser.getUserId().intValue());
            user.setName(tuser.getLoginName());
            user.setAliasName(tuser.getFirstName(), tuser.getLastName());
            uList.add(user);
        }
        return uList;
    }

    public static ArrayList getALEipUserFacility(String[] ids, RunData rundata) throws ALDBErrorException {
        ArrayList<UserFacilityLiteBean> ulist = new ArrayList<UserFacilityLiteBean>();
        int ids_len = ids.length;
        Integer tmp_id = null;
        ArrayList<Integer> tmp_ids = new ArrayList<Integer>();
        ArrayList<String> f_ids = new ArrayList<String>();
        for (int i = 0; i < ids_len; ++i) {
            if (ids[i].startsWith(TARGET_FACILITY_ID)) {
                f_ids.add(ids[i].replace(TARGET_FACILITY_ID, ""));
                continue;
            }
            try {
                tmp_id = Integer.valueOf(ids[i]);
                if (tmp_id <= 3) continue;
                tmp_ids.add(tmp_id);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        UserFacilityLiteBean user = null;
        if (tmp_ids != null && tmp_ids.size() > 0) {
            StringBuffer tmp_ids_str = new StringBuffer();
            int tmp_ids_len = tmp_ids.size() - 1;
            for (int i = 0; i < tmp_ids_len; ++i) {
                tmp_ids_str.append(tmp_ids.get(i)).append(",");
            }
            tmp_ids_str.append(tmp_ids.get(tmp_ids_len));
            StringBuffer statement = new StringBuffer();
            statement.append("SELECT DISTINCT ");
            statement.append("  B.USER_ID, B.LOGIN_NAME, B.FIRST_NAME, B.LAST_NAME, D.POSITION ");
            statement.append("FROM TURBINE_USER_GROUP_ROLE as A ");
            statement.append("LEFT JOIN TURBINE_USER as B ");
            statement.append("  on A.USER_ID = B.USER_ID ");
            statement.append("LEFT JOIN TURBINE_GROUP as C ");
            statement.append("  on A.GROUP_ID = C.GROUP_ID ");
            statement.append("LEFT JOIN EIP_M_USER_POSITION as D ");
            statement.append("  on A.USER_ID = D.USER_ID ");
            statement.append("WHERE B.USER_ID > 3 AND B.DISABLED = 'F'");
            statement.append(" AND B.USER_ID IN (").append(tmp_ids_str.toString()).append(")");
            statement.append("ORDER BY D.POSITION");
            String query = statement.toString();
            DataContext u_dataContext = DatabaseOrmService.getInstance().getDataContext();
            SQLTemplate rawSelect = new SQLTemplate(TurbineUser.class, query, true);
            rawSelect.setFetchingDataRows(true);
            List users = u_dataContext.performQuery((Query)rawSelect);
            int recNum = users.size();
            for (int j = 0; j < recNum; ++j) {
                DataRow dataRow = (DataRow)users.get(j);
                user = new UserFacilityLiteBean();
                user.initField();
                user.setUserFacilityId(((Integer)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"USER_ID")).intValue());
                user.setName((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"LOGIN_NAME"));
                user.setAliasName((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"FIRST_NAME"), (String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"LAST_NAME"));
                user.setUserFacilityType(SCHEDULEMAP_TYPE_USER);
                if (Integer.toString(ALEipUtils.getUserId((RunData)rundata)).equals(user.getUserFacilityId())) {
                    ulist.add(0, user);
                    continue;
                }
                ulist.add(user);
            }
        }
        if (f_ids != null && f_ids.size() > 0) {
            DataContext f_dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery f_query = new SelectQuery(EipMFacility.class);
            Expression f_exp = ExpressionFactory.inDbExp((String)"FACILITY_ID", f_ids);
            f_query.setQualifier(f_exp);
            List facilities = f_dataContext.performQuery((Query)f_query);
            if (facilities.size() == 0) {
                return null;
            }
            int f_size = facilities.size();
            for (int i = 0; i < f_size; ++i) {
                EipMFacility f_user = (EipMFacility)facilities.get(i);
                user = new UserFacilityLiteBean();
                user.initField();
                user.setUserFacilityId(f_user.getFacilityId().intValue());
                user.setName(TARGET_FACILITY_ID + user.getUserFacilityId());
                user.setAliasName(f_user.getFacilityName());
                user.setUserFacilityType(SCHEDULEMAP_TYPE_FACILITY);
                ulist.add(user);
            }
        }
        return ulist;
    }

    public static void addTerm(List weekConList, Date viewStartDate, int index, AjaxScheduleResultData rd) {
        try {
            boolean success = false;
            if (weekConList.size() > 0) {
                AjaxTermScheduleWeekContainer tmpWeekCon = null;
                int size = weekConList.size();
                for (int i = 0; i < size; ++i) {
                    tmpWeekCon = (AjaxTermScheduleWeekContainer)weekConList.get(i);
                    success = tmpWeekCon.canAddTerm(rd);
                    if (!success) continue;
                    tmpWeekCon.addTermResultData(index, rd);
                    break;
                }
            }
            if (!success) {
                Calendar cal2 = Calendar.getInstance();
                cal2.setTime(viewStartDate);
                AjaxTermScheduleWeekContainer weekCon = new AjaxTermScheduleWeekContainer();
                weekCon.initField();
                weekCon.setViewStartDate(cal2);
                weekCon.addTermResultData(index, rd);
                weekConList.add(weekCon);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
        }
    }

    public static void addTermSchedule(List weekConList, Date viewStartDate, int index, ScheduleResultData rd) {
        try {
            boolean success = false;
            if (weekConList.size() > 0) {
                ScheduleTermWeekContainer tmpWeekCon = null;
                int size = weekConList.size();
                for (int i = 0; i < size; ++i) {
                    tmpWeekCon = (ScheduleTermWeekContainer)weekConList.get(i);
                    success = tmpWeekCon.canAddTerm(rd);
                    if (!success) continue;
                    tmpWeekCon.addTermResultData(index, rd);
                    break;
                }
            }
            if (!success) {
                Calendar cal2 = Calendar.getInstance();
                cal2.setTime(viewStartDate);
                ScheduleTermWeekContainer weekCon = new ScheduleTermWeekContainer();
                weekCon.initField();
                weekCon.setViewStartDate(cal2);
                weekCon.addTermResultData(index, rd);
                weekConList.add(weekCon);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
        }
    }

    public static Date getEmptyDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(9999, 11, 31);
        return cal.getTime();
    }

    public static String hasAuthOther(RunData rundata) {
        try {
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            if (aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "schedule_other", 1)) {
                return "T";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return SCHEDULEMAP_TYPE_FACILITY;
    }

    public static String hasAuthSelf(RunData rundata) {
        try {
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            if (aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "schedule_self", 1)) {
                return "T";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return SCHEDULEMAP_TYPE_FACILITY;
    }

    public static String hasAuthOtherUpdate(RunData rundata) {
        try {
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            if (aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "schedule_other", 8)) {
                return "T";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return SCHEDULEMAP_TYPE_FACILITY;
    }

    public static String hasAuthSelfUpdate(RunData rundata) {
        try {
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            if (aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "schedule_self", 8)) {
                return "T";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return SCHEDULEMAP_TYPE_FACILITY;
    }

    public static int getOwnerId(RunData rundata) {
        String scheduleId = rundata.getParameters().getString("entityid");
        if (scheduleId == null | "".equals(scheduleId)) {
            return ALEipUtils.getUserId((RunData)rundata);
        }
        Expression exp = ExpressionFactory.matchDbExp((String)"SCHEDULE_ID", (Object)Integer.valueOf(scheduleId));
        SelectQuery query = new SelectQuery(EipTSchedule.class, exp);
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        List list = dataContext.performQuery((Query)query);
        if (list.size() == 0) {
            return ALEipUtils.getUserId((RunData)rundata);
        }
        return ((EipTSchedule)list.get(0)).getOwnerId();
    }

    public static boolean hasRelation(RunData rundata) {
        String scheduleId = rundata.getParameters().getString("entityid");
        if (scheduleId == null | "".equals(scheduleId)) {
            return false;
        }
        int userId = ALEipUtils.getUserId((RunData)rundata);
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        Expression exp11 = ExpressionFactory.matchExp((String)"scheduleId", (Object)Integer.valueOf(scheduleId));
        Expression exp12 = ExpressionFactory.matchExp((String)"userId", (Object)userId);
        SelectQuery query = new SelectQuery(EipTScheduleMap.class, exp11);
        query.andQualifier(exp12);
        List list = dataContext.performQuery((Query)query);
        return list.size() != 0;
    }

    public static boolean hasMinimumAuthority(RunData rundata) {
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        boolean hasAuthority = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "schedule_self", 1);
        if (!hasAuthority) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        return true;
    }
}

