/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule.daemon;

import com.aimluck.commons.field.ALCellDateTimeField;
import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.account.EipMCompany;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.mail.util.ALEipUserAddr;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.schedule.CellScheduleResultData;
import com.aimluck.eip.schedule.ScheduleToDoResultData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.daemonfactory.AipoDaemonFactoryService;
import com.aimluck.eip.system.util.SystemUtils;
import com.aimluck.eip.todo.util.ToDoUtils;
import com.aimluck.eip.util.ALCellularUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.ServletConfig;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.daemon.Daemon;
import org.apache.jetspeed.daemon.DaemonConfig;
import org.apache.jetspeed.daemon.DaemonEntry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.servlet.TurbineServlet;

public class RemainderScheduleDaemon
implements Daemon {
    private static RemainderScheduleDaemon instance = null;
    private int status = 1;
    private int result = 0;
    private DaemonConfig config = null;
    private DaemonEntry entry = null;
    private boolean enable_run = false;
    private int send_time_hour = 15;
    private int send_time_minutes = 0;
    private ALDateTimeField viewDate;
    private DataContext dataContext;
    private String servlet_name = "";
    private String scheme = null;
    private int port = 80;
    private String realpath = "";
    private String localurl = "";
    private boolean enableAsp = false;
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)RemainderScheduleDaemon.class.getName());

    public void run() {
        if (!this.enable_run) {
            this.enable_run = true;
            return;
        }
        try {
            this.setResult(3);
            this.doViewList();
            this.doCheck();
            this.setResult(1);
        }
        catch (Exception e) {
            this.setResult(2);
            logger.error((Object)"RemainderScheduleDaemon", (Throwable)e);
        }
    }

    private boolean doCheck() {
        boolean res = false;
        Calendar cal = Calendar.getInstance();
        Calendar cal_now = Calendar.getInstance();
        long now_millis = cal.getTimeInMillis();
        cal.set(11, this.send_time_hour);
        cal.set(12, this.send_time_minutes);
        if (cal_now.getTimeInMillis() >= cal.getTimeInMillis()) {
            cal.add(5, 1);
        }
        cal.set(13, 0);
        cal.set(14, 0);
        long next_millis = cal.getTimeInMillis();
        long interval = (next_millis - now_millis) / 1000L;
        this.entry = new DaemonEntry(this.entry.getName(), interval, this.entry.getClassname(), this.entry.onStartup());
        return res;
    }

    private void doViewList() throws Exception {
        this.initList();
        Object obj = null;
        List todolist = null;
        ALEipUserAddr useraddr = null;
        String[] to = null;
        String msg = "";
        List useraddrs = this.getAllUserAddrList();
        int useraddrs_size = useraddrs.size();
        for (int j = 0; j < useraddrs_size; ++j) {
            try {
                List aList;
                useraddr = (ALEipUserAddr)useraddrs.get(j);
                to = useraddr.getAddrs();
                if (to == null || (aList = this.selectList(useraddr.getUserId())) == null) continue;
                ArrayList<Object> list = new ArrayList<Object>();
                int size = aList.size();
                for (int i = 0; i < size; ++i) {
                    obj = this.getResultData(aList.get(i));
                    if (obj == null) continue;
                    list.add(obj);
                }
                todolist = this.getToDoList(useraddr.getUserId());
                msg = this.getSendMessage(useraddr, list, todolist);
                ArrayList<ALEipUserAddr> destMemberList = new ArrayList<ALEipUserAddr>();
                destMemberList.add(useraddr);
                String org_id = DatabaseOrmService.getInstance().getDefaultOrgId();
                String subject = "[Aipo]\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb";
                ALMailUtils.sendMailDelegate((String)org_id, (int)1, destMemberList, (String)subject, (String)subject, (String)msg, (String)msg, (int)ALMailUtils.getSendDestType((int)24), new ArrayList());
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"RemainderScheduleDaemon", (Throwable)e);
            }
        }
    }

    private void initList() {
        this.viewDate = new ALDateTimeField("yyyy-MM-dd");
        this.viewDate.setNotNull(true);
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        this.viewDate.setValue(cal.getTime());
    }

    private List getAllUserAddrList() {
        SelectQuery query = new SelectQuery(TurbineUser.class);
        query.addCustomDbAttribute("USER_ID");
        query.addCustomDbAttribute("EMAIL");
        query.addCustomDbAttribute("CELLULAR_MAIL");
        Expression exp1 = ExpressionFactory.matchExp((String)"disabled", (Object)"F");
        Expression exp2 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)1);
        Expression exp3 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)2);
        Expression exp4 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)3);
        query.setQualifier(exp1);
        query.andQualifier(exp2);
        query.andQualifier(exp3);
        query.andQualifier(exp4);
        List userids = this.dataContext.performQuery((Query)query);
        if (userids.size() == 0) {
            return null;
        }
        ALEipUserAddr useraddr = null;
        ArrayList<ALEipUserAddr> list = new ArrayList<ALEipUserAddr>();
        int size = userids.size();
        for (int i = 0; i < size; ++i) {
            DataRow dataRow = (DataRow)userids.get(i);
            useraddr = new ALEipUserAddr();
            useraddr.setUserId((Integer)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"USER_ID"));
            useraddr.setPcMailAddr((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"EMAIL"));
            useraddr.setCellMailAddr((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"CELLULAR_MAIL"));
            list.add(useraddr);
        }
        return list;
    }

    private List selectList(Integer userid) {
        EipTScheduleMap record;
        int i;
        List resultBaseList = this.dataContext.performQuery((Query)this.getSelectQuery(userid));
        List resultList = ScheduleUtils.sortByDummySchedule(resultBaseList);
        ArrayList<EipTScheduleMap> list = new ArrayList<EipTScheduleMap>();
        ArrayList<EipTScheduleMap> delList = new ArrayList<EipTScheduleMap>();
        int delSize = 0;
        int resultSize = resultList.size();
        int size = 0;
        boolean canAdd = true;
        for (i = 0; i < resultSize; ++i) {
            record = (EipTScheduleMap)resultList.get(i);
            EipTSchedule schedule = record.getEipTSchedule();
            delList.clear();
            canAdd = true;
            size = list.size();
            for (int j = 0; j < size; ++j) {
                EipTScheduleMap record2 = (EipTScheduleMap)list.get(j);
                EipTSchedule schedule2 = record2.getEipTSchedule();
                if (!schedule.getRepeatPattern().equals("N") && "D".equals(record2.getStatus()) && schedule.getScheduleId() == schedule2.getParentId()) {
                    canAdd = false;
                    break;
                }
                if (schedule2.getRepeatPattern().equals("N") || !"D".equals(record.getStatus()) || schedule2.getScheduleId() != schedule.getParentId()) continue;
                if (!delList.contains(record2)) {
                    delList.add(record2);
                }
                canAdd = true;
            }
            delSize = delList.size();
            for (int k = 0; k < delSize; ++k) {
                list.remove(delList.get(k));
            }
            if (!canAdd) continue;
            list.add(record);
        }
        delList.clear();
        size = list.size();
        for (i = 0; i < size; ++i) {
            record = (EipTScheduleMap)list.get(i);
            if (!"D".equals(record.getStatus())) continue;
            delList.add(record);
        }
        delSize = delList.size();
        for (i = 0; i < delSize; ++i) {
            list.remove(delList.get(i));
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object a, Object b) {
                Calendar cal = Calendar.getInstance();
                Calendar cal2 = Calendar.getInstance();
                EipTSchedule p1 = null;
                EipTSchedule p2 = null;
                try {
                    p1 = ((EipTScheduleMap)a).getEipTSchedule();
                    p2 = ((EipTScheduleMap)b).getEipTSchedule();
                }
                catch (Exception e) {
                    logger.error((Object)"Exception", (Throwable)e);
                }
                cal.setTime(p1.getStartDate());
                cal.set(0, 0, 0);
                cal2.setTime(p2.getStartDate());
                cal2.set(0, 0, 0);
                if (cal.getTime().compareTo(cal2.getTime()) != 0) {
                    return cal.getTime().compareTo(cal2.getTime());
                }
                cal.setTime(p1.getEndDate());
                cal.set(0, 0, 0);
                cal2.setTime(p2.getEndDate());
                cal2.set(0, 0, 0);
                return cal.getTime().compareTo(cal2.getTime());
            }
        });
        return list;
    }

    protected SelectQuery getSelectQuery(Integer userid) {
        SelectQuery query = new SelectQuery(EipTScheduleMap.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)userid);
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"type", (Object)"U");
        query.andQualifier(exp2);
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"eipTSchedule.endDate", (Object)this.viewDate.getValue());
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.viewDate.getValue());
        cal.add(5, 1);
        ALCellDateTimeField field = new ALCellDateTimeField();
        field.setValue(cal.getTime());
        Expression exp12 = ExpressionFactory.lessExp((String)"eipTSchedule.startDate", (Object)field.getValue());
        Expression exp13 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)"N");
        Expression exp14 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)"S");
        Date date = this.viewDate.getValue();
        int weekindex = date.getDay();
        String token = null;
        StringBuffer sb = new StringBuffer();
        sb.append("W");
        for (int i = 0; i < 7; ++i) {
            token = i == weekindex ? "1" : "_";
            sb.append(token);
        }
        Expression exp21 = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)(sb.toString() + "L"));
        Expression exp22 = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)(sb.toString() + "N"));
        Expression exp23 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)"DN");
        Expression exp31 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)"DL");
        SimpleDateFormat sdf = new SimpleDateFormat("dd");
        sdf.setTimeZone(TimeZone.getTimeZone("JST"));
        String dayStr = sdf.format(date);
        Expression exp24 = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)("M" + dayStr + "L"));
        Expression exp25 = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)("M" + dayStr + "N"));
        query.andQualifier(exp11.andExp(exp12).andExp(exp13.orExp(exp14).orExp(exp21).orExp(exp31).orExp(exp24)).orExp(exp22.orExp(exp23).orExp(exp25)));
        ArrayList<Ordering> orders = new ArrayList<Ordering>();
        orders.add(new Ordering("eipTSchedule.startDate", true));
        orders.add(new Ordering("eipTSchedule.endDate", true));
        query.addOrderings(orders);
        return query;
    }

    protected Object getResultData(Object obj) {
        CellScheduleResultData rd = new CellScheduleResultData();
        CellScheduleResultData rd2 = new CellScheduleResultData();
        rd.initField();
        rd2.setFormat("yyyy-MM-dd-HH-mm");
        rd2.initField();
        try {
            EipTScheduleMap record = (EipTScheduleMap)obj;
            EipTSchedule schedule = record.getEipTSchedule();
            if ("R".equals(record.getStatus())) {
                return null;
            }
            if (!ScheduleUtils.isView(this.viewDate, schedule.getRepeatPattern(), schedule.getStartDate(), schedule.getEndDate())) {
                return null;
            }
            rd.setScheduleId(schedule.getScheduleId());
            rd.setParentId(schedule.getParentId());
            rd.setName(schedule.getName());
            rd.setStartDate(schedule.getStartDate());
            rd.setEndDate(schedule.getEndDate());
            rd.setTmpreserve("T".equals(record.getStatus()));
            rd.setPublic("O".equals(schedule.getPublicFlag()));
            rd.setHidden("P".equals(schedule.getPublicFlag()));
            rd.setPattern(schedule.getRepeatPattern());
            if (rd.getPattern().equals("S")) {
                rd.setSpan(true);
                return rd;
            }
            if (!rd.getPattern().equals("N")) {
                if (!ScheduleUtils.isView(this.viewDate, rd.getPattern(), rd.getStartDate().getValue(), rd.getEndDate().getValue())) {
                    return rd;
                }
                rd.setRepeat(true);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return null;
        }
        return rd;
    }

    private String getSendMessage(ALEipUserAddr useraddr, List schelist, List todolist) {
        int i;
        String CR = System.getProperty("line.separator");
        StringBuffer body = new StringBuffer();
        body.append("--- ").append(this.viewDate.getYear()).append("\u5e74").append(this.viewDate.getMonth()).append("\u6708").append(this.viewDate.getDay()).append("\u65e5").append(" ---").append(CR).append(CR);
        body.append("[\u4e88\u5b9a]").append(CR);
        if (schelist != null && schelist.size() > 0) {
            CellScheduleResultData rd = null;
            int size = schelist.size();
            for (i = 0; i < size; ++i) {
                rd = (CellScheduleResultData)schelist.get(i);
                if (rd.isSpan()) {
                    body.append("\u30fb\u671f\u9593\uff1a");
                } else {
                    body.append("\u30fb").append(rd.getDate()).append("  ");
                }
                body.append(rd.getName());
                if (!rd.isPublic()) {
                    body.append("(\u975e\u516c\u958b)");
                }
                if (rd.isDuplicate()) {
                    body.append("(\u91cd\u8907)");
                }
                if (rd.isRepeat()) {
                    body.append("(\u7e70\u308a\u8fd4\u3057)");
                }
                if (rd.isTmpreserve()) {
                    body.append("(\u4eee)");
                }
                body.append(CR);
            }
        } else {
            body.append("\u4e88\u5b9a\u306f\u3042\u308a\u307e\u305b\u3093\u3002").append(CR);
        }
        body.append(CR);
        body.append("[ToDo]").append(CR);
        if (todolist != null && todolist.size() > 0) {
            ScheduleToDoResultData todord = null;
            int todosize = todolist.size();
            for (i = 0; i < todosize; ++i) {
                todord = (ScheduleToDoResultData)todolist.get(i);
                body.append("\u30fb").append(todord.getTodoName()).append(CR);
            }
        } else {
            body.append("ToDo\u306f\u3042\u308a\u307e\u305b\u3093\u3002").append(CR);
        }
        body.append(CR);
        body.append("[Aipo\u3078\u306e\u30a2\u30af\u30bb\u30b9]").append(CR);
        String globalurl = this.getCellularUrl(useraddr);
        if (globalurl != null && !globalurl.equals("")) {
            body.append("\u30fb\u793e\u5916").append(CR);
            body.append("\u3000").append(globalurl).append(CR);
        }
        body.append("\u30fb\u793e\u5185").append(CR);
        body.append("\u3000").append(this.localurl).append(CR).append(CR);
        body.append("---------------------");
        return body.toString();
    }

    private void loadAipoUrls() {
        this.localurl = "";
        try {
            this.localurl = SystemUtils.getUrl((String)InetAddress.getLocalHost().getHostAddress(), (int)this.port, (String)this.servlet_name);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    private String getCellularUrl(ALEipUserAddr useraddr) {
        ALEipUser eipUser;
        String url = null;
        try {
            eipUser = ALEipUtils.getALEipUser((int)useraddr.getUserId());
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return "";
        }
        String key = eipUser.getName().getValue() + "_" + ALCellularUtils.getCheckValueForCellLogin((String)eipUser.getName().getValue(), (String)eipUser.getUserId().toString());
        EipMCompany record = ALEipUtils.getEipMCompany((String)"1");
        String domain = SystemUtils.getUrl((String)record.getIpaddress(), (int)record.getPort(), (String)this.servlet_name);
        url = domain != null && domain.length() > 0 ? domain + "?key=" + key : "";
        return url;
    }

    private List getToDoList(Integer userid) {
        ArrayList<ScheduleToDoResultData> todoList = new ArrayList<ScheduleToDoResultData>();
        SelectQuery query = this.getSelectQueryForTodo(userid);
        List todos = this.dataContext.performQuery((Query)query);
        int todosize = todos.size();
        for (int i = 0; i < todosize; ++i) {
            DataRow dataRow = (DataRow)todos.get(i);
            ScheduleToDoResultData rd = new ScheduleToDoResultData();
            rd.initField();
            rd.setTodoName((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"TODO_NAME"));
            todoList.add(rd);
        }
        return todoList;
    }

    private SelectQuery getSelectQueryForTodo(Integer userid) {
        SelectQuery query = new SelectQuery(EipTTodo.class);
        query.addCustomDbAttribute("TODO_NAME");
        Expression exp1 = ExpressionFactory.noMatchExp((String)"state", (Object)100);
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"addonScheduleFlg", (Object)"T");
        query.andQualifier(exp2);
        Expression exp3 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)userid);
        query.andQualifier(exp3);
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.viewDate.getValue());
        Expression exp12 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.viewDate.getValue());
        Expression exp21 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.viewDate.getValue());
        Expression exp22 = ExpressionFactory.matchExp((String)"endDate", (Object)ToDoUtils.getEmptyDate());
        Expression exp31 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.viewDate.getValue());
        Expression exp32 = ExpressionFactory.matchExp((String)"startDate", (Object)ToDoUtils.getEmptyDate());
        query.andQualifier(exp11.andExp(exp12).orExp(exp21.andExp(exp22)).orExp(exp31.andExp(exp32)));
        return query;
    }

    private void error(Throwable t, String message) {
        this.setResult(2);
        logger.error((Object)message, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(DaemonConfig config, DaemonEntry entry) {
        this.config = config;
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        AipoDaemonFactoryService aipoDaemonService = (AipoDaemonFactoryService)TurbineServices.getInstance().getService("DaemonFactory");
        ServletConfig servlet_config = aipoDaemonService.getServletConfig();
        this.servlet_name = servlet_config.getServletName();
        this.scheme = TurbineServlet.getServerScheme();
        this.port = SystemUtils.getServerPort();
        this.realpath = servlet_config.getServletContext().getRealPath("/");
        Calendar cal = Calendar.getInstance();
        Calendar cal_now = Calendar.getInstance();
        long now_millis = cal.getTimeInMillis();
        int now_hour = cal.get(11);
        int now_minutes = cal.get(12);
        FileInputStream input = null;
        try {
            ALMailUtils.getNotifyTime();
            String timestr = ALMailUtils.getNotifyTime();
            this.send_time_hour = Integer.valueOf(timestr.substring(0, 2));
            this.send_time_minutes = Integer.valueOf(timestr.substring(3, 5));
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iex) {
                    logger.error((Object)"Exception", (Throwable)iex);
                }
            }
        }
        cal.set(11, this.send_time_hour);
        cal.set(12, this.send_time_minutes);
        if (cal_now.getTimeInMillis() >= cal.getTimeInMillis()) {
            cal.add(5, 1);
        }
        cal.set(13, 0);
        cal.set(14, 0);
        long next_millis = cal.getTimeInMillis();
        long interval = (next_millis - now_millis) / 1000L;
        this.entry = new DaemonEntry(entry.getName(), interval, entry.getClassname(), entry.onStartup());
        this.enableAsp = JetspeedResources.getBoolean((String)"asp.enable", (boolean)false);
        this.enable_run = false;
        this.loadAipoUrls();
    }

    public DaemonConfig getDaemonConfig() {
        return this.config;
    }

    public DaemonEntry getDaemonEntry() {
        return this.entry;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public String getMessage() {
        return null;
    }
}

