/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.schedule.AjaxScheduleDayContainer;
import com.aimluck.eip.schedule.AjaxScheduleResultData;
import com.aimluck.eip.schedule.AjaxScheduleWeeklyGroupSelectData;
import com.aimluck.eip.schedule.AjaxTermScheduleDayContainer;
import com.aimluck.eip.schedule.AjaxTermScheduleWeekContainer;
import com.aimluck.eip.schedule.ScheduleFormData;
import com.aimluck.eip.schedule.beans.ScheduleBean;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.userfacility.beans.UserFacilityLiteBean;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whatsnew.util.WhatsNewUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ScheduleWeeklyJSONFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ScheduleFormData.class.getName());
    private List userIdMemberAll;
    private List facilityIdMemberAll;
    private ALDateTimeField startDate;
    private ALDateTimeField endDate;
    private ALDateTimeField viewDate;
    private String start_date;
    private String end_date;
    private String view_date;
    private int entityId;
    private String aclPortletFeature;
    private int userId;
    private EipTSchedule schedule;
    private boolean isEdit;
    private int edit_repeat_flag;
    private ArrayList memberList;
    private List scheduleMaps;
    private int ownerId;
    private ArrayList msgList;
    private boolean isViewList;

    public void initField() {
        this.userIdMemberAll = new ArrayList();
        this.facilityIdMemberAll = new ArrayList();
        this.aclPortletFeature = "schedule_self";
    }

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        this.start_date = null;
        this.end_date = null;
        this.view_date = null;
        this.entityId = 0;
        this.userId = 0;
        this.isEdit = false;
        this.memberList = new ArrayList();
        this.scheduleMaps = null;
        this.ownerId = 0;
        this.edit_repeat_flag = 0;
        this.startDate = new ALDateTimeField("yyyy-MM-dd-HH-mm");
        this.endDate = new ALDateTimeField("yyyy-MM-dd-HH-mm");
        this.viewDate = new ALDateTimeField("yyyy-MM-dd");
        this.msgList = new ArrayList();
        this.isViewList = false;
        this.aclPortletFeature = "schedule_self";
    }

    public String doViewList(ALAction action, RunData rundata, Context context, List msgList) {
        try {
            ScheduleBean bean;
            AjaxScheduleResultData rd;
            int i;
            this.doCheckAclPermission(rundata, context, 1);
            ArrayList termScheduleList = new ArrayList();
            List _scheduleList = new ArrayList();
            ArrayList<ScheduleBean> scheduleList = new ArrayList<ScheduleBean>();
            ArrayList<String> holidayList = new ArrayList<String>();
            ArrayList<String> dateList = new ArrayList<String>();
            ArrayList<String> dayOfWeekList = new ArrayList<String>();
            AjaxScheduleWeeklyGroupSelectData listData = new AjaxScheduleWeeklyGroupSelectData();
            listData.doSelectList(null, rundata, context);
            JSONObject json = new JSONObject();
            json.put((Object)"hasAcl", (Object)this.hasAcl(rundata));
            json.put((Object)"today", (Object)listData.getToday().toString());
            json.put((Object)"prevDate", (Object)listData.getPrevDate().toString());
            json.put((Object)"nextDate", (Object)listData.getNextDate().toString());
            json.put((Object)"prevWeek", (Object)listData.getPrevWeek().toString());
            json.put((Object)"nextWeek", (Object)listData.getNextWeek().toString());
            json.put((Object)"prevMonth", (Object)listData.getPrevMonth().toString());
            json.put((Object)"nextMonth", (Object)listData.getNextMonth().toString());
            List dayList = listData.getContainer().getDayList();
            List termList = listData.getWeekTermContainerList();
            int dayListSize = dayList.size();
            int termListSize = termList.size();
            Date containerDate = null;
            for (i = 0; i < termListSize; ++i) {
                AjaxTermScheduleWeekContainer termContainer = (AjaxTermScheduleWeekContainer)termList.get(i);
                List termDayList = termContainer.getDayList();
                int termDayListSize = termDayList.size();
                ArrayList<ScheduleBean> _termScheduleList = new ArrayList<ScheduleBean>();
                for (int k = 0; k < termDayListSize; ++k) {
                    AjaxTermScheduleDayContainer termDayContainer = (AjaxTermScheduleDayContainer)termDayList.get(k);
                    if (k == 0) {
                        containerDate = termDayContainer.getDate().getValue();
                    }
                    if ((rd = termDayContainer.getTermResultData()) == null || containerDate == null) continue;
                    int stime = (int)(rd.getStartDate().getValue().getTime() / 86400000L);
                    int etime = (int)(rd.getEndDate().getValue().getTime() / 86400000L);
                    int ctime = (int)(containerDate.getTime() / 86400000L);
                    int col = etime - stime + 1;
                    int rindex = stime - ctime;
                    bean = new ScheduleBean();
                    bean.initField();
                    bean.setResultData(rd);
                    if (!rd.isPublic() && !rd.isMember()) {
                        bean.setName("\u975e\u516c\u958b");
                    }
                    bean.setColspanReal(col);
                    bean.setIndex(k);
                    bean.setIndexReal(rindex);
                    if (rd.isHidden() && !rd.isMember()) continue;
                    List mlist = rd.getMemberList();
                    this.addMemberAllIdList(mlist);
                    _termScheduleList.add(bean);
                }
                termScheduleList.add(_termScheduleList);
            }
            for (i = 0; i < dayListSize; ++i) {
                AjaxScheduleDayContainer container = (AjaxScheduleDayContainer)dayList.get(i);
                if (i == 0) {
                    containerDate = container.getDate().getValue();
                }
                dateList.add(container.getDate().toString());
                dayOfWeekList.add(container.getDate().getDayOfWeek());
                _scheduleList = container.getScheduleList();
                if (container.isHoliday()) {
                    holidayList.add(container.getHoliday().getName().getValue());
                } else {
                    holidayList.add("");
                }
                if (i == 0) {
                    json.put((Object)"startDate", (Object)container.getDate().toString());
                } else if (i == dayListSize - 1) {
                    json.put((Object)"endDate", (Object)container.getDate().toString());
                }
                int scheSize = _scheduleList.size();
                for (int j = 0; j < scheSize; ++j) {
                    rd = (AjaxScheduleResultData)_scheduleList.get(j);
                    if (rd.isDummy()) continue;
                    bean = new ScheduleBean();
                    bean.initField();
                    bean.setResultData(rd);
                    if (!rd.isPublic() && !rd.isMember()) {
                        bean.setName("\u975e\u516c\u958b");
                    }
                    bean.setIndex(i);
                    if (rd.isHidden() && !rd.isMember()) continue;
                    List mlist = rd.getMemberList();
                    this.addMemberAllIdList(mlist);
                    scheduleList.add(bean);
                }
            }
            List memberList = this.getMemberAllBeanList();
            json.put((Object)"termSchedule", termScheduleList);
            json.put((Object)"schedule", scheduleList);
            json.put((Object)"holiday", holidayList);
            json.put((Object)"date", dateList);
            json.put((Object)"dayOfWeek", dayOfWeekList);
            json.put((Object)"memberAllList", (Object)memberList);
            if (msgList != null && msgList.size() > 0) {
                json.put((Object)"errList", (Object)msgList);
            }
            return json.toString();
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return null;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public boolean doUpdate(ALAction action, RunData rundata, Context context) {
        if (!ScheduleUtils.hasRelation(rundata)) {
            this.aclPortletFeature = "schedule_other";
        }
        try {
            this.doCheckAclPermission(rundata, context, 8);
            boolean res = this.setFormData(rundata, context, this.msgList) && this.validate(this.msgList) && this.updateFormData(rundata, context, this.msgList);
            return res;
        }
        catch (ALPermissionException e) {
            this.msgList.add("PermissionError");
            this.msgList.add("\u30a2\u30af\u30bb\u30b9\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u30b7\u30b9\u30c6\u30e0\u7ba1\u7406\u8005\u306b\u304a\u554f\u3044\u5408\u308f\u305b\u304f\u3060\u3055\u3044\u3002");
            return false;
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void loadParameters(RunData rundata, Context context, List msgList) {
        ALDateTimeField dummy = new ALDateTimeField("yyyy-MM-dd-HH-mm");
        dummy.setNotNull(true);
        if (!ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            msgList.add("not own portlet");
            return;
        }
        if (rundata.getParameters().containsKey((Object)"start_date") && rundata.getParameters().containsKey((Object)"end_date")) {
            this.start_date = rundata.getParameters().getString("start_date");
            dummy.setValue(this.start_date);
            if (!dummy.validate(new ArrayList())) {
                ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"start_date");
                ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"end_date");
                msgList.add("starDate_irregular");
                return;
            }
            this.end_date = rundata.getParameters().getString("end_date");
            dummy.setValue(this.end_date);
            if (!dummy.validate(new ArrayList())) {
                ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"end_date");
                ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"end_date");
                msgList.add("endDate_irregular");
                return;
            }
            if (rundata.getParameters().containsKey((Object)"view_date")) {
                this.view_date = rundata.getParameters().getString("view_date");
                dummy.setValue(this.view_date);
                if (!dummy.validate(new ArrayList())) {
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"view_date");
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"view_date");
                    msgList.add("viewDate_irregular");
                    return;
                }
            }
            if (rundata.getParameters().containsKey((Object)"entityid")) {
                this.entityId = rundata.getParameters().getInt("entityid");
                return;
            }
            msgList.add("entityId_missing");
            return;
        }
        this.isViewList = true;
    }

    public boolean setFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            this.userId = ALEipUtils.getUserId((RunData)rundata);
            this.schedule = ScheduleUtils.getEipTSchedule(rundata, this.entityId, false, this.userId);
            this.isEdit = "T".equals(this.schedule.getEditFlag());
            if (rundata.getParameters().containsKey((Object)"edit_repeat_flag")) {
                this.edit_repeat_flag = rundata.getParameters().getInt("edit_repeat_flag");
            }
            this.scheduleMaps = ScheduleUtils.getEipTScheduleMaps(this.schedule);
            int listSize = this.scheduleMaps.size();
            for (int i = 0; i < listSize; ++i) {
                EipTScheduleMap map = (EipTScheduleMap)this.scheduleMaps.get(i);
                if (!"U".equals(map.getType())) continue;
                int targetUserId = map.getUserId();
                this.memberList.add(ALEipUtils.getALEipUser((int)targetUserId));
            }
            this.ownerId = this.schedule.getOwnerId();
            this.startDate.setValue(this.start_date);
            this.endDate.setValue(this.end_date);
            this.viewDate.setValue(this.view_date);
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean validate(ArrayList msgList) throws ALDBErrorException, ALPageNotFoundException {
        return msgList.size() <= 0;
    }

    public boolean updateFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res;
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        if (this.isEdit || this.userId == this.ownerId || this.aclPortletFeature == "schedule_other") {
            if (this.edit_repeat_flag == 0) {
                this.schedule.setStartDate(this.startDate.getValue());
                this.schedule.setEndDate(this.endDate.getValue());
                Date now = new Date();
                this.schedule.setUpdateDate(now);
                this.schedule.setUpdateUserId(Integer.valueOf(this.userId));
                dataContext.commitChanges();
                res = true;
                this.sendEventLog(rundata, context);
                this.sendWhatsNew(dataContext, this.schedule);
            } else {
                EipTSchedule newSchedule = (EipTSchedule)dataContext.createAndRegisterNewObject(EipTSchedule.class);
                newSchedule.setParentId(this.schedule.getScheduleId());
                newSchedule.setName(this.schedule.getName());
                newSchedule.setPlace(this.schedule.getPlace());
                newSchedule.setNote(this.schedule.getNote());
                newSchedule.setPublicFlag(this.schedule.getPublicFlag());
                newSchedule.setEditFlag(this.schedule.getEditFlag());
                newSchedule.setOwnerId(Integer.valueOf(this.ownerId));
                Date now = new Date();
                newSchedule.setCreateDate(now);
                newSchedule.setCreateUserId(Integer.valueOf(this.ownerId));
                newSchedule.setUpdateDate(now);
                newSchedule.setUpdateUserId(Integer.valueOf(this.userId));
                newSchedule.setEndDate(this.endDate.getValue());
                newSchedule.setRepeatPattern("N");
                newSchedule.setStartDate(this.startDate.getValue());
                int listSize = this.scheduleMaps.size();
                ArrayList<Integer> memberIdList = new ArrayList<Integer>();
                ArrayList<Integer> facilityIdList = new ArrayList<Integer>();
                for (int i = 0; i < listSize; ++i) {
                    EipTScheduleMap newMap = (EipTScheduleMap)dataContext.createAndRegisterNewObject(EipTScheduleMap.class);
                    EipTScheduleMap map = (EipTScheduleMap)this.scheduleMaps.get(i);
                    newMap.setEipTSchedule(newSchedule);
                    newMap.setUserId(map.getUserId());
                    if (map.getUserId() == this.ownerId) {
                        newMap.setStatus("O");
                    } else {
                        EipTScheduleMap tmpMap = this.getScheduleMap(this.scheduleMaps, map.getUserId(), "U");
                        if (tmpMap != null) {
                            newMap.setStatus(tmpMap.getStatus());
                        } else {
                            newMap.setStatus("T");
                        }
                    }
                    newMap.setType(map.getType());
                    newMap.setCommonCategoryId(map.getCommonCategoryId());
                    newMap.setEipTCommonCategory(map.getEipTCommonCategory());
                    if ("U".equals(map.getType())) {
                        memberIdList.add(map.getUserId());
                        continue;
                    }
                    facilityIdList.add(map.getUserId());
                }
                if (this.viewDate != null) {
                    ScheduleUtils.insertDummySchedule(this.schedule, this.userId, this.viewDate.getValue(), this.viewDate.getValue(), memberIdList, facilityIdList);
                }
                dataContext.commitChanges();
                res = true;
                this.sendEventLog(rundata, context);
                this.sendWhatsNew(dataContext, newSchedule);
            }
        } else {
            msgList.add("\u305d\u306e\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb\u306f\u7de8\u96c6\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093");
            res = false;
        }
        return res;
    }

    private boolean doCheckAclPermission(RunData rundata, Context context, int defineAclType) throws ALPermissionException {
        if (defineAclType == 0) {
            return true;
        }
        String pfeature = this.getAclPortletFeature();
        if (pfeature == null || "".equals(pfeature)) {
            return true;
        }
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        boolean hasAuthority = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), pfeature, defineAclType);
        if (!hasAuthority) {
            throw new ALPermissionException();
        }
        return true;
    }

    private void sendEventLog(RunData rundata, Context context) {
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"mode", (String)"update");
        ALEventlogFactoryService.getInstance().getEventlogHandler().log(this.schedule.getScheduleId().intValue(), 240, this.schedule.getName());
    }

    private void sendWhatsNew(DataContext dataContext, EipTSchedule newSchedule) {
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        List userIds = aclhandler.getAcceptUserIdsInListExceptLoginUser(dataContext, this.userId, "schedule_self", 2, (List)this.memberList);
        int size = userIds.size();
        for (int i = 0; i < size; ++i) {
            Integer _id = (Integer)userIds.get(i);
            WhatsNewUtils.insertWhatsNew((DataContext)dataContext, (int)6, (int)newSchedule.getScheduleId(), (int)_id);
        }
    }

    private void addMemberAllIdList(List list) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            int id;
            String listId = (String)list.get(i);
            if (listId.startsWith("f")) {
                id = Integer.parseInt(listId.substring(1));
                if (this.facilityIdMemberAll.contains(id)) continue;
                this.facilityIdMemberAll.add(id);
                continue;
            }
            id = Integer.parseInt(listId);
            if (this.userIdMemberAll.contains(id)) continue;
            this.userIdMemberAll.add(id);
        }
    }

    private List getMemberAllBeanList() {
        ArrayList<UserFacilityLiteBean> rList = new ArrayList<UserFacilityLiteBean>();
        try {
            UserFacilityLiteBean tmpMbean;
            int i;
            int size;
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = null;
            if (this.facilityIdMemberAll != null && this.facilityIdMemberAll.size() > 0) {
                query = new SelectQuery(EipMFacility.class);
                Expression exp_f = ExpressionFactory.inDbExp((String)"FACILITY_ID", (Collection)this.facilityIdMemberAll);
                query.setQualifier(exp_f);
                List fList = dataContext.performQuery((Query)query);
                if (fList != null) {
                    size = fList.size();
                    for (i = 0; i < size; ++i) {
                        EipMFacility facility = (EipMFacility)fList.get(i);
                        tmpMbean = new UserFacilityLiteBean();
                        tmpMbean.initField();
                        tmpMbean.setAliasName(facility.getFacilityName());
                        tmpMbean.setName("f" + facility.getFacilityId().toString());
                        tmpMbean.setUserFacilityId(facility.getFacilityId().intValue());
                        tmpMbean.setUserFacilityType("F");
                        rList.add(tmpMbean);
                    }
                }
            }
            if (this.userIdMemberAll != null && this.userIdMemberAll.size() > 0) {
                query = new SelectQuery(TurbineUser.class);
                Expression exp_u = ExpressionFactory.inDbExp((String)"USER_ID", (Collection)this.userIdMemberAll);
                query.setQualifier(exp_u);
                List uList = dataContext.performQuery((Query)query);
                if (uList != null) {
                    size = uList.size();
                    for (i = 0; i < size; ++i) {
                        TurbineUser user = (TurbineUser)uList.get(i);
                        tmpMbean = new UserFacilityLiteBean();
                        tmpMbean.initField();
                        tmpMbean.setAliasName(user.getFirstName(), user.getLastName());
                        tmpMbean.setName(user.getUserId().toString());
                        tmpMbean.setUserFacilityId(user.getUserId().intValue());
                        tmpMbean.setUserFacilityType("U");
                        rList.add(tmpMbean);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rList;
    }

    private boolean hasAcl(RunData rundata) {
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.aclPortletFeature = "schedule_other";
        boolean hasAuthority = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "schedule_other", 4);
        return hasAuthority;
    }

    private String getAclPortletFeature() {
        return this.aclPortletFeature;
    }

    public List getMsgList() {
        return this.msgList;
    }

    public boolean getIsViewList() {
        return this.isViewList;
    }

    private EipTScheduleMap getScheduleMap(List scheduleMaps, int userid, String type) {
        EipTScheduleMap map = null;
        int size = scheduleMaps.size();
        for (int i = 0; i < size; ++i) {
            map = (EipTScheduleMap)scheduleMaps.get(i);
            if (map.getUserId() != userid || !type.equals(map.getType())) continue;
            return map;
        }
        return null;
    }
}

