/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.facilities.util.FacilitiesUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.schedule.ScheduleResultData;
import com.aimluck.eip.schedule.ScheduleToDoResultData;
import com.aimluck.eip.schedule.ScheduleWeekContainer;
import com.aimluck.eip.schedule.ScheduleWeeklySelectData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.todo.util.ToDoUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ScheduleWeeklyGroupSelectData
extends ScheduleWeeklySelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ScheduleWeeklyGroupSelectData.class.getName());
    private Map termmap;
    private Map map;
    private List members;
    private List groups;
    private Integer userid;
    private String myGroupURI;
    private Map todomap;
    private String portletId;
    private Map facilitymap;
    private List facilityList;
    private boolean hasAuthoritySelfInsert = false;
    private boolean hasAuthorityFacilityInsert = false;
    protected final String FLAG_CHANGE_TURN_STR = new StringBuffer().append(((Object)((Object)this)).getClass().getName()).append("flagchangeturn").toString();

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.viewtype = "weekly-group";
        try {
            VelocityPortlet portlet;
            String changeturnFlag;
            String flag_changeturn;
            VelocityPortlet portlet2;
            String groupName;
            this.termmap = new LinkedHashMap();
            this.map = new LinkedHashMap();
            this.todomap = new LinkedHashMap();
            this.facilitymap = new LinkedHashMap();
            this.groups = ALEipUtils.getMyGroups((RunData)rundata);
            this.userid = ALEipUtils.getUserId((RunData)rundata);
            String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
            if ((filter == null || filter.equals("")) && (groupName = (portlet2 = ALEipUtils.getPortlet((RunData)rundata, (Context)context)).getPortletConfig().getInitParameter("p3a-group")) != null) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR, (String)groupName);
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR, (String)"group");
            }
            if (((flag_changeturn = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.FLAG_CHANGE_TURN_STR)) == null || flag_changeturn.equals("")) && (changeturnFlag = (portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context)).getPortletConfig().getInitParameter("p3b-group")) != null) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.FLAG_CHANGE_TURN_STR, (String)changeturnFlag);
            }
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            this.hasAuthoritySelfInsert = aclhandler.hasAuthority(this.userid.intValue(), "schedule_self", 4);
            this.hasAuthorityFacilityInsert = aclhandler.hasAuthority(this.userid.intValue(), "schedule_facility", 4);
            this.myGroupURI = ScheduleUtils.getPortletURIinPersonalConfigPane(rundata, "MyGroup");
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
    }

    protected List selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        try {
            List list = this.dataContext.performQuery((Query)this.getSelectQuery(rundata, context));
            if (this.viewTodo == 1) {
                this.loadTodo(rundata, context);
            }
            return ScheduleUtils.sortByDummySchedule(list);
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleWeeklyGroupSelectData]", (Throwable)e);
            throw new ALDBErrorException();
        }
    }

    protected SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipTScheduleMap.class);
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"eipTSchedule.endDate", (Object)this.getViewStart().getValue());
        Expression exp12 = ExpressionFactory.lessExp((String)"eipTSchedule.startDate", (Object)this.getViewEndCrt().getValue());
        Expression exp13 = ExpressionFactory.noMatchExp((String)"eipTSchedule.repeatPattern", (Object)"N");
        Expression exp14 = ExpressionFactory.noMatchExp((String)"eipTSchedule.repeatPattern", (Object)"S");
        query.setQualifier(exp11.andExp(exp12).orExp(exp13.andExp(exp14)));
        query.addOrdering("eipTSchedule.startDate", true);
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    protected Object getResultData(Object obj) throws ALPageNotFoundException, ALDBErrorException {
        ScheduleResultData rd = new ScheduleResultData();
        rd.initField();
        try {
            boolean is_member;
            EipTScheduleMap record = (EipTScheduleMap)obj;
            EipTSchedule schedule = record.getEipTSchedule();
            if ("R".equals(record.getStatus())) {
                return rd;
            }
            SelectQuery mapquery = new SelectQuery(EipTScheduleMap.class);
            Expression mapexp1 = ExpressionFactory.matchExp((String)"scheduleId", (Object)schedule.getScheduleId());
            mapquery.setQualifier(mapexp1);
            Expression mapexp2 = ExpressionFactory.matchExp((String)"userId", (Object)this.userid);
            mapquery.andQualifier(mapexp2);
            List schedulemaps = this.dataContext.performQuery((Query)mapquery);
            boolean bl = is_member = schedulemaps != null && schedulemaps.size() > 0;
            if (!"D".equals(record.getStatus()) && "P".equals(schedule.getPublicFlag()) && this.userid.intValue() != record.getUserId().intValue() && this.userid.intValue() != schedule.getOwnerId().intValue() && !is_member) {
                return rd;
            }
            if ("C".equals(schedule.getPublicFlag()) && this.userid.intValue() != record.getUserId().intValue() && this.userid.intValue() != schedule.getOwnerId().intValue() && !is_member) {
                rd.setName("\u975e\u516c\u958b");
                rd.setTmpreserve(false);
            } else {
                rd.setName(schedule.getName());
                rd.setTmpreserve("T".equals(record.getStatus()));
            }
            rd.setScheduleId(schedule.getScheduleId());
            rd.setParentId(schedule.getParentId());
            rd.setStartDate(schedule.getStartDate());
            rd.setEndDate(schedule.getEndDate());
            rd.setPublic("O".equals(schedule.getPublicFlag()));
            rd.setHidden("P".equals(schedule.getPublicFlag()));
            rd.setDummy("D".equals(record.getStatus()));
            rd.setLoginuser(record.getUserId().intValue() == this.userid.intValue());
            rd.setOwner(schedule.getOwnerId().intValue() == this.userid.intValue());
            rd.setMember(is_member);
            rd.setPattern(schedule.getRepeatPattern());
            ScheduleWeekContainer weekCon = null;
            weekCon = "U".equals(record.getType()) ? (ScheduleWeekContainer)this.map.get(record.getUserId()) : (ScheduleWeekContainer)this.facilitymap.get(record.getUserId());
            if (rd.getPattern().equals("S")) {
                ArrayList terms;
                int col;
                int count;
                int stime = -((int)((this.getViewStart().getValue().getTime() - rd.getStartDate().getValue().getTime()) / 86400000L));
                int etime = -((int)((this.getViewStart().getValue().getTime() - rd.getEndDate().getValue().getTime()) / 86400000L));
                if (stime < 0) {
                    stime = 0;
                }
                if ((count = stime) + (col = etime - stime + 1) > 7) {
                    col = 7 - count;
                }
                rd.setRowspan(col);
                if (col > 0 && (terms = (ArrayList)this.termmap.get(record.getUserId())) != null) {
                    ScheduleUtils.addTermSchedule(terms, this.getViewStart().getValue(), count, rd);
                }
                return rd;
            }
            weekCon.addResultData(rd);
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return null;
        }
        return rd;
    }

    protected SelectQuery buildSelectQueryForFilter(SelectQuery query, RunData rundata, Context context) {
        String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        String filter_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR);
        String crt_key = null;
        Attributes map = this.getColumnMap();
        if (filter == null || filter_type == null || filter.equals("")) {
            Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)this.userid);
            query.andQualifier(exp1);
            this.members = new ArrayList();
            this.members.add(ALEipUtils.getALEipUser((RunData)rundata));
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.tmpCal.getTime());
            ScheduleWeekContainer week = new ScheduleWeekContainer();
            week.initField();
            week.setViewStartDate(cal);
            this.termmap.put(this.userid, new ArrayList());
            this.map.put(this.userid, week);
            this.todomap.put(this.userid, new ArrayList());
            return query;
        }
        crt_key = map.getValue(filter_type);
        if (crt_key == null) {
            return query;
        }
        List ulist = ALEipUtils.getUserIds((String)filter);
        int size = ulist.size();
        if (size == 0) {
            ulist.add(-1);
        } else {
            for (int i = 0; i < size; ++i) {
                Integer id = (Integer)ulist.get(i);
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.tmpCal.getTime());
                ScheduleWeekContainer week = new ScheduleWeekContainer();
                week.initField();
                week.setViewStartDate(cal);
                this.termmap.put(id, new ArrayList());
                this.map.put(id, week);
                this.todomap.put(id, new ArrayList());
            }
        }
        List facilityIds = null;
        facilityIds = "Facility".equals(filter) ? this.getFacilityIdAllList() : FacilitiesUtils.getFacilityIds((String)filter);
        int f_size = facilityIds.size();
        if (f_size == 0) {
            facilityIds.add(-1);
        } else {
            for (int i = 0; i < f_size; ++i) {
                Integer id = (Integer)facilityIds.get(i);
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.tmpCal.getTime());
                ScheduleWeekContainer week = new ScheduleWeekContainer();
                week.initField();
                week.setViewStartDate(cal);
                this.facilitymap.put(id, week);
            }
        }
        if ("Facility".equals(filter)) {
            Expression exp21 = ExpressionFactory.matchExp((String)"type", (Object)"F");
            Expression exp22 = ExpressionFactory.inExp((String)crt_key, (Collection)facilityIds);
            query.andQualifier(exp21.andExp(exp22));
        } else {
            Expression exp11 = ExpressionFactory.matchExp((String)"type", (Object)"U");
            Expression exp12 = ExpressionFactory.inExp((String)crt_key, (Collection)ulist);
            Expression exp21 = ExpressionFactory.matchExp((String)"type", (Object)"F");
            Expression exp22 = ExpressionFactory.inExp((String)crt_key, (Collection)facilityIds);
            query.andQualifier(exp11.andExp(exp12).orExp(exp21.andExp(exp22)));
        }
        this.members = ALEipUtils.getUsers((String)filter);
        String flag_changeturn = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.FLAG_CHANGE_TURN_STR);
        if ("0".equals(flag_changeturn)) {
            ALEipUser eipUser = null;
            int memberSize = this.members.size();
            for (int i = 0; i < memberSize; ++i) {
                eipUser = (ALEipUser)this.members.get(i);
                if (eipUser.getUserId().getValue() != (long)this.userid.intValue()) continue;
                this.members.remove(i);
                this.members.add(0, eipUser);
            }
        }
        this.facilityList = FacilitiesUtils.getFacilityList((String)filter);
        this.current_filter = filter;
        this.current_filter_type = filter_type;
        return query;
    }

    private List getFacilityIdAllList() {
        ArrayList<Integer> facilityIdAllList = new ArrayList<Integer>();
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipMFacility.class);
            query.addCustomDbAttribute("FACILITY_ID");
            List aList = dataContext.performQuery((Query)query);
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                DataRow dataRow = (DataRow)aList.get(i);
                facilityIdAllList.add((Integer)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"FACILITY_ID"));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return facilityIdAllList;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("group", "userId");
        return map;
    }

    public void loadTodo(RunData rundata, Context context) {
        try {
            SelectQuery query = this.getSelectQueryForTodo(rundata, context);
            List todos = this.dataContext.performQuery((Query)query);
            int todossize = todos.size();
            for (int i = 0; i < todossize; ++i) {
                ArrayList usertodos1;
                int col;
                int count;
                EipTTodo record = (EipTTodo)todos.get(i);
                ScheduleToDoResultData rd = new ScheduleToDoResultData();
                rd.initField();
                String todo_url = "";
                todo_url = this.userid.intValue() == record.getTurbineUser().getUserId().intValue() ? ScheduleUtils.getPortletURItoTodoDetailPane(rundata, "ToDo", record.getTodoId().longValue(), this.portletId) : ScheduleUtils.getPortletURItoTodoPublicDetailPane(rundata, "ToDo", record.getTodoId().longValue(), this.portletId);
                rd.setTodoId(record.getTodoId().intValue());
                rd.setTodoName(record.getTodoName());
                rd.setUserId(record.getTurbineUser().getUserId().intValue());
                rd.setStartDate(record.getStartDate());
                rd.setEndDate(record.getEndDate());
                rd.setTodoUrl(todo_url);
                rd.setPublicFlag("T".equals(record.getPublicFlag()));
                int stime = ScheduleUtils.equalsToDate(ToDoUtils.getEmptyDate(), rd.getStartDate().getValue(), false) ? 0 : -((int)((this.getViewStart().getValue().getTime() - rd.getStartDate().getValue().getTime()) / 86400000L));
                int etime = -((int)((this.getViewStart().getValue().getTime() - rd.getEndDate().getValue().getTime()) / 86400000L));
                if (stime < 0) {
                    stime = 0;
                }
                if ((count = stime) + (col = etime - stime + 1) > 7) {
                    col = 7 - count;
                }
                rd.setRowspan(col);
                if (col <= 0 || (usertodos1 = (ArrayList)this.todomap.get(record.getTurbineUser().getUserId())) == null) continue;
                ScheduleUtils.addToDo(usertodos1, this.getViewStart().getValue(), count, rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return;
        }
    }

    private SelectQuery getSelectQueryForTodo(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipTTodo.class);
        Expression exp1 = ExpressionFactory.noMatchExp((String)"state", (Object)100);
        query.setQualifier(exp1);
        Expression exp01 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)this.userid);
        Expression exp02 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)this.userid);
        Expression exp03 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"T");
        Expression exp04 = ExpressionFactory.matchExp((String)"addonScheduleFlg", (Object)"T");
        query.andQualifier(exp01.orExp(exp02.andExp(exp03)).andExp(exp04));
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.getViewStart().getValue());
        Expression exp12 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.getViewEnd().getValue());
        Expression exp21 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.getViewEnd().getValue());
        Expression exp22 = ExpressionFactory.matchExp((String)"endDate", (Object)ToDoUtils.getEmptyDate());
        Expression exp31 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.getViewStart().getValue());
        Expression exp32 = ExpressionFactory.matchExp((String)"startDate", (Object)ToDoUtils.getEmptyDate());
        query.andQualifier(exp11.andExp(exp12).orExp(exp21.andExp(exp22)).orExp(exp31.andExp(exp32)));
        return query;
    }

    public ScheduleWeekContainer getContainer(long id) {
        return (ScheduleWeekContainer)this.map.get((int)id);
    }

    public List getMemberList() {
        return this.members;
    }

    public Map getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public List getGroupList() {
        return this.groups;
    }

    public boolean isMatch(long id) {
        return this.userid == (int)id;
    }

    public String getMyGroupURI() {
        return this.myGroupURI;
    }

    public List getTermContainer(long id) {
        return (List)this.termmap.get((int)id);
    }

    public List getToDoContainer(long id) {
        return (List)this.todomap.get((int)id);
    }

    public void setPortletId(String id) {
        this.portletId = id;
    }

    public List getFacilityList() {
        return this.facilityList;
    }

    public ScheduleWeekContainer getFacilityContainer(long id) {
        return (ScheduleWeekContainer)this.facilitymap.get((int)id);
    }

    public long getUserId() {
        return this.userid.longValue();
    }

    public String getAclPortletFeature() {
        return "schedule_other";
    }

    public boolean hasAuthoritySelfInsert() {
        return this.hasAuthoritySelfInsert;
    }

    public boolean hasAuthorityFacilityInsert() {
        return this.hasAuthorityFacilityInsert;
    }
}

