/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.schedule.ScheduleResultData;
import com.aimluck.eip.schedule.ScheduleToDoResultData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.todo.util.ToDoUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ScheduleOnedaySelectData
extends ALAbstractSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ScheduleOnedaySelectData.class.getName());
    private ALDateTimeField viewDate;
    private ALDateTimeField prevDate;
    private ALDateTimeField nextDate;
    private ALDateTimeField today;
    private ScheduleResultData[] resultData;
    private ArrayList termList;
    protected int startHour;
    protected int endHour;
    private int count;
    protected String viewtype;
    protected boolean is_duplicate;
    private List dlist;
    int tmpIndex;
    protected String tmpViewDate2;
    private Map rowspanMap;
    private int rowIndex;
    protected int viewToDo;
    private List todoList;
    private String portletId;
    protected DataContext dataContext;
    private boolean hasAuthoritySelfInsert = false;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        this.viewDate = new ALDateTimeField("yyyy-MM-dd");
        this.viewDate.setNotNull(true);
        this.nextDate = new ALDateTimeField("yyyy-MM-dd");
        this.prevDate = new ALDateTimeField("yyyy-MM-dd");
        this.today = new ALDateTimeField("yyyy-MM-dd");
        Calendar to = Calendar.getInstance();
        to.set(11, 0);
        to.set(12, 0);
        this.today.setValue(to.getTime());
        this.startHour = Integer.parseInt(ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p1a-rows"));
        this.endHour = Integer.parseInt(ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p1b-rows"));
        this.viewToDo = Integer.parseInt(ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p5a-view"));
        this.tmpIndex = 0;
        this.count = 0;
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"view_date")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"view_date", (String)rundata.getParameters().getString("view_date"));
        }
        String tmpViewDate = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"view_date");
        if (this.tmpViewDate2 != null) {
            tmpViewDate = this.tmpViewDate2;
        }
        if (tmpViewDate == null || tmpViewDate.equals("")) {
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            this.viewDate.setValue(cal.getTime());
        } else {
            this.viewDate.setValue(tmpViewDate);
            if (!this.viewDate.validate(new ArrayList())) {
                ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"view_date");
                throw new ALPageNotFoundException();
            }
        }
        this.resultData = new ScheduleResultData[(this.endHour - this.startHour) * 4 * 2];
        this.dlist = new ArrayList();
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(this.viewDate.getValue());
        cal2.add(5, 1);
        this.nextDate.setValue(cal2.getTime());
        cal2.add(5, -2);
        this.prevDate.setValue(cal2.getTime());
        this.rowspanMap = new HashMap();
        for (int i = this.startHour; i <= this.endHour; ++i) {
            this.rowspanMap.put(i, 4);
        }
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpStart", (String)(this.viewDate.toString() + "-00-00"));
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpEnd", (String)(this.viewDate.toString() + "-00-00"));
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        this.termList = new ArrayList();
        super.init(action, rundata, context);
        this.viewtype = "oneday";
        int userId = ALEipUtils.getUserId((RunData)rundata);
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAuthoritySelfInsert = aclhandler.hasAuthority(userId, "schedule_self", 4);
    }

    protected List selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTScheduleMap record;
            int i;
            List resultBaseList = this.dataContext.performQuery((Query)this.getSelectQuery(rundata, context));
            List resultList = ScheduleUtils.sortByDummySchedule(resultBaseList);
            ArrayList<EipTScheduleMap> list = new ArrayList<EipTScheduleMap>();
            ArrayList<EipTScheduleMap> delList = new ArrayList<EipTScheduleMap>();
            int delSize = 0;
            int resultSize = resultList.size();
            int size = 0;
            boolean canAdd = true;
            for (i = 0; i < resultSize; ++i) {
                record = (EipTScheduleMap)resultList.get(i);
                EipTSchedule schedule = record.getEipTSchedule();
                delList.clear();
                canAdd = true;
                size = list.size();
                for (int j = 0; j < size; ++j) {
                    EipTScheduleMap record2 = (EipTScheduleMap)list.get(j);
                    EipTSchedule schedule2 = record2.getEipTSchedule();
                    if (!schedule.getRepeatPattern().equals("N") && "D".equals(record2.getStatus()) && schedule.getScheduleId().intValue() == schedule2.getParentId().intValue()) {
                        canAdd = false;
                        break;
                    }
                    if (schedule2.getRepeatPattern().equals("N") || !"D".equals(record.getStatus()) || schedule2.getScheduleId().intValue() != schedule.getParentId().intValue()) continue;
                    if (!delList.contains(record2)) {
                        delList.add(record2);
                    }
                    canAdd = true;
                }
                delSize = delList.size();
                for (int k = 0; k < delSize; ++k) {
                    list.remove(delList.get(k));
                }
                if (!canAdd) continue;
                list.add(record);
            }
            delList.clear();
            size = list.size();
            for (i = 0; i < size; ++i) {
                record = (EipTScheduleMap)list.get(i);
                if (!"D".equals(record.getStatus())) continue;
                delList.add(record);
            }
            delSize = delList.size();
            for (i = 0; i < delSize; ++i) {
                list.remove(delList.get(i));
            }
            Collections.sort(list, new Comparator(){

                public int compare(Object a, Object b) {
                    Calendar cal = Calendar.getInstance();
                    Calendar cal2 = Calendar.getInstance();
                    EipTSchedule p1 = null;
                    EipTSchedule p2 = null;
                    try {
                        p1 = ((EipTScheduleMap)a).getEipTSchedule();
                        p2 = ((EipTScheduleMap)b).getEipTSchedule();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Exception", (Throwable)e);
                    }
                    cal.setTime(p1.getStartDate());
                    cal.set(0, 0, 0);
                    cal2.setTime(p2.getStartDate());
                    cal2.set(0, 0, 0);
                    if (cal.getTime().compareTo(cal2.getTime()) != 0) {
                        return cal.getTime().compareTo(cal2.getTime());
                    }
                    cal.setTime(p1.getEndDate());
                    cal.set(0, 0, 0);
                    cal2.setTime(p2.getEndDate());
                    cal2.set(0, 0, 0);
                    return cal.getTime().compareTo(cal2.getTime());
                }
            });
            if (this.viewToDo == 1) {
                this.loadToDo(rundata, context);
            }
            return list;
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleOnedaySelectData]", (Throwable)e);
            throw new ALDBErrorException();
        }
    }

    protected SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipTScheduleMap.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"type", (Object)"U");
        query.andQualifier(exp2);
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"eipTSchedule.endDate", (Object)this.viewDate.getValue());
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.viewDate.getValue());
        cal.add(5, 1);
        ALDateTimeField field = new ALDateTimeField();
        field.setValue(cal.getTime());
        Expression exp12 = ExpressionFactory.lessExp((String)"eipTSchedule.startDate", (Object)field.getValue());
        Expression exp13 = ExpressionFactory.noMatchExp((String)"eipTSchedule.repeatPattern", (Object)"N");
        Expression exp14 = ExpressionFactory.noMatchExp((String)"eipTSchedule.repeatPattern", (Object)"S");
        query.andQualifier(exp11.andExp(exp12).orExp(exp13.andExp(exp14)));
        ArrayList<Ordering> orders = new ArrayList<Ordering>();
        orders.add(new Ordering("eipTSchedule.startDate", true));
        orders.add(new Ordering("eipTSchedule.endDate", true));
        query.addOrderings(orders);
        return query;
    }

    protected Object selectDetail(RunData rundata, Context context) {
        return null;
    }

    protected Object getResultData(Object obj) throws ALPageNotFoundException, ALDBErrorException {
        ScheduleResultData rd = new ScheduleResultData();
        ScheduleResultData rd2 = new ScheduleResultData();
        rd.initField();
        rd2.setFormat("yyyy-MM-dd-HH-mm");
        rd2.initField();
        try {
            EipTScheduleMap record = (EipTScheduleMap)obj;
            EipTSchedule schedule = record.getEipTSchedule();
            if ("R".equals(record.getStatus())) {
                return rd;
            }
            if (!ScheduleUtils.isView(this.viewDate, schedule.getRepeatPattern(), schedule.getStartDate(), schedule.getEndDate())) {
                return rd;
            }
            rd.setScheduleId(schedule.getScheduleId());
            rd.setParentId(schedule.getParentId());
            rd.setName(schedule.getName());
            rd.setStartDate(schedule.getStartDate());
            rd.setEndDate(schedule.getEndDate());
            rd.setTmpreserve("T".equals(record.getStatus()));
            rd.setPublic("O".equals(schedule.getPublicFlag()));
            rd.setHidden("P".equals(schedule.getPublicFlag()));
            rd.setPattern(schedule.getRepeatPattern());
            if (rd.getPattern().equals("S")) {
                this.termList.add(rd);
                return rd;
            }
            if (!rd.getPattern().equals("N")) {
                if (!ScheduleUtils.isView(this.viewDate, rd.getPattern(), rd.getStartDate().getValue(), rd.getEndDate().getValue())) {
                    return rd;
                }
                rd.setRepeat(true);
            }
            boolean dup = false;
            int sta = this.startHour * 4;
            int eta = this.endHour * 4;
            int st = Integer.parseInt(rd.getStartDate().getHour()) * 4 + Integer.parseInt(rd.getStartDate().getMinute()) / 15;
            int ed = Integer.parseInt(rd.getEndDate().getHour()) * 4 + Integer.parseInt(rd.getEndDate().getMinute()) / 15;
            if (!rd.getStartDate().getDay().equals(rd.getEndDate().getDay()) && rd.getEndDate().getHour().equals("0")) {
                ed = 96;
            }
            if (ed - sta > 0 && eta - st > 0 || ed - sta == 0 && st == ed) {
                if (sta > st) {
                    st = sta;
                }
                if (eta < ed) {
                    ed = eta;
                }
                sta -= this.rowIndex;
                int tmpRowIndex = this.rowIndex;
                if (ed - st == 0) {
                    rd.setRowspan(1);
                    Integer rowspan = (Integer)this.rowspanMap.get(Integer.valueOf(rd.getStartDate().getHour()));
                    if (rowspan > 4) {
                        this.resultData[this.tmpIndex].setDuplicate(true);
                        rd.setDuplicate(true);
                    }
                    this.rowspanMap.put(Integer.valueOf(rd.getStartDate().getHour()), rowspan + 1);
                    ++this.rowIndex;
                    ++ed;
                } else {
                    rd.setRowspan(ed - st);
                }
                if (st - sta - this.count > 0) {
                    rd2.setRowspan(st - sta - this.count);
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(this.viewDate.getValue());
                    cal.add(10, this.startHour);
                    int hour = (this.count - tmpRowIndex) / 4;
                    int min = (this.count - tmpRowIndex) % 4 * 15;
                    cal.add(10, hour);
                    cal.add(12, min);
                    rd2.setStartDate(cal.getTime());
                    hour = (st - sta - this.count) / 4;
                    min = (st - sta - this.count) % 4 * 15;
                    cal.add(10, hour);
                    cal.add(12, min);
                    rd2.setEndDate(cal.getTime());
                    this.resultData[this.count] = rd2;
                } else if (st - sta - this.count != 0) {
                    this.dlist.add(rd);
                    rd.setDuplicate(true);
                    dup = true;
                    this.is_duplicate = true;
                    this.resultData[this.tmpIndex].setDuplicate(true);
                }
                if (!dup) {
                    this.resultData[st - sta] = rd;
                    this.tmpIndex = st - sta;
                    this.count = ed - sta;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return null;
        }
        return rd;
    }

    protected Object getResultDataDetail(Object obj) {
        return null;
    }

    protected Attributes getColumnMap() {
        return null;
    }

    public boolean doViewList(ALAction action, RunData rundata, Context context) {
        boolean res = super.doViewList(action, rundata, context);
        if (res) {
            this.postDoList();
        }
        return res;
    }

    public boolean doSelectList(ALAction action, RunData rundata, Context context) {
        boolean res = super.doSelectList(action, rundata, context);
        if (res) {
            this.postDoList();
        }
        return res;
    }

    private void postDoList() {
        int index = (this.endHour - this.startHour) * 4 + this.rowIndex;
        if (index > this.count) {
            ScheduleResultData rd = new ScheduleResultData();
            rd.setFormat("yyyy-MM-dd-HH-mm");
            rd.initField();
            rd.setRowspan(index - this.count);
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.viewDate.getValue());
            cal.add(10, this.startHour);
            int hour = (this.count - this.rowIndex) / 4;
            int min = (this.count - this.rowIndex) % 4 * 15;
            cal.add(10, hour);
            cal.add(12, min);
            rd.setStartDate(cal.getTime());
            hour = (index - this.count) / 4;
            min = (index - this.count) % 4 * 15;
            cal.add(10, hour);
            cal.add(12, min);
            rd.setEndDate(cal.getTime());
            this.resultData[this.count] = rd;
        }
    }

    public void loadToDo(RunData rundata, Context context) {
        this.todoList = new ArrayList();
        try {
            SelectQuery query = this.getSelectQueryForTodo(rundata, context);
            List todos = this.dataContext.performQuery((Query)query);
            int todosize = todos.size();
            for (int i = 0; i < todosize; ++i) {
                EipTTodo record = (EipTTodo)todos.get(i);
                ScheduleToDoResultData rd = new ScheduleToDoResultData();
                rd.initField();
                String todo_url = this.getPortletURItoTodo(rundata, record.getTodoId().longValue(), this.portletId);
                rd.setTodoId(record.getTodoId().intValue());
                rd.setTodoName(record.getTodoName());
                rd.setUserId(record.getTurbineUser().getUserId().intValue());
                rd.setStartDate(record.getStartDate());
                rd.setEndDate(record.getEndDate());
                rd.setTodoUrl(todo_url);
                rd.setPublicFlag("T".equals(record.getPublicFlag()));
                this.todoList.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return;
        }
    }

    protected String getPortletURItoTodo(RunData rundata, long entityid, String schedulePortletId) {
        return ScheduleUtils.getPortletURItoTodoDetailPane(rundata, "ToDo", entityid, schedulePortletId);
    }

    private SelectQuery getSelectQueryForTodo(RunData rundata, Context context) {
        Integer uid = ALEipUtils.getUserId((RunData)rundata);
        SelectQuery query = new SelectQuery(EipTTodo.class);
        Expression exp1 = ExpressionFactory.noMatchExp((String)"state", (Object)100);
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"addonScheduleFlg", (Object)"T");
        query.andQualifier(exp2);
        Expression exp3 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)uid);
        query.andQualifier(exp3);
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.viewDate.getValue());
        Expression exp12 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.viewDate.getValue());
        Expression exp21 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.viewDate.getValue());
        Expression exp22 = ExpressionFactory.matchExp((String)"endDate", (Object)ToDoUtils.getEmptyDate());
        Expression exp31 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.viewDate.getValue());
        Expression exp32 = ExpressionFactory.matchExp((String)"startDate", (Object)ToDoUtils.getEmptyDate());
        query.andQualifier(exp11.andExp(exp12).orExp(exp21.andExp(exp22)).orExp(exp31.andExp(exp32)));
        return query;
    }

    public ALDateTimeField getViewDate() {
        return this.viewDate;
    }

    public ALDateTimeField getNextDate() {
        return this.nextDate;
    }

    public ALDateTimeField getPrevDate() {
        return this.prevDate;
    }

    public ALDateTimeField getToday() {
        return this.today;
    }

    public ScheduleResultData getResult(int index) {
        return this.resultData[index];
    }

    public int getStartHour() {
        return this.startHour;
    }

    public int getEndHour() {
        return this.endHour;
    }

    public String getViewtype() {
        return this.viewtype;
    }

    public boolean isDuplicate() {
        return this.is_duplicate;
    }

    public List getDuplicateScheduleList() {
        return this.dlist;
    }

    public void setTmpViewDate(String date) {
        this.tmpViewDate2 = date;
    }

    public int getRowspan(int hour) {
        return (Integer)this.rowspanMap.get(hour);
    }

    public List getTermResultDataList() {
        return this.termList;
    }

    public List getToDoResultDataList() {
        return this.todoList;
    }

    public void setPortletId(String id) {
        this.portletId = id;
    }

    public String getAclPortletFeature() {
        return "schedule_self";
    }

    public boolean hasAuthoritySelfInsert() {
        return this.hasAuthoritySelfInsert;
    }
}

