/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.facilities.util.FacilitiesUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.schedule.ScheduleOnedayContainer;
import com.aimluck.eip.schedule.ScheduleOnedayResultData;
import com.aimluck.eip.schedule.ScheduleOnedaySelectData;
import com.aimluck.eip.schedule.ScheduleToDoResultData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.todo.util.ToDoUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ScheduleOnedayGroupSelectData
extends ScheduleOnedaySelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ScheduleOnedayGroupSelectData.class.getName());
    private Map termmap;
    private Map map;
    private List members;
    private List groups;
    private int userid;
    private int[] rows;
    private int max;
    private boolean is_hasspan;
    private String myGroupURI;
    private Map todomap;
    private String portletId;
    protected final String FLAG_CHANGE_TURN_STR = new StringBuffer().append(((Object)((Object)this)).getClass().getName()).append("flagchangeturn").toString();
    private Map facilitymap;
    private List facilityList;
    private boolean hasAuthoritySelfInsert = false;
    private boolean hasAuthorityFacilityInsert = false;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.viewtype = "oneday-group";
        try {
            VelocityPortlet portlet;
            String changeturnFlag;
            String flag_changeturn;
            VelocityPortlet portlet2;
            String groupName;
            this.termmap = new LinkedHashMap();
            this.map = new LinkedHashMap();
            this.todomap = new LinkedHashMap();
            this.facilitymap = new LinkedHashMap();
            this.groups = ALEipUtils.getMyGroups((RunData)rundata);
            this.userid = ALEipUtils.getUserId((RunData)rundata);
            this.rows = new int[(this.endHour - this.startHour) * 4 + 1];
            int size = this.rows.length;
            for (int i = 0; i < size; ++i) {
                this.rows[i] = 1;
            }
            String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
            if ((filter == null || filter.equals("")) && (groupName = (portlet2 = ALEipUtils.getPortlet((RunData)rundata, (Context)context)).getPortletConfig().getInitParameter("p3a-group")) != null) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR, (String)groupName);
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR, (String)"group");
            }
            if (((flag_changeturn = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.FLAG_CHANGE_TURN_STR)) == null || flag_changeturn.equals("")) && (changeturnFlag = (portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context)).getPortletConfig().getInitParameter("p3b-group")) != null) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.FLAG_CHANGE_TURN_STR, (String)changeturnFlag);
            }
            this.myGroupURI = ScheduleUtils.getPortletURIinPersonalConfigPane(rundata, "MyGroup");
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            this.hasAuthoritySelfInsert = aclhandler.hasAuthority(this.userid, "schedule_self", 4);
            this.hasAuthorityFacilityInsert = aclhandler.hasAuthority(this.userid, "schedule_facility", 4);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
    }

    protected SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipTScheduleMap.class);
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"eipTSchedule.endDate", (Object)this.getViewDate().getValue());
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getViewDate().getValue());
        cal.add(5, 1);
        ALDateTimeField field = new ALDateTimeField();
        field.setValue(cal.getTime());
        Expression exp12 = ExpressionFactory.lessExp((String)"eipTSchedule.startDate", (Object)field.getValue());
        Expression exp13 = ExpressionFactory.noMatchExp((String)"eipTSchedule.repeatPattern", (Object)"N");
        Expression exp14 = ExpressionFactory.noMatchExp((String)"eipTSchedule.repeatPattern", (Object)"S");
        query.setQualifier(exp11.andExp(exp12).orExp(exp13.andExp(exp14)));
        ArrayList<Ordering> orders = new ArrayList<Ordering>();
        orders.add(new Ordering("eipTSchedule.startDate", true));
        orders.add(new Ordering("eipTSchedule.endDate", true));
        query.addOrderings(orders);
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    protected SelectQuery buildSelectQueryForFilter(SelectQuery query, RunData rundata, Context context) {
        String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        String filter_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR);
        String crt_key = null;
        Attributes map = this.getColumnMap();
        if (filter == null || filter_type == null || filter.equals("") || this.tmpViewDate2 != null) {
            Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.andQualifier(exp1);
            this.members = new ArrayList();
            this.members.add(ALEipUtils.getALEipUser((RunData)rundata));
            ScheduleOnedayContainer con = new ScheduleOnedayContainer();
            con.initField();
            con.initHour(this.startHour, this.endHour);
            Integer uid = ALEipUtils.getUserId((RunData)rundata);
            this.termmap.put(uid, new ArrayList());
            this.map.put(uid, con);
            this.todomap.put(uid, new ArrayList());
            return query;
        }
        crt_key = map.getValue(filter_type);
        if (crt_key == null) {
            return query;
        }
        List ulist = ALEipUtils.getUserIds((String)filter);
        int size = ulist.size();
        if (size == 0) {
            ulist.add(-1);
        } else {
            for (int i = 0; i < size; ++i) {
                Integer id = (Integer)ulist.get(i);
                ScheduleOnedayContainer con = new ScheduleOnedayContainer();
                con.initField();
                con.initHour(this.startHour, this.endHour);
                this.termmap.put(id, new ArrayList());
                this.map.put(id, con);
                this.todomap.put(id, new ArrayList());
            }
        }
        List facilityIds = null;
        facilityIds = "Facility".equals(filter) ? this.getFacilityIdAllList() : FacilitiesUtils.getFacilityIds((String)filter);
        int f_size = facilityIds.size();
        if (f_size == 0) {
            facilityIds.add(-1);
        } else {
            for (int i = 0; i < f_size; ++i) {
                Integer id = (Integer)facilityIds.get(i);
                ScheduleOnedayContainer con = new ScheduleOnedayContainer();
                con.initField();
                con.initHour(this.startHour, this.endHour);
                this.facilitymap.put(id, con);
            }
        }
        if ("Facility".equals(filter)) {
            Expression exp21 = ExpressionFactory.matchExp((String)"type", (Object)"F");
            Expression exp22 = ExpressionFactory.inExp((String)crt_key, (Collection)facilityIds);
            query.andQualifier(exp21.andExp(exp22));
        } else {
            Expression exp11 = ExpressionFactory.matchExp((String)"type", (Object)"U");
            Expression exp12 = ExpressionFactory.inExp((String)crt_key, (Collection)ulist);
            Expression exp21 = ExpressionFactory.matchExp((String)"type", (Object)"F");
            Expression exp22 = ExpressionFactory.inExp((String)crt_key, (Collection)facilityIds);
            query.andQualifier(exp11.andExp(exp12).orExp(exp21.andExp(exp22)));
        }
        this.members = ALEipUtils.getUsers((String)filter);
        String flag_changeturn = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.FLAG_CHANGE_TURN_STR);
        if ("0".equals(flag_changeturn)) {
            ALEipUser eipUser = null;
            int memberSize = this.members.size();
            for (int i = 0; i < memberSize; ++i) {
                eipUser = (ALEipUser)this.members.get(i);
                if (eipUser.getUserId().getValue() != (long)this.userid) continue;
                this.members.remove(i);
                this.members.add(0, eipUser);
            }
        }
        this.facilityList = FacilitiesUtils.getFacilityList((String)filter);
        this.current_filter = filter;
        this.current_filter_type = filter_type;
        return query;
    }

    private List getFacilityIdAllList() {
        ArrayList<Integer> facilityIdAllList = new ArrayList<Integer>();
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipMFacility.class);
            query.addCustomDbAttribute("FACILITY_ID");
            List aList = dataContext.performQuery((Query)query);
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                DataRow dataRow = (DataRow)aList.get(i);
                facilityIdAllList.add((Integer)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"FACILITY_ID"));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return facilityIdAllList;
    }

    protected Object getResultData(Object obj) throws ALPageNotFoundException, ALDBErrorException {
        ScheduleOnedayResultData rd = new ScheduleOnedayResultData();
        rd.initField();
        try {
            boolean is_member;
            EipTScheduleMap record = (EipTScheduleMap)obj;
            EipTSchedule schedule = record.getEipTSchedule();
            if ("R".equals(record.getStatus())) {
                return rd;
            }
            if (!ScheduleUtils.isView(this.getViewDate(), schedule.getRepeatPattern(), schedule.getStartDate(), schedule.getEndDate())) {
                return rd;
            }
            SelectQuery mapquery = new SelectQuery(EipTScheduleMap.class);
            Expression mapexp1 = ExpressionFactory.matchExp((String)"scheduleId", (Object)schedule.getScheduleId());
            mapquery.setQualifier(mapexp1);
            Expression mapexp2 = ExpressionFactory.matchExp((String)"userId", (Object)this.userid);
            mapquery.andQualifier(mapexp2);
            List schedulemaps = this.dataContext.performQuery((Query)mapquery);
            boolean bl = is_member = schedulemaps != null && schedulemaps.size() > 0;
            if (!"D".equals(record.getStatus()) && "P".equals(schedule.getPublicFlag()) && this.userid != record.getUserId() && this.userid != schedule.getOwnerId() && !is_member) {
                return rd;
            }
            if ("C".equals(schedule.getPublicFlag()) && this.userid != record.getUserId() && this.userid != schedule.getOwnerId() && !is_member) {
                rd.setName("\u975e\u516c\u958b");
                rd.setTmpreserve(false);
            } else {
                rd.setName(schedule.getName());
                rd.setTmpreserve("T".equals(record.getStatus()));
            }
            rd.setScheduleId(schedule.getScheduleId());
            rd.setParentId(schedule.getParentId());
            rd.setStartDate(schedule.getStartDate());
            rd.setEndDate(schedule.getEndDate());
            rd.setPublic("O".equals(schedule.getPublicFlag()));
            rd.setHidden("P".equals(schedule.getPublicFlag()));
            rd.setDummy("D".equals(record.getStatus()));
            rd.setLoginuser(record.getUserId() == this.userid);
            rd.setOwner(schedule.getOwnerId() == this.userid);
            rd.setMember(is_member);
            rd.setPattern(schedule.getRepeatPattern());
            ScheduleOnedayContainer con = null;
            con = "U".equals(record.getType()) ? (ScheduleOnedayContainer)this.map.get(record.getUserId()) : (ScheduleOnedayContainer)this.facilitymap.get(record.getUserId());
            if (rd.getPattern().equals("S")) {
                this.is_hasspan = true;
                ArrayList terms = (ArrayList)this.termmap.get(record.getUserId());
                if (terms != null) {
                    terms.add(rd);
                }
                return rd;
            }
            if (!rd.getPattern().equals("N")) {
                if (!ScheduleUtils.isView(this.getViewDate(), rd.getPattern(), rd.getStartDate().getValue(), rd.getEndDate().getValue())) {
                    return rd;
                }
                rd.setRepeat(true);
            }
            con.addResultData(rd, this.startHour, this.endHour, this.getViewDate());
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return null;
        }
        return rd;
    }

    public boolean doViewList(ALAction action, RunData rundata, Context context) {
        boolean res = super.doViewList(action, rundata, context);
        this.postDoList();
        return res;
    }

    public boolean doSelectList(ALAction action, RunData rundata, Context context) {
        boolean res = super.doSelectList(action, rundata, context);
        this.postDoList();
        return res;
    }

    private void postDoList() {
        Collection col = this.map.values();
        for (ScheduleOnedayContainer con : col) {
            con.last(this.startHour, this.endHour, this.getViewDate());
            if (con.isDuplicate()) {
                this.is_duplicate = true;
            }
            int size = this.rows.length;
            int[] tmpRows = con.getRows();
            for (int i = 0; i < size; ++i) {
                if (tmpRows[i] <= this.rows[i]) continue;
                this.rows[i] = tmpRows[i];
            }
        }
        int size = this.rows.length;
        for (int i = 0; i < size; ++i) {
            this.max += this.rows[i];
        }
        Collection fcol = this.facilitymap.values();
        for (ScheduleOnedayContainer con : fcol) {
            con.last(this.startHour, this.endHour, this.getViewDate());
            if (!con.isDuplicate()) continue;
            this.is_duplicate = true;
        }
    }

    public void loadToDo(RunData rundata, Context context) {
        try {
            SelectQuery query = this.getSelectQueryForTodo(rundata, context);
            List todos = this.dataContext.performQuery((Query)query);
            int todossize = todos.size();
            for (int i = 0; i < todossize; ++i) {
                EipTTodo record = (EipTTodo)todos.get(i);
                ScheduleToDoResultData rd = new ScheduleToDoResultData();
                rd.initField();
                String todo_url = "";
                todo_url = this.userid == record.getTurbineUser().getUserId() ? ScheduleUtils.getPortletURItoTodoDetailPane(rundata, "ToDo", record.getTodoId().longValue(), this.portletId) : ScheduleUtils.getPortletURItoTodoPublicDetailPane(rundata, "ToDo", record.getTodoId().longValue(), this.portletId);
                rd.setTodoId(record.getTodoId().intValue());
                rd.setTodoName(record.getTodoName());
                rd.setUserId(record.getTurbineUser().getUserId().intValue());
                rd.setStartDate(record.getStartDate());
                rd.setEndDate(record.getEndDate());
                rd.setTodoUrl(todo_url);
                rd.setPublicFlag("T".equals(record.getPublicFlag()));
                ArrayList usertodos1 = (ArrayList)this.todomap.get(record.getTurbineUser().getUserId());
                if (usertodos1 == null) continue;
                usertodos1.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return;
        }
    }

    private SelectQuery getSelectQueryForTodo(RunData rundata, Context context) {
        Integer uid = this.userid;
        SelectQuery query = new SelectQuery(EipTTodo.class);
        Expression exp1 = ExpressionFactory.noMatchExp((String)"state", (Object)100);
        query.setQualifier(exp1);
        Expression exp01 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)uid);
        Expression exp02 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)uid);
        Expression exp03 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"T");
        Expression exp04 = ExpressionFactory.matchExp((String)"addonScheduleFlg", (Object)"T");
        query.andQualifier(exp01.orExp(exp02.andExp(exp03)).andExp(exp04));
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.getViewDate().getValue());
        Expression exp12 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.getViewDate().getValue());
        Expression exp21 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.getViewDate().getValue());
        Expression exp22 = ExpressionFactory.matchExp((String)"endDate", (Object)ToDoUtils.getEmptyDate());
        Expression exp31 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.getViewDate().getValue());
        Expression exp32 = ExpressionFactory.matchExp((String)"startDate", (Object)ToDoUtils.getEmptyDate());
        query.andQualifier(exp11.andExp(exp12).orExp(exp21.andExp(exp22)).orExp(exp31.andExp(exp32)));
        return query;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("group", "userId");
        return map;
    }

    public int getColspan(int hour) {
        return this.rows[(hour - this.startHour) * 4] + this.rows[(hour - this.startHour) * 4 + 1] + this.rows[(hour - this.startHour) * 4 + 2] + this.rows[(hour - this.startHour) * 4 + 3];
    }

    public int getScheduleColspan(ScheduleOnedayResultData rd, int[] rows_) {
        int st = rd.getStartRow();
        int ed = rd.getEndRow();
        int span = 0;
        if (st == ed) {
            span = rows_[st] == rd.getIndex() ? this.rows[st] - rows_[st] + 1 : 1;
        } else {
            for (int i = st; i < ed; ++i) {
                span += this.rows[i];
            }
            span += 1 - rows_[st];
        }
        return span;
    }

    public ScheduleOnedayResultData getSpanSchedule(long id) {
        Integer userid = (int)id;
        return ((ScheduleOnedayContainer)this.map.get(userid)).getSpanResultData();
    }

    public List getScheduleList(long id) {
        Integer userid = (int)id;
        return ((ScheduleOnedayContainer)this.map.get(userid)).getSchedule();
    }

    public int[] getRows(long id) {
        Integer userid = (int)id;
        return ((ScheduleOnedayContainer)this.map.get(userid)).getRows();
    }

    public List getDuplicateScheduleList(long id) {
        Integer userid = (int)id;
        return ((ScheduleOnedayContainer)this.map.get(userid)).getDuplicateSchedule();
    }

    public Map getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public List getMemberList() {
        return this.members;
    }

    public List getGroupList() {
        return this.groups;
    }

    public boolean isMatch(long id) {
        return this.userid == (int)id;
    }

    public int getMax() {
        return this.max - 1;
    }

    public boolean isHasspan() {
        return this.is_hasspan;
    }

    public String getMyGroupURI() {
        return this.myGroupURI;
    }

    public List getTermResultDataList(long id) {
        return (List)this.termmap.get((int)id);
    }

    public List getToDoResultDataList(long id) {
        return (List)this.todomap.get((int)id);
    }

    public void setPortletId(String id) {
        this.portletId = id;
    }

    public List getFacilityList() {
        return this.facilityList;
    }

    public List getFacilityScheduleList(long id) {
        Integer fid = (int)id;
        return ((ScheduleOnedayContainer)this.facilitymap.get(fid)).getSchedule();
    }

    public int[] getFacilityRows(long id) {
        Integer fid = (int)id;
        return ((ScheduleOnedayContainer)this.facilitymap.get(fid)).getRows();
    }

    public List getFacilityDuplicateScheduleList(long id) {
        Integer fid = (int)id;
        return ((ScheduleOnedayContainer)this.facilitymap.get(fid)).getDuplicateSchedule();
    }

    public String getAclPortletFeature() {
        return "schedule_other";
    }

    public boolean hasAuthoritySelfInsert() {
        return this.hasAuthoritySelfInsert;
    }

    public boolean hasAuthorityFacilityInsert() {
        return this.hasAuthorityFacilityInsert;
    }
}

