/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.schedule.ScheduleOnedayResultData;
import com.aimluck.eip.schedule.ScheduleResultData;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class ScheduleOnedayContainer
implements ALData {
    private List list;
    private List dList;
    private ScheduleOnedayResultData rd;
    private int[] rows;
    private int count;
    private int rowIndex;

    public void initField() {
        this.list = new ArrayList();
        this.dList = new ArrayList();
    }

    public void initHour(int startHour, int endHour) {
        this.rows = new int[(endHour - startHour) * 4 + 1];
        int size = this.rows.length;
        for (int i = 0; i < size; ++i) {
            this.rows[i] = 1;
        }
    }

    public void addResultData(ScheduleOnedayResultData rd, int startHour, int endHour, ALDateTimeField viewDate) {
        ScheduleOnedayResultData rd2 = new ScheduleOnedayResultData();
        rd2.setFormat("yyyy-MM-dd-HH-mm");
        rd2.initField();
        boolean dup = false;
        int sta = startHour * 4;
        int eta = endHour * 4;
        int st = Integer.parseInt(rd.getStartDate().getHour()) * 4 + Integer.parseInt(rd.getStartDate().getMinute()) / 15;
        int ed = Integer.parseInt(rd.getEndDate().getHour()) * 4 + Integer.parseInt(rd.getEndDate().getMinute()) / 15;
        if (!rd.getStartDate().getDay().equals(rd.getEndDate().getDay()) && rd.getEndDate().getHour().equals("0")) {
            ed = 96;
        }
        if (ed - sta > 0 && eta - st > 0 || ed - sta == 0 && st == ed) {
            if (sta > st) {
                st = sta;
            }
            if (eta < ed) {
                ed = eta;
            }
            int tmpRowIndex = this.rowIndex;
            rd.setStartRow(st - sta);
            rd.setEndRow(ed - sta);
            if (ed - st == 0 && st - sta + tmpRowIndex - this.count >= 0) {
                rd.setIndex(this.rows[st - sta]);
                if (this.rows[st - sta] > 1) {
                    rd.setDuplicate(true);
                    ((ScheduleResultData)this.list.get(this.list.size() - 1)).setDuplicate(true);
                }
                int n = st - sta;
                this.rows[n] = this.rows[n] + 1;
                ++this.rowIndex;
                ++ed;
            }
            if (st - (sta -= tmpRowIndex) - this.count > 0) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(viewDate.getValue());
                cal.add(10, startHour);
                int hour = (this.count - tmpRowIndex) / 4;
                int min = (this.count - tmpRowIndex) % 4 * 15;
                cal.add(10, hour);
                cal.add(12, min);
                rd2.setStartDate(cal.getTime());
                hour = (st - sta - this.count) / 4;
                min = (st - sta - this.count) % 4 * 15;
                cal.add(10, hour);
                cal.add(12, min);
                rd2.setEndDate(cal.getTime());
                rd2.setStartRow(this.list.size() == 0 ? 0 : ((ScheduleOnedayResultData)this.list.get(this.list.size() - 1)).getEndRow());
                rd2.setEndRow(rd.getStartRow());
                this.list.add(rd2);
            } else if (st - sta - this.count != 0) {
                this.dList.add(rd);
                rd.setDuplicate(true);
                dup = true;
                ((ScheduleResultData)this.list.get(this.list.size() - 1)).setDuplicate(true);
            }
            if (!dup) {
                this.list.add(rd);
                this.count = ed - sta;
            }
        }
    }

    public void last(int startHour, int endHour, ALDateTimeField viewDate) {
        int index = (endHour - startHour) * 4 + this.rowIndex;
        if (index > this.count) {
            ScheduleOnedayResultData rd = new ScheduleOnedayResultData();
            rd.setFormat("yyyy-MM-dd-HH-mm");
            rd.initField();
            rd.setRowspan(index - this.count);
            Calendar cal = Calendar.getInstance();
            cal.setTime(viewDate.getValue());
            cal.add(10, startHour);
            int hour = (this.count - this.rowIndex) / 4;
            int min = (this.count - this.rowIndex) % 4 * 15;
            cal.add(10, hour);
            cal.add(12, min);
            rd.setStartDate(cal.getTime());
            hour = (index - this.count) / 4;
            min = (index - this.count) % 4 * 15;
            cal.add(10, hour);
            cal.add(12, min);
            rd.setEndDate(cal.getTime());
            rd.setStartRow(this.list.size() == 0 ? 0 : ((ScheduleOnedayResultData)this.list.get(this.list.size() - 1)).getEndRow());
            rd.setEndRow(this.rows.length - 1);
            this.list.add(rd);
        }
    }

    public void setSpanResultData(ScheduleOnedayResultData rd) {
        this.rd = rd;
    }

    public int[] getRows() {
        return this.rows;
    }

    public ScheduleOnedayResultData getSpanResultData() {
        return this.rd;
    }

    public List getSchedule() {
        return this.list;
    }

    public List getDuplicateSchedule() {
        return this.dList;
    }

    public boolean isDuplicate() {
        return this.dList.size() != 0;
    }
}

