/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALDateContainer;
import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALIllegalDateException;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.category.util.CommonCategoryUtils;
import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipTCommonCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.facilities.FacilityResultData;
import com.aimluck.eip.facilities.util.FacilitiesUtils;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.schedule.ScheduleOnedayGroupSelectData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whatsnew.util.WhatsNewUtils;
import java.security.Principal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.om.security.UserIdPrincipal;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ScheduleFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ScheduleFormData.class.getName());
    private static final int FLAG_EDIT_REPEAT_DEF = -1;
    private static final int FLAG_EDIT_REPEAT_ALL = 0;
    private static final int FLAG_EDIT_REPEAT_ONE = 1;
    public static final int FLAG_DEL_MEMBER_ALL = 0;
    public static final int FLAG_DEL_MEMBER_ONE = 1;
    public static final int FLAG_DEL_RANGE_ALL = 0;
    public static final int FLAG_DEL_RANGE_ONE = 1;
    private ALDateTimeField start_date;
    private ALDateTimeField end_date;
    private ALStringField name;
    private ALStringField place;
    private ALStringField note;
    private ALStringField public_flag;
    private ALStringField repeat_type;
    private ALStringField week_0;
    private ALStringField week_1;
    private ALStringField week_2;
    private ALStringField week_3;
    private ALStringField week_4;
    private ALStringField week_5;
    private ALStringField week_6;
    private ALStringField limit_flag;
    private ALDateField limit_start_date;
    private ALDateField limit_end_date;
    private ALNumberField month_day;
    private ArrayList memberList;
    private int currentYear;
    private boolean is_member;
    private boolean is_repeat;
    private boolean is_span;
    private ALEipUser login_user;
    private String tmpStart;
    private String tmpEnd;
    private ScheduleOnedayGroupSelectData selectData;
    private String tmpScheduleId;
    private List groups;
    private ALNumberField edit_repeat_flag;
    private String tmpView;
    private ALDateTimeField view_date;
    private ALStringField edit_flag;
    private ALStringField change_tmpreserve_flag;
    private ALNumberField del_member_flag;
    private ALNumberField del_range_flag;
    private boolean is_owner;
    private boolean is_facility;
    private ArrayList facilityList;
    private ArrayList facilityAllList;
    private ALNumberField common_category_id;
    private DataContext dataContext;
    private int msg_type = 0;
    private String org_id;
    private ALEipUser loginUser;
    private String date_detail;
    private String db_scheduleid;
    private int facilityCheck;
    private String aclPortletFeature = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        this.is_facility = rundata.getParameters().getBoolean("is_facility");
        this.is_member = rundata.getParameters().getBoolean("is_member");
        this.is_repeat = rundata.getParameters().getBoolean("is_repeat");
        this.is_span = rundata.getParameters().getBoolean("is_span");
        this.login_user = ALEipUtils.getALEipUser((RunData)rundata);
        this.groups = ALEipUtils.getMyGroups((RunData)rundata);
        this.is_owner = true;
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        this.org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
        this.loginUser = ALEipUtils.getALEipUser((RunData)rundata);
        this.date_detail = "";
        this.facilityAllList = new ArrayList();
        this.facilityAllList.addAll(FacilitiesUtils.getFacilityAllList());
        this.db_scheduleid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        this.facilityCheck = 0;
        String scheduleId = rundata.getParameters().getString("entityid");
        if (scheduleId == null || scheduleId.equals("new")) {
            String[] str = rundata.getParameters().getStrings("member_to");
            if (str != null && str.length > 0) {
                this.aclPortletFeature = "schedule_other";
                String user_name = this.login_user.getName().toString();
                for (int i = 0; i < str.length; ++i) {
                    if (!user_name.equals(str[i])) continue;
                    this.aclPortletFeature = "schedule_self";
                    break;
                }
            } else {
                this.aclPortletFeature = "schedule_self";
            }
        } else {
            this.aclPortletFeature = ScheduleUtils.hasRelation(rundata) ? "schedule_self" : "schedule_other";
        }
        super.init(action, rundata, context);
    }

    public void loadParametersViewDate(RunData rundata, Context context) {
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            if (rundata.getParameters().containsKey((Object)"view_date")) {
                ALDateTimeField dummy = new ALDateTimeField("yyyy-MM-dd");
                this.tmpView = rundata.getParameters().getString("view_date");
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpView", (String)this.tmpView);
                dummy.setValue(this.tmpView);
                if (!dummy.validate(new ArrayList())) {
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"tmpView");
                    logger.debug((Object)"[ScheduleFormData] Parameter cannot validate");
                    ALEipUtils.redirectPageNotFound((RunData)rundata);
                    return;
                }
            } else if ((this.tmpView == null || this.tmpView.equals("")) && this.tmpStart != null && !this.tmpStart.equals("")) {
                this.tmpView = this.tmpStart;
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpView", (String)this.tmpView);
            }
        }
    }

    public void loadParameters(RunData rundata, Context context) {
        ALDateTimeField dummy = new ALDateTimeField("yyyy-MM-dd-HH-mm");
        dummy.setNotNull(true);
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            if (rundata.getParameters().containsKey((Object)"form_start")) {
                this.tmpStart = rundata.getParameters().getString("form_start");
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpStart", (String)this.tmpStart);
                dummy.setValue(this.tmpStart);
                if (!dummy.validate(new ArrayList())) {
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"form_start");
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"form_end");
                    logger.debug((Object)"[ScheduleFormData] Parameter cannot validate");
                    ALEipUtils.redirectPageNotFound((RunData)rundata);
                    return;
                }
            } else {
                dummy.setValue(new Date());
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpStart", (String)dummy.toString());
            }
            if (rundata.getParameters().containsKey((Object)"form_end")) {
                this.tmpEnd = rundata.getParameters().getString("form_end");
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpEnd", (String)this.tmpEnd);
                dummy.setValue(this.tmpEnd);
                if (!dummy.validate(new ArrayList())) {
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"form_start");
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"form_end");
                    logger.debug((Object)"[ScheduleFormData] Parameter cannot validate");
                    ALEipUtils.redirectPageNotFound((RunData)rundata);
                    return;
                }
            } else {
                dummy.setValue(new Date());
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpEnd", (String)dummy.toString());
            }
        }
        this.tmpStart = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tmpStart");
        this.tmpEnd = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tmpEnd");
        this.loadParametersViewDate(rundata, context);
    }

    public void initField() {
        Date now = new Date();
        Calendar cal = Calendar.getInstance();
        int min = cal.get(12);
        if (min <= 5) {
            cal.set(12, 5);
        } else if (min <= 10) {
            cal.set(12, 10);
        } else if (min <= 15) {
            cal.set(12, 15);
        } else if (min <= 20) {
            cal.set(12, 20);
        } else if (min <= 25) {
            cal.set(12, 25);
        } else if (min <= 30) {
            cal.set(12, 30);
        } else if (min <= 35) {
            cal.set(12, 35);
        } else if (min <= 40) {
            cal.set(12, 40);
        } else if (min <= 45) {
            cal.set(12, 45);
        } else if (min <= 50) {
            cal.set(12, 50);
        } else if (min <= 55) {
            cal.set(12, 55);
        } else {
            cal.set(12, 60);
        }
        this.start_date = new ALDateTimeField("yyyy-MM-dd-HH-mm");
        if (this.tmpStart == null || this.tmpStart.equals("")) {
            this.start_date.setValue(now);
        } else {
            this.start_date.setValue(this.tmpStart);
        }
        this.start_date.setFieldName("\u958b\u59cb\u65e5\u6642");
        this.end_date = new ALDateTimeField("yyyy-MM-dd-HH-mm");
        if (this.tmpEnd == null || this.tmpEnd.equals("")) {
            if (this.tmpStart == null || this.tmpStart.equals("")) {
                this.end_date.setValue(now);
            } else {
                this.end_date.setValue(this.tmpStart);
            }
        } else {
            this.end_date.setValue(this.tmpEnd);
        }
        this.end_date.setFieldName("\u7d42\u4e86\u65e5\u6642");
        this.repeat_type = new ALStringField();
        this.repeat_type.setFieldName("\u7e70\u308a\u8fd4\u3057\u30bf\u30a4\u30d7");
        this.repeat_type.setValue("D");
        this.repeat_type.setTrim(true);
        this.week_0 = new ALStringField();
        this.week_0.setFieldName("\u65e5");
        this.week_0.setTrim(true);
        this.week_1 = new ALStringField();
        this.week_1.setFieldName("\u6708");
        this.week_1.setTrim(true);
        this.week_2 = new ALStringField();
        this.week_2.setFieldName("\u706b");
        this.week_2.setTrim(true);
        this.week_3 = new ALStringField();
        this.week_3.setFieldName("\u6c34");
        this.week_3.setTrim(true);
        this.week_4 = new ALStringField();
        this.week_4.setFieldName("\u6728");
        this.week_4.setTrim(true);
        this.week_5 = new ALStringField();
        this.week_5.setFieldName("\u91d1");
        this.week_5.setTrim(true);
        this.week_6 = new ALStringField();
        this.week_6.setFieldName("\u571f");
        this.week_6.setTrim(true);
        this.month_day = new ALNumberField();
        this.month_day.setFieldName("\u7e70\u308a\u8fd4\u3059\u6708");
        this.limit_flag = new ALStringField();
        this.limit_flag.setFieldName("\u7e70\u308a\u8fd4\u3057");
        this.limit_flag.setValue("OFF");
        this.limit_flag.setTrim(true);
        this.limit_start_date = new ALDateField();
        this.limit_start_date.setFieldName("\u7e70\u308a\u8fd4\u3057\u671f\u9650");
        this.limit_start_date.setValue(this.start_date.getValue());
        this.limit_end_date = new ALDateField();
        this.limit_end_date.setFieldName("\u7e70\u308a\u8fd4\u3057\u671f\u9650");
        ALDateTimeField tmp_date = new ALDateTimeField("yyyy-MM-dd-HH-mm");
        if (this.tmpEnd == null || this.tmpEnd.equals("")) {
            if (this.tmpStart == null || this.tmpStart.equals("")) {
                tmp_date.setValue(now);
                this.limit_end_date.setValue(tmp_date.getValue());
            } else {
                tmp_date.setValue(this.tmpStart);
                this.limit_end_date.setValue(tmp_date.getValue());
            }
        } else {
            tmp_date.setValue(this.tmpEnd);
            this.limit_end_date.setValue(tmp_date.getValue());
        }
        this.name = new ALStringField();
        this.name.setFieldName("\u4e88\u5b9a");
        this.name.setTrim(true);
        this.place = new ALStringField();
        this.place.setFieldName("\u5834\u6240");
        this.place.setTrim(true);
        this.note = new ALStringField();
        this.note.setFieldName("\u5185\u5bb9");
        this.note.setTrim(false);
        this.public_flag = new ALStringField();
        this.public_flag.setFieldName("\u516c\u958b\u533a\u5206");
        this.public_flag.setTrim(true);
        this.public_flag.setValue("O");
        this.edit_repeat_flag = new ALNumberField();
        this.edit_repeat_flag.setFieldName("\u7e70\u308a\u8fd4\u3057\u7de8\u96c6\u7bc4\u56f2");
        this.edit_repeat_flag.setValue(-1L);
        this.view_date = new ALDateTimeField("yyyy-MM-dd");
        if (this.tmpView == null || this.tmpView.equals("")) {
            this.view_date.setValue(now);
        } else {
            this.view_date.setValue(this.tmpView);
        }
        this.view_date.setFieldName("\u6307\u5b9a\u65e5\u6642");
        this.edit_flag = new ALStringField();
        this.edit_flag.setFieldName("\u7de8\u96c6\uff0f\u524a\u9664\u6a29\u9650");
        this.edit_flag.setTrim(true);
        this.edit_flag.setValue("T");
        this.change_tmpreserve_flag = new ALStringField();
        this.change_tmpreserve_flag.setFieldName("\u4eee\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb");
        this.change_tmpreserve_flag.setTrim(true);
        this.change_tmpreserve_flag.setValue("F");
        this.memberList = new ArrayList();
        this.currentYear = Calendar.getInstance().get(1);
        this.del_member_flag = new ALNumberField();
        this.del_member_flag.setValue(0L);
        this.del_range_flag = new ALNumberField();
        this.del_range_flag.setValue(0L);
        this.facilityList = new ArrayList();
        this.common_category_id = new ALNumberField();
        this.common_category_id.setFieldName("\u30ab\u30c6\u30b4\u30ea");
        this.common_category_id.setValue(1L);
    }

    protected boolean setFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res) {
            try {
                Object[] f_id;
                this.tmpScheduleId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
                Object[] str = rundata.getParameters().getStrings("member_to");
                if (str != null && str.length > 0) {
                    SelectQuery query = new SelectQuery(TurbineUser.class);
                    Expression exp = ExpressionFactory.inExp((String)"loginName", (Object[])str);
                    query.setQualifier(exp);
                    this.memberList.addAll(ALEipUtils.getUsersFromSelectQuery((SelectQuery)query));
                }
                if (this.memberList.size() == 0) {
                    this.memberList.add(this.login_user);
                }
                if (!ScheduleUtils.isZeroLength((String[])(f_id = rundata.getParameters().getStrings("facility_to")))) {
                    SelectQuery fquery = new SelectQuery(EipMFacility.class);
                    Expression fexp = ExpressionFactory.inDbExp((String)"FACILITY_ID", (Object[])f_id);
                    fquery.setQualifier(fexp);
                    List f_list = this.dataContext.performQuery((Query)fquery);
                    int f_size = f_list.size();
                    for (int i = 0; i < f_size; ++i) {
                        EipMFacility f_record = (EipMFacility)f_list.get(i);
                        FacilityResultData rd = new FacilityResultData();
                        rd.initField();
                        rd.setFacilityId(f_record.getFacilityId().longValue());
                        rd.setFacilityName(f_record.getFacilityName());
                        this.facilityList.add(rd);
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Exception", (Throwable)ex);
            }
        }
        return res;
    }

    protected void setValidator() {
        this.name.setNotNull(true);
        this.name.limitMaxLength(50);
        this.place.limitMaxLength(50);
        this.note.limitMaxLength(1000);
    }

    protected boolean validate(ArrayList msgList) throws ALDBErrorException, ALPageNotFoundException {
        this.start_date.validate(msgList);
        this.end_date.validate(msgList);
        if (this.end_date.getValue().before(this.start_date.getValue())) {
            msgList.add("\u300e <span class='em'>\u7d42\u4e86\u65e5\u6642</span> \u300f\u306f\u300e <span class='em'>\u958b\u59cb\u65e5\u6642</span> \u300f\u4ee5\u964d\u306e\u65e5\u4ed8\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (this.is_repeat) {
            try {
                if ("W".equals(this.repeat_type.getValue())) {
                    long deltaDay;
                    if (this.week_0.getValue() == null && this.week_1.getValue() == null && this.week_2.getValue() == null && this.week_3.getValue() == null && this.week_4.getValue() == null && this.week_5.getValue() == null && this.week_6.getValue() == null) {
                        msgList.add("\u300e <span class='em'>\u6bce\u9031</span> \u300f\u306f\u66dc\u65e5\u3092\u3072\u3068\u3064\u4ee5\u4e0a\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    } else if ("ON".equals(this.limit_flag.toString()) && (deltaDay = (this.limit_end_date.getValue().getDate().getTime() - this.limit_start_date.getValue().getDate().getTime()) / 86400000L) < 6L) {
                        Calendar limitStartCal = Calendar.getInstance();
                        limitStartCal.setTime(this.limit_start_date.getValue().getDate());
                        Calendar limitEndCal = Calendar.getInstance();
                        limitEndCal.setTime(this.limit_end_date.getValue().getDate());
                        int limitStartDayOfWeek = limitStartCal.get(7);
                        int limitEndDayOfWeek = limitEndCal.get(7);
                        boolean hasWeek = true;
                        if (this.week_0.getValue() != null) {
                            hasWeek &= this.includeWeek(1, limitStartDayOfWeek, limitEndDayOfWeek);
                        }
                        if (this.week_1.getValue() != null) {
                            hasWeek &= this.includeWeek(2, limitStartDayOfWeek, limitEndDayOfWeek);
                        }
                        if (this.week_2.getValue() != null) {
                            hasWeek &= this.includeWeek(3, limitStartDayOfWeek, limitEndDayOfWeek);
                        }
                        if (this.week_3.getValue() != null) {
                            hasWeek &= this.includeWeek(4, limitStartDayOfWeek, limitEndDayOfWeek);
                        }
                        if (this.week_4.getValue() != null) {
                            hasWeek &= this.includeWeek(5, limitStartDayOfWeek, limitEndDayOfWeek);
                        }
                        if (this.week_5.getValue() != null) {
                            hasWeek &= this.includeWeek(6, limitStartDayOfWeek, limitEndDayOfWeek);
                        }
                        if (this.week_6.getValue() != null) {
                            hasWeek &= this.includeWeek(7, limitStartDayOfWeek, limitEndDayOfWeek);
                        }
                        if (!hasWeek) {
                            msgList.add("\u300e <span class='em'>\u6bce\u9031</span> \u300f\u3067\u9078\u629e\u3059\u308b\u66dc\u65e5\u306f\u3001\u300e <span class='em'>\u671f\u9650</span> \u300f\u306e\u7bc4\u56f2\u5185\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                        }
                    }
                } else if ("M".equals(this.repeat_type.getValue()) && "ON".equals(this.limit_flag.toString())) {
                    Calendar limitStartCal = Calendar.getInstance();
                    limitStartCal.setTime(this.limit_start_date.getValue().getDate());
                    Calendar limitEndCal = Calendar.getInstance();
                    limitEndCal.setTime(this.limit_end_date.getValue().getDate());
                    int limitStartMonth = limitStartCal.get(2);
                    int limitEndMonth = limitEndCal.get(2);
                    if (limitStartMonth >= limitEndMonth) {
                        if ((long)this.limit_start_date.getValue().getDay() > this.month_day.getValue() || (long)this.limit_end_date.getValue().getDay() < this.month_day.getValue()) {
                            msgList.add("\u300e <span class='em'>\u6bce\u6708</span> \u300f\u306f\u300e <span class='em'>\u671f\u9650</span> \u300f\u306e\u7bc4\u56f2\u5185\u306e\u65e5\u4ed8\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                        }
                    } else if ((long)this.limit_start_date.getValue().getDay() > this.month_day.getValue() && (long)this.limit_end_date.getValue().getDay() < this.month_day.getValue()) {
                        msgList.add("\u300e <span class='em'>\u6bce\u6708</span> \u300f\u306f\u300e <span class='em'>\u671f\u9650</span> \u300f\u306e\u7bc4\u56f2\u5185\u306e\u65e5\u4ed8\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    }
                }
                if (!ScheduleUtils.equalsToDate(this.limit_start_date.getValue().getDate(), this.limit_end_date.getValue().getDate(), false) && this.limit_start_date.getValue().getDate().after(this.limit_end_date.getValue().getDate())) {
                    msgList.add("\u300e <span class='em'>\u671f\u9650</span> \u300f\u306f\u4eca\u65e5\u4ee5\u964d\u306e\u65e5\u4ed8\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                }
            }
            catch (NumberFormatException nfe) {
                logger.error((Object)"[ScheduleFormData] NumberFormatException: Limit Date is wrong.");
                throw new ALPageNotFoundException();
            }
            catch (ALIllegalDateException ad) {
                logger.error((Object)"[ScheduleFormData] ALIllegalDateException: Limit Date is wrong.");
                throw new ALPageNotFoundException();
            }
        }
        this.name.validate(msgList);
        this.place.validate(msgList);
        this.note.validate(msgList);
        this.common_category_id.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTSchedule record = ScheduleUtils.getEipTSchedule(rundata, context, false);
            if (record == null) {
                return false;
            }
            this.is_owner = (long)record.getOwnerId().intValue() == this.login_user.getUserId().getValue();
            this.name.setValue(record.getName());
            this.place.setValue(record.getPlace());
            this.note.setValue(record.getNote());
            this.public_flag.setValue(record.getPublicFlag());
            if ("T".equals(record.getEditFlag())) {
                if (this.is_owner) {
                    this.edit_flag.setValue(record.getEditFlag());
                } else {
                    int createUserId = record.getOwnerId();
                    boolean inculudeCreateUser = false;
                    List scheduleMaps = record.getEipTScheduleMaps();
                    for (int i = 0; i < scheduleMaps.size(); ++i) {
                        EipTScheduleMap map = (EipTScheduleMap)scheduleMaps.get(i);
                        if (createUserId != map.getUserId() || "R".equals(map.getStatus())) continue;
                        inculudeCreateUser = true;
                        break;
                    }
                    if (inculudeCreateUser) {
                        this.edit_flag.setValue("F");
                    } else {
                        this.edit_flag.setValue("T");
                    }
                }
            } else {
                this.edit_flag.setValue("F");
            }
            String ptn = record.getRepeatPattern();
            int count = 0;
            this.is_repeat = true;
            this.is_span = false;
            if (ptn.charAt(0) == 'D') {
                this.repeat_type.setValue("D");
                count = 1;
            } else if (ptn.charAt(0) == 'W') {
                this.repeat_type.setValue("W");
                this.week_0.setValue(ptn.charAt(1) != '0' ? "TRUE" : null);
                this.week_1.setValue(ptn.charAt(2) != '0' ? "TRUE" : null);
                this.week_2.setValue(ptn.charAt(3) != '0' ? "TRUE" : null);
                this.week_3.setValue(ptn.charAt(4) != '0' ? "TRUE" : null);
                this.week_4.setValue(ptn.charAt(5) != '0' ? "TRUE" : null);
                this.week_5.setValue(ptn.charAt(6) != '0' ? "TRUE" : null);
                this.week_6.setValue(ptn.charAt(7) != '0' ? "TRUE" : null);
                count = 8;
            } else if (ptn.charAt(0) == 'M') {
                this.repeat_type.setValue("M");
                this.month_day.setValue((long)Integer.parseInt(ptn.substring(1, 3)));
                count = 3;
            } else if (ptn.charAt(0) == 'S') {
                this.is_span = true;
                this.is_repeat = false;
            } else {
                this.is_repeat = false;
            }
            if (this.is_repeat) {
                Calendar tmpViewCal = Calendar.getInstance();
                tmpViewCal.setTime(this.view_date.getValue());
                Calendar tmpStartCal = Calendar.getInstance();
                tmpStartCal.setTime(record.getStartDate());
                tmpViewCal.set(11, tmpStartCal.get(11));
                tmpViewCal.set(12, tmpStartCal.get(12));
                this.start_date.setValue(tmpViewCal.getTime());
                Calendar tmpStopCal = Calendar.getInstance();
                tmpStopCal.setTime(record.getEndDate());
                tmpViewCal.set(11, tmpStopCal.get(11));
                tmpViewCal.set(12, tmpStopCal.get(12));
                this.end_date.setValue(tmpViewCal.getTime());
                if (ptn.charAt(count) == 'N') {
                    this.limit_start_date.setValue(this.view_date.getValue());
                    this.limit_end_date.setValue(this.view_date.getValue());
                    this.limit_flag.setValue("OFF");
                } else {
                    this.limit_flag.setValue("ON");
                    this.limit_start_date.setValue(record.getStartDate());
                    this.limit_end_date.setValue(record.getEndDate());
                }
                this.edit_repeat_flag.setValue(0L);
            }
            if (this.is_span) {
                this.start_date.setValue(record.getStartDate());
                this.end_date.setValue(record.getEndDate());
                this.limit_start_date.setValue(record.getStartDate());
                this.limit_end_date.setValue(record.getEndDate());
            }
            if (!this.is_repeat && !this.is_span) {
                this.start_date.setValue(record.getStartDate());
                this.end_date.setValue(record.getEndDate());
                this.limit_start_date.setValue(record.getStartDate());
                this.limit_end_date.setValue(record.getEndDate());
            }
            SelectQuery mapquery = new SelectQuery(EipTScheduleMap.class);
            Expression mapexp = ExpressionFactory.matchExp((String)"scheduleId", (Object)record.getScheduleId());
            mapquery.setQualifier(mapexp);
            List list = this.dataContext.performQuery((Query)mapquery);
            ArrayList<Integer> users = new ArrayList<Integer>();
            ArrayList<Integer> facilityIds = new ArrayList<Integer>();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                EipTScheduleMap map = (EipTScheduleMap)list.get(i);
                if ("U".equals(map.getType())) {
                    users.add(map.getUserId());
                    if (ALEipUtils.getALEipUser((RunData)rundata).getUserId().getValue() != map.getUserId().longValue()) continue;
                    EipTCommonCategory category = map.getEipTCommonCategory();
                    if (category == null) {
                        this.common_category_id.setValue(1L);
                        continue;
                    }
                    this.common_category_id.setValue(category.getCommonCategoryId().longValue());
                    continue;
                }
                this.common_category_id.setValue(1L);
                facilityIds.add(map.getUserId());
            }
            if (users.size() > 0) {
                SelectQuery query = new SelectQuery(TurbineUser.class);
                Expression exp = ExpressionFactory.inDbExp((String)"USER_ID", users);
                query.setQualifier(exp);
                this.memberList.addAll(ALEipUtils.getUsersFromSelectQuery((SelectQuery)query));
            } else {
                this.memberList.add(this.login_user);
            }
            if (facilityIds.size() > 0) {
                SelectQuery fquery = new SelectQuery(EipMFacility.class);
                Expression fexp = ExpressionFactory.inDbExp((String)"FACILITY_ID", facilityIds);
                fquery.setQualifier(fexp);
                this.facilityList.addAll(FacilitiesUtils.getFacilitiesFromSelectQuery((SelectQuery)fquery));
            }
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) throws ALDBErrorException {
        try {
            EipTScheduleMap map;
            int i;
            int f_size = this.facilityList.size();
            if (!this.facilityCheckAclPermission(f_size, msgList, rundata, 4)) {
                return false;
            }
            if (this.is_span) {
                Date startdate = this.start_date.getValue();
                startdate.setHours(0);
                startdate.setMinutes(0);
                this.start_date.setValue(startdate);
                Date enddate = this.end_date.getValue();
                enddate.setHours(0);
                enddate.setMinutes(0);
                this.end_date.setValue(enddate);
            } else {
                GregorianCalendar startcal = new GregorianCalendar();
                startcal.setTime(this.start_date.getValue());
                Calendar endcal = Calendar.getInstance();
                endcal.setTime(this.end_date.getValue());
                endcal.set(1, startcal.get(1));
                endcal.set(2, startcal.get(2));
                endcal.set(5, startcal.get(5));
                this.end_date.setValue(endcal.getTime());
            }
            int ownerid = ALEipUtils.getUserId((RunData)rundata);
            EipTSchedule schedule = (EipTSchedule)this.dataContext.createAndRegisterNewObject(EipTSchedule.class);
            schedule.setParentId(Integer.valueOf(0));
            schedule.setName(this.name.getValue());
            schedule.setPlace(this.place.getValue());
            schedule.setNote(this.note.getValue());
            schedule.setPublicFlag(this.public_flag.getValue());
            if (this.memberList.size() >= 1) {
                schedule.setEditFlag(this.edit_flag.getValue());
            } else {
                schedule.setEditFlag("F");
            }
            schedule.setOwnerId(Integer.valueOf(ownerid));
            Date now = new Date();
            schedule.setCreateDate(now);
            schedule.setCreateUserId(Integer.valueOf(ownerid));
            schedule.setUpdateDate(now);
            schedule.setUpdateUserId(Integer.valueOf(ownerid));
            if (this.is_span) {
                schedule.setEndDate(this.end_date.getValue());
                schedule.setRepeatPattern("S");
                schedule.setStartDate(this.start_date.getValue());
            } else if (!this.is_repeat) {
                schedule.setEndDate(this.end_date.getValue());
                schedule.setRepeatPattern("N");
                schedule.setStartDate(this.start_date.getValue());
            } else {
                char lim = 'N';
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.end_date.getValue());
                if ("ON".equals(this.limit_flag.getValue())) {
                    lim = 'L';
                    cal.set(this.limit_end_date.getValue().getYear(), this.limit_end_date.getValue().getMonth() - 1, this.limit_end_date.getValue().getDay());
                    ALDateContainer container = this.limit_start_date.getValue();
                    Calendar limitStartCal = Calendar.getInstance();
                    limitStartCal.setTime(this.start_date.getValue());
                    limitStartCal.set(1, container.getYear());
                    limitStartCal.set(2, container.getMonth() - 1);
                    limitStartCal.set(5, container.getDay());
                    schedule.setStartDate(limitStartCal.getTime());
                } else {
                    schedule.setStartDate(this.start_date.getValue());
                }
                schedule.setEndDate(cal.getTime());
                if ("D".equals(this.repeat_type.getValue())) {
                    schedule.setRepeatPattern(new StringBuffer().append('D').append(lim).toString());
                } else if ("W".equals(this.repeat_type.getValue())) {
                    schedule.setRepeatPattern(new StringBuffer().append('W').append(this.week_0.getValue() != null ? 1 : 0).append(this.week_1.getValue() != null ? 1 : 0).append(this.week_2.getValue() != null ? 1 : 0).append(this.week_3.getValue() != null ? 1 : 0).append(this.week_4.getValue() != null ? 1 : 0).append(this.week_5.getValue() != null ? 1 : 0).append(this.week_6.getValue() != null ? 1 : 0).append(lim).toString());
                } else {
                    DecimalFormat format = new DecimalFormat("00");
                    schedule.setRepeatPattern(new StringBuffer().append('M').append(format.format(this.month_day.getValue())).append(lim).toString());
                }
            }
            EipTCommonCategory category1 = CommonCategoryUtils.getEipTCommonCategory((DataContext)this.dataContext, (Long)1L);
            int size = this.memberList.size();
            for (i = 0; i < size; ++i) {
                map = (EipTScheduleMap)this.dataContext.createAndRegisterNewObject(EipTScheduleMap.class);
                ALEipUser user = (ALEipUser)this.memberList.get(i);
                int userid = (int)user.getUserId().getValue();
                map.setEipTSchedule(schedule);
                map.setUserId(Integer.valueOf(userid));
                if (userid == ALEipUtils.getUserId((RunData)rundata)) {
                    map.setStatus("O");
                } else {
                    map.setStatus("T");
                }
                EipTCommonCategory category = CommonCategoryUtils.getEipTCommonCategory((DataContext)this.dataContext, (Long)this.common_category_id.getValue());
                if (category == null) {
                    map.setCommonCategoryId(Integer.valueOf(1));
                    map.setEipTSchedule(schedule);
                    map.setEipTCommonCategory(category1);
                } else {
                    map.setCommonCategoryId(Integer.valueOf((int)this.common_category_id.getValue()));
                    map.setEipTSchedule(schedule);
                    map.setEipTCommonCategory(category);
                }
                map.setType("U");
            }
            if ("O".equals(this.public_flag.toString()) && !this.is_span) {
                for (i = 0; i < f_size; ++i) {
                    map = (EipTScheduleMap)this.dataContext.createAndRegisterNewObject(EipTScheduleMap.class);
                    FacilityResultData frd = (FacilityResultData)this.facilityList.get(i);
                    int facilityid = (int)frd.getFacilityId().getValue();
                    map.setEipTSchedule(schedule);
                    map.setUserId(Integer.valueOf(facilityid));
                    map.setStatus("O");
                    map.setType("F");
                    map.setEipTCommonCategory(category1);
                    map.setCommonCategoryId(Integer.valueOf(1));
                }
            }
            this.date_detail = this.getMsgDate(schedule);
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(schedule.getScheduleId().intValue(), 240, schedule.getName());
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            List userIds = aclhandler.getAcceptUserIdsInListExceptLoginUser(this.dataContext, (int)this.loginUser.getUserId().getValue(), "schedule_self", 2, (List)this.memberList);
            int u_size = userIds.size();
            for (int i2 = 0; i2 < u_size; ++i2) {
                Integer _id = (Integer)userIds.get(i2);
                WhatsNewUtils.insertWhatsNew((DataContext)this.dataContext, (int)6, (int)schedule.getScheduleId(), (int)_id);
            }
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        try {
            int msgType = ALMailUtils.getSendDestType((int)24);
            if (msgType > 0) {
                List destMemberList = ALMailUtils.getALEipUserAddrs((List)this.memberList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
                String subject = "[Aipo]\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb";
                ALMailUtils.sendMailDelegate((String)this.org_id, (int)ALEipUtils.getUserId((RunData)rundata), (List)destMemberList, (String)subject, (String)subject, (String)this.createMsgForPc(), (String)this.createMsgForCellPhone(), (int)ALMailUtils.getSendDestType((int)24), new ArrayList());
            }
        }
        catch (Exception ex) {
            msgList.add("\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    private String getMsgDate(EipTSchedule schedule) {
        Calendar start_cal = Calendar.getInstance();
        start_cal.setTime(schedule.getStartDate());
        Calendar end_cal = Calendar.getInstance();
        end_cal.setTime(schedule.getEndDate());
        StringBuffer result = new StringBuffer();
        String ptn = schedule.getRepeatPattern();
        int count = 0;
        boolean is_repeat = true;
        boolean is_span = false;
        if (ptn.charAt(0) == 'D') {
            result.append("\u6bce\u65e5");
            count = 1;
        } else if (ptn.charAt(0) == 'W') {
            result.append(new StringBuffer().append("\u6bce\u9031 ").append(ptn.charAt(1) != '0' ? "\u65e5" : "").append(ptn.charAt(2) != '0' ? "\u6708" : "").append(ptn.charAt(3) != '0' ? "\u706b" : "").append(ptn.charAt(4) != '0' ? "\u6c34" : "").append(ptn.charAt(5) != '0' ? "\u6728" : "").append(ptn.charAt(6) != '0' ? "\u91d1" : "").append(ptn.charAt(7) != '0' ? "\u571f" : "").append(" \u66dc\u65e5").toString());
            count = 8;
        } else if (ptn.charAt(0) == 'M') {
            result.append("\u6bce\u6708 ").append(Integer.parseInt(ptn.substring(1, 3))).append("\u65e5").toString();
            count = 3;
        } else if (ptn.charAt(0) == 'S') {
            is_span = true;
            is_repeat = false;
        } else {
            is_repeat = false;
        }
        ALDateTimeField date_field = new ALDateTimeField("yyyy/MM/dd");
        ALDateTimeField time_field = new ALDateTimeField("HH:mm");
        if (!is_span) {
            if (!is_repeat) {
                date_field.setValue(schedule.getStartDate());
                result.append(date_field.toString());
            }
            time_field.setValue(schedule.getStartDate());
            result.append(" ").append(time_field.toString()).append("\uff5e");
            time_field.setValue(schedule.getEndDate());
            result.append(time_field.toString()).append(" ");
        } else {
            Date start = schedule.getStartDate();
            Date end = schedule.getEndDate();
            date_field.setValue(start);
            result.append(date_field.toString());
            if (!start.equals(end)) {
                result.append("\uff5e");
                date_field.setValue(end);
                result.append(date_field.toString());
            }
        }
        if (is_repeat && ptn.charAt(count) != 'N') {
            date_field.setValue(schedule.getStartDate());
            result.append(" \uff08").append(date_field.toString()).append("\uff5e");
            date_field.setValue(schedule.getEndDate());
            result.append(date_field.toString()).append("\uff09").toString();
        }
        return result.toString();
    }

    private String createMsgForPc() {
        ALBaseUser user = null;
        try {
            user = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(this.loginUser.getUserId().toString()));
        }
        catch (Exception e) {
            return "";
        }
        String CR = System.getProperty("line.separator");
        StringBuffer body = new StringBuffer("");
        body.append(this.loginUser.getAliasName().toString());
        if (!"".equals(user.getEmail())) {
            body.append("(").append(user.getEmail()).append(")");
        }
        body.append("\u3055\u3093\u304c\u4e88\u5b9a\u3092\u8ffd\u52a0\u3057\u307e\u3057\u305f\u3002").append(CR).append(CR);
        body.append("[\u4e88\u5b9a]").append(CR).append(this.getName().toString()).append(CR);
        body.append("[\u65e5\u6642]").append(CR).append(this.date_detail).append(CR);
        if (this.getPlace().toString().length() > 0) {
            body.append("[\u5834\u6240] ").append(CR).append(this.getPlace().toString()).append(CR);
        }
        if (this.getNote().toString().length() > 0) {
            body.append("[\u5185\u5bb9]").append(CR).append(this.getNote().toString()).append(CR);
        }
        if (this.memberList != null) {
            int size = this.memberList.size();
            body.append("[\u53c2\u52a0\u8005]").append(CR);
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    body.append(", ");
                }
                ALEipUser member = (ALEipUser)this.memberList.get(i);
                body.append(member.getAliasName());
            }
            body.append(CR);
        }
        body.append(CR);
        body.append("[Aipo\u3078\u306e\u30a2\u30af\u30bb\u30b9]").append(CR);
        String message = ALMailUtils.getGlobalurl();
        if (message != null && !message.equals("")) {
            body.append("\u30fb\u793e\u5916").append(CR);
            body.append("\u3000").append(message).append(CR);
        }
        body.append("\u30fb\u793e\u5185").append(CR);
        body.append("\u3000").append(ALMailUtils.getLocalurl()).append(CR).append(CR);
        body.append("---------------------").append(CR);
        body.append("Aipo").append(CR);
        return body.toString();
    }

    private String createMsgForCellPhone() {
        ALBaseUser user = null;
        try {
            user = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(this.loginUser.getUserId().toString()));
        }
        catch (Exception e) {
            return "";
        }
        String CR = System.getProperty("line.separator");
        StringBuffer body = new StringBuffer("");
        body.append(this.loginUser.getAliasName().toString());
        if (!"".equals(user.getEmail())) {
            body.append("(").append(user.getEmail()).append(")");
        }
        body.append("\u3055\u3093\u304c\u4e88\u5b9a\u3092\u8ffd\u52a0\u3057\u307e\u3057\u305f\u3002").append(CR).append(CR);
        body.append("[\u4e88\u5b9a]").append(CR).append(this.getName().toString()).append(CR);
        body.append("[\u65e5\u6642]").append(CR).append(this.date_detail).append(CR);
        if (this.memberList != null) {
            int size = this.memberList.size();
            body.append("[\u53c2\u52a0\u8005]").append(CR);
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    body.append(", ");
                }
                ALEipUser member = (ALEipUser)this.memberList.get(i);
                body.append(member.getAliasName());
            }
            body.append(CR);
        }
        body.append(CR);
        String message = ALMailUtils.getGlobalurl();
        if (message != null && !message.equals("")) {
            body.append("[Aipo\u3078\u306e\u30a2\u30af\u30bb\u30b9]").append(CR);
            body.append("\u3000").append(message).append(CR);
        }
        body.append("---------------------").append(CR);
        body.append("Aipo").append(CR);
        return body.toString();
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        ArrayList<ALEipUser> newmemberList = new ArrayList<ALEipUser>();
        try {
            int size;
            List scheduleMaps;
            int f_size = this.facilityList.size();
            if (!this.facilityCheckAclPermission(f_size, msgList, rundata, 8)) {
                return false;
            }
            if (this.is_span) {
                Date startdate = this.start_date.getValue();
                startdate.setHours(0);
                startdate.setMinutes(0);
                this.start_date.setValue(startdate);
                Date enddate = this.end_date.getValue();
                enddate.setHours(0);
                enddate.setMinutes(0);
                this.end_date.setValue(enddate);
            } else {
                GregorianCalendar startcal = new GregorianCalendar();
                startcal.setTime(this.start_date.getValue());
                Calendar endcal = Calendar.getInstance();
                endcal.setTime(this.end_date.getValue());
                endcal.set(1, startcal.get(1));
                endcal.set(2, startcal.get(2));
                endcal.set(5, startcal.get(5));
                this.end_date.setValue(endcal.getTime());
            }
            EipTSchedule schedule = ScheduleUtils.getEipTSchedule(rundata, context, false);
            if (schedule == null) {
                return false;
            }
            int entity_id = schedule.getScheduleId();
            int ownerid = schedule.getOwnerId();
            List scheduleMapList = schedule.getEipTScheduleMaps();
            int scheduleMapListSize = scheduleMapList.size();
            ArrayList<Integer> oldmemberIdList = new ArrayList<Integer>();
            for (int i = 0; i < scheduleMapListSize; ++i) {
                EipTScheduleMap map = (EipTScheduleMap)scheduleMapList.get(i);
                if (!"U".equals(map.getType())) continue;
                oldmemberIdList.add(map.getUserId());
            }
            int allmemberListSize = this.memberList.size();
            for (int i = 0; i < allmemberListSize; ++i) {
                int memberId = (int)((ALEipUser)this.memberList.get(i)).getUserId().getValue();
                if (this.isContains(oldmemberIdList, memberId)) continue;
                newmemberList.add(ALEipUtils.getALEipUser((int)memberId));
            }
            EipTCommonCategory category1 = CommonCategoryUtils.getEipTCommonCategory((DataContext)this.dataContext, (Long)1L);
            if (this.edit_repeat_flag.getValue() == 1L) {
                EipTSchedule newSchedule = (EipTSchedule)this.dataContext.createAndRegisterNewObject(EipTSchedule.class);
                newSchedule.setParentId(schedule.getScheduleId());
                newSchedule.setName(this.name.getValue());
                newSchedule.setPlace(this.place.getValue());
                newSchedule.setNote(this.note.getValue());
                newSchedule.setPublicFlag(this.public_flag.getValue());
                newSchedule.setEditFlag("F");
                newSchedule.setEditFlag(schedule.getEditFlag());
                newSchedule.setOwnerId(Integer.valueOf(ownerid));
                Date now = new Date();
                newSchedule.setCreateDate(now);
                newSchedule.setCreateUserId(Integer.valueOf(ownerid));
                newSchedule.setUpdateDate(now);
                newSchedule.setUpdateUserId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
                newSchedule.setEndDate(this.end_date.getValue());
                newSchedule.setRepeatPattern("N");
                newSchedule.setStartDate(this.start_date.getValue());
                int allsize = this.memberList.size() + this.facilityList.size();
                if (allsize > 0) {
                    EipTScheduleMap map;
                    int i;
                    scheduleMaps = schedule.getEipTScheduleMaps();
                    size = this.memberList.size();
                    int size2 = scheduleMaps.size();
                    for (i = 0; i < size; ++i) {
                        map = (EipTScheduleMap)this.dataContext.createAndRegisterNewObject(EipTScheduleMap.class);
                        ALEipUser user = (ALEipUser)this.memberList.get(i);
                        int userid = (int)user.getUserId().getValue();
                        map.setEipTSchedule(newSchedule);
                        map.setUserId(Integer.valueOf(userid));
                        if (userid == ownerid) {
                            map.setStatus("O");
                        } else if ("T".equals(this.change_tmpreserve_flag.getValue())) {
                            map.setStatus("T");
                        } else {
                            EipTScheduleMap tmpMap = this.getScheduleMap(scheduleMaps, userid, "U");
                            if (tmpMap != null) {
                                map.setStatus(tmpMap.getStatus());
                            } else {
                                map.setStatus("T");
                            }
                        }
                        EipTCommonCategory category = CommonCategoryUtils.getEipTCommonCategory((DataContext)this.dataContext, (Long)this.common_category_id.getValue());
                        if (category == null) {
                            map.setCommonCategoryId(Integer.valueOf(1));
                            map.setEipTCommonCategory(category1);
                        } else {
                            map.setCommonCategoryId(Integer.valueOf((int)this.common_category_id.getValue()));
                            map.setEipTCommonCategory(category);
                        }
                        map.setType("U");
                    }
                    if ("O".equals(this.public_flag.toString()) && !this.is_span) {
                        for (i = 0; i < f_size; ++i) {
                            map = (EipTScheduleMap)this.dataContext.createAndRegisterNewObject(EipTScheduleMap.class);
                            FacilityResultData frd = (FacilityResultData)this.facilityList.get(i);
                            int facilityid = (int)frd.getFacilityId().getValue();
                            map.setEipTSchedule(newSchedule);
                            map.setUserId(Integer.valueOf(facilityid));
                            map.setStatus("O");
                            map.setType("F");
                            map.setEipTCommonCategory(category1);
                            map.setCommonCategoryId(Integer.valueOf(1));
                        }
                    }
                }
                scheduleMaps = schedule.getEipTScheduleMaps();
                int scheduleMapsSize = scheduleMaps.size();
                ArrayList<Integer> memberIdList = new ArrayList<Integer>();
                ArrayList<Integer> facilityIdList = new ArrayList<Integer>();
                for (int i = 0; i < scheduleMapsSize; ++i) {
                    EipTScheduleMap map = (EipTScheduleMap)scheduleMaps.get(i);
                    if ("U".equals(map.getType())) {
                        memberIdList.add(map.getUserId());
                        continue;
                    }
                    facilityIdList.add(map.getUserId());
                }
                int memberListSize = this.memberList.size();
                for (int i = 0; i < memberListSize; ++i) {
                    int memberId = (int)((ALEipUser)this.memberList.get(i)).getUserId().getValue();
                    if (this.isContains(memberIdList, memberId)) continue;
                    memberIdList.add(memberId);
                }
                int memberIdListSize = memberIdList.size();
                int[] memberIds = new int[memberIdListSize];
                for (int i = 0; i < memberIdListSize; ++i) {
                    memberIds[i] = (Integer)memberIdList.get(i);
                }
                int facilityListSize = this.facilityList.size();
                for (int i = 0; i < facilityListSize; ++i) {
                    int facilityId = (int)((FacilityResultData)this.facilityList.get(i)).getFacilityId().getValue();
                    if (this.isContains(facilityIdList, facilityId)) continue;
                    this.facilityList.add(facilityId);
                }
                int facilityIdListSize = facilityIdList.size();
                int[] facilityIds = new int[facilityIdListSize];
                for (int i = 0; i < facilityIdListSize; ++i) {
                    facilityIds[i] = (Integer)facilityIdList.get(i);
                }
                ScheduleUtils.insertDummySchedule(schedule, ownerid, this.view_date.getValue(), this.view_date.getValue(), memberIds, facilityIds);
                entity_id = newSchedule.getScheduleId();
            } else {
                EipTScheduleMap map;
                int i;
                schedule.setName(this.name.getValue());
                schedule.setPlace(this.place.getValue());
                schedule.setNote(this.note.getValue());
                schedule.setPublicFlag(this.public_flag.getValue());
                if (schedule.getOwnerId() == ALEipUtils.getUserId((RunData)rundata) || schedule.getOwnerId() == 0) {
                    schedule.setEditFlag(this.edit_flag.getValue());
                }
                int ownerUserId = schedule.getOwnerId();
                boolean rejectOwnerUser = false;
                List tmpScheduleMaps = schedule.getEipTScheduleMaps();
                for (int i2 = 0; i2 < tmpScheduleMaps.size(); ++i2) {
                    EipTScheduleMap map2 = (EipTScheduleMap)tmpScheduleMaps.get(i2);
                    if (ownerUserId != map2.getUserId() || !"R".equals(map2.getStatus())) continue;
                    rejectOwnerUser = true;
                    break;
                }
                if (rejectOwnerUser) {
                    schedule.setOwnerId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
                }
                schedule.setUpdateDate(new Date());
                schedule.setUpdateUserId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
                if (this.is_span) {
                    schedule.setEndDate(this.end_date.getValue());
                    schedule.setRepeatPattern("S");
                    schedule.setStartDate(this.start_date.getValue());
                } else if (!this.is_repeat) {
                    schedule.setEndDate(this.end_date.getValue());
                    schedule.setRepeatPattern("N");
                    schedule.setStartDate(this.start_date.getValue());
                } else {
                    String tmpPattern;
                    char lim = 'N';
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(this.end_date.getValue());
                    if ("ON".equals(this.limit_flag.getValue())) {
                        lim = 'L';
                        cal.set(this.limit_end_date.getValue().getYear(), this.limit_end_date.getValue().getMonth() - 1, this.limit_end_date.getValue().getDay());
                        ALDateContainer container = this.limit_start_date.getValue();
                        Calendar limitStartCal = Calendar.getInstance();
                        limitStartCal.setTime(this.start_date.getValue());
                        limitStartCal.set(1, container.getYear());
                        limitStartCal.set(2, container.getMonth() - 1);
                        limitStartCal.set(5, container.getDay());
                        schedule.setStartDate(limitStartCal.getTime());
                    } else {
                        schedule.setStartDate(this.start_date.getValue());
                    }
                    schedule.setEndDate(cal.getTime());
                    if ("D".equals(this.repeat_type.getValue())) {
                        tmpPattern = new StringBuffer().append('D').append(lim).toString();
                        schedule.setRepeatPattern(tmpPattern);
                    } else if ("W".equals(this.repeat_type.getValue())) {
                        tmpPattern = new StringBuffer().append('W').append(this.week_0.getValue() != null ? 1 : 0).append(this.week_1.getValue() != null ? 1 : 0).append(this.week_2.getValue() != null ? 1 : 0).append(this.week_3.getValue() != null ? 1 : 0).append(this.week_4.getValue() != null ? 1 : 0).append(this.week_5.getValue() != null ? 1 : 0).append(this.week_6.getValue() != null ? 1 : 0).append(lim).toString();
                        schedule.setRepeatPattern(tmpPattern);
                    } else {
                        DecimalFormat format = new DecimalFormat("00");
                        schedule.setRepeatPattern(new StringBuffer().append('M').append(format.format(this.month_day.getValue())).append(lim).toString());
                    }
                }
                scheduleMaps = schedule.getEipTScheduleMaps();
                this.dataContext.deleteObjects((Collection)scheduleMaps);
                size = this.memberList.size();
                int size2 = scheduleMaps.size();
                for (i = 0; i < size; ++i) {
                    map = (EipTScheduleMap)this.dataContext.createAndRegisterNewObject(EipTScheduleMap.class);
                    ALEipUser user = (ALEipUser)this.memberList.get(i);
                    int userid = (int)user.getUserId().getValue();
                    map.setScheduleId(schedule.getScheduleId());
                    map.setEipTSchedule(schedule);
                    map.setUserId(Integer.valueOf(userid));
                    if (userid == schedule.getOwnerId()) {
                        map.setStatus("O");
                    } else if ("T".equals(this.change_tmpreserve_flag.getValue())) {
                        map.setStatus("T");
                    } else {
                        EipTScheduleMap tmpMap = this.getScheduleMap(scheduleMaps, userid, "U");
                        if (tmpMap != null) {
                            map.setStatus(tmpMap.getStatus());
                        } else {
                            map.setStatus("T");
                        }
                    }
                    EipTCommonCategory category = CommonCategoryUtils.getEipTCommonCategory((DataContext)this.dataContext, (Long)this.common_category_id.getValue());
                    if (category == null) {
                        map.setCommonCategoryId(Integer.valueOf(1));
                        map.setEipTSchedule(schedule);
                        map.setEipTCommonCategory(category1);
                    } else {
                        map.setCommonCategoryId(Integer.valueOf((int)this.common_category_id.getValue()));
                        map.setEipTSchedule(schedule);
                        map.setEipTCommonCategory(category);
                    }
                    map.setType("U");
                    schedule.addToEipTScheduleMaps(map);
                }
                if ("O".equals(this.public_flag.toString()) && !this.is_span) {
                    for (i = 0; i < f_size; ++i) {
                        map = (EipTScheduleMap)this.dataContext.createAndRegisterNewObject(EipTScheduleMap.class);
                        FacilityResultData frd = (FacilityResultData)this.facilityList.get(i);
                        int facilityid = (int)frd.getFacilityId().getValue();
                        map.setEipTSchedule(schedule);
                        map.setUserId(Integer.valueOf(facilityid));
                        map.setStatus("O");
                        map.setType("F");
                        map.setEipTCommonCategory(category1);
                        map.setCommonCategoryId(Integer.valueOf(1));
                    }
                }
            }
            this.date_detail = this.getMsgDate(schedule);
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(schedule.getScheduleId().intValue(), 240, schedule.getName());
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            List userIds = aclhandler.getAcceptUserIdsInListExceptLoginUser(this.dataContext, (int)this.loginUser.getUserId().getValue(), "schedule_self", 2, (List)this.memberList);
            int size2 = userIds.size();
            for (int i = 0; i < size2; ++i) {
                Integer _id = (Integer)userIds.get(i);
                WhatsNewUtils.insertWhatsNew((DataContext)this.dataContext, (int)6, (int)entity_id, (int)_id);
            }
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        try {
            int msgType = ALMailUtils.getSendDestType((int)24);
            if (msgType > 0) {
                List destMemberList = ALMailUtils.getALEipUserAddrs((List)this.memberList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
                String subject = "[Aipo]\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb";
                ALMailUtils.sendMailDelegate((String)this.org_id, (int)ALEipUtils.getUserId((RunData)rundata), (List)destMemberList, (String)subject, (String)subject, (String)this.createMsgForPc(), (String)this.createMsgForCellPhone(), (int)ALMailUtils.getSendDestType((int)24), new ArrayList());
            }
        }
        catch (Exception ex) {
            msgList.add("\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    private EipTScheduleMap getScheduleMap(List scheduleMaps, int userid, String type) {
        EipTScheduleMap map = null;
        int size = scheduleMaps.size();
        for (int i = 0; i < size; ++i) {
            map = (EipTScheduleMap)scheduleMaps.get(i);
            if (map.getUserId() != userid || !type.equals(map.getType())) continue;
            return map;
        }
        return null;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTSchedule schedule;
            if (rundata.getParameters().containsKey((Object)"del_member_flag")) {
                this.del_member_flag.setValue(rundata.getParameters().getString("del_member_flag"));
            }
            if (rundata.getParameters().containsKey((Object)"del_range_flag")) {
                this.del_range_flag.setValue(rundata.getParameters().getString("del_range_flag"));
            }
            int userid = 0;
            if (rundata.getParameters().containsKey((Object)"userid")) {
                userid = rundata.getParameters().getInt("userid");
            }
            if ((schedule = ScheduleUtils.getEipTSchedule(rundata, context, false)) == null) {
                return false;
            }
            List members = ScheduleUtils.getUsers(rundata, context, true);
            if (members != null && members.size() > 0) {
                this.memberList.addAll(members);
            }
            boolean acl_delete_other = false;
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            if (aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "schedule_other", 16)) {
                acl_delete_other = true;
            }
            boolean isMember = false;
            int loginuserId = (int)this.login_user.getUserId().getValue();
            int membersSize = this.memberList.size();
            ALEipUser eipUser = null;
            for (int i = 0; i < membersSize; ++i) {
                eipUser = (ALEipUser)this.memberList.get(i);
                if ((long)loginuserId != eipUser.getUserId().getValue()) continue;
                isMember = true;
                break;
            }
            if (!acl_delete_other && !isMember && schedule.getCreateUserId() != loginuserId) {
                logger.error((Object)"[ScheduleFormData] ALPageNotFoundException: The user does not have the auth to delete the schedule.");
                throw new ALPermissionException();
            }
            if (loginuserId != schedule.getOwnerId() && "F".equals(schedule.getEditFlag()) && 1L != this.del_member_flag.getValue()) {
                return true;
            }
            int delFlag = -1;
            delFlag = this.del_member_flag.getValue() == 0L ? (this.del_range_flag.getValue() == 0L ? 0 : 1) : (this.del_range_flag.getValue() == 0L ? 2 : 3);
            if (delFlag == 0) {
                this.deleteSchedule(schedule);
            } else if (delFlag == 1) {
                if (!"N".equals(schedule.getRepeatPattern())) {
                    int ownerid = ALEipUtils.getUserId((RunData)rundata);
                    int memberIdListSize = this.memberList.size();
                    int[] memberIdList = new int[memberIdListSize];
                    for (int i = 0; i < memberIdListSize; ++i) {
                        memberIdList[i] = (int)((ALEipUser)this.memberList.get(i)).getUserId().getValue();
                    }
                    int[] facilityIdList = ScheduleUtils.getFacilityIds(schedule);
                    ScheduleUtils.insertDummySchedule(schedule, ownerid, this.view_date.getValue(), this.view_date.getValue(), memberIdList, facilityIdList);
                }
            } else if (delFlag == 2) {
                List scheduleMaps = ScheduleUtils.getEipTScheduleMaps(schedule);
                if (scheduleMaps != null && scheduleMaps.size() > 0) {
                    int countRejectSchedule = 0;
                    ArrayList<EipTScheduleMap> tmpScheduleMaps = new ArrayList<EipTScheduleMap>();
                    for (int i = 0; i < scheduleMaps.size(); ++i) {
                        EipTScheduleMap scheduleMap = (EipTScheduleMap)scheduleMaps.get(i);
                        if (!"U".equals(scheduleMap.getType())) continue;
                        tmpScheduleMaps.add(scheduleMap);
                        if (!"R".equals(scheduleMap.getStatus())) continue;
                        ++countRejectSchedule;
                    }
                    int scheduleMapsSize = tmpScheduleMaps.size();
                    if (countRejectSchedule >= scheduleMapsSize - 1) {
                        this.deleteSchedule(schedule);
                    } else {
                        for (int i = 0; i < scheduleMapsSize; ++i) {
                            EipTScheduleMap scheduleMap = (EipTScheduleMap)tmpScheduleMaps.get(i);
                            if (scheduleMap.getUserId() != userid || (long)scheduleMap.getUserId().intValue() != this.login_user.getUserId().getValue() && (long)schedule.getCreateUserId().intValue() != this.login_user.getUserId().getValue()) continue;
                            if ("O".equals(scheduleMap.getStatus())) {
                                schedule.setOwnerId(Integer.valueOf(0));
                                if ("F".equals(schedule.getEditFlag())) {
                                    schedule.setEditFlag("T");
                                }
                            }
                            scheduleMap.setStatus("R");
                        }
                    }
                }
            } else if (delFlag == 3) {
                if (!"N".equals(schedule.getRepeatPattern())) {
                    int ownerid = ALEipUtils.getUserId((RunData)rundata);
                    int[] memberIdList = new int[]{userid};
                    int[] facilityIdList = ScheduleUtils.getFacilityIds(schedule);
                    ScheduleUtils.insertDummySchedule(schedule, ownerid, this.view_date.getValue(), this.view_date.getValue(), memberIdList, facilityIdList);
                }
            } else {
                this.dataContext.deleteObject((Persistent)schedule);
            }
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(schedule.getScheduleId().intValue(), 240, schedule.getName());
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    public boolean doViewForm(ALAction action, RunData rundata, Context context) {
        boolean res = super.doViewForm(action, rundata, context);
        return res;
    }

    public boolean doInsert(ALAction action, RunData rundata, Context context) {
        boolean res = super.doInsert(action, rundata, context);
        return res;
    }

    public boolean doUpdate(ALAction action, RunData rundata, Context context) {
        boolean res = super.doUpdate(action, rundata, context);
        return res;
    }

    private boolean facilityCheckAclPermission(int f_size, ArrayList msgList, RunData rundata, int aclType) {
        if (f_size > 0) {
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            this.hasAuthority = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "schedule_facility", aclType);
            if (!this.hasAuthority) {
                msgList.add(" \u65bd\u8a2d\u3092\u4e88\u7d04\u3059\u308b\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093 ");
                return false;
            }
        }
        return true;
    }

    private void post(ALAction action, RunData rundata, Context context) {
        this.selectData = new ScheduleOnedayGroupSelectData();
        this.selectData.initField();
        if (this.tmpView != null && !this.tmpView.equals("")) {
            this.selectData.setTmpViewDate(this.tmpView);
        } else {
            this.start_date.setNotNull(true);
            if (this.start_date.validate(new ArrayList())) {
                this.selectData.setTmpViewDate(this.start_date.toString());
            } else if (this.tmpStart == null || this.tmpStart.equals("")) {
                ALDateTimeField now = new ALDateTimeField("yyyy-MM-dd-HH-mm");
                now.setValue(new Date());
                this.selectData.setTmpViewDate(now.toString());
            } else {
                this.selectData.setTmpViewDate(this.tmpStart);
            }
        }
        this.selectData.doSelectList(action, rundata, context);
    }

    private boolean includeWeek(int selectedWeek, int startWeek, int endWeek) {
        if (startWeek <= endWeek) {
            return startWeek <= selectedWeek && selectedWeek <= endWeek;
        }
        return selectedWeek >= startWeek || endWeek >= selectedWeek;
    }

    private void deleteSchedule(EipTSchedule schedule) {
        Integer scheduleId = schedule.getScheduleId();
        this.dataContext.deleteObject((Persistent)schedule);
        SelectQuery query = new SelectQuery(EipTSchedule.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"parentId", (Object)scheduleId);
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"eipTScheduleMaps.status", (Object)"D");
        query.andQualifier(exp2);
        List dellist = this.dataContext.performQuery((Query)query);
        this.dataContext.deleteObjects((Collection)dellist);
    }

    private boolean isContains(List memberIdList, int userId) {
        int size = memberIdList.size();
        Integer tmpInt = null;
        for (int i = 0; i < size; ++i) {
            tmpInt = (Integer)memberIdList.get(i);
            if (userId != tmpInt) continue;
            return true;
        }
        return false;
    }

    public ALDateTimeField getStartDate() {
        return this.start_date;
    }

    public ALDateTimeField getStartDateSub() {
        ALDateTimeField tmpDate = new ALDateTimeField("yyyy/MM/dd");
        tmpDate.setValue(this.start_date.getValue());
        return tmpDate;
    }

    public ALDateTimeField getStartDateTime() {
        ALDateTimeField tmpDate = new ALDateTimeField("HH:mm");
        tmpDate.setValue(this.start_date.getValue());
        return tmpDate;
    }

    public ALDateTimeField getEndDate() {
        return this.end_date;
    }

    public ALDateTimeField getEndDateSub() {
        ALDateTimeField tmpDate = new ALDateTimeField("yyyy/MM/dd");
        tmpDate.setValue(this.end_date.getValue());
        return tmpDate;
    }

    public ALDateTimeField getEndDateTime() {
        ALDateTimeField tmpDate = new ALDateTimeField("HH:mm");
        tmpDate.setValue(this.end_date.getValue());
        return tmpDate;
    }

    public List getMemberList() {
        return this.memberList;
    }

    public List getUsers(String groupname) {
        return ALEipUtils.getUsers((String)groupname);
    }

    public Map getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public ALStringField getName() {
        return this.name;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public ALStringField getPlace() {
        return this.place;
    }

    public int getCurrentYear() {
        return this.currentYear;
    }

    public boolean isMember() {
        return this.is_member || this.memberList.size() > 1;
    }

    public boolean isOwner() {
        return this.is_owner;
    }

    public ALEipUser getLoginUser() {
        return this.login_user;
    }

    public ScheduleOnedayGroupSelectData getSelectData() {
        return this.selectData;
    }

    public ALStringField getPublicFlag() {
        return this.public_flag;
    }

    public boolean isRepeat() {
        return this.is_repeat;
    }

    public boolean isSpan() {
        return this.is_span;
    }

    public ALDateField getLimitStartDate() {
        return this.limit_start_date;
    }

    public ALDateTimeField getLimitStartDateSub() {
        ALDateTimeField tmpDate = new ALDateTimeField("yyyy/MM/dd");
        try {
            tmpDate.setValue(this.limit_start_date.getValue().getDate());
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleFormData]", (Throwable)e);
        }
        return tmpDate;
    }

    public ALDateField getLimitEndDate() {
        return this.limit_end_date;
    }

    public ALDateTimeField getLimitEndDateSub() {
        ALDateTimeField tmpDate = new ALDateTimeField("yyyy/MM/dd");
        try {
            tmpDate.setValue(this.limit_end_date.getValue().getDate());
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleFormData]", (Throwable)e);
        }
        return tmpDate;
    }

    public ALStringField getLimitFlag() {
        return this.limit_flag;
    }

    public ALNumberField getMonthDay() {
        return this.month_day;
    }

    public ALStringField getRepeatType() {
        return this.repeat_type;
    }

    public ALStringField getWeek0() {
        return this.week_0;
    }

    public ALStringField getWeek1() {
        return this.week_1;
    }

    public ALStringField getWeek2() {
        return this.week_2;
    }

    public ALStringField getWeek3() {
        return this.week_3;
    }

    public ALStringField getWeek4() {
        return this.week_4;
    }

    public ALStringField getWeek5() {
        return this.week_5;
    }

    public ALStringField getWeek6() {
        return this.week_6;
    }

    public List getGroupList() {
        return this.groups;
    }

    public ALNumberField getEditRepeatFlag() {
        return this.edit_repeat_flag;
    }

    public ALStringField getEditFlag() {
        return this.edit_flag;
    }

    public ALStringField getChangeTmpreserveFlag() {
        return this.change_tmpreserve_flag;
    }

    public ALDateTimeField getViewDate() {
        return this.view_date;
    }

    public int getInt(long num) {
        return (int)num;
    }

    public boolean isFacility() {
        return this.is_facility || this.facilityList.size() > 0;
    }

    public List getFacilityList() {
        return this.facilityList;
    }

    public List getFacilityAllList() {
        return this.facilityAllList;
    }

    public ALNumberField getCommonCategoryId() {
        return this.common_category_id;
    }

    public int getMsgType() {
        return this.msg_type;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }
}

