/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALCellDateTimeField;
import com.aimluck.commons.field.ALCellStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Date;
import org.apache.cayenne.access.DataContext;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ScheduleChangeStatusFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ScheduleChangeStatusFormData.class.getName());
    private ALCellStringField status;
    private String tmpView;
    private ALCellDateTimeField view_date;

    public void loadParametersViewDate(RunData rundata, Context context) {
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"view_date")) {
            ALCellDateTimeField dummy = new ALCellDateTimeField("yyyy-MM-dd");
            this.tmpView = rundata.getParameters().getString("view_date");
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpView", (String)this.tmpView);
            dummy.setValue(this.tmpView);
            if (!dummy.validate(new ArrayList())) {
                ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"tmpView");
                logger.debug((Object)"[ScheduleFormData] Parameter cannot validate");
                ALEipUtils.redirectPageNotFound((RunData)rundata);
                return;
            }
        }
        this.tmpView = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tmpView");
    }

    public void initField() {
        this.status = new ALCellStringField();
        this.status.setTrim(true);
        Date now = new Date();
        this.view_date = new ALCellDateTimeField("yyyy-MM-dd");
        if (this.tmpView == null || this.tmpView.equals("")) {
            this.view_date.setValue(now);
        } else {
            this.view_date.setValue(this.tmpView);
        }
        this.view_date.setFieldName("\u6307\u5b9a\u65e5\u6642");
    }

    protected void setValidator() {
    }

    protected boolean validate(ArrayList msgList) {
        return "T".equals(this.status.getValue()) || "C".equals(this.status.getValue()) || "R".equals(this.status.getValue()) || "O".equals(this.status.getValue());
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) throws ALDBErrorException, ALPageNotFoundException {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            EipTScheduleMap schedule = ScheduleUtils.getEipTScheduleMap(rundata, context);
            if (schedule == null) {
                return false;
            }
            schedule.setStatus(this.status.getValue());
            dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(schedule.getScheduleId().intValue(), 240, schedule.getEipTSchedule().getName());
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleChangeStatusFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    public ALCellDateTimeField getViewDate() {
        return this.view_date;
    }
}

