/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALCellDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.schedule.CellScheduleResultData;
import com.aimluck.eip.schedule.ScheduleOnedaySelectData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CellScheduleOnedaySelectData
extends ScheduleOnedaySelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CellScheduleOnedaySelectData.class.getName());
    private Map rowspanMap;
    private int rowIndex;
    private DataContext dataContext;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
    }

    protected List selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        try {
            List resultBaseList = this.dataContext.performQuery((Query)this.getSelectQuery(rundata, context));
            List resultList = ScheduleUtils.sortByDummySchedule(resultBaseList);
            ArrayList<EipTScheduleMap> list = new ArrayList<EipTScheduleMap>();
            ArrayList delList = new ArrayList();
            boolean delSize = false;
            int resultSize = resultList.size();
            int size = 0;
            int DummySize = 0;
            boolean flg = false;
            boolean canAdd = true;
            for (int i = 0; i < resultSize; ++i) {
                EipTScheduleMap record = (EipTScheduleMap)resultList.get(i);
                EipTSchedule schedule = record.getEipTSchedule();
                delList.clear();
                canAdd = true;
                size = list.size();
                if (!record.getStatus().equals("D")) {
                    if (!flg) {
                        DummySize = i;
                        flg = true;
                    }
                    for (int j = 0; j < DummySize; ++j) {
                        EipTScheduleMap record2 = (EipTScheduleMap)resultList.get(j);
                        EipTSchedule schedule2 = record2.getEipTSchedule();
                        if (schedule.getRepeatPattern().equals("N") || !schedule.getScheduleId().equals(schedule2.getParentId())) continue;
                        canAdd = false;
                        break;
                    }
                } else {
                    canAdd = false;
                }
                if (!canAdd) continue;
                list.add(record);
            }
            Collections.sort(list, new Comparator(){

                public int compare(Object a, Object b) {
                    Calendar cal = Calendar.getInstance();
                    Calendar cal2 = Calendar.getInstance();
                    EipTSchedule p1 = null;
                    EipTSchedule p2 = null;
                    try {
                        p1 = ((EipTScheduleMap)a).getEipTSchedule();
                        p2 = ((EipTScheduleMap)b).getEipTSchedule();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Exception", (Throwable)e);
                    }
                    cal.setTime(p1.getStartDate());
                    cal.set(0, 0, 0);
                    cal2.setTime(p2.getStartDate());
                    cal2.set(0, 0, 0);
                    if (cal.getTime().compareTo(cal2.getTime()) != 0) {
                        return cal.getTime().compareTo(cal2.getTime());
                    }
                    cal.setTime(p1.getEndDate());
                    cal.set(0, 0, 0);
                    cal2.setTime(p2.getEndDate());
                    cal2.set(0, 0, 0);
                    return cal.getTime().compareTo(cal2.getTime());
                }
            });
            int listsize = list.size();
            this.setPageParam(listsize);
            int start = this.getStart();
            int rowsNum = this.getRowsNum();
            int count = -1;
            ArrayList reslist = new ArrayList();
            for (int i = 0; i < rowsNum && (count = i + start) < listsize; ++i) {
                reslist.add(list.get(count));
            }
            if (this.viewToDo == 1) {
                this.loadToDo(rundata, context);
            }
            return reslist;
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleOnedaySelectData]", (Throwable)e);
            throw new ALDBErrorException();
        }
    }

    protected SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipTScheduleMap.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"type", (Object)"U");
        query.andQualifier(exp2);
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"eipTSchedule.endDate", (Object)this.getViewDate().getValue());
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getViewDate().getValue());
        cal.add(5, 1);
        ALCellDateTimeField field = new ALCellDateTimeField();
        field.setValue(cal.getTime());
        Expression exp12 = ExpressionFactory.lessExp((String)"eipTSchedule.startDate", (Object)field.getValue());
        Expression exp13 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)"N");
        Expression exp14 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)"S");
        Date date = this.getViewDate().getValue();
        int weekindex = date.getDay();
        String token = null;
        StringBuffer sb = new StringBuffer();
        sb.append("W");
        for (int i = 0; i < 7; ++i) {
            token = i == weekindex ? "1" : "_";
            sb.append(token);
        }
        Expression exp21 = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)(sb.toString() + "L"));
        Expression exp22 = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)(sb.toString() + "N"));
        Expression exp23 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)"DN");
        Expression exp31 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)"DL");
        SimpleDateFormat sdf = new SimpleDateFormat("dd");
        sdf.setTimeZone(TimeZone.getTimeZone("JST"));
        String dayStr = sdf.format(date);
        Expression exp24 = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)("M" + dayStr + "L"));
        Expression exp25 = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)("M" + dayStr + "N"));
        query.andQualifier(exp11.andExp(exp12).andExp(exp13.orExp(exp14).orExp(exp21).orExp(exp31).orExp(exp24)).orExp(exp22.orExp(exp23).orExp(exp25)));
        ArrayList<Ordering> orders = new ArrayList<Ordering>();
        orders.add(new Ordering("eipTSchedule.startDate", true));
        orders.add(new Ordering("eipTSchedule.endDate", true));
        query.addOrderings(orders);
        return query;
    }

    protected Object getResultData(Object obj) throws ALPageNotFoundException, ALDBErrorException {
        CellScheduleResultData rd = new CellScheduleResultData();
        CellScheduleResultData rd2 = new CellScheduleResultData();
        rd.initField();
        rd2.setFormat("yyyy-MM-dd-HH-mm");
        rd2.initField();
        try {
            EipTScheduleMap record = (EipTScheduleMap)obj;
            EipTSchedule schedule = record.getEipTSchedule();
            if ("R".equals(record.getStatus())) {
                return rd;
            }
            if (!ScheduleUtils.isView(this.getViewDate(), schedule.getRepeatPattern(), schedule.getStartDate(), schedule.getEndDate())) {
                return rd;
            }
            rd.setScheduleId(schedule.getScheduleId());
            rd.setParentId(schedule.getParentId());
            rd.setName(schedule.getName());
            rd.setStartDate(schedule.getStartDate());
            rd.setEndDate(schedule.getEndDate());
            rd.setTmpreserve("T".equals(record.getStatus()));
            rd.setPublic("O".equals(schedule.getPublicFlag()));
            rd.setHidden("P".equals(schedule.getPublicFlag()));
            rd.setPattern(schedule.getRepeatPattern());
            if (rd.getPattern().equals("S")) {
                rd.setSpan(true);
                return rd;
            }
            if (!rd.getPattern().equals("N")) {
                if (!ScheduleUtils.isView(this.getViewDate(), rd.getPattern(), rd.getStartDate().getValue(), rd.getEndDate().getValue())) {
                    return rd;
                }
                rd.setRepeat(true);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return null;
        }
        return rd;
    }

    protected String getPortletURItoTodo(RunData rundata, long entityid, String schedulePortletId) {
        return ScheduleUtils.getPortletURItoTodoDetailPaneForCell(rundata, "Cell_ToDo", entityid, schedulePortletId);
    }
}

