/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALCellDateField;
import com.aimluck.commons.field.ALCellDateTimeField;
import com.aimluck.commons.field.ALCellNumberField;
import com.aimluck.commons.field.ALCellStringField;
import com.aimluck.commons.field.ALDateContainer;
import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.category.util.CommonCategoryUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTCommonCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.facilities.FacilityResultData;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.schedule.ScheduleOnedayGroupSelectData;
import com.aimluck.eip.schedule.util.CellScheduleUtils;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whatsnew.util.WhatsNewUtils;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CellScheduleFormNoteData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CellScheduleFormNoteData.class.getName());
    private static final int FLAG_EDIT_REPEAT_DEF = -1;
    private static final int FLAG_EDIT_REPEAT_ALL = 0;
    private static final int FLAG_EDIT_REPEAT_ONE = 1;
    public static final int FLAG_DEL_MEMBER_ALL = 0;
    public static final int FLAG_DEL_MEMBER_ONE = 1;
    public static final int FLAG_DEL_RANGE_ALL = 0;
    public static final int FLAG_DEL_RANGE_ONE = 1;
    private ALCellDateTimeField start_date;
    private ALCellDateTimeField end_date;
    private ALCellStringField name;
    private ALCellStringField place;
    private ALCellStringField note;
    private ALCellStringField public_flag;
    private ALCellStringField repeat_type;
    private ALCellStringField week_0;
    private ALCellStringField week_1;
    private ALCellStringField week_2;
    private ALCellStringField week_3;
    private ALCellStringField week_4;
    private ALCellStringField week_5;
    private ALCellStringField week_6;
    private ALCellStringField limit_flag;
    private ALCellDateField limit_start_date;
    private ALCellDateField limit_end_date;
    private ALCellNumberField month_day;
    private ArrayList memberList;
    private ArrayList facilityMemberList;
    private ALCellNumberField common_category_id;
    private int currentYear;
    private boolean is_member;
    private boolean is_repeat;
    private boolean is_span;
    private ALEipUser login_user;
    private String tmpStart;
    private String tmpEnd;
    private ScheduleOnedayGroupSelectData selectData;
    private String tmpScheduleId;
    private List groups;
    private ALCellNumberField edit_repeat_flag;
    private String tmpView;
    private ALCellDateTimeField view_date;
    private ALCellStringField edit_flag;
    private ALCellStringField change_tmpreserve_flag;
    private ALCellNumberField del_member_flag;
    private ALCellNumberField del_range_flag;
    private boolean is_owner;
    protected String entityid;
    private ALCellNumberField del_flag;
    private DataContext dataContext;
    private String aclPortletFeature;

    public boolean doViewForm(ALAction action, RunData rundata, Context context, boolean enable_entityid) {
        try {
            if (enable_entityid) {
                this.init(action, rundata, context);
                boolean isedit = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid") != null;
                action.setMode(isedit ? "edit_form" : "new_form");
                this.setMode(action.getMode());
                ArrayList msgList = new ArrayList();
                boolean res = this.setFormData(rundata, context, msgList) && ScheduleUtils.validateDelegate((ALDateTimeField)this.getStartDate(), (ALDateTimeField)this.getEndDate(), (ALStringField)this.getRepeatType(), this.isRepeat(), this.isSpan(), (ALStringField)this.getWeek0(), (ALStringField)this.getWeek1(), (ALStringField)this.getWeek2(), (ALStringField)this.getWeek3(), (ALStringField)this.getWeek4(), (ALStringField)this.getWeek5(), (ALStringField)this.getWeek6(), (ALStringField)this.getLimitFlag(), (ALDateField)this.getLimitStartDate(), (ALDateField)this.getLimitEndDate(), (ALNumberField)this.getMonthDay(), this.getLoginUser(), this.entityid, msgList) && this.loadFormData(rundata, context, msgList);
                action.setResultData((Object)this);
                action.addErrorMessages(msgList);
                action.putData(rundata, context);
                return res;
            }
            this.init(action, rundata, context);
            action.setMode("new_form");
            ArrayList msgList = new ArrayList();
            boolean res = this.setFormData(rundata, context, msgList) && ScheduleUtils.validateDelegate((ALDateTimeField)this.getStartDate(), (ALDateTimeField)this.getEndDate(), (ALStringField)this.getRepeatType(), this.isRepeat(), this.isSpan(), (ALStringField)this.getWeek0(), (ALStringField)this.getWeek1(), (ALStringField)this.getWeek2(), (ALStringField)this.getWeek3(), (ALStringField)this.getWeek4(), (ALStringField)this.getWeek5(), (ALStringField)this.getWeek6(), (ALStringField)this.getLimitFlag(), (ALDateField)this.getLimitStartDate(), (ALDateField)this.getLimitEndDate(), (ALNumberField)this.getMonthDay(), this.getLoginUser(), this.entityid, msgList);
            action.setResultData((Object)this);
            action.addErrorMessages(msgList);
            action.putData(rundata, context);
            return res;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        this.is_repeat = rundata.getParameters().getBoolean("is_repeat");
        this.is_span = rundata.getParameters().getBoolean("is_span");
        this.login_user = ALEipUtils.getALEipUser((RunData)rundata);
        this.is_owner = true;
        super.init(action, rundata, context);
        this.entityid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        this.aclPortletFeature = "schedule_self";
    }

    public void setTempView(RunData rundata, Context context) {
        if (rundata.getParameters().getString("view_date") != null) {
            this.tmpView = rundata.getParameters().getString("view_date");
        }
    }

    public void loadParameters(RunData rundata, Context context, ALCellDateTimeField start_date, ALCellDateTimeField end_date) {
        String date = ScheduleUtils.translateDate(start_date.getValue(), "yyyy-MM-dd-HH-mm");
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpStart", (String)date);
        date = ScheduleUtils.translateDate(end_date.getValue(), "yyyy-MM-dd-HH-mm");
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpEnd", (String)date);
        this.tmpStart = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tmpStart");
        this.tmpEnd = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tmpEnd");
        ScheduleUtils.loadParametersViewDate(rundata, context, this.tmpStart, this.tmpView);
    }

    public void loadParameters(RunData rundata, Context context) {
        ScheduleUtils.loadParametersDelegate(rundata, context, this.tmpStart, this.tmpEnd, this.tmpView);
    }

    public void initField() {
        Calendar cal = Calendar.getInstance();
        int min = cal.get(12);
        if (min <= 15) {
            cal.set(12, 15);
        } else if (min <= 30) {
            cal.set(12, 30);
        } else if (min <= 45) {
            cal.set(12, 45);
        } else {
            cal.set(12, 60);
        }
        Date now = cal.getTime();
        this.start_date = new ALCellDateTimeField("yyyy-MM-dd-HH-mm");
        if (this.tmpStart == null || this.tmpStart.equals("")) {
            this.start_date.setValue(now);
        } else {
            this.start_date.setValue(this.tmpStart);
        }
        this.start_date.setFieldName("\u958b\u59cb\u65e5\u6642");
        this.end_date = new ALCellDateTimeField("yyyy-MM-dd-HH-mm");
        if (this.tmpEnd == null || this.tmpEnd.equals("")) {
            if (this.tmpStart == null || this.tmpStart.equals("")) {
                this.end_date.setValue(now);
            } else {
                this.end_date.setValue(this.tmpStart);
            }
        } else {
            this.end_date.setValue(this.tmpEnd);
        }
        this.end_date.setFieldName("\u7d42\u4e86\u65e5\u6642");
        this.repeat_type = new ALCellStringField();
        this.repeat_type.setFieldName("\u7e70\u308a\u8fd4\u3057\u30bf\u30a4\u30d7");
        this.repeat_type.setValue("D");
        this.repeat_type.setTrim(true);
        this.week_0 = new ALCellStringField();
        this.week_0.setFieldName("\u65e5");
        this.week_0.setTrim(true);
        this.week_1 = new ALCellStringField();
        this.week_1.setFieldName("\u6708");
        this.week_1.setTrim(true);
        this.week_2 = new ALCellStringField();
        this.week_2.setFieldName("\u706b");
        this.week_2.setTrim(true);
        this.week_3 = new ALCellStringField();
        this.week_3.setFieldName("\u6c34");
        this.week_3.setTrim(true);
        this.week_4 = new ALCellStringField();
        this.week_4.setFieldName("\u6728");
        this.week_4.setTrim(true);
        this.week_5 = new ALCellStringField();
        this.week_5.setFieldName("\u91d1");
        this.week_5.setTrim(true);
        this.week_6 = new ALCellStringField();
        this.week_6.setFieldName("\u571f");
        this.week_6.setTrim(true);
        this.month_day = new ALCellNumberField();
        this.month_day.setFieldName("\u6bce\u6708\u306e\u65e5");
        this.month_day.limitValue(1L, 31L);
        this.limit_flag = new ALCellStringField();
        this.limit_flag.setFieldName("\u7e70\u308a\u8fd4\u3057");
        this.limit_flag.setValue("OFF");
        this.limit_flag.setTrim(true);
        this.limit_start_date = new ALCellDateField();
        this.limit_start_date.setFieldName("\u7e70\u308a\u8fd4\u3057\u671f\u9650");
        this.limit_start_date.setValue(this.start_date.getValue());
        this.limit_end_date = new ALCellDateField();
        this.limit_end_date.setFieldName("\u7e70\u308a\u8fd4\u3057\u671f\u9650");
        ALCellDateTimeField tmp_date = new ALCellDateTimeField("yyyy-MM-dd-HH-mm");
        if (this.tmpEnd == null || this.tmpEnd.equals("")) {
            if (this.tmpStart == null || this.tmpStart.equals("")) {
                tmp_date.setValue(now);
                this.limit_end_date.setValue(tmp_date.getValue());
            } else {
                tmp_date.setValue(this.tmpStart);
                this.limit_end_date.setValue(tmp_date.getValue());
            }
        } else {
            tmp_date.setValue(this.tmpEnd);
            this.limit_end_date.setValue(tmp_date.getValue());
        }
        this.name = new ALCellStringField();
        this.name.setFieldName("\u4e88\u5b9a");
        this.name.setTrim(true);
        this.place = new ALCellStringField();
        this.place.setFieldName("\u5834\u6240");
        this.place.setTrim(true);
        this.note = new ALCellStringField();
        this.note.setFieldName("\u5185\u5bb9");
        this.note.setTrim(false);
        this.public_flag = new ALCellStringField();
        this.public_flag.setFieldName("\u516c\u958b\u533a\u5206");
        this.public_flag.setTrim(true);
        this.public_flag.setValue("O");
        this.edit_repeat_flag = new ALCellNumberField();
        this.edit_repeat_flag.setFieldName("\u7e70\u308a\u8fd4\u3057\u7de8\u96c6\u7bc4\u56f2");
        this.edit_repeat_flag.setValue(-1L);
        this.view_date = new ALCellDateTimeField("yyyy-MM-dd");
        if (this.tmpView == null || this.tmpView.equals("")) {
            this.view_date.setValue(now);
        } else {
            this.view_date.setValue(this.tmpView);
        }
        this.view_date.setFieldName("\u6307\u5b9a\u65e5\u6642");
        this.edit_flag = new ALCellStringField();
        this.edit_flag.setFieldName("\u7de8\u96c6\uff0f\u524a\u9664\u6a29\u9650");
        this.edit_flag.setTrim(true);
        this.edit_flag.setValue("T");
        this.change_tmpreserve_flag = new ALCellStringField();
        this.change_tmpreserve_flag.setFieldName("\u4eee\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb");
        this.change_tmpreserve_flag.setTrim(true);
        this.change_tmpreserve_flag.setValue("F");
        this.memberList = new ArrayList();
        this.currentYear = Calendar.getInstance().get(1);
        this.del_member_flag = new ALCellNumberField();
        this.del_member_flag.setValue(0L);
        this.del_range_flag = new ALCellNumberField();
        this.del_range_flag.setValue(0L);
        this.del_flag = new ALCellNumberField();
        this.del_flag.setValue(0L);
        this.facilityMemberList = new ArrayList();
        this.common_category_id = new ALCellNumberField();
        this.common_category_id.setFieldName("\u30ab\u30c6\u30b4\u30ea");
        this.common_category_id.setValue(1L);
    }

    protected boolean setFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        Field[] fields = ((Object)((Object)this)).getClass().getDeclaredFields();
        boolean res = ScheduleUtils.setFormDataDelegate(rundata, context, this, fields, msgList);
        if (!res) {
            return res;
        }
        this.memberList = CellScheduleUtils.getShareUserMemberList(rundata);
        if (!this.is_span) {
            Date date = this.start_date.getValue();
            int year = date.getYear();
            int month = date.getMonth();
            int day = date.getDate();
            date = this.end_date.getValue();
            date.setYear(year);
            date.setMonth(month);
            date.setDate(day);
            this.end_date.setValue(date);
            this.tmpScheduleId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            this.facilityMemberList = CellScheduleUtils.getShareFacilityMemberList(rundata);
        }
        return res;
    }

    protected void setValidator() {
        this.getMonthDay().setNotNull(true);
        this.getLimitStartDate().setNotNull(true);
        this.getLimitEndDate().setNotNull(true);
        this.getName().setNotNull(true);
        this.getName().limitMaxLength(50);
        this.getPlace().limitMaxLength(50);
        this.getNote().limitMaxLength(1000);
    }

    protected boolean validate(ArrayList msgList) throws ALDBErrorException, ALPageNotFoundException {
        ScheduleUtils.validateDelegate((ALDateTimeField)this.getStartDate(), (ALDateTimeField)this.getEndDate(), (ALStringField)this.getRepeatType(), this.isRepeat(), this.isSpan(), (ALStringField)this.getWeek0(), (ALStringField)this.getWeek1(), (ALStringField)this.getWeek2(), (ALStringField)this.getWeek3(), (ALStringField)this.getWeek4(), (ALStringField)this.getWeek5(), (ALStringField)this.getWeek6(), (ALStringField)this.getLimitFlag(), (ALDateField)this.getLimitStartDate(), (ALDateField)this.getLimitEndDate(), (ALNumberField)this.getMonthDay(), this.getLoginUser(), this.entityid, msgList);
        this.getName().validate(msgList);
        this.getPlace().validate(msgList);
        this.getNote().validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTSchedule record = ScheduleUtils.getEipTSchedule(rundata, context, false);
            if (record == null) {
                return false;
            }
            this.is_owner = record.getOwnerId().longValue() == this.login_user.getUserId().getValue();
            this.name.setValue(record.getName());
            this.place.setValue(record.getPlace());
            this.note.setValue(record.getNote());
            this.public_flag.setValue(record.getPublicFlag());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) throws ALDBErrorException {
        try {
            if (this.isSpan()) {
                Date startdate = this.getStartDate().getValue();
                startdate.setHours(0);
                startdate.setMinutes(0);
                this.getStartDate().setValue(startdate);
                Date enddate = this.getEndDate().getValue();
                enddate.setHours(0);
                enddate.setMinutes(0);
                this.getEndDate().setValue(enddate);
            } else {
                GregorianCalendar startcal = new GregorianCalendar();
                startcal.setTime(this.getStartDate().getValue());
                Calendar endcal = Calendar.getInstance();
                endcal.setTime(this.getEndDate().getValue());
                endcal.set(1, startcal.get(1));
                endcal.set(2, startcal.get(2));
                endcal.set(5, startcal.get(5));
                this.getEndDate().setValue(endcal.getTime());
            }
            int ownerid = ALEipUtils.getUserId((RunData)rundata);
            EipTSchedule schedule = (EipTSchedule)this.dataContext.createAndRegisterNewObject(EipTSchedule.class);
            schedule.setParentId(Integer.valueOf(0));
            schedule.setName(this.getName().getValue());
            schedule.setPlace(this.getPlace().getValue());
            schedule.setNote(this.getNote().getValue());
            schedule.setPublicFlag(this.getPublicFlag().getValue());
            if (this.getMemberList().size() > 1) {
                schedule.setEditFlag(this.getEditFlag().getValue());
            } else {
                schedule.setEditFlag("F");
            }
            schedule.setOwnerId(Integer.valueOf(ownerid));
            Date now = new Date();
            schedule.setCreateDate(now);
            schedule.setCreateUserId(Integer.valueOf(ownerid));
            schedule.setUpdateDate(now);
            schedule.setUpdateUserId(Integer.valueOf(ownerid));
            if (this.isSpan()) {
                schedule.setEndDate(this.getEndDate().getValue());
                schedule.setRepeatPattern("S");
                schedule.setStartDate(this.getStartDate().getValue());
            } else if (!this.isRepeat()) {
                schedule.setEndDate(this.getEndDate().getValue());
                schedule.setRepeatPattern("N");
                schedule.setStartDate(this.getStartDate().getValue());
            } else {
                char lim = 'N';
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.getEndDate().getValue());
                if ("ON".equals(this.getLimitFlag().getValue())) {
                    lim = 'L';
                    cal.set(this.getLimitEndDate().getValue().getYear(), this.getLimitEndDate().getValue().getMonth() - 1, this.getLimitEndDate().getValue().getDay());
                    ALDateContainer container = this.getLimitStartDate().getValue();
                    Calendar limitStartCal = Calendar.getInstance();
                    limitStartCal.setTime(this.getStartDate().getValue());
                    limitStartCal.set(1, container.getYear());
                    limitStartCal.set(2, container.getMonth() - 1);
                    limitStartCal.set(5, container.getDay());
                    schedule.setStartDate(limitStartCal.getTime());
                } else {
                    schedule.setStartDate(this.getStartDate().getValue());
                }
                schedule.setEndDate(cal.getTime());
                if ("D".equals(this.getRepeatType().getValue())) {
                    schedule.setRepeatPattern(new StringBuffer().append('D').append(lim).toString());
                } else if ("W".equals(this.getRepeatType().getValue())) {
                    schedule.setRepeatPattern(new StringBuffer().append('W').append(this.getWeek0().getValue() != null ? 1 : 0).append(this.getWeek1().getValue() != null ? 1 : 0).append(this.getWeek2().getValue() != null ? 1 : 0).append(this.getWeek3().getValue() != null ? 1 : 0).append(this.getWeek4().getValue() != null ? 1 : 0).append(this.getWeek5().getValue() != null ? 1 : 0).append(this.getWeek6().getValue() != null ? 1 : 0).append(lim).toString());
                } else {
                    DecimalFormat format = new DecimalFormat("00");
                    schedule.setRepeatPattern(new StringBuffer().append('M').append(format.format(this.month_day.getValue())).append(lim).toString());
                }
            }
            EipTCommonCategory category1 = CommonCategoryUtils.getEipTCommonCategory((DataContext)this.dataContext, (Long)1L);
            int size = this.getMemberList().size();
            for (int i = 0; i < size; ++i) {
                EipTScheduleMap map = (EipTScheduleMap)this.dataContext.createAndRegisterNewObject(EipTScheduleMap.class);
                ALEipUser user = (ALEipUser)this.getMemberList().get(i);
                int userid = (int)user.getUserId().getValue();
                map.setEipTSchedule(schedule);
                map.setUserId(Integer.valueOf(userid));
                if (userid == ALEipUtils.getUserId((RunData)rundata)) {
                    map.setStatus("O");
                } else {
                    map.setStatus("T");
                }
                EipTCommonCategory category = CommonCategoryUtils.getEipTCommonCategory((DataContext)this.dataContext, (Long)this.common_category_id.getValue());
                if (category == null) {
                    map.setCommonCategoryId(Integer.valueOf(1));
                    map.setEipTSchedule(schedule);
                    map.setEipTCommonCategory(category1);
                } else {
                    map.setCommonCategoryId(Integer.valueOf((int)this.common_category_id.getValue()));
                    map.setEipTSchedule(schedule);
                    map.setEipTCommonCategory(category);
                }
                map.setType("U");
            }
            int f_size = this.facilityMemberList.size();
            for (int i = 0; i < f_size; ++i) {
                EipTScheduleMap map = (EipTScheduleMap)this.dataContext.createAndRegisterNewObject(EipTScheduleMap.class);
                FacilityResultData frd = (FacilityResultData)this.facilityMemberList.get(i);
                int facilityid = (int)frd.getFacilityId().getValue();
                map.setEipTSchedule(schedule);
                map.setUserId(Integer.valueOf(facilityid));
                map.setStatus("O");
                map.setType("F");
                map.setEipTCommonCategory(category1);
                map.setCommonCategoryId(Integer.valueOf(1));
            }
            this.dataContext.commitChanges();
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"mode", (String)"insert");
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(schedule.getScheduleId().intValue(), 240, schedule.getName());
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            List userIds = aclhandler.getAcceptUserIdsInListExceptLoginUser(this.dataContext, (int)this.login_user.getUserId().getValue(), "schedule_self", 2, (List)this.memberList);
            int u_size = userIds.size();
            for (int i = 0; i < u_size; ++i) {
                Integer _id = (Integer)userIds.get(i);
                WhatsNewUtils.insertWhatsNew((DataContext)this.dataContext, (int)6, (int)schedule.getScheduleId(), (int)_id);
            }
        }
        catch (Exception e) {
            logger.error((Object)"[CellScheduleFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            if (this.isSpan()) {
                Date startdate = this.start_date.getValue();
                startdate.setHours(0);
                startdate.setMinutes(0);
                this.start_date.setValue(startdate);
                Date enddate = this.end_date.getValue();
                enddate.setHours(0);
                enddate.setMinutes(0);
                this.end_date.setValue(enddate);
            } else {
                GregorianCalendar startcal = new GregorianCalendar();
                startcal.setTime(this.start_date.getValue());
                Calendar endcal = Calendar.getInstance();
                endcal.setTime(this.end_date.getValue());
                endcal.set(1, startcal.get(1));
                endcal.set(2, startcal.get(2));
                endcal.set(5, startcal.get(5));
                this.end_date.setValue(endcal.getTime());
            }
            EipTSchedule schedule = ScheduleUtils.getEipTSchedule(rundata, context, false);
            if (schedule == null) {
                return false;
            }
            int ownerid = ALEipUtils.getUserId((RunData)rundata);
            if (ownerid != schedule.getOwnerId() && "F".equals(schedule.getEditFlag())) {
                return true;
            }
            EipTCommonCategory category1 = CommonCategoryUtils.getEipTCommonCategory((DataContext)this.dataContext, (Long)1L);
            if (this.edit_repeat_flag.getValue() == 1L) {
                int i;
                EipTSchedule newSchedule = (EipTSchedule)this.dataContext.createAndRegisterNewObject(EipTSchedule.class);
                newSchedule.setParentId(schedule.getScheduleId());
                newSchedule.setName(this.name.getValue());
                newSchedule.setPlace(this.place.getValue());
                newSchedule.setNote(this.note.getValue());
                newSchedule.setPublicFlag(this.public_flag.getValue());
                newSchedule.setEditFlag("F");
                newSchedule.setOwnerId(Integer.valueOf(ownerid));
                Date now = new Date();
                newSchedule.setCreateDate(now);
                newSchedule.setCreateUserId(Integer.valueOf(ownerid));
                newSchedule.setUpdateDate(now);
                newSchedule.setUpdateUserId(Integer.valueOf(ownerid));
                newSchedule.setEndDate(this.end_date.getValue());
                newSchedule.setRepeatPattern("N");
                newSchedule.setStartDate(this.start_date.getValue());
                int allsize = this.memberList.size() + this.facilityMemberList.size();
                if (allsize > 0) {
                    int size = this.memberList.size();
                    List scheduleMaps = schedule.getEipTScheduleMaps();
                    for (int i2 = 0; i2 < size; ++i2) {
                        EipTScheduleMap map = (EipTScheduleMap)this.dataContext.createAndRegisterNewObject(EipTScheduleMap.class);
                        ALEipUser user = (ALEipUser)this.memberList.get(i2);
                        int userid = (int)user.getUserId().getValue();
                        map.setEipTSchedule(newSchedule);
                        map.setUserId(Integer.valueOf(userid));
                        if (userid == ALEipUtils.getUserId((RunData)rundata)) {
                            map.setStatus("O");
                        } else if ("T".equals(this.change_tmpreserve_flag.getValue())) {
                            map.setStatus("T");
                        } else {
                            EipTScheduleMap tmpMap = this.getScheduleMap(scheduleMaps, userid);
                            if (tmpMap != null) {
                                map.setStatus(tmpMap.getStatus());
                            } else {
                                map.setStatus("T");
                            }
                        }
                        EipTCommonCategory category = CommonCategoryUtils.getEipTCommonCategory((DataContext)this.dataContext, (Long)this.common_category_id.getValue());
                        if (category == null) {
                            map.setCommonCategoryId(Integer.valueOf(1));
                            map.setEipTCommonCategory(category1);
                        } else {
                            map.setCommonCategoryId(Integer.valueOf((int)this.common_category_id.getValue()));
                            map.setEipTCommonCategory(category);
                        }
                        map.setType("U");
                    }
                    int f_size = this.facilityMemberList.size();
                    for (i = 0; i < f_size; ++i) {
                        EipTScheduleMap map = (EipTScheduleMap)this.dataContext.createAndRegisterNewObject(EipTScheduleMap.class);
                        FacilityResultData frd = (FacilityResultData)this.facilityMemberList.get(i);
                        int facilityid = (int)frd.getFacilityId().getValue();
                        map.setEipTSchedule(newSchedule);
                        map.setUserId(Integer.valueOf(facilityid));
                        map.setStatus("O");
                        map.setType("F");
                        map.setEipTCommonCategory(category1);
                        map.setCommonCategoryId(Integer.valueOf(1));
                    }
                }
                List scheduleMaps = schedule.getEipTScheduleMaps();
                int scheduleMapsSize = scheduleMaps.size();
                ArrayList<Integer> memberIdList = new ArrayList<Integer>();
                for (i = 0; i < scheduleMapsSize; ++i) {
                    memberIdList.add(((EipTScheduleMap)scheduleMaps.get(i)).getUserId());
                }
                int memberListSize = this.memberList.size();
                for (int i3 = 0; i3 < memberListSize; ++i3) {
                    int memberId = (int)((ALEipUser)this.memberList.get(i3)).getUserId().getValue();
                    if (ScheduleUtils.isContains(memberIdList, memberId)) continue;
                    memberIdList.add(memberId);
                }
                int memberIdListSize = memberIdList.size();
                int[] memberIds = new int[memberIdListSize];
                for (int i4 = 0; i4 < memberIdListSize; ++i4) {
                    memberIds[i4] = (Integer)memberIdList.get(i4);
                }
                ScheduleUtils.insertDummySchedule(schedule, ownerid, this.view_date.getValue(), this.view_date.getValue(), memberIds);
            } else {
                schedule.setName(this.name.getValue());
                schedule.setPlace(this.place.getValue());
                schedule.setNote(this.note.getValue());
                schedule.setPublicFlag(this.public_flag.getValue());
                if (schedule.getOwnerId() == ALEipUtils.getUserId((RunData)rundata) || schedule.getOwnerId() == 0) {
                    schedule.setEditFlag(this.edit_flag.getValue());
                }
                int ownerUserId = schedule.getOwnerId();
                boolean rejectOwnerUser = false;
                List tmpScheduleMaps = schedule.getEipTScheduleMaps();
                for (int i = 0; i < tmpScheduleMaps.size(); ++i) {
                    EipTScheduleMap map = (EipTScheduleMap)tmpScheduleMaps.get(i);
                    if (ownerUserId != map.getUserId() || !"R".equals(map.getStatus())) continue;
                    rejectOwnerUser = true;
                    break;
                }
                boolean includeOwnerUser = false;
                int membersSize = this.memberList.size();
                ALEipUser eipUser = null;
                for (int i = 0; i < membersSize; ++i) {
                    eipUser = (ALEipUser)this.memberList.get(i);
                    if ((long)ownerUserId != eipUser.getUserId().getValue()) continue;
                    includeOwnerUser = true;
                    break;
                }
                if (rejectOwnerUser || !includeOwnerUser) {
                    schedule.setOwnerId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
                }
                schedule.setUpdateDate(new Date());
                schedule.setUpdateUserId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
                if (this.is_span) {
                    schedule.setEndDate(this.end_date.getValue());
                    schedule.setRepeatPattern("S");
                    schedule.setStartDate(this.start_date.getValue());
                } else if (!this.is_repeat) {
                    schedule.setEndDate(this.end_date.getValue());
                    schedule.setRepeatPattern("N");
                    schedule.setStartDate(this.start_date.getValue());
                } else {
                    String tmpPattern;
                    char lim = 'N';
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(this.end_date.getValue());
                    if ("ON".equals(this.limit_flag.getValue())) {
                        lim = 'L';
                        cal.set(this.limit_end_date.getValue().getYear(), this.limit_end_date.getValue().getMonth() - 1, this.limit_end_date.getValue().getDay());
                        ALDateContainer container = this.limit_start_date.getValue();
                        Calendar limitStartCal = Calendar.getInstance();
                        limitStartCal.setTime(this.start_date.getValue());
                        limitStartCal.set(1, container.getYear());
                        limitStartCal.set(2, container.getMonth() - 1);
                        limitStartCal.set(5, container.getDay());
                        schedule.setStartDate(limitStartCal.getTime());
                    } else {
                        schedule.setStartDate(this.start_date.getValue());
                    }
                    schedule.setEndDate(cal.getTime());
                    if ("D".equals(this.repeat_type.getValue())) {
                        tmpPattern = new StringBuffer().append('D').append(lim).toString();
                        schedule.setRepeatPattern(tmpPattern);
                    } else if ("W".equals(this.repeat_type.getValue())) {
                        tmpPattern = new StringBuffer().append('W').append(this.week_0.getValue() != null ? 1 : 0).append(this.week_1.getValue() != null ? 1 : 0).append(this.week_2.getValue() != null ? 1 : 0).append(this.week_3.getValue() != null ? 1 : 0).append(this.week_4.getValue() != null ? 1 : 0).append(this.week_5.getValue() != null ? 1 : 0).append(this.week_6.getValue() != null ? 1 : 0).append(lim).toString();
                        schedule.setRepeatPattern(tmpPattern);
                    } else {
                        DecimalFormat format = new DecimalFormat("00");
                        schedule.setRepeatPattern(new StringBuffer().append('M').append(format.format(this.month_day.getValue())).append(lim).toString());
                    }
                }
                List scheduleMaps = schedule.getEipTScheduleMaps();
                SelectQuery query = new SelectQuery(EipTScheduleMap.class);
                Expression exp = ExpressionFactory.matchExp((String)"scheduleId", (Object)schedule.getScheduleId());
                query.setQualifier(exp);
                List schedulemaps = this.dataContext.performQuery((Query)query);
                this.dataContext.deleteObjects((Collection)schedulemaps);
                int size = this.memberList.size();
                for (int i = 0; i < size; ++i) {
                    EipTScheduleMap map = (EipTScheduleMap)this.dataContext.createAndRegisterNewObject(EipTScheduleMap.class);
                    ALEipUser user = (ALEipUser)this.memberList.get(i);
                    int userid = (int)user.getUserId().getValue();
                    map.setEipTSchedule(schedule);
                    map.setUserId(Integer.valueOf(userid));
                    if (userid == schedule.getOwnerId()) {
                        map.setStatus("O");
                    } else if ("T".equals(this.change_tmpreserve_flag.getValue())) {
                        map.setStatus("T");
                    } else {
                        EipTScheduleMap tmpMap = this.getScheduleMap(schedulemaps, userid);
                        if (tmpMap != null) {
                            map.setStatus(tmpMap.getStatus());
                        } else {
                            map.setStatus("T");
                        }
                    }
                    EipTCommonCategory category = CommonCategoryUtils.getEipTCommonCategory((DataContext)this.dataContext, (Long)this.common_category_id.getValue());
                    if (category == null) {
                        map.setCommonCategoryId(Integer.valueOf(1));
                        map.setEipTSchedule(schedule);
                        map.setEipTCommonCategory(category1);
                    } else {
                        map.setCommonCategoryId(Integer.valueOf((int)this.common_category_id.getValue()));
                        map.setEipTSchedule(schedule);
                        map.setEipTCommonCategory(category);
                    }
                    map.setType("U");
                }
                int f_size = this.facilityMemberList.size();
                for (int i = 0; i < f_size; ++i) {
                    EipTScheduleMap map = (EipTScheduleMap)this.dataContext.createAndRegisterNewObject(EipTScheduleMap.class);
                    FacilityResultData frd = (FacilityResultData)this.facilityMemberList.get(i);
                    int facilityid = (int)frd.getFacilityId().getValue();
                    map.setEipTSchedule(schedule);
                    map.setUserId(Integer.valueOf(facilityid));
                    map.setStatus("O");
                    map.setType("F");
                    map.setEipTCommonCategory(category1);
                    map.setCommonCategoryId(Integer.valueOf(1));
                }
            }
            this.dataContext.commitChanges();
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"mode", (String)"update");
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(schedule.getScheduleId().intValue(), 240, schedule.getName());
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            List userIds = aclhandler.getAcceptUserIdsInListExceptLoginUser(this.dataContext, (int)this.login_user.getUserId().getValue(), "schedule_self", 2, (List)this.memberList);
            int u_size = userIds.size();
            for (int i = 0; i < u_size; ++i) {
                Integer _id = (Integer)userIds.get(i);
                WhatsNewUtils.insertWhatsNew((DataContext)this.dataContext, (int)6, (int)schedule.getScheduleId(), (int)_id);
            }
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    private EipTScheduleMap getScheduleMap(List scheduleMaps, int userid) {
        EipTScheduleMap map = null;
        int size = scheduleMaps.size();
        for (int i = 0; i < size; ++i) {
            map = (EipTScheduleMap)scheduleMaps.get(i);
            if (map.getUserId() != userid) continue;
            return map;
        }
        return null;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            if (rundata.getParameters().containsKey((Object)"del_flag")) {
                this.del_flag.setValue(rundata.getParameters().getString("del_flag"));
            }
            if (this.del_flag.getValue() == 1L) {
                this.del_member_flag.setValue(0L);
                this.del_range_flag.setValue(1L);
            } else if (this.del_flag.getValue() == 2L) {
                this.del_member_flag.setValue(1L);
                this.del_range_flag.setValue(0L);
            } else if (this.del_flag.getValue() == 3L) {
                this.del_member_flag.setValue(1L);
                this.del_range_flag.setValue(1L);
            } else {
                this.del_member_flag.setValue(0L);
                this.del_range_flag.setValue(0L);
            }
            EipTSchedule schedule = ScheduleUtils.getEipTSchedule(rundata, context, false);
            if (schedule == null) {
                return false;
            }
            List members = ScheduleUtils.getUsers(rundata, context, true);
            if (members != null && members.size() > 0) {
                this.memberList.addAll(members);
            }
            boolean isMember = false;
            int loginuserId = (int)this.login_user.getUserId().getValue();
            int membersSize = this.memberList.size();
            ALEipUser eipUser = null;
            for (int i = 0; i < membersSize; ++i) {
                eipUser = (ALEipUser)this.memberList.get(i);
                if ((long)loginuserId != eipUser.getUserId().getValue()) continue;
                isMember = true;
                break;
            }
            if (!isMember) {
                logger.error((Object)"[ScheduleFormData] ALPageNotFoundException: The user does not have the auth to delete the schedule.");
                throw new ALPageNotFoundException();
            }
            if (loginuserId != schedule.getOwnerId() && "F".equals(schedule.getEditFlag()) && 1L != this.del_member_flag.getValue()) {
                return true;
            }
            int delFlag = -1;
            delFlag = this.del_member_flag.getValue() == 0L ? (this.del_range_flag.getValue() == 0L ? 0 : 1) : (this.del_range_flag.getValue() == 0L ? 2 : 3);
            if (delFlag == 0) {
                this.deleteSchedule(schedule);
            } else if (delFlag == 1) {
                if (!"N".equals(schedule.getRepeatPattern())) {
                    int ownerid = ALEipUtils.getUserId((RunData)rundata);
                    int memberIdListSize = this.memberList.size();
                    int[] memberIdList = new int[memberIdListSize];
                    for (int i = 0; i < memberIdListSize; ++i) {
                        memberIdList[i] = (int)((ALEipUser)this.memberList.get(i)).getUserId().getValue();
                    }
                    ScheduleUtils.insertDummySchedule(schedule, ownerid, this.view_date.getValue(), this.view_date.getValue(), memberIdList);
                }
            } else if (delFlag == 2) {
                List scheduleMaps = ScheduleUtils.getEipTScheduleMaps(schedule);
                schedule.getScheduleId();
                if (scheduleMaps != null && scheduleMaps.size() > 0) {
                    int countRejectSchedule = 0;
                    ArrayList<EipTScheduleMap> tmpScheduleMap = new ArrayList<EipTScheduleMap>();
                    for (int i = 0; i < scheduleMaps.size(); ++i) {
                        EipTScheduleMap scheduleMap = (EipTScheduleMap)scheduleMaps.get(i);
                        if (!"U".equals(scheduleMap.getType())) continue;
                        tmpScheduleMap.add(scheduleMap);
                        if (!"R".equals(scheduleMap.getStatus())) continue;
                        ++countRejectSchedule;
                    }
                    int scheduleMapsSize = tmpScheduleMap.size();
                    if (countRejectSchedule >= scheduleMapsSize - 1) {
                        this.deleteSchedule(schedule);
                    } else {
                        for (int i = 0; i < scheduleMapsSize; ++i) {
                            EipTScheduleMap scheduleMap = (EipTScheduleMap)scheduleMaps.get(i);
                            if ((long)scheduleMap.getUserId().intValue() != this.login_user.getUserId().getValue() || (long)scheduleMap.getUserId().intValue() != this.login_user.getUserId().getValue() && (long)schedule.getCreateUserId().intValue() != this.login_user.getUserId().getValue()) continue;
                            if ("O".equals(scheduleMap.getStatus())) {
                                schedule.setOwnerId(Integer.valueOf(0));
                                if ("F".equals(schedule.getEditFlag())) {
                                    schedule.setEditFlag("T");
                                }
                            }
                            scheduleMap.setStatus("R");
                        }
                    }
                }
            } else if (delFlag == 3) {
                if (!"N".equals(schedule.getRepeatPattern())) {
                    int ownerid = ALEipUtils.getUserId((RunData)rundata);
                    this.memberList.clear();
                    this.memberList.add(this.login_user);
                    int memberIdListSize = this.memberList.size();
                    int[] memberIdList = new int[memberIdListSize];
                    for (int i = 0; i < memberIdListSize; ++i) {
                        memberIdList[i] = (int)((ALEipUser)this.memberList.get(i)).getUserId().getValue();
                    }
                    ScheduleUtils.insertDummySchedule(schedule, ownerid, this.view_date.getValue(), this.view_date.getValue(), memberIdList);
                }
            } else {
                this.dataContext.deleteObject((Persistent)schedule);
            }
            this.dataContext.commitChanges();
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"mode", (String)"delete");
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(schedule.getScheduleId().intValue(), 240, schedule.getName());
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    private void deleteSchedule(EipTSchedule schedule) {
        int scheduleId = schedule.getScheduleId();
        this.dataContext.deleteObject((Persistent)schedule);
        SelectQuery query = new SelectQuery(EipTSchedule.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"parentId", (Object)scheduleId);
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"eipTScheduleMaps.status", (Object)"D");
        query.andQualifier(exp2);
        List dellist = this.dataContext.performQuery((Query)query);
        if (dellist != null && dellist.size() > 0) {
            this.dataContext.deleteObjects((Collection)dellist);
        }
    }

    public void setScheduleType(boolean is_repeat, boolean is_span) {
        this.is_repeat = is_repeat;
        this.is_span = is_span;
    }

    public ALCellDateTimeField getStartDate() {
        return this.start_date;
    }

    public String getStartDateDate() {
        try {
            return ScheduleUtils.translateDate(this.start_date.getValue(), "yyyyMMdd");
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getStartDateTime() {
        try {
            return ScheduleUtils.translateDate(this.start_date.getValue(), "HHmm");
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getStartDateDate2() {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.end_date.getValue());
            return ScheduleUtils.translateDate(this.start_date.getValue(), "yyyy/MM/dd") + ALDateUtil.getDayOfWeek((Calendar)cal);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getStartDateTime2() {
        try {
            return ScheduleUtils.translateDate(this.start_date.getValue(), "HH:mm");
        }
        catch (Exception e) {
            return "";
        }
    }

    public ALCellDateTimeField getEndDate() {
        return this.end_date;
    }

    public String getEndDateDate() {
        try {
            return ScheduleUtils.translateDate(this.end_date.getValue(), "yyyyMMdd");
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getEndDateTime() {
        try {
            return ScheduleUtils.translateDate(this.end_date.getValue(), "HHmm");
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getEndDateDate2() {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.end_date.getValue());
            return ScheduleUtils.translateDate(this.end_date.getValue(), "yyyy/MM/dd") + ALDateUtil.getDayOfWeek((Calendar)cal);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getEndDateTime2() {
        try {
            return ScheduleUtils.translateDate(this.end_date.getValue(), "HH:mm");
        }
        catch (Exception e) {
            return "";
        }
    }

    public List getMemberList() {
        return this.memberList;
    }

    public List getUsers(String groupname) {
        return ALEipUtils.getUsers((String)groupname);
    }

    public Map getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public ALCellStringField getName() {
        return this.name;
    }

    public ALCellStringField getNote() {
        return this.note;
    }

    public ALCellStringField getPlace() {
        return this.place;
    }

    public int getCurrentYear() {
        return this.currentYear;
    }

    public boolean isMember() {
        return this.is_member || this.memberList.size() > 1;
    }

    public boolean isOwner() {
        return this.is_owner;
    }

    public ALEipUser getLoginUser() {
        return this.login_user;
    }

    public ScheduleOnedayGroupSelectData getSelectData() {
        return this.selectData;
    }

    public ALCellStringField getPublicFlag() {
        return this.public_flag;
    }

    public boolean isRepeat() {
        return this.is_repeat;
    }

    public boolean isSpan() {
        return this.is_span;
    }

    public ALCellDateField getLimitStartDate() {
        return this.limit_start_date;
    }

    public String getLimitStartDateDate() {
        try {
            return ScheduleUtils.translateDate(this.limit_start_date.getValue().getDate(), "yyyyMMdd");
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getLimitStartDateDate2() {
        try {
            return ScheduleUtils.translateDate(this.limit_start_date.getValue().getDate(), "yyyy/MM/dd");
        }
        catch (Exception e) {
            return "";
        }
    }

    public ALCellDateField getLimitEndDate() {
        return this.limit_end_date;
    }

    public String getLimitEndDateDate() {
        try {
            return ScheduleUtils.translateDate(this.limit_end_date.getValue().getDate(), "yyyyMMdd");
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getLimitEndDateDate2() {
        try {
            return ScheduleUtils.translateDate(this.limit_end_date.getValue().getDate(), "yyyy/MM/dd");
        }
        catch (Exception e) {
            return "";
        }
    }

    public ALCellStringField getLimitFlag() {
        return this.limit_flag;
    }

    public ALCellNumberField getMonthDay() {
        return this.month_day;
    }

    public ALCellStringField getRepeatType() {
        return this.repeat_type;
    }

    public ALCellStringField getWeek0() {
        return this.week_0;
    }

    public ALCellStringField getWeek1() {
        return this.week_1;
    }

    public ALCellStringField getWeek2() {
        return this.week_2;
    }

    public ALCellStringField getWeek3() {
        return this.week_3;
    }

    public ALCellStringField getWeek4() {
        return this.week_4;
    }

    public ALCellStringField getWeek5() {
        return this.week_5;
    }

    public ALCellStringField getWeek6() {
        return this.week_6;
    }

    public List getGroupList() {
        return this.groups;
    }

    public ALCellNumberField getEditRepeatFlag() {
        return this.edit_repeat_flag;
    }

    public ALCellStringField getEditFlag() {
        return this.edit_flag;
    }

    public ALCellStringField getChangeTmpreserveFlag() {
        return this.change_tmpreserve_flag;
    }

    public ALCellDateTimeField getViewDate() {
        return this.view_date;
    }

    public int getInt(long num) {
        return (int)num;
    }

    public void setScheduleType(RunData rundata) {
        this.setScheduleType(rundata.getParameters().getBoolean("is_repeat"), rundata.getParameters().getBoolean("is_span"));
    }

    public String getEntityId() {
        return this.entityid;
    }

    public List getFacilityMemberList() {
        return this.facilityMemberList;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }
}

