/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALCellDateField;
import com.aimluck.commons.field.ALCellDateTimeField;
import com.aimluck.commons.field.ALCellNumberField;
import com.aimluck.commons.field.ALCellStringField;
import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.schedule.ScheduleOnedayGroupSelectData;
import com.aimluck.eip.schedule.util.CellScheduleUtils;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CellScheduleFormMemberData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CellScheduleFormMemberData.class.getName());
    private static final int FLAG_EDIT_REPEAT_DEF = -1;
    private static final int FLAG_EDIT_REPEAT_ALL = 0;
    private static final int FLAG_EDIT_REPEAT_ONE = 1;
    public static final int FLAG_DEL_MEMBER_ALL = 0;
    public static final int FLAG_DEL_MEMBER_ONE = 1;
    public static final int FLAG_DEL_RANGE_ALL = 0;
    public static final int FLAG_DEL_RANGE_ONE = 1;
    private ALCellDateTimeField start_date;
    private ALCellDateTimeField end_date;
    private ALCellStringField repeat_type;
    private ALCellStringField week_0;
    private ALCellStringField week_1;
    private ALCellStringField week_2;
    private ALCellStringField week_3;
    private ALCellStringField week_4;
    private ALCellStringField week_5;
    private ALCellStringField week_6;
    private ALCellStringField limit_flag;
    private ALCellDateField limit_start_date;
    private ALCellDateField limit_end_date;
    private ALCellNumberField month_day;
    private ArrayList memberList;
    private ArrayList facilityMemberList;
    private int currentYear;
    private boolean is_member;
    private boolean is_repeat;
    private boolean is_span;
    private ALEipUser login_user;
    private String tmpStart;
    private String tmpEnd;
    private ScheduleOnedayGroupSelectData selectData;
    private String tmpScheduleId;
    private List groups;
    private ALCellNumberField edit_repeat_flag;
    private String tmpView;
    private ALCellDateTimeField view_date;
    private ALCellStringField edit_flag;
    private ALCellStringField change_tmpreserve_flag;
    private boolean is_owner;
    private ALCellStringField selectedgroup;
    private int rows_num = 10;
    private int start;
    private int count;
    private int pages_num = 1;
    private int current_page = 1;
    protected String entityid;

    public boolean doViewForm(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            boolean isedit = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid") != null;
            action.setMode(isedit ? "edit_form" : "new_form");
            this.setMode(action.getMode());
            ArrayList msgList = new ArrayList();
            boolean res = this.setFormData(rundata, context, msgList) && ScheduleUtils.validateDelegate((ALDateTimeField)this.getStartDate(), (ALDateTimeField)this.getEndDate(), (ALStringField)this.getRepeatType(), this.isRepeat(), this.isSpan(), (ALStringField)this.getWeek0(), (ALStringField)this.getWeek1(), (ALStringField)this.getWeek2(), (ALStringField)this.getWeek3(), (ALStringField)this.getWeek4(), (ALStringField)this.getWeek5(), (ALStringField)this.getWeek6(), (ALStringField)this.getLimitFlag(), (ALDateField)this.getLimitStartDate(), (ALDateField)this.getLimitEndDate(), (ALNumberField)this.getMonthDay(), this.getLoginUser(), this.entityid, msgList);
            action.setResultData((Object)this);
            action.addErrorMessages(msgList);
            action.putData(rundata, context);
            return res;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        this.is_member = rundata.getParameters().getBoolean("is_member");
        this.is_repeat = rundata.getParameters().getBoolean("is_repeat");
        this.is_span = rundata.getParameters().getBoolean("is_span");
        this.login_user = ALEipUtils.getALEipUser((RunData)rundata);
        this.groups = ALEipUtils.getMyGroups((RunData)rundata);
        this.is_owner = true;
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"start")) {
            this.current_page = rundata.getParameters().getInt("start");
        }
        super.init(action, rundata, context);
        this.entityid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
    }

    public void loadParameters(RunData rundata, Context context) {
        ScheduleUtils.loadParametersDelegate(rundata, context, this.tmpStart, this.tmpEnd, this.tmpView);
    }

    public void initField() {
        Calendar cal = Calendar.getInstance();
        int min = cal.get(12);
        if (min <= 15) {
            cal.set(12, 15);
        } else if (min <= 30) {
            cal.set(12, 30);
        } else if (min <= 45) {
            cal.set(12, 45);
        } else {
            cal.set(12, 60);
        }
        Date now = cal.getTime();
        this.start_date = new ALCellDateTimeField("yyyy-MM-dd-HH-mm");
        if (this.tmpStart == null || this.tmpStart.equals("")) {
            this.start_date.setValue(now);
        } else {
            this.start_date.setValue(this.tmpStart);
        }
        this.start_date.setFieldName("\u958b\u59cb\u65e5\u6642");
        this.end_date = new ALCellDateTimeField("yyyy-MM-dd-HH-mm");
        if (this.tmpEnd == null || this.tmpEnd.equals("")) {
            if (this.tmpStart == null || this.tmpStart.equals("")) {
                this.end_date.setValue(now);
            } else {
                this.end_date.setValue(this.tmpStart);
            }
        } else {
            this.end_date.setValue(this.tmpEnd);
        }
        this.end_date.setFieldName("\u7d42\u4e86\u65e5\u6642");
        this.repeat_type = new ALCellStringField();
        this.repeat_type.setFieldName("\u7e70\u308a\u8fd4\u3057\u30bf\u30a4\u30d7");
        this.repeat_type.setValue("D");
        this.repeat_type.setTrim(true);
        this.week_0 = new ALCellStringField();
        this.week_0.setFieldName("\u65e5");
        this.week_0.setTrim(true);
        this.week_1 = new ALCellStringField();
        this.week_1.setFieldName("\u6708");
        this.week_1.setTrim(true);
        this.week_2 = new ALCellStringField();
        this.week_2.setFieldName("\u706b");
        this.week_2.setTrim(true);
        this.week_3 = new ALCellStringField();
        this.week_3.setFieldName("\u6c34");
        this.week_3.setTrim(true);
        this.week_4 = new ALCellStringField();
        this.week_4.setFieldName("\u6728");
        this.week_4.setTrim(true);
        this.week_5 = new ALCellStringField();
        this.week_5.setFieldName("\u91d1");
        this.week_5.setTrim(true);
        this.week_6 = new ALCellStringField();
        this.week_6.setFieldName("\u571f");
        this.week_6.setTrim(true);
        this.month_day = new ALCellNumberField();
        this.month_day.setFieldName("\u6bce\u6708\u306e\u65e5");
        this.month_day.limitValue(1L, 31L);
        this.limit_flag = new ALCellStringField();
        this.limit_flag.setFieldName("\u7e70\u308a\u8fd4\u3057");
        this.limit_flag.setValue("OFF");
        this.limit_flag.setTrim(true);
        this.limit_start_date = new ALCellDateField();
        this.limit_start_date.setFieldName("\u7e70\u308a\u8fd4\u3057\u671f\u9650");
        this.limit_start_date.setValue(this.start_date.getValue());
        this.limit_end_date = new ALCellDateField();
        this.limit_end_date.setFieldName("\u7e70\u308a\u8fd4\u3057\u671f\u9650");
        ALCellDateTimeField tmp_date = new ALCellDateTimeField("yyyy-MM-dd-HH-mm");
        if (this.tmpEnd == null || this.tmpEnd.equals("")) {
            if (this.tmpStart == null || this.tmpStart.equals("")) {
                tmp_date.setValue(now);
                this.limit_end_date.setValue(tmp_date.getValue());
            } else {
                tmp_date.setValue(this.tmpStart);
                this.limit_end_date.setValue(tmp_date.getValue());
            }
        } else {
            tmp_date.setValue(this.tmpEnd);
            this.limit_end_date.setValue(tmp_date.getValue());
        }
        this.edit_repeat_flag = new ALCellNumberField();
        this.edit_repeat_flag.setFieldName("\u7e70\u308a\u8fd4\u3057\u7de8\u96c6\u7bc4\u56f2");
        this.edit_repeat_flag.setValue(-1L);
        this.view_date = new ALCellDateTimeField("yyyy-MM-dd");
        if (this.tmpView == null || this.tmpView.equals("")) {
            this.view_date.setValue(now);
        } else {
            this.view_date.setValue(this.tmpView);
        }
        this.view_date.setFieldName("\u6307\u5b9a\u65e5\u6642");
        this.edit_flag = new ALCellStringField();
        this.edit_flag.setFieldName("\u7de8\u96c6\uff0f\u524a\u9664\u6a29\u9650");
        this.edit_flag.setTrim(true);
        this.edit_flag.setValue("T");
        this.change_tmpreserve_flag = new ALCellStringField();
        this.change_tmpreserve_flag.setFieldName("\u4eee\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb");
        this.change_tmpreserve_flag.setTrim(true);
        this.change_tmpreserve_flag.setValue("F");
        this.memberList = new ArrayList();
        this.currentYear = Calendar.getInstance().get(1);
        this.selectedgroup = new ALCellStringField();
        this.selectedgroup.setFieldName("\u30b0\u30eb\u30fc\u30d7");
        this.facilityMemberList = new ArrayList();
    }

    protected void setValidator() {
        this.month_day.setNotNull(true);
        this.limit_start_date.setNotNull(true);
        this.limit_end_date.setNotNull(true);
    }

    protected boolean validate(ArrayList msgList) throws ALDBErrorException, ALPageNotFoundException {
        return ScheduleUtils.validateDelegate((ALDateTimeField)this.getStartDate(), (ALDateTimeField)this.getEndDate(), (ALStringField)this.getRepeatType(), this.isRepeat(), this.isSpan(), (ALStringField)this.getWeek0(), (ALStringField)this.getWeek1(), (ALStringField)this.getWeek2(), (ALStringField)this.getWeek3(), (ALStringField)this.getWeek4(), (ALStringField)this.getWeek5(), (ALStringField)this.getWeek6(), (ALStringField)this.getLimitFlag(), (ALDateField)this.getLimitStartDate(), (ALDateField)this.getLimitEndDate(), (ALNumberField)this.getMonthDay(), this.getLoginUser(), this.entityid, msgList);
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        EipTSchedule record = ScheduleUtils.getEipTSchedule(rundata, context, false);
        if (record == null) {
            return false;
        }
        this.is_owner = record.getOwnerId().longValue() == this.login_user.getUserId().getValue();
        String ptn = record.getRepeatPattern();
        int count = 0;
        this.is_repeat = true;
        this.is_span = false;
        if (ptn.charAt(0) == 'D') {
            this.repeat_type.setValue("D");
            count = 1;
        } else if (ptn.charAt(0) == 'W') {
            this.repeat_type.setValue("W");
            this.week_0.setValue(ptn.charAt(1) != '0' ? "TRUE" : null);
            this.week_1.setValue(ptn.charAt(2) != '0' ? "TRUE" : null);
            this.week_2.setValue(ptn.charAt(3) != '0' ? "TRUE" : null);
            this.week_3.setValue(ptn.charAt(4) != '0' ? "TRUE" : null);
            this.week_4.setValue(ptn.charAt(5) != '0' ? "TRUE" : null);
            this.week_5.setValue(ptn.charAt(6) != '0' ? "TRUE" : null);
            this.week_6.setValue(ptn.charAt(7) != '0' ? "TRUE" : null);
            count = 8;
        } else if (ptn.charAt(0) == 'M') {
            this.repeat_type.setValue("M");
            this.month_day.setValue((long)Integer.parseInt(ptn.substring(1, 3)));
            count = 3;
        } else if (ptn.charAt(0) == 'S') {
            this.is_span = true;
            this.is_repeat = false;
        } else {
            this.is_repeat = false;
        }
        if (this.is_repeat) {
            Calendar tmpViewCal = Calendar.getInstance();
            tmpViewCal.setTime(this.view_date.getValue());
            Calendar tmpStartCal = Calendar.getInstance();
            tmpStartCal.setTime(record.getStartDate());
            tmpViewCal.set(11, tmpStartCal.get(11));
            tmpViewCal.set(12, tmpStartCal.get(12));
            this.start_date.setValue(tmpViewCal.getTime());
            Calendar tmpStopCal = Calendar.getInstance();
            tmpStopCal.setTime(record.getEndDate());
            tmpViewCal.set(11, tmpStopCal.get(11));
            tmpViewCal.set(12, tmpStopCal.get(12));
            this.end_date.setValue(tmpViewCal.getTime());
            if (ptn.charAt(count) == 'N') {
                this.limit_start_date.setValue(this.view_date.getValue());
                this.limit_end_date.setValue(this.view_date.getValue());
                this.limit_flag.setValue("OFF");
            } else {
                this.limit_flag.setValue("ON");
                this.limit_start_date.setValue(record.getStartDate());
                this.limit_end_date.setValue(record.getEndDate());
            }
            this.edit_repeat_flag.setValue(0L);
        }
        if (this.is_span) {
            this.start_date.setValue(record.getStartDate());
            this.end_date.setValue(record.getEndDate());
            this.limit_start_date.setValue(record.getStartDate());
            this.limit_end_date.setValue(record.getEndDate());
        }
        if (!this.is_repeat && !this.is_span) {
            this.start_date.setValue(record.getStartDate());
            this.end_date.setValue(record.getEndDate());
            this.limit_start_date.setValue(record.getStartDate());
            this.limit_end_date.setValue(record.getEndDate());
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) throws ALDBErrorException {
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        return false;
    }

    public boolean doCheck(ALAction action, RunData rundata, Context context) {
        try {
            boolean res;
            this.init(action, rundata, context);
            ArrayList msgList = new ArrayList();
            this.setValidator();
            boolean bl = res = this.setFormData(rundata, context, msgList) && this.validate(msgList);
            if (!res) {
                action.setMode("new_form");
            }
            action.setResultData((Object)this);
            action.addErrorMessages(msgList);
            action.putData(rundata, context);
            return res;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    private EipTScheduleMap getScheduleMap(List scheduleMaps, int userid) {
        EipTScheduleMap map = null;
        int size = scheduleMaps.size();
        for (int i = 0; i < size; ++i) {
            map = (EipTScheduleMap)scheduleMaps.get(i);
            if (map.getUserId() != userid) continue;
            return map;
        }
        return null;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        return false;
    }

    protected boolean setFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        Field[] fields = ((Object)((Object)this)).getClass().getDeclaredFields();
        boolean res = ScheduleUtils.setFormDataDelegate(rundata, context, this, fields, msgList);
        if (!res) {
            return res;
        }
        this.memberList = CellScheduleUtils.getShareUserMemberList(rundata);
        if (!this.is_span) {
            Date date = this.start_date.getValue();
            int year = date.getYear();
            int month = date.getMonth();
            int day = date.getDate();
            date = this.end_date.getValue();
            date.setYear(year);
            date.setMonth(month);
            date.setDate(day);
            this.end_date.setValue(date);
            this.facilityMemberList = CellScheduleUtils.getShareFacilityMemberList(rundata);
        }
        return true;
    }

    public void setScheduleType(boolean is_repeat, boolean is_span) {
        this.is_repeat = is_repeat;
        this.is_span = is_span;
    }

    public void setScheduleType(RunData rundata) {
        this.is_repeat = rundata.getParameters().getBoolean("is_repeat");
        this.is_span = rundata.getParameters().getBoolean("is_span");
    }

    public ALCellDateTimeField getStartDate() {
        return this.start_date;
    }

    public String getStartDateDate() {
        return ScheduleUtils.translateDate(this.start_date.getValue(), "yyyyMMdd");
    }

    public String getStartDateTime() {
        return ScheduleUtils.translateDate(this.start_date.getValue(), "HHmm");
    }

    public ALCellDateTimeField getEndDate() {
        return this.end_date;
    }

    public String getEndDateDate() {
        return ScheduleUtils.translateDate(this.end_date.getValue(), "yyyyMMdd");
    }

    public String getEndDateTime() {
        return ScheduleUtils.translateDate(this.end_date.getValue(), "HHmm");
    }

    public List getUsers(String groupname) {
        if (groupname == null || groupname.length() == 0) {
            return new ArrayList();
        }
        if ("all".equals(groupname)) {
            groupname = "LoginUser";
        }
        List userlist = ALEipUtils.getUsers((String)groupname);
        ScheduleUtils.removeUser(userlist, this.login_user);
        int size = userlist.size();
        this.setPageParam(size);
        int start = this.getStart();
        int rowsNum = this.getRowsNum();
        int count = -1;
        ArrayList list = new ArrayList();
        for (int i = 0; i < rowsNum && (count = i + start) < size; ++i) {
            list.add(userlist.get(count));
        }
        return list;
    }

    public Map getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public int getCurrentYear() {
        return this.currentYear;
    }

    public boolean isOwner() {
        return this.is_owner;
    }

    public ALEipUser getLoginUser() {
        return this.login_user;
    }

    public ScheduleOnedayGroupSelectData getSelectData() {
        return this.selectData;
    }

    public boolean isRepeat() {
        return this.is_repeat;
    }

    public boolean isSpan() {
        return this.is_span;
    }

    public ALCellDateField getLimitStartDate() {
        return this.limit_start_date;
    }

    public String getLimitStartDateDate() {
        Date date = null;
        try {
            date = this.limit_start_date.getValue().getDate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (date == null) {
            return "";
        }
        return ScheduleUtils.translateDate(date, "yyyyMMdd");
    }

    public ALCellDateField getLimitEndDate() {
        return this.limit_end_date;
    }

    public String getLimitEndDateDate() {
        Date date = null;
        try {
            date = this.limit_end_date.getValue().getDate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (date == null) {
            return "";
        }
        return ScheduleUtils.translateDate(date, "yyyyMMdd");
    }

    public ALCellStringField getLimitFlag() {
        return this.limit_flag;
    }

    public ALCellNumberField getMonthDay() {
        return this.month_day;
    }

    public ALCellStringField getRepeatType() {
        return this.repeat_type;
    }

    public ALCellStringField getWeek0() {
        return this.week_0;
    }

    public ALCellStringField getWeek1() {
        return this.week_1;
    }

    public ALCellStringField getWeek2() {
        return this.week_2;
    }

    public ALCellStringField getWeek3() {
        return this.week_3;
    }

    public ALCellStringField getWeek4() {
        return this.week_4;
    }

    public ALCellStringField getWeek5() {
        return this.week_5;
    }

    public ALCellStringField getWeek6() {
        return this.week_6;
    }

    public List getGroupList() {
        return this.groups;
    }

    public ALCellNumberField getEditRepeatFlag() {
        return this.edit_repeat_flag;
    }

    public ALCellDateTimeField getViewDate() {
        return this.view_date;
    }

    public int getInt(long num) {
        return (int)num;
    }

    public ALCellStringField getSelectedGroup() {
        return this.selectedgroup;
    }

    public List getMemberList() {
        return this.memberList;
    }

    public boolean isContains(List memberList, ALEipUser user) {
        return ScheduleUtils.isContains(memberList, user);
    }

    public ALCellStringField getEditFlag() {
        return this.edit_flag;
    }

    protected void setPageParam(int cnt) {
        this.start = this.rows_num * (this.current_page - 1);
        this.count = cnt;
        this.pages_num = (int)Math.ceil((double)this.count / (double)this.rows_num);
    }

    public void setRowsNum(int num) {
        if (num >= 1) {
            this.rows_num = num;
        }
    }

    public int getRowsNum() {
        return this.rows_num;
    }

    public int getCount() {
        return this.count;
    }

    public int getPagesNum() {
        return this.pages_num;
    }

    public int getCurrentPage() {
        return this.current_page;
    }

    public int getStart() {
        return this.start;
    }

    public String getEntityId() {
        return this.entityid;
    }

    public ALCellStringField getChangeTmpreserveFlag() {
        return this.change_tmpreserve_flag;
    }

    public List getFacilityMemberList() {
        return this.facilityMemberList;
    }
}

