/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.facilities.FacilityResultData;
import com.aimluck.eip.facilities.util.FacilitiesUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.schedule.AjaxScheduleResultData;
import com.aimluck.eip.schedule.AjaxScheduleWeekContainer;
import com.aimluck.eip.schedule.ScheduleToDoResultData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.todo.util.ToDoUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Parameter;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.psml.PsmlParameter;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AjaxScheduleWeeklyGroupSelectData
extends ALAbstractSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AjaxScheduleWeeklyGroupSelectData.class.getName());
    private ALDateTimeField prevDate;
    private ALDateTimeField nextDate;
    private ALDateTimeField prevWeek;
    private ALDateTimeField nextWeek;
    private ALDateTimeField today;
    private ALDateTimeField prevMonth;
    private ALDateTimeField nextMonth;
    private ALDateTimeField viewStart;
    private ALDateTimeField viewEnd;
    private ALDateTimeField viewEndCrt;
    private AjaxScheduleWeekContainer weekCon;
    protected String viewtype;
    protected Calendar tmpCal;
    private ArrayList weekTodoConList;
    private ArrayList weekTermConList;
    private List todoList;
    protected int viewTodo;
    private ArrayList memberList;
    private ArrayList facilityList;
    private List recordMemberList;
    private String portletId;
    protected DataContext dataContext;
    private int userid;
    private boolean show_all;
    private List doneTermList;
    private Integer uid;
    private String acl_feat;
    private String has_acl_other;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String tmpViewStart;
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        this.viewtype = "weekly";
        this.prevDate = new ALDateTimeField("yyyy-MM-dd");
        this.nextDate = new ALDateTimeField("yyyy-MM-dd");
        this.prevWeek = new ALDateTimeField("yyyy-MM-dd");
        this.nextWeek = new ALDateTimeField("yyyy-MM-dd");
        this.prevMonth = new ALDateTimeField("yyyy-MM-dd");
        this.nextMonth = new ALDateTimeField("yyyy-MM-dd");
        this.viewStart = new ALDateTimeField("yyyy-MM-dd");
        this.viewStart.setNotNull(true);
        this.viewEnd = new ALDateTimeField("yyyy-MM-dd");
        this.viewEndCrt = new ALDateTimeField("yyyy-MM-dd");
        this.today = new ALDateTimeField("yyyy-MM-dd");
        Calendar to = Calendar.getInstance();
        to.set(11, 0);
        to.set(12, 0);
        this.today.setValue(to.getTime());
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"view_start")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"view_start", (String)rundata.getParameters().getString("view_start"));
        }
        if ((tmpViewStart = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"view_start")) == null || tmpViewStart.equals("")) {
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            this.viewStart.setValue(cal.getTime());
        } else {
            this.viewStart.setValue(tmpViewStart);
            if (!this.viewStart.validate(new ArrayList())) {
                ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"view_start");
                throw new ALPageNotFoundException();
            }
        }
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(this.viewStart.getValue());
        cal2.add(5, 1);
        this.nextDate.setValue(cal2.getTime());
        cal2.add(5, 6);
        this.nextWeek.setValue(cal2.getTime());
        cal2.add(5, -8);
        this.prevDate.setValue(cal2.getTime());
        cal2.add(5, -6);
        this.prevWeek.setValue(cal2.getTime());
        cal2.add(5, 7);
        this.tmpCal = Calendar.getInstance();
        this.tmpCal.setTime(cal2.getTime());
        try {
            this.weekCon = new AjaxScheduleWeekContainer();
            this.weekCon.initField();
            this.weekCon.setViewStartDate(cal2);
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
        }
        this.viewEndCrt.setValue(cal2.getTime());
        cal2.add(5, -1);
        this.viewEnd.setValue(cal2.getTime());
        Calendar cal3 = Calendar.getInstance();
        cal3.setTime(this.viewStart.getValue());
        cal3.add(2, -1);
        this.prevMonth.setValue(cal3.getTime());
        cal3.add(2, 2);
        this.nextMonth.setValue(cal3.getTime());
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpStart", (String)(this.viewStart.toString() + "-00-00"));
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpEnd", (String)(this.viewStart.toString() + "-00-00"));
        this.weekTodoConList = new ArrayList();
        this.weekTermConList = new ArrayList();
        if (action != null) {
            this.viewTodo = Integer.parseInt(ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p5a-view"));
        }
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        this.userid = ALEipUtils.getUserId((RunData)rundata);
        String tmpstr = rundata.getParameters().getString("s_all");
        this.show_all = "t".equals(tmpstr);
        this.doneTermList = new ArrayList();
        this.acl_feat = "schedule_self";
        this.has_acl_other = ScheduleUtils.hasAuthOther(rundata);
        boolean ex_user = this.initMemberList(rundata);
        boolean ex_facility = this.initFacilityList(rundata);
        if (!ex_user && !ex_facility) {
            this.memberList = new ArrayList();
            this.memberList.add(this.uid);
        }
        super.init(action, rundata, context);
    }

    private boolean initMemberList(RunData rundata) {
        this.memberList = null;
        String[] str = rundata.getParameters().getStrings("m_id");
        ArrayList<Integer> u_list = new ArrayList<Integer>();
        int len = 0;
        if (str == null || str.length == 0) {
            return false;
        }
        for (String s_item : str) {
            if (s_item.startsWith("f")) continue;
            u_list.add(Integer.parseInt(s_item));
        }
        if (u_list.size() == 0) {
            return false;
        }
        ArrayList temp_list = new ArrayList();
        this.memberList = new ArrayList();
        SelectQuery member_query = new SelectQuery(TurbineUser.class);
        Expression exp = ExpressionFactory.inDbExp((String)"USER_ID", u_list);
        member_query.setQualifier(exp);
        member_query.toString();
        temp_list.addAll(ALEipUtils.getUsersFromSelectQuery((SelectQuery)member_query));
        int tmpsize = temp_list.size();
        for (int i = 0; i < tmpsize; ++i) {
            ALEipUser eipuser = (ALEipUser)temp_list.get(i);
            if (!"T".equals(this.has_acl_other) && (long)this.uid.intValue() != eipuser.getUserId().getValue()) {
                this.acl_feat = "schedule_other";
            }
            this.memberList.add(eipuser.getUserId().getValue());
        }
        return this.memberList.size() != 0 && this.memberList != null;
    }

    private boolean initFacilityList(RunData rundata) {
        this.facilityList = null;
        String[] str = rundata.getParameters().getStrings("m_id");
        ArrayList<Integer> f_list = new ArrayList<Integer>();
        int len = 0;
        if (str == null || str.length == 0) {
            return false;
        }
        for (String s_item : str) {
            if (!s_item.startsWith("f")) continue;
            f_list.add(Integer.parseInt(s_item.substring(1)));
        }
        if (f_list.size() == 0) {
            return false;
        }
        ArrayList temp_list = new ArrayList();
        this.facilityList = new ArrayList();
        SelectQuery facility_query = new SelectQuery(EipMFacility.class);
        Expression exp = ExpressionFactory.inDbExp((String)"FACILITY_ID", f_list);
        facility_query.setQualifier(exp);
        temp_list.addAll(FacilitiesUtils.getFacilitiesFromSelectQuery((SelectQuery)facility_query));
        int tmpsize = temp_list.size();
        for (int i = 0; i < tmpsize; ++i) {
            FacilityResultData facility = (FacilityResultData)temp_list.get(i);
            this.facilityList.add(facility.getFacilityId().getValue());
        }
        if (this.facilityList.size() == 0 || this.facilityList == null) {
            return false;
        }
        this.acl_feat = "schedule_other";
        return true;
    }

    protected List selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        try {
            SelectQuery fquery;
            this.savePsmlParameters(rundata, context);
            ArrayList list = new ArrayList();
            SelectQuery uquery = this.getSelectQuery(rundata, context);
            if (uquery != null) {
                list.addAll(this.dataContext.performQuery((Query)uquery));
            }
            if ((fquery = this.getSelectQueryForFacility(rundata, context)) != null) {
                list.addAll(this.dataContext.performQuery((Query)fquery));
            }
            if (this.viewTodo == 1) {
                this.loadTodo(rundata, context);
            }
            if (this.show_all) {
                return ScheduleUtils.sortByDummySchedule(list);
            }
            return this.sortLoginUserSchedule(list);
        }
        catch (Exception e) {
            logger.error((Object)"[AjaxScheduleWeeklyGroupSelectData] TorqueException", (Throwable)e);
            throw new ALDBErrorException();
        }
    }

    private List sortLoginUserSchedule(List list) {
        ArrayList<EipTScheduleMap> dummyList = new ArrayList<EipTScheduleMap>();
        ArrayList<EipTScheduleMap> normalList = new ArrayList<EipTScheduleMap>();
        ArrayList<EipTScheduleMap> loginUserList = new ArrayList<EipTScheduleMap>();
        ArrayList<EipTScheduleMap> ownerList = new ArrayList<EipTScheduleMap>();
        EipTScheduleMap map = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            map = (EipTScheduleMap)list.get(i);
            if ("D".equals(map.getStatus())) {
                dummyList.add(map);
                continue;
            }
            if (this.userid == map.getUserId()) {
                loginUserList.add(map);
                continue;
            }
            if (map.getEipTSchedule().getOwnerId().intValue() == map.getUserId().intValue()) {
                ownerList.add(map);
                continue;
            }
            normalList.add(map);
        }
        list.clear();
        list.addAll(dummyList);
        list.addAll(loginUserList);
        list.addAll(ownerList);
        list.addAll(normalList);
        return list;
    }

    private boolean savePsmlParameters(RunData rundata, Context context) {
        try {
            Profile profile;
            Portlets portlets;
            String portletEntryId = rundata.getParameters().getString("js_peid", null);
            if (portletEntryId == null || "".equals(portletEntryId)) {
                return false;
            }
            String KEY_UIDS = "p6a-uids";
            String KEY_SCHK = "p7d-schk";
            StringBuffer uids = new StringBuffer();
            String[] str = rundata.getParameters().getStrings("m_id");
            if (str == null || str.length == 0 || !"T".equals(this.has_acl_other)) {
                str = new String[]{Integer.toString(ALEipUtils.getUserId((RunData)rundata))};
            }
            int len = str.length - 1;
            for (int i = 0; i < len; ++i) {
                uids.append(str[i]).append(",");
            }
            uids.append(str[len]);
            String schk = rundata.getParameters().getString("s_all");
            if (!"t".equals(schk)) {
                schk = "f";
            }
            if ((portlets = (profile = ((JetspeedRunData)rundata).getProfile()).getDocument().getPortlets()) == null) {
                return false;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return false;
            }
            PsmlParameter param = null;
            int length = portletList.length;
            block3: for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    if (!entries[j].getId().equals(portletEntryId)) continue;
                    boolean hasParam = false;
                    boolean hasParam2 = false;
                    Parameter[] params = entries[j].getParameter();
                    int param_len = params.length;
                    for (int k = 0; k < param_len; ++k) {
                        if (params[k].getName().equals(KEY_UIDS)) {
                            params[k].setValue(uids.toString());
                            entries[j].setParameter(k, params[k]);
                            hasParam = true;
                            continue;
                        }
                        if (!params[k].getName().equals(KEY_SCHK)) continue;
                        params[k].setValue(schk);
                        entries[j].setParameter(k, params[k]);
                        hasParam2 = true;
                    }
                    if (!hasParam) {
                        param = new PsmlParameter();
                        param.setName(KEY_UIDS);
                        param.setValue(uids.toString());
                        entries[j].addParameter((Parameter)param);
                    }
                    if (hasParam2) continue block3;
                    param = new PsmlParameter();
                    param.setName(KEY_SCHK);
                    param.setValue(schk);
                    entries[j].addParameter((Parameter)param);
                    continue block3;
                }
            }
            profile.store();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected SelectQuery getSelectQuery(RunData rundata, Context context) {
        if (this.memberList == null) {
            return null;
        }
        int membersize = this.memberList.size();
        if (membersize < 1) {
            return null;
        }
        Expression exp20 = ExpressionFactory.matchExp((String)"type", (Object)"U");
        SelectQuery query = new SelectQuery(EipTScheduleMap.class);
        query.setQualifier(exp20);
        Expression exp21 = ExpressionFactory.matchExp((String)"userId", this.memberList.get(0));
        for (int i = 1; i < membersize; ++i) {
            Expression exp1 = ExpressionFactory.matchExp((String)"userId", this.memberList.get(i));
            exp21 = exp21.orExp(exp1);
        }
        query.andQualifier(exp21);
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"eipTSchedule.endDate", (Object)this.viewStart.getValue());
        Expression exp12 = ExpressionFactory.lessOrEqualExp((String)"eipTSchedule.startDate", (Object)this.viewEndCrt.getValue());
        Expression exp13 = ExpressionFactory.noMatchExp((String)"eipTSchedule.repeatPattern", (Object)"N");
        Expression exp14 = ExpressionFactory.noMatchExp((String)"eipTSchedule.repeatPattern", (Object)"S");
        query.andQualifier(exp11.andExp(exp12).orExp(exp13.andExp(exp14)));
        query.addOrdering("eipTSchedule.startDate", true);
        query.setDistinct(true);
        return query;
    }

    protected SelectQuery getSelectQueryForFacility(RunData rundata, Context context) {
        if (this.facilityList == null) {
            return null;
        }
        int facilitysize = this.facilityList.size();
        if (facilitysize < 1) {
            return null;
        }
        Expression exp20 = ExpressionFactory.matchExp((String)"type", (Object)"F");
        SelectQuery query = new SelectQuery(EipTScheduleMap.class);
        query.setQualifier(exp20);
        Expression exp21 = ExpressionFactory.matchExp((String)"userId", this.facilityList.get(0));
        for (int i = 0; i < facilitysize; ++i) {
            Expression exp1 = ExpressionFactory.matchExp((String)"userId", this.facilityList.get(i));
            exp21 = exp21.orExp(exp1);
        }
        query.andQualifier(exp21);
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"eipTSchedule.endDate", (Object)this.viewStart.getValue());
        Expression exp12 = ExpressionFactory.lessOrEqualExp((String)"eipTSchedule.startDate", (Object)this.viewEndCrt.getValue());
        Expression exp13 = ExpressionFactory.noMatchExp((String)"eipTSchedule.repeatPattern", (Object)"N");
        Expression exp14 = ExpressionFactory.noMatchExp((String)"eipTSchedule.repeatPattern", (Object)"S");
        query.andQualifier(exp11.andExp(exp12).orExp(exp13.andExp(exp14)));
        query.addOrdering("eipTSchedule.startDate", true);
        query.setDistinct(true);
        return query;
    }

    protected Object getResultData(Object obj) throws ALPageNotFoundException, ALDBErrorException {
        AjaxScheduleResultData rd = new AjaxScheduleResultData();
        rd.initField();
        try {
            EipTScheduleMap record = (EipTScheduleMap)obj;
            EipTSchedule schedule = record.getEipTSchedule();
            if ("R".equals(record.getStatus())) {
                return rd;
            }
            SelectQuery mapquery = new SelectQuery(EipTScheduleMap.class);
            Expression mapexp1 = ExpressionFactory.matchExp((String)"scheduleId", (Object)schedule.getScheduleId());
            mapquery.setQualifier(mapexp1);
            try {
                this.recordMemberList = new ArrayList();
                List tmpList = this.dataContext.performQuery((Query)mapquery);
                int tmpSize = tmpList.size();
                int tmpUserId = record.getUserId();
                for (int i = 0; i < tmpSize; ++i) {
                    EipTScheduleMap tmpMap = (EipTScheduleMap)tmpList.get(i);
                    int m = tmpMap.getUserId();
                    if ("R".equals(tmpMap.getStatus())) continue;
                    if ("F".equals(tmpMap.getType())) {
                        this.recordMemberList.add("f" + Integer.toString(m));
                        continue;
                    }
                    this.recordMemberList.add(Integer.toString(m));
                }
                if (this.recordMemberList != null && this.recordMemberList.size() > 0) {
                    rd.setMemberList(this.recordMemberList);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Expression mapexp2 = ExpressionFactory.matchExp((String)"userId", (Object)this.userid);
            mapquery.andQualifier(mapexp2);
            List schedulemaps = this.dataContext.performQuery((Query)mapquery);
            boolean is_member = schedulemaps != null && schedulemaps.size() > 0;
            rd.setScheduleId(schedule.getScheduleId());
            rd.setParentId(schedule.getParentId());
            rd.setUserId(record.getUserId());
            rd.setName(schedule.getName());
            rd.setStartDate(schedule.getStartDate());
            rd.setEndDate(schedule.getEndDate());
            rd.setTmpreserve("T".equals(record.getStatus()));
            rd.setPublic("O".equals(schedule.getPublicFlag()));
            rd.setHidden("P".equals(schedule.getPublicFlag()));
            rd.setDummy("D".equals(record.getStatus()));
            rd.setLoginuser(record.getUserId() == this.userid);
            rd.setOwner(schedule.getOwnerId() == this.userid);
            rd.setType(record.getType());
            rd.setMember(is_member);
            rd.setPattern(schedule.getRepeatPattern());
            rd.setEditFlag("T".equals(schedule.getEditFlag()));
            if (rd.getPattern().equals("S")) {
                int schedule_id;
                int col;
                int count;
                int stime = ScheduleUtils.equalsToDate(ScheduleUtils.getEmptyDate(), rd.getStartDate().getValue(), false) ? 0 : -((int)((this.viewStart.getValue().getTime() - rd.getStartDate().getValue().getTime()) / 86400000L));
                int etime = -((int)((this.viewStart.getValue().getTime() - rd.getEndDate().getValue().getTime()) / 86400000L));
                if (stime < 0) {
                    stime = 0;
                }
                if ((count = stime) + (col = etime - stime + 1) > 7) {
                    col = 7 - count;
                }
                rd.setRowspan(col);
                if (col > 0 && !this.doneTermList.contains(schedule_id = (int)rd.getScheduleId().getValue())) {
                    ScheduleUtils.addTerm(this.weekTermConList, this.viewStart.getValue(), count, rd);
                    if (!this.show_all && !rd.isDummy()) {
                        this.doneTermList.add(schedule_id);
                    }
                }
                return rd;
            }
            this.weekCon.addResultData(rd, this.show_all);
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return null;
        }
        return rd;
    }

    protected Object selectDetail(RunData rundata, Context context) {
        return null;
    }

    protected Object getResultDataDetail(Object obj) {
        return null;
    }

    protected Attributes getColumnMap() {
        return null;
    }

    private Portlet getPortletURI(RunData rundata, String portletEntryId) {
        try {
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return null;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return null;
            }
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    if (!entries[j].getId().equals(portletEntryId)) continue;
                    Iterator iter = entries[j].getParameterIterator();
                    while (iter.hasNext()) {
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
        return null;
    }

    public void loadTodo(RunData rundata, Context context) {
        this.todoList = new ArrayList();
        try {
            SelectQuery query = this.getSelectQueryForTodo(rundata, context);
            List todos = this.dataContext.performQuery((Query)query);
            int todossize = todos.size();
            for (int i = 0; i < todossize; ++i) {
                int col;
                int count;
                EipTTodo record = (EipTTodo)todos.get(i);
                ScheduleToDoResultData rd = new ScheduleToDoResultData();
                rd.initField();
                String todo_url = ScheduleUtils.getPortletURItoTodoDetailPane(rundata, "ToDo", record.getTodoId().longValue(), this.portletId);
                rd.setTodoId(record.getTodoId().intValue());
                rd.setTodoName(record.getTodoName());
                rd.setUserId(record.getTurbineUser().getUserId().intValue());
                rd.setStartDate(record.getStartDate());
                rd.setEndDate(record.getEndDate());
                rd.setTodoUrl(todo_url);
                rd.setPublicFlag("T".equals(record.getPublicFlag()));
                int stime = ScheduleUtils.equalsToDate(ToDoUtils.getEmptyDate(), rd.getStartDate().getValue(), false) ? 0 : -((int)((this.viewStart.getValue().getTime() - rd.getStartDate().getValue().getTime()) / 86400000L));
                int etime = -((int)((this.viewStart.getValue().getTime() - rd.getEndDate().getValue().getTime()) / 86400000L));
                if (stime < 0) {
                    stime = 0;
                }
                if ((count = stime) + (col = etime - stime + 1) > 7) {
                    col = 7 - count;
                }
                rd.setRowspan(col);
                if (col <= 0) continue;
                ScheduleUtils.addToDo(this.weekTodoConList, this.viewStart.getValue(), count, rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return;
        }
    }

    private SelectQuery getSelectQueryForTodo(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipTTodo.class);
        Expression exp1 = ExpressionFactory.noMatchExp((String)"state", (Object)100);
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"addonScheduleFlg", (Object)"T");
        query.andQualifier(exp2);
        Expression exp3 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)this.uid);
        query.andQualifier(exp3);
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.viewStart.getValue());
        Expression exp12 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.viewEndCrt.getValue());
        Expression exp21 = ExpressionFactory.lessOrEqualExp((String)"startDate", (Object)this.viewEndCrt.getValue());
        Expression exp22 = ExpressionFactory.matchExp((String)"endDate", (Object)ToDoUtils.getEmptyDate());
        Expression exp31 = ExpressionFactory.greaterOrEqualExp((String)"endDate", (Object)this.viewStart.getValue());
        Expression exp32 = ExpressionFactory.matchExp((String)"startDate", (Object)ToDoUtils.getEmptyDate());
        query.andQualifier(exp11.andExp(exp12).orExp(exp21.andExp(exp22)).orExp(exp31.andExp(exp32)));
        return query;
    }

    public ALDateTimeField getViewStart() {
        return this.viewStart;
    }

    public ALDateTimeField getViewEnd() {
        return this.viewEnd;
    }

    public String getViewtype() {
        return this.viewtype;
    }

    public ALDateTimeField getViewEndCrt() {
        return this.viewEndCrt;
    }

    public ALDateTimeField getPrevDate() {
        return this.prevDate;
    }

    public ALDateTimeField getPrevWeek() {
        return this.prevWeek;
    }

    public ALDateTimeField getNextDate() {
        return this.nextDate;
    }

    public ALDateTimeField getNextWeek() {
        return this.nextWeek;
    }

    public ALDateTimeField getToday() {
        return this.today;
    }

    public ALDateTimeField getPrevMonth() {
        return this.prevMonth;
    }

    public ALDateTimeField getNextMonth() {
        return this.nextMonth;
    }

    public AjaxScheduleWeekContainer getContainer() {
        return this.weekCon;
    }

    public List getWeekTermContainerList() {
        return this.weekTermConList;
    }

    public List getWeekToDoContainerList() {
        return this.weekTodoConList;
    }

    public void setPortletId(String id) {
        this.portletId = id;
    }

    public String getAclPortletFeature() {
        return this.acl_feat;
    }
}

