/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.actions.schedule;

import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.modules.actions.common.ALBaseAction;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.userfacility.beans.UserFacilityLiteBean;
import com.aimluck.eip.userfacility.util.UserFacilityUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AjaxScheduleAction
extends ALBaseAction {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AjaxScheduleAction.class.getName());
    private boolean isMax = false;

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.clearAjaxScheduleSession(rundata, context);
        try {
            String time_start = portlet.getPortletConfig().getInitParameter("p1a-rows");
            context.put("time_start", (Object)time_start);
            String time_end = portlet.getPortletConfig().getInitParameter("p1b-rows");
            context.put("time_end", (Object)time_end);
            String time_interval = portlet.getPortletConfig().getInitParameter("p1c-rows");
            context.put("time_interval", (Object)time_interval);
            String weekly_days = portlet.getPortletConfig().getInitParameter("p2a-days");
            context.put("weekly_days", (Object)weekly_days);
            String weekly_group = portlet.getPortletConfig().getInitParameter("p3a-group");
            context.put("weekly_group", (Object)weekly_group);
            String init_user = portlet.getPortletConfig().getInitParameter("p3a-user");
            context.put("init_user", (Object)init_user);
            ArrayList<UserFacilityLiteBean> memberList = new ArrayList<UserFacilityLiteBean>();
            String selected_user = portlet.getPortletConfig().getInitParameter("p6a-uids");
            if (selected_user == null || "".equals(selected_user)) {
                UserFacilityLiteBean login_user = UserFacilityUtils.getUserFacilityLiteBean((RunData)rundata);
                memberList.add(login_user);
            } else {
                String[] selected_users = selected_user.split(",");
                ArrayList ulist = ScheduleUtils.getALEipUserFacility(selected_users, rundata);
                if (ulist == null || ulist.size() == 0) {
                    UserFacilityLiteBean login_user = UserFacilityUtils.getUserFacilityLiteBean((RunData)rundata);
                    memberList.add(login_user);
                } else {
                    memberList.addAll(ulist);
                }
            }
            context.put("member_list", memberList);
            String showAll = portlet.getPortletConfig().getInitParameter("p7d-schk");
            if (!"t".equals(showAll)) {
                showAll = "f";
            }
            context.put("init_s_all", (Object)showAll);
            ALEipUser loginuser = ALEipUtils.getALEipUser((RunData)rundata);
            String current = loginuser.getAliasName().toString();
            context.put("current_user", (Object)current);
            context.put("current_user_ln", (Object)loginuser.getName());
            context.put("current_user_id", (Object)loginuser.getUserId());
            String template = portlet.getPortletConfig().getInitParameter("template");
            String tab = template.equals("ajax-schedule-oneday") ? "oneday" : (template.equals("ajax-schedule-oneday-group") ? "oneday-group" : (template.equals("ajax-schedule-monthly") ? "monthly" : (template.equals("ajax-calendar-weekly") ? "weekly" : "weekly-group")));
            context.put("hasAcl", (Object)ScheduleUtils.hasAuthOther(rundata));
            if (this.isMax) {
                this.putData(rundata, context);
                this.setTemplate(rundata, "ajax-calendar-list");
            } else if ("ajax-schedule-weekly".equals(template)) {
                this.setTemplate(rundata, "ajax-calendar-weekly");
            } else {
                this.setTemplate(rundata, template);
            }
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)tab);
        }
        catch (Exception ex) {
            logger.error((Object)"[AjaxScheduleAction] Exception.", (Throwable)ex);
            ALEipUtils.redirectDBError((RunData)rundata);
        }
    }

    protected void buildMaximizedContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.isMax = true;
        this.buildNormalContext(portlet, context, rundata);
    }

    public void doSchedule_list(RunData rundata, Context context) {
        this.isMax = true;
    }

    private void clearAjaxScheduleSession(RunData rundata, Context context) {
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"entityid");
    }
}

