/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.userfacility.util;

import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.facility.beans.FacilityLiteBean;
import com.aimluck.eip.facility.util.FacilityUtils;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.user.beans.UserLiteBean;
import com.aimluck.eip.user.util.UserUtils;
import com.aimluck.eip.userfacility.beans.UserFacilityLiteBean;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.util.RunData;

public class UserFacilityUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)UserFacilityUtils.class.getName());

    public static List getUserFacilityLiteBeansFromGroup(RunData rundata, String groupname) {
        UserFacilityLiteBean user;
        List tmp_u_list = UserUtils.getUserLiteBeansFromGroup((RunData)rundata, (String)groupname, (boolean)true);
        int t_size = tmp_u_list.size();
        ArrayList<UserFacilityLiteBean> list = new ArrayList<UserFacilityLiteBean>();
        for (int i = 0; i < t_size; ++i) {
            UserLiteBean t_user = (UserLiteBean)tmp_u_list.get(i);
            user = new UserFacilityLiteBean();
            user.initField();
            user.setUserFacilityId(Integer.parseInt(t_user.getUserId()));
            user.setName(t_user.getUserId());
            user.setAliasName(t_user.getAliasName());
            user.setUserFacilityType("U");
            list.add(user);
        }
        if (!"LoginUser".equals(groupname)) {
            StringBuffer statement = new StringBuffer();
            statement.append("SELECT DISTINCT ");
            statement.append("  B.FACILITY_ID, B.FACILITY_NAME ");
            statement.append("FROM EIP_FACILITY_GROUP as A ");
            statement.append("LEFT JOIN EIP_M_FACILITY as B ");
            statement.append("  on A.FACILITY_ID = B.FACILITY_ID ");
            statement.append("LEFT JOIN TURBINE_GROUP as C ");
            statement.append("  on A.GROUP_ID = C.GROUP_ID ");
            statement.append("WHERE C.GROUP_NAME = '").append(groupname).append("'");
            String query = statement.toString();
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SQLTemplate rawSelect = new SQLTemplate(TurbineUser.class, query, true);
            rawSelect.setFetchingDataRows(true);
            List ulist = dataContext.performQuery((Query)rawSelect);
            int recNum = ulist.size();
            for (int j = 0; j < recNum; ++j) {
                DataRow dataRow = (DataRow)ulist.get(j);
                user = new UserFacilityLiteBean();
                user.initField();
                user.setUserFacilityId((Integer)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"FACILITY_ID"));
                user.setName("f" + user.getUserFacilityId());
                user.setAliasName((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"FACILITY_NAME"));
                user.setUserFacilityType("F");
                list.add(user);
            }
        } else {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipMFacility.class);
            List aList = dataContext.performQuery((Query)query);
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                EipMFacility record = (EipMFacility)aList.get(i);
                user = new UserFacilityLiteBean();
                user.initField();
                user.setUserFacilityId(record.getFacilityId());
                user.setName("f" + user.getUserFacilityId());
                user.setAliasName(record.getFacilityName());
                user.setUserFacilityType("F");
                list.add(user);
            }
        }
        return list;
    }

    public static List getUserFacilityLiteBeans(RunData rundata, boolean isMygroup, boolean isPost) {
        ArrayList<UserFacilityLiteBean> list = new ArrayList<UserFacilityLiteBean>();
        try {
            UserFacilityLiteBean user;
            List tmp_u_list = UserUtils.getUserGroupLiteBeans((RunData)rundata, (boolean)isMygroup, (boolean)isPost);
            int t_size = tmp_u_list.size();
            for (int i = 0; i < t_size; ++i) {
                UserLiteBean t_user = (UserLiteBean)tmp_u_list.get(i);
                user = new UserFacilityLiteBean();
                user.initField();
                user.setUserFacilityId(Integer.parseInt(t_user.getUserId()));
                user.setName(t_user.getName());
                user.setAliasName(t_user.getAliasName());
                user.setUserFacilityType("U");
                list.add(user);
            }
            List tmp_f_list = FacilityUtils.getFacilityLiteBeans();
            int f_size = tmp_f_list.size();
            for (int i = 0; i < f_size; ++i) {
                FacilityLiteBean f_user = (FacilityLiteBean)tmp_f_list.get(i);
                user = new UserFacilityLiteBean();
                user.initField();
                user.setUserFacilityId(Integer.parseInt(f_user.getFacilityId()));
                user.setName("f" + user.getUserFacilityId());
                user.setAliasName(f_user.getFacilityName());
                user.setUserFacilityType("F");
                list.add(user);
            }
        }
        catch (Exception e) {
            logger.error((Object)"[UserUtils]", (Throwable)e);
        }
        return list;
    }

    public static UserFacilityLiteBean getUserFacilityLiteBean(RunData rundata) {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        UserFacilityLiteBean user = new UserFacilityLiteBean();
        user.initField();
        user.setUserFacilityId(Integer.parseInt(jdata.getJetspeedUser().getUserId()));
        user.setName(jdata.getJetspeedUser().getUserName());
        user.setAliasName(jdata.getJetspeedUser().getFirstName(), jdata.getJetspeedUser().getLastName());
        user.setUserFacilityType("U");
        return user;
    }
}

