/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.broker;

import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.util.LoggerFactory;
import test.ojb.broker.ObjectWithBlob;

public class BlobTest
extends TestCase {
    PersistenceBroker broker;
    private static Class CLASS = class$test$ojb$broker$BlobTest == null ? (class$test$ojb$broker$BlobTest = BlobTest.class$("test.ojb.broker.BlobTest")) : class$test$ojb$broker$BlobTest;
    static /* synthetic */ Class class$test$ojb$broker$BlobTest;

    public static void main(String[] args) {
        String[] arr = new String[]{CLASS.getName()};
        TestRunner.main((String[])arr);
    }

    public BlobTest(String name) {
        super(name);
    }

    public void setUp() {
        this.broker = PersistenceBrokerFactory.createPersistenceBroker();
    }

    public void tearDown() {
        try {
            this.broker.clearCache();
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            // empty catch block
        }
    }

    public void testBlobInsertion() {
        int size = 5000;
        try {
            ObjectWithBlob obj = new ObjectWithBlob();
            byte[] barr = new byte[size];
            char[] carr = new char[size];
            int i = 0;
            while (i < size) {
                barr[i] = 120;
                carr[i] = 121;
                ++i;
            }
            obj.setId(1);
            obj.setBlob(barr);
            obj.setClob(carr);
            this.broker.store(obj);
            this.broker.clearCache();
            Identity oid = new Identity(obj);
            ObjectWithBlob obj1 = (ObjectWithBlob)this.broker.getObjectByIdentity(oid);
            Assert.assertEquals((int)obj.getBlob().length, (int)obj1.getBlob().length);
            Assert.assertEquals((int)obj.getClob().length, (int)obj1.getClob().length);
        }
        catch (Throwable t) {
            LoggerFactory.getDefaultLogger().error(t);
            Assert.fail((String)t.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

