/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.util;

import ojb.broker.server.BrokerPool;
import ojb.broker.server.PersistenceBrokerServer;
import ojb.broker.util.BaseConfiguration;
import ojb.broker.util.LoggerFactory;
import ojb.odmg.locking.AbstractLockStrategy;

public class PersistenceBrokerFactoryConfiguration
extends BaseConfiguration {
    private boolean serverUsed;
    private String repositoryFilename;
    private String[] servers;
    private Class sequenceManagerClass;
    private Class objectCacheClass;
    private Class connectionFactoryClass;
    private Class lockManagerClass;
    private Class lockMapClass;
    private boolean lockAssociationAsWrites;
    private int sequenceManagerGrabSize;
    private Class oqlCollectionClass;
    private Class loggerClass;
    private String loggerConfigFile;
    private int logLevel;
    private boolean ignoreAutoCommitExceptions;
    static /* synthetic */ Class class$ojb$broker$util$SequenceManagerDefaultImpl;
    static /* synthetic */ Class class$ojb$broker$cache$ObjectCacheDefaultImpl;
    static /* synthetic */ Class class$ojb$broker$accesslayer$ConnectionFactoryDefaultImpl;
    static /* synthetic */ Class class$ojb$odmg$locking$LockManagerDefaultImpl;
    static /* synthetic */ Class class$ojb$odmg$locking$PersistentLockMapImpl;
    static /* synthetic */ Class class$ojb$broker$util$PoorMansLoggerImpl;
    static /* synthetic */ Class class$ojb$odmg$collections$DListImpl;

    public String getLoggerConfigFile() {
        return this.loggerConfigFile;
    }

    public String getLogLevel(String loggerName) {
        return this.getProperty(loggerName + ".LogLevel", "INFO");
    }

    public boolean islockAssociationAsWrites() {
        return this.lockAssociationAsWrites;
    }

    public boolean getIgnoreAutoCommitExceptions() {
        return this.ignoreAutoCommitExceptions;
    }

    public boolean isServerUsed() {
        return this.serverUsed;
    }

    public String getRepositoryFilename() {
        return this.repositoryFilename;
    }

    public String[] getServers() {
        return this.servers;
    }

    public Class getSequenceManagerClass() {
        return this.sequenceManagerClass;
    }

    public Class getObjectCacheClass() {
        return this.objectCacheClass;
    }

    public Class getConnectionFactoryClass() {
        return this.connectionFactoryClass;
    }

    public Class getLockManagerClass() {
        return this.lockManagerClass;
    }

    public int getSequenceManagerGrabSize() {
        return this.sequenceManagerGrabSize;
    }

    public Class getOqlCollectionClass() {
        return this.oqlCollectionClass;
    }

    public Class getLockMapClass() {
        return this.lockMapClass;
    }

    public Class getLoggerClass() {
        return this.loggerClass;
    }

    protected void load() {
        String fn = System.getProperty("OJB.properties", "OJB.properties");
        this.setFilename(fn);
        super.load();
        this.serverUsed = this.getProperty("useServer", "false").equalsIgnoreCase("true");
        this.repositoryFilename = this.getProperty("repositoryFile", "repository.xml");
        String strServers = this.getProperty("BrokerServers", "localhost:2001");
        this.servers = this.parseSeparatedString(strServers, ";");
        this.ignoreAutoCommitExceptions = this.getProperty("ignoreAutoCommitExceptions", "false").equalsIgnoreCase("true");
        String classname = null;
        try {
            classname = this.getProperty("SequenceManagerClass", (class$ojb$broker$util$SequenceManagerDefaultImpl == null ? (class$ojb$broker$util$SequenceManagerDefaultImpl = PersistenceBrokerFactoryConfiguration.class$("ojb.broker.util.SequenceManagerDefaultImpl")) : class$ojb$broker$util$SequenceManagerDefaultImpl).getName());
            this.sequenceManagerClass = Class.forName(classname, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            LoggerFactory.getBootLogger().warn("OJB Warning: Class " + classname + " is not defined. Will use " + (class$ojb$broker$util$SequenceManagerDefaultImpl == null ? (class$ojb$broker$util$SequenceManagerDefaultImpl = PersistenceBrokerFactoryConfiguration.class$("ojb.broker.util.SequenceManagerDefaultImpl")) : class$ojb$broker$util$SequenceManagerDefaultImpl) + " instead");
        }
        try {
            this.sequenceManagerGrabSize = Integer.parseInt(this.getProperty("SequenceManagerGrabSize", "10"));
        }
        catch (NumberFormatException e) {
            this.sequenceManagerGrabSize = 10;
            LoggerFactory.getBootLogger().warn("OJB Warning: wrong value for SequenceManagerGrabSize. Will use 10 as default value");
        }
        try {
            this.logLevel = Integer.parseInt(this.getProperty("LogLevel", "3"));
        }
        catch (NumberFormatException e) {
            this.logLevel = 3;
            LoggerFactory.getBootLogger().warn("OJB Warning: wrong value for LogLevel. Will use 3 as default value");
        }
        try {
            classname = this.getProperty("ObjectCacheClass", (class$ojb$broker$cache$ObjectCacheDefaultImpl == null ? (class$ojb$broker$cache$ObjectCacheDefaultImpl = PersistenceBrokerFactoryConfiguration.class$("ojb.broker.cache.ObjectCacheDefaultImpl")) : class$ojb$broker$cache$ObjectCacheDefaultImpl).getName());
            this.objectCacheClass = Class.forName(classname, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            LoggerFactory.getBootLogger().warn("OJB Warning: Class " + classname + " is not defined. Will use " + (class$ojb$broker$cache$ObjectCacheDefaultImpl == null ? (class$ojb$broker$cache$ObjectCacheDefaultImpl = PersistenceBrokerFactoryConfiguration.class$("ojb.broker.cache.ObjectCacheDefaultImpl")) : class$ojb$broker$cache$ObjectCacheDefaultImpl) + " instead");
        }
        try {
            classname = this.getProperty("ConnectionFactoryClass", (class$ojb$broker$accesslayer$ConnectionFactoryDefaultImpl == null ? (class$ojb$broker$accesslayer$ConnectionFactoryDefaultImpl = PersistenceBrokerFactoryConfiguration.class$("ojb.broker.accesslayer.ConnectionFactoryDefaultImpl")) : class$ojb$broker$accesslayer$ConnectionFactoryDefaultImpl).getName());
            this.connectionFactoryClass = Class.forName(classname, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            LoggerFactory.getBootLogger().warn("OJB Warning: Class " + classname + " is not defined. Will use " + (class$ojb$broker$accesslayer$ConnectionFactoryDefaultImpl == null ? (class$ojb$broker$accesslayer$ConnectionFactoryDefaultImpl = PersistenceBrokerFactoryConfiguration.class$("ojb.broker.accesslayer.ConnectionFactoryDefaultImpl")) : class$ojb$broker$accesslayer$ConnectionFactoryDefaultImpl) + " instead");
        }
        try {
            classname = this.getProperty("LockManagerClass", (class$ojb$odmg$locking$LockManagerDefaultImpl == null ? (class$ojb$odmg$locking$LockManagerDefaultImpl = PersistenceBrokerFactoryConfiguration.class$("ojb.odmg.locking.LockManagerDefaultImpl")) : class$ojb$odmg$locking$LockManagerDefaultImpl).getName());
            this.lockManagerClass = Class.forName(classname, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            LoggerFactory.getBootLogger().warn("OJB Warning: Class " + classname + " is not defined. Will use " + (class$ojb$odmg$locking$LockManagerDefaultImpl == null ? (class$ojb$odmg$locking$LockManagerDefaultImpl = PersistenceBrokerFactoryConfiguration.class$("ojb.odmg.locking.LockManagerDefaultImpl")) : class$ojb$odmg$locking$LockManagerDefaultImpl) + " instead");
        }
        try {
            classname = this.getProperty("LockMapClass", (class$ojb$odmg$locking$PersistentLockMapImpl == null ? (class$ojb$odmg$locking$PersistentLockMapImpl = PersistenceBrokerFactoryConfiguration.class$("ojb.odmg.locking.PersistentLockMapImpl")) : class$ojb$odmg$locking$PersistentLockMapImpl).getName());
            this.lockMapClass = Class.forName(classname, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            LoggerFactory.getBootLogger().warn("OJB Warning: Class " + classname + " is not defined. Will use " + (class$ojb$odmg$locking$PersistentLockMapImpl == null ? (class$ojb$odmg$locking$PersistentLockMapImpl = PersistenceBrokerFactoryConfiguration.class$("ojb.odmg.locking.PersistentLockMapImpl")) : class$ojb$odmg$locking$PersistentLockMapImpl) + " instead");
        }
        try {
            classname = this.getProperty("LoggerClass", (class$ojb$broker$util$PoorMansLoggerImpl == null ? (class$ojb$broker$util$PoorMansLoggerImpl = PersistenceBrokerFactoryConfiguration.class$("ojb.broker.util.PoorMansLoggerImpl")) : class$ojb$broker$util$PoorMansLoggerImpl).getName());
            this.loggerClass = Class.forName(classname, true, Thread.currentThread().getContextClassLoader());
            this.loggerConfigFile = this.getProperty("LoggerConfigFile", "");
        }
        catch (ClassNotFoundException e) {
            LoggerFactory.getBootLogger().warn("OJB Warning: Class " + classname + " is not defined. Will use " + (class$ojb$broker$util$PoorMansLoggerImpl == null ? (class$ojb$broker$util$PoorMansLoggerImpl = PersistenceBrokerFactoryConfiguration.class$("ojb.broker.util.PoorMansLoggerImpl")) : class$ojb$broker$util$PoorMansLoggerImpl) + " instead");
        }
        AbstractLockStrategy.DEFAULT_LOCK_TIMEOUT = Long.parseLong(this.getProperty("LockTimeout", "60000"));
        PersistenceBrokerServer.THREADCOUNT = Integer.parseInt(this.getProperty("ServerThreadCount", "10"));
        BrokerPool.BROKERCOUNT = Integer.parseInt(this.getProperty("BrokerPoolSize", "10"));
        this.lockAssociationAsWrites = this.getProperty("LockAssociations", "WRITE").equalsIgnoreCase("WRITE");
        try {
            classname = this.getProperty("OqlCollectionClass", (class$ojb$odmg$collections$DListImpl == null ? (class$ojb$odmg$collections$DListImpl = PersistenceBrokerFactoryConfiguration.class$("ojb.odmg.collections.DListImpl")) : class$ojb$odmg$collections$DListImpl).getName());
            this.oqlCollectionClass = Class.forName(classname, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            LoggerFactory.getBootLogger().warn("OJB Warning: Class " + classname + " is not defined. Will use " + (class$ojb$odmg$collections$DListImpl == null ? (class$ojb$odmg$collections$DListImpl = PersistenceBrokerFactoryConfiguration.class$("ojb.odmg.collections.DListImpl")) : class$ojb$odmg$collections$DListImpl) + " instead");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

