/*
 * Decompiled with CFR 0.152.
 */
package com.develop.version;

import com.develop.jcfe.ClassFile;
import com.develop.jcfe.attribute.SerializableAttribute;
import com.develop.version.VersionInfo;
import com.develop.version.VersionMatcher;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VersioningLoader
extends URLClassLoader {
    private static boolean auditHit;
    private static boolean auditMiss;
    private static boolean auditFail;
    private final VersionMatcher vm;
    RequiredVersions rv = new RequiredVersions();

    public VersioningLoader(URL[] urls, VersionMatcher vm) {
        super(urls);
        this.vm = vm;
    }

    public VersioningLoader(URL[] urls, ClassLoader parent, VersionMatcher vm) {
        super(urls, parent);
        this.vm = vm;
    }

    public VersioningLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory fact, VersionMatcher vm) {
        super(urls, parent, fact);
        this.vm = vm;
    }

    private URL getURLBase(URL url) {
        URL[] urls = this.getURLs();
        int length = urls.length;
        String stringForm = url.toExternalForm();
        int n = 0;
        while (n < length) {
            if (stringForm.startsWith(urls[n].toExternalForm())) {
                return urls[n];
            }
            ++n;
        }
        return null;
    }

    private byte[] getClassBytes(URL url) throws IOException {
        InputStream is = url.openStream();
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int ch = 0;
        while (-1 != (ch = is.read())) {
            baos.write(ch);
        }
        return baos.toByteArray();
    }

    private Class defineClass(String name, URL url, byte[] bytes) {
        URL urlBase = this.getURLBase(url);
        if (urlBase == null) {
            throw new Error("url has no base");
        }
        return this.defineClass(name, bytes, 0, bytes.length, new CodeSource(urlBase, null));
    }

    private static VersionInfo getVersionInfo(ClassFile cf) {
        SerializableAttribute sa = (SerializableAttribute)cf.getAttribute("ser.com.develop.version.VersionInfo");
        if (sa == null) {
            return null;
        }
        return (VersionInfo)sa.getObject();
    }

    private boolean versionMatches(String name, VersionInfo vi) {
        int lastDot = name.lastIndexOf(46);
        String pkgName = lastDot == -1 ? "" : name.substring(0, lastDot);
        List l = this.rv.getPackageRequirements(pkgName, false);
        Object version = vi.getVersion();
        if (l == null) {
            return true;
        }
        Iterator it = l.iterator();
        while (it.hasNext()) {
            if (this.vm.verify(it.next(), version)) continue;
            return false;
        }
        return true;
    }

    private void updateVersionInfo(VersionInfo newInfo) {
        if (newInfo == null) {
            return;
        }
        Set newEntries = newInfo.getRequiredVersions().entrySet();
        Iterator it = newEntries.iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            List l = this.rv.getPackageRequirements((String)entry.getKey(), true);
            l.add(entry.getValue());
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        String className = name.replace('.', '/') + ".class";
        try {
            Enumeration<URL> e = this.findResources(className);
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                byte[] bytes = this.getClassBytes(url);
                ClassFile cf = new ClassFile(bytes);
                VersionInfo vi = VersioningLoader.getVersionInfo(cf);
                if (this.versionMatches(name, vi)) {
                    this.updateVersionInfo(vi);
                    Class cls = this.defineClass(name, url, bytes);
                    if (auditHit) {
                        String vers = vi == null ? "" : vi.getVersion().toString();
                        System.out.println("VL: Loading " + name + " " + vers + " from " + url);
                    }
                    return cls;
                }
                if (!auditMiss) continue;
                System.out.println("VL: Missed match " + name + " at URL " + url);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (auditFail) {
            System.out.println("VL: could not load " + name);
        }
        return null;
    }

    static {
        String audit = System.getProperty("com.develop.version.audit");
        if (audit != null) {
            if (-1 != audit.indexOf("hit")) {
                auditHit = true;
            }
            if (-1 != audit.indexOf("miss")) {
                auditMiss = true;
            }
            if (-1 != audit.indexOf("fail")) {
                auditFail = true;
            }
        }
    }

    private static class RequiredVersions {
        HashMap pkgToVersion = new HashMap();

        private RequiredVersions() {
        }

        public List getPackageRequirements(String pkgName, boolean create) {
            ArrayList l = (ArrayList)this.pkgToVersion.get(pkgName);
            if (l == null && create) {
                l = new ArrayList();
                this.pkgToVersion.put(pkgName, l);
            }
            return l;
        }
    }
}

