/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.mail.util;

import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.cayenne.om.account.EipMCompany;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.portlet.EipMMailNotifyConf;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.mail.ALLocalMailMessage;
import com.aimluck.eip.mail.ALMailFactoryService;
import com.aimluck.eip.mail.ALMailHandler;
import com.aimluck.eip.mail.ALMailMessage;
import com.aimluck.eip.mail.ALMailReceiverContext;
import com.aimluck.eip.mail.ALMailSenderContext;
import com.aimluck.eip.mail.ALPop3MailReceiverContext;
import com.aimluck.eip.mail.ALSmtpMailContext;
import com.aimluck.eip.mail.ALSmtpMailSenderContext;
import com.aimluck.eip.mail.util.ALEipUserAddr;
import com.aimluck.eip.mail.util.UnicodeCorrecter;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.daemonfactory.AipoDaemonFactoryService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.sk_jp.io.CharCodeConverter;
import com.sk_jp.mail.JISDataSource;
import com.sk_jp.mail.MailUtility;
import com.sun.mail.util.BASE64EncoderStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Key;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import javax.servlet.ServletConfig;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;

public class ALMailUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALMailUtils.class.getName());
    public static final String CR = System.getProperty("line.separator");
    public static final int ACCOUNT_TYPE_NON = 0;
    public static final int ACCOUNT_TYPE_DEFAULT = 1;
    public static final int ACCOUNT_TYPE_INIT = 2;
    public static final int KEY_MSGTYPE_DAYMAIL = 1;
    public static final int KEY_MSGTYPE_NOTE = 21;
    public static final int KEY_MSGTYPE_BLOG = 22;
    public static final int KEY_MSGTYPE_WORKFLOW = 23;
    public static final int KEY_MSGTYPE_SCHEDULE = 24;
    public static final int VALUE_MSGTYPE_DEST_NONE = 0;
    public static final int VALUE_MSGTYPE_DEST_PC = 1;
    public static final int VALUE_MSGTYPE_DEST_CELLULAR = 2;
    public static final int VALUE_MSGTYPE_DEST_PC_CELLULAR = 3;
    public static final int COMPARE_TYPE_ASC = 1;
    public static final int COMPARE_TYPE_DESC = 2;
    public static final int COMPARE_NAME_SUBJECT = 1;
    public static final int COMPARE_NAME_PERSON = 2;
    public static final int COMPARE_NAME_DATE = 3;
    public static final int COMPARE_NAME_FILE_VOLUME = 4;
    public static final String DATE_FORMAT = "yyyy/MM/dd HH:mm";
    public static final String storePath = JetspeedResources.getString((String)"aipo.home", (String)"");
    public static final String rootFolderPath = JetspeedResources.getString((String)"aipo.mail.home", (String)"");
    private static final String seacretPassword = "1t's a s3@cr3t k3y";

    public static EipMMailAccount getMailAccount(int userId, int accountId) {
        if (userId < 0 || accountId < 0) {
            return null;
        }
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipMMailAccount.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)userId);
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchDbExp((String)"ACCOUNT_ID", (Object)accountId);
            query.andQualifier(exp2);
            List accounts = dataContext.performQuery((Query)query);
            if (accounts == null || accounts.size() == 0) {
                logger.debug((Object)"[WebMail] Not found AccountID...");
                return null;
            }
            return (EipMMailAccount)accounts.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static String getAccountName(int userId, int accountId) {
        if (userId < 0 || accountId < 0) {
            return null;
        }
        String accountName = null;
        try {
            EipMMailAccount mailAccount = ALMailUtils.getMailAccount(userId, accountId);
            if (mailAccount == null) {
                return null;
            }
            accountName = mailAccount.getAccountName();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
        return accountName;
    }

    public static ALMailMessage getReplyMessage(ALMailMessage mailmsg) {
        if (mailmsg == null) {
            return null;
        }
        ALLocalMailMessage msg = null;
        try {
            msg = (ALLocalMailMessage)mailmsg;
            StringBuffer sb = new StringBuffer();
            sb.append(" ").append(CR).append("----- Original Message ----- ").append(CR);
            sb.append("From: ").append(ALMailUtils.getAddressString(msg.getFrom())).append(CR);
            sb.append("To: ").append(ALMailUtils.getAddressString(msg.getRecipients(Message.RecipientType.TO))).append(CR);
            sb.append("Sent: ").append(msg.getSentDate()).append(CR);
            sb.append("Subject: ").append(UnicodeCorrecter.correctToISO2022JP(msg.getSubject())).append(CR).append(" ").append(CR);
            msg.setSubject(MimeUtility.encodeText((String)("Re: " + UnicodeCorrecter.correctToISO2022JP(msg.getSubject()))));
            msg.setRecipient(Message.RecipientType.TO, msg.getReplyTo()[0]);
            String[] lines = msg.getBodyTextArray();
            if (lines != null && lines.length > 0) {
                int length = lines.length;
                for (int i = 0; i < length; ++i) {
                    sb.append("> ").append(lines[i]).append(CR);
                }
            }
            msg.setText(UnicodeCorrecter.correctToISO2022JP(sb.toString()));
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return null;
        }
        return msg;
    }

    public static ALMailMessage getForwardMessage(ALMailMessage mailmsg) {
        if (mailmsg == null) {
            return null;
        }
        ALLocalMailMessage msg = null;
        try {
            msg = (ALLocalMailMessage)mailmsg;
            StringBuffer sb = new StringBuffer();
            sb.append(" ").append(CR).append("----- Original Message ----- ").append(CR);
            sb.append("From: ").append(ALMailUtils.getAddressString(msg.getFrom())).append(CR);
            sb.append("To: ").append(ALMailUtils.getAddressString(msg.getRecipients(Message.RecipientType.TO))).append(CR);
            sb.append("Sent: ").append(msg.getSentDate()).append(CR);
            sb.append("Subject: ").append(UnicodeCorrecter.correctToISO2022JP(msg.getSubject())).append(CR).append(" ").append(CR);
            msg.setSubject(MimeUtility.encodeText((String)("Fwd: " + UnicodeCorrecter.correctToISO2022JP(msg.getSubject()))));
            String[] lines = msg.getBodyTextArray();
            if (lines != null && lines.length > 0) {
                int length = lines.length;
                for (int i = 0; i < length; ++i) {
                    sb.append(lines[i]).append(CR);
                }
            }
            msg.setText(UnicodeCorrecter.correctToISO2022JP(sb.toString()));
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return null;
        }
        return msg;
    }

    public static String[] getLines(String str) {
        if (str == null || str.equals("")) {
            return null;
        }
        if (str.indexOf(CR) < 0) {
            return new String[]{str};
        }
        String token = null;
        ArrayList<String> tokens = new ArrayList<String>();
        BufferedReader reader = null;
        String[] lines = null;
        try {
            reader = new BufferedReader(new StringReader(str));
            while ((token = reader.readLine()) != null) {
                tokens.add(token);
            }
            reader.close();
            lines = new String[tokens.size()];
            lines = tokens.toArray(lines);
        }
        catch (Exception ioe) {
            logger.error((Object)"Exception", (Throwable)ioe);
            try {
                reader.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return null;
        }
        return lines;
    }

    public static String[] getTokens(String line, String delim) {
        if (line == null || line.equals("")) {
            return null;
        }
        if (line.indexOf(delim) < 0) {
            return new String[]{line};
        }
        StringTokenizer st = new StringTokenizer(line, delim);
        int length = st.countTokens();
        String[] tokens = new String[length];
        for (int i = 0; i < length; ++i) {
            tokens[i] = st.nextToken();
        }
        return tokens;
    }

    public static int[] reverse(int[] objs) {
        if (objs == null) {
            return null;
        }
        int length = objs.length;
        int[] destObjs = new int[length];
        System.arraycopy(objs, 0, destObjs, 0, length);
        Arrays.sort(destObjs);
        int[] reverseObjs = new int[length];
        for (int i = 0; i < length; ++i) {
            reverseObjs[i] = destObjs[length - i - 1];
        }
        return reverseObjs;
    }

    public static String getAddressString(Address[] addresses) {
        if (addresses == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        InternetAddress addr = null;
        int length = addresses.length - 1;
        for (int i = 0; i < length; ++i) {
            addr = (InternetAddress)addresses[i];
            if (addr.getPersonal() != null) {
                String personaladdr = ALMailUtils.getOneString(ALMailUtils.getTokens(addr.getPersonal(), "\r\n"), "");
                sb.append(MailUtility.decodeText((String)personaladdr)).append(" <").append(addr.getAddress()).append(">, ");
                continue;
            }
            sb.append(addr.getAddress()).append(", ");
        }
        addr = (InternetAddress)addresses[length];
        if (addr.getPersonal() != null) {
            String personaladdr = ALMailUtils.getOneString(ALMailUtils.getTokens(addr.getPersonal(), "\r\n"), "");
            sb.append(MailUtility.decodeText((String)personaladdr)).append(" <").append(addr.getAddress()).append(">");
        } else {
            sb.append(addr.getAddress());
        }
        return sb.toString();
    }

    public static String getOneString(String[] strs, String delim) {
        if (strs == null) {
            return "";
        }
        String delimiter = delim + " ";
        StringBuffer sb = new StringBuffer();
        int length = strs.length - 1;
        for (int i = 0; i < length; ++i) {
            sb.append(strs[i]).append(delimiter);
        }
        sb.append(strs[length]);
        return sb.toString();
    }

    public static String translateDate(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("JST"));
        return sdf.format(date);
    }

    public static Date translateDate(String dateStr) {
        if (dateStr == null || dateStr.equals("")) {
            return null;
        }
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("JST"));
        try {
            date = sdf.parse(dateStr);
        }
        catch (Exception e) {
            return null;
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProperty(String filename, String key) {
        File file = ALMailUtils.getFile(filename);
        if (file == null) {
            return null;
        }
        String value = null;
        Properties prop = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            prop.load(input);
            value = prop.getProperty(key);
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            value = null;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Exception", (Throwable)e);
                    value = null;
                }
            }
        }
        return value;
    }

    public static void setProperty(String filename, String key, String value) {
        File file = ALMailUtils.getFile(filename);
        if (file == null) {
            return;
        }
        Properties prop = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            prop.load(input);
            prop.put(key, value);
            prop.store(new FileOutputStream(file), null);
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
        }
    }

    public static File getFile(String filename) {
        if (filename == null) {
            return null;
        }
        File file = new File(filename);
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    return null;
                }
            }
            catch (IOException e) {
                return null;
            }
        }
        return file;
    }

    public static boolean deleteFolder(File folder) {
        if (folder == null) {
            return true;
        }
        String[] files = folder.list();
        if (files == null) {
            folder.delete();
            return true;
        }
        int length = files.length;
        if (length <= 0) {
            folder.delete();
            return true;
        }
        String folderPath = folder.getAbsolutePath() + File.separator;
        File tmpfile = null;
        for (int i = 0; i < length; ++i) {
            tmpfile = new File(folderPath + files[i]);
            if (!tmpfile.exists()) continue;
            if (tmpfile.isFile()) {
                tmpfile.delete();
                continue;
            }
            if (!tmpfile.isDirectory()) continue;
            ALMailUtils.deleteFolder(tmpfile);
        }
        folder.delete();
        return true;
    }

    public static boolean createLockFile(String dir, String userId) {
        block5: {
            try {
                Calendar calendar;
                long nowTime;
                File lockDir = new File(dir);
                if (!lockDir.exists()) {
                    lockDir.mkdirs();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(dir).append(File.separator).append(userId).append(".lock");
                File lockFile = new File(sb.toString());
                if (lockFile.createNewFile()) break block5;
                long lastModifiedTime = lockFile.lastModified();
                if (lastModifiedTime + 1200000L < (nowTime = (calendar = Calendar.getInstance()).getTimeInMillis())) {
                    lockFile.delete();
                    if (!lockFile.createNewFile()) {
                        return false;
                    }
                    break block5;
                }
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static boolean deleteLockFile(String dir, String userId) {
        StringBuffer sb = new StringBuffer();
        sb.append(dir).append(File.separator).append(userId).append(".lock");
        File lockFile = new File(sb.toString());
        return lockFile.delete();
    }

    public static Date getReceivedDate(MimeMessage msg) {
        try {
            String[] receivedHeaders = msg.getHeader("Received");
            if (receivedHeaders == null || receivedHeaders.length == 0) {
                return null;
            }
            Date receivedDate = null;
            StringTokenizer st = new StringTokenizer(receivedHeaders[0], ";");
            if (st.countTokens() == 2) {
                st.nextToken();
                String receivedDateStr = st.nextToken();
                if (receivedDateStr != null && !receivedDateStr.equals("")) {
                    receivedDate = MailUtility.parseDate((String)receivedDateStr);
                }
                return receivedDate;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String convertBase64ToIso2022(String str) {
        if (str == null || str.length() <= 0) {
            return str;
        }
        StringBuffer sb = new StringBuffer("=?ISO-2022-JP?B?");
        sb.append(str).append("?=");
        return sb.toString();
    }

    public static String encodeWordJIS(String s) {
        try {
            return "=?ISO-2022-JP?B?" + new String(BASE64EncoderStream.encode((byte[])CharCodeConverter.sjisToJis((byte[])UnicodeCorrecter.correctToCP932(s).getBytes("Windows-31J")))) + "?=";
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("CANT HAPPEN");
        }
    }

    public static InternetAddress getInternetAddress(String addr) {
        InternetAddress address = null;
        StringTokenizer st = new StringTokenizer(addr, "<>");
        int count = st.countTokens();
        try {
            if (count <= 0) {
                return null;
            }
            if (count == 1) {
                address = new InternetAddress(st.nextToken().trim());
            } else if (count == 2) {
                String name = st.nextToken().trim();
                String addressStr = st.nextToken().trim();
                address = new InternetAddress(addressStr, ALMailUtils.encodeWordJIS(name));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return null;
        }
        return address;
    }

    public static String[] checkFilesExistance(String[] filePaths) {
        ArrayList<String> checkedList = new ArrayList<String>();
        File file = null;
        int filePathsLength = filePaths.length;
        for (int i = 0; i < filePathsLength; ++i) {
            file = new File(filePaths[i]);
            if (!file.exists()) continue;
            checkedList.add(filePaths[i]);
        }
        int checkedListLength = checkedList.size();
        String[] filePathList = new String[checkedListLength];
        for (int i = 0; i < checkedListLength; ++i) {
            filePathList[i] = (String)checkedList.get(i);
        }
        return filePathList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileNameFromText(String FilePath) {
        String line = "";
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FilePath + ".txt"), ALEipConstants.DEF_CONTENT_ENCODING));
            line = reader.readLine();
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    logger.error((Object)"Exception", (Throwable)ex);
                }
            }
        }
        return line;
    }

    public static void setTextContent(Part p, String s) throws MessagingException {
        p.setDataHandler(new DataHandler((DataSource)new JISDataSource(s)));
        p.setHeader("Content-Transfer-Encoding", "7bit");
    }

    public static final byte[] getDecryptedMailAccountPasswd(byte[] data) {
        return ALMailUtils.getDecryptedMailAccountPasswd(seacretPassword.toCharArray(), data);
    }

    public static final byte[] getDecryptedMailAccountPasswd(char[] password, byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] decryptedData = null;
        try {
            decryptedData = ALMailUtils.cryptPBEWithMD5AndDES(2, password, data);
            if (decryptedData == null) {
                return null;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return null;
        }
        return decryptedData;
    }

    public static final byte[] getEncryptedMailAccountPasswd(byte[] data) {
        return ALMailUtils.getEncryptedMailAccountPasswd(seacretPassword.toCharArray(), data);
    }

    public static final byte[] getEncryptedMailAccountPasswd(char[] password, byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] encryptedData = null;
        try {
            encryptedData = ALMailUtils.cryptPBEWithMD5AndDES(1, password, data);
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return null;
        }
        return encryptedData;
    }

    public static final byte[] cryptPBEWithMD5AndDES(int cipherMode, char[] password, byte[] data) {
        byte[] ciphertext = null;
        byte[] salt = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};
        int count = 20;
        PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, count);
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
        try {
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
            Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
            pbeCipher.init(cipherMode, (Key)pbeKey, pbeParamSpec);
            ciphertext = pbeCipher.doFinal(data);
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return null;
        }
        return ciphertext;
    }

    public static ALMailReceiverContext getALPop3MailReceiverContext(String orgId, EipMMailAccount account) {
        if (account == null) {
            return null;
        }
        ALPop3MailReceiverContext rcontext = new ALPop3MailReceiverContext();
        try {
            rcontext.setOrgId(orgId);
            rcontext.setUserId(account.getUserId());
            rcontext.setAccountId(account.getAccountId());
            rcontext.setPop3Host(account.getPop3serverName());
            rcontext.setPop3Port(account.getPop3Port());
            rcontext.setPop3UserId(account.getPop3userName());
            rcontext.setPop3UserPasswd(new String(ALMailUtils.getDecryptedMailAccountPasswd(account.getPop3password())));
            rcontext.setDelete(Integer.parseInt(account.getDelAtPop3Flg()) == 1);
            rcontext.setEnableSavingDays(Integer.parseInt(account.getDelAtPop3BeforeDaysFlg()) == 1);
            rcontext.setSavingDays(account.getDelAtPop3BeforeDays());
            rcontext.setDenyReceivedMail(Integer.parseInt(account.getNonReceivedFlg()) == 1);
            rcontext.setAuthReceiveFlag(account.getAuthReceiveFlg().intValue());
        }
        catch (Exception e) {
            return null;
        }
        return rcontext;
    }

    public static ALMailSenderContext getALSmtpMailSenderContext(String orgId, EipMMailAccount account) {
        if (account == null) {
            return null;
        }
        ALSmtpMailSenderContext scontext = new ALSmtpMailSenderContext();
        int authSendFlg = 0;
        try {
            authSendFlg = Integer.parseInt(account.getAuthSendFlg());
        }
        catch (NumberFormatException e) {
            authSendFlg = 0;
        }
        try {
            scontext.setOrgId(orgId);
            scontext.setUserId(account.getUserId());
            scontext.setAccountId(account.getAccountId());
            scontext.setSmtpHost(account.getSmtpserverName());
            scontext.setSmtpPort(account.getSmtpPort());
            scontext.setAuthSendFlag(authSendFlg);
            scontext.setAuthSendUserId(account.getAuthSendUserId());
            byte[] auth_pass = ALMailUtils.getDecryptedMailAccountPasswd(account.getAuthSendUserPasswd());
            if (auth_pass != null) {
                scontext.setAuthSendUserPassword(new String(ALMailUtils.getDecryptedMailAccountPasswd(account.getAuthSendUserPasswd())));
            } else {
                scontext.setAuthSendUserPassword(null);
            }
            scontext.setPop3Host(account.getPop3serverName());
            scontext.setPop3Port(account.getPop3Port());
            scontext.setPop3UserId(account.getPop3userName());
            scontext.setPop3UserPasswd(new String(ALMailUtils.getDecryptedMailAccountPasswd(account.getPop3password())));
        }
        catch (Exception e) {
            return null;
        }
        return scontext;
    }

    public static ALSmtpMailContext getALSmtpMailContext(String[] to, String[] cc, String[] bcc, String from, String name, String subject, String msgText, String[] filePaths, Map additionalHeaders) {
        ALSmtpMailContext mailcontext = new ALSmtpMailContext();
        mailcontext.setTo(to);
        mailcontext.setCc(cc);
        mailcontext.setBcc(bcc);
        mailcontext.seFrom(from);
        mailcontext.setName(name);
        mailcontext.setSubject(subject);
        mailcontext.setMsgText(msgText);
        mailcontext.setFilePaths(filePaths);
        mailcontext.setAdditionalHeaders(additionalHeaders);
        return mailcontext;
    }

    public static EipMMailAccount getEipMMailAccountForAdmin() {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipMMailAccount.class);
            Expression exp = ExpressionFactory.matchExp((String)"userId", (Object)1);
            query.andQualifier(exp);
            List accounts = dataContext.performQuery((Query)query);
            if (accounts == null || accounts.size() == 0) {
                logger.debug((Object)"[ALMailUtils] Not found AccountID...");
                return null;
            }
            return (EipMMailAccount)accounts.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipMMailAccount getFirstEipMMailAccount(int userId) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipMMailAccount.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)userId);
            query.setQualifier(exp1);
            Expression exp21 = ExpressionFactory.matchExp((String)"accountType", (Object)"1");
            Expression exp22 = ExpressionFactory.matchExp((String)"accountType", (Object)"2");
            query.andQualifier(exp21.orExp(exp22));
            List accounts = dataContext.performQuery((Query)query);
            if (accounts == null || accounts.size() == 0) {
                logger.debug((Object)"[ALMailUtils] Not found AccountID...");
                return null;
            }
            return (EipMMailAccount)accounts.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static boolean insertMailAccountData(RunData rundata, ArrayList msgList, int userId, String accountName, int accountType, String mailAddress, String mailUserName, String smtpServerName, int smtpPort, String Pop3ServerName, int pop3Port, String pop3UserName, String pop3Password, int authSendFlag, String authSendUserId, String authSendUserPasswd, int authReceiveFlg, int delAtPop3Flg, int delAtPop3BeforeDaysFlg, int delAtPop3BeforeDays, String nonReceivedFlg) {
        boolean enableUpdate = false;
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            Date createdDate = Calendar.getInstance().getTime();
            EipMMailAccount mailAccount = null;
            if (accountType == 2) {
                mailAccount = (EipMMailAccount)dataContext.createAndRegisterNewObject(EipMMailAccount.class);
                mailAccount.setAccountType(Integer.toString(2));
            } else {
                SelectQuery query = new SelectQuery(EipMMailAccount.class);
                Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)userId);
                query.setQualifier(exp1);
                Expression exp2 = ExpressionFactory.matchExp((String)"accountType", (Object)2);
                query.andQualifier(exp2);
                List list = dataContext.performQuery((Query)query);
                if (list == null || list.size() <= 0) {
                    int count;
                    mailAccount = (EipMMailAccount)dataContext.createAndRegisterNewObject(EipMMailAccount.class);
                    SelectQuery query3 = new SelectQuery(EipMMailAccount.class);
                    Expression exp3 = ExpressionFactory.matchExp((String)"userId", (Object)userId);
                    query3.setQualifier(exp3);
                    List mails = dataContext.performQuery((Query)query3);
                    int n = count = mails != null && mails.size() > 0 ? mails.size() : 0;
                    if (count <= 0) {
                        mailAccount.setAccountType(Integer.toString(1));
                    } else {
                        mailAccount.setAccountType(Integer.toString(0));
                    }
                } else {
                    EipMMailAccount acc;
                    mailAccount = acc = (EipMMailAccount)list.get(0);
                    if (Integer.toString(2).equals(acc.getAccountType())) {
                        enableUpdate = true;
                        mailAccount.setAccountType(Integer.toString(1));
                    } else {
                        mailAccount.setAccountType(Integer.toString(0));
                    }
                }
            }
            mailAccount.setUserId(Integer.valueOf(userId));
            mailAccount.setAccountName(accountName);
            mailAccount.setSmtpserverName(smtpServerName);
            mailAccount.setPop3serverName(Pop3ServerName);
            mailAccount.setPop3userName(pop3UserName);
            mailAccount.setPop3password(ALMailUtils.getEncryptedMailAccountPasswd(pop3Password.getBytes()));
            mailAccount.setMailUserName(mailUserName);
            mailAccount.setMailAddress(mailAddress);
            mailAccount.setSmtpPort(Integer.toString(smtpPort));
            mailAccount.setPop3Port(Integer.toString(pop3Port));
            mailAccount.setAuthSendFlg(Integer.toString(authSendFlag));
            mailAccount.setAuthSendUserId(authSendUserId);
            if (authSendUserPasswd != null) {
                mailAccount.setAuthSendUserPasswd(ALMailUtils.getEncryptedMailAccountPasswd(authSendUserPasswd.getBytes()));
            }
            mailAccount.setAuthReceiveFlg(Short.valueOf((short)authReceiveFlg));
            mailAccount.setDelAtPop3Flg(Integer.valueOf(delAtPop3Flg).toString());
            mailAccount.setDelAtPop3BeforeDaysFlg(Integer.valueOf(delAtPop3BeforeDaysFlg).toString());
            mailAccount.setDelAtPop3BeforeDays(Integer.valueOf(delAtPop3BeforeDays));
            mailAccount.setNonReceivedFlg(nonReceivedFlg);
            mailAccount.setUpdateDate(createdDate);
            if (!enableUpdate) {
                mailAccount.setCreateDate(createdDate);
            }
            dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(mailAccount.getAccountId().intValue(), 231, mailAccount.getAccountName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public static boolean sendMailDelegate(String org_id, int srcUserId, List destMemberList, String pcSubject, String cellularSubject, String pcBody, String cellularBody, int destType, ArrayList msgList) throws Exception {
        ALSmtpMailContext mailcontext;
        String[] tos;
        if (destType < 0 || destType > 3) {
            return false;
        }
        if (destMemberList == null || destMemberList.size() == 0) {
            return false;
        }
        EipMMailAccount account = ALMailUtils.getEipMMailAccountForAdmin();
        if (account == null) {
            return false;
        }
        ArrayList<String> destEmailAddrs = new ArrayList<String>();
        ArrayList<String> destCellularEMailAddrs = new ArrayList<String>();
        int size = destMemberList.size();
        for (int i = 0; i < size; ++i) {
            String cellularEmailAddr;
            ALEipUserAddr user = (ALEipUserAddr)destMemberList.get(i);
            String emailAddr = user.getPcMailAddr();
            if (emailAddr != null && !emailAddr.equals("")) {
                destEmailAddrs.add(emailAddr);
            }
            if ((cellularEmailAddr = user.getCellMailAddr()) == null || cellularEmailAddr.equals("")) continue;
            destCellularEMailAddrs.add(cellularEmailAddr);
        }
        int destEmailAddrsSize = destEmailAddrs.size();
        int destCellularEMailAddrsSize = destCellularEMailAddrs.size();
        ALMailHandler mailhandler = ALMailFactoryService.getInstance().getMailHandler();
        ALMailSenderContext scontext = ALMailUtils.getALSmtpMailSenderContext(org_id, account);
        int successSendToPc = 0;
        int successSendToCell = 0;
        if ((destType == 1 || destType == 3) && destEmailAddrsSize > 0) {
            tos = new String[destEmailAddrsSize];
            tos = destEmailAddrs.toArray(tos);
            mailcontext = ALMailUtils.getALSmtpMailContext(tos, null, null, account.getMailAddress(), ALStringUtil.unsanitizing((String)account.getMailUserName()), ALStringUtil.unsanitizing((String)pcSubject), ALStringUtil.unsanitizing((String)pcBody), null, null);
            successSendToPc = mailhandler.send(scontext, mailcontext);
        }
        if ((destType == 2 || destType == 3) && destCellularEMailAddrsSize > 0) {
            tos = new String[destCellularEMailAddrsSize];
            tos = destCellularEMailAddrs.toArray(tos);
            mailcontext = ALMailUtils.getALSmtpMailContext(tos, null, null, account.getMailAddress(), ALStringUtil.unsanitizing((String)account.getMailUserName()), ALStringUtil.unsanitizing((String)cellularSubject), ALStringUtil.unsanitizing((String)cellularBody), null, null);
            successSendToCell = mailhandler.send(scontext, mailcontext);
        }
        return successSendToPc == 0 && successSendToCell == 0;
    }

    public static List getALEipUserAddrs(List memberList, int loginUserId, boolean includeLoginUser) {
        ArrayList<ALEipUserAddr> resList = new ArrayList<ALEipUserAddr>();
        ALEipUserAddr useraddr = null;
        int membersize = memberList.size();
        for (int i = 0; i < membersize; ++i) {
            ALEipUser user = (ALEipUser)memberList.get(i);
            if (!includeLoginUser && user.getUserId().getValue() == (long)loginUserId) continue;
            try {
                ALBaseUser baseuser = (ALBaseUser)JetspeedSecurity.getUser((String)user.getName().getValue());
                useraddr = new ALEipUserAddr();
                useraddr.setUserId(Integer.valueOf(baseuser.getUserId()));
                useraddr.setPcMailAddr(baseuser.getEmail());
                useraddr.setCellMailAddr(baseuser.getCellularMail());
                resList.add(useraddr);
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)"Exception", (Throwable)ex);
            }
        }
        return resList;
    }

    public static int getSendDestType(int keyMsgtype) {
        int destType = 0;
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipMMailNotifyConf.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)1);
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"notifyType", (Object)keyMsgtype);
            query.andQualifier(exp2);
            List confs = dataContext.performQuery((Query)query);
            if (confs == null || confs.size() == 0) {
                logger.debug((Object)"[ALMailUtils] Not found Notify...");
                return 0;
            }
            EipMMailNotifyConf conf = (EipMMailNotifyConf)confs.get(0);
            destType = conf.getNotifyFlg();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return 0;
        }
        return destType;
    }

    public static boolean setSendDestType(int keyMsgtype, int valueMsgtype) {
        try {
            if (valueMsgtype < 0 || valueMsgtype > 3) {
                return false;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipMMailNotifyConf.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"notifyType", (Object)keyMsgtype);
            query.setQualifier(exp1);
            List confs = dataContext.performQuery((Query)query);
            if (confs == null || confs.size() == 0) {
                logger.debug((Object)"[ALMailUtils] Not found Notify...");
                return false;
            }
            EipMMailNotifyConf conf = (EipMMailNotifyConf)confs.get(0);
            conf.setNotifyFlg(Integer.valueOf(valueMsgtype));
            dataContext.commitChanges();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public static String getGlobalurl() {
        EipMCompany record = ALEipUtils.getEipMCompany((String)"1");
        String domain = ALMailUtils.getUrl(record.getIpaddress(), record.getPort(), ALMailUtils.getServletName());
        return domain;
    }

    public static String getLocalurl() {
        String localurl = "";
        try {
            localurl = ALMailUtils.getUrl(InetAddress.getLocalHost().getHostAddress(), JetspeedResources.getInt((String)"aipo.webappserver.port", (int)80), ALMailUtils.getServletName());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return localurl;
    }

    private static String getServletName() {
        AipoDaemonFactoryService aipoDaemonService = (AipoDaemonFactoryService)TurbineServices.getInstance().getService("DaemonFactory");
        ServletConfig servlet_config = aipoDaemonService.getServletConfig();
        return servlet_config.getServletName();
    }

    private static String getUrl(String ip, int port, String servername) {
        if (ip == null || ip.length() == 0 || port == -1) {
            return "";
        }
        String protocol = JetspeedResources.getString((String)"access.url.protocol", (String)"http");
        StringBuffer url = new StringBuffer();
        if (port == 80) {
            url.append(protocol).append("://").append(ip).append("/").append(servername).append("/");
        } else {
            url.append(protocol).append("://").append(ip).append(":").append(port).append("/").append(servername).append("/");
        }
        return url.toString();
    }

    public static boolean setNotifyTime(int hour, int minute) {
        StringBuffer sb = new StringBuffer();
        if (hour < 10) {
            sb.append("0");
        }
        sb.append(Integer.toString(hour)).append(":");
        if (minute < 10) {
            sb.append("0");
        }
        sb.append(Integer.toString(minute)).append(":00");
        Time time = new Time(0L);
        time = Time.valueOf(sb.toString());
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        SelectQuery query = new SelectQuery(EipMMailNotifyConf.class);
        Expression exp = ExpressionFactory.matchDbExp((String)"NOTIFY_ID", (Object)"1");
        query.setQualifier(exp);
        List list = dataContext.performQuery((Query)query);
        if (list == null || list.size() == 0) {
            return false;
        }
        EipMMailNotifyConf notify = (EipMMailNotifyConf)list.get(0);
        notify.setNotifyTime((Date)time);
        dataContext.commitChanges();
        return true;
    }

    public static String getNotifyTime() {
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        SelectQuery query = new SelectQuery(EipMMailNotifyConf.class);
        Expression exp = ExpressionFactory.matchDbExp((String)"NOTIFY_ID", (Object)"1");
        query.setQualifier(exp);
        List list = dataContext.performQuery((Query)query);
        if (list == null || list.size() == 0) {
            return null;
        }
        Date date = ((EipMMailNotifyConf)list.get(0)).getNotifyTime();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        StringBuffer sb = new StringBuffer();
        int hour = cal.get(11);
        int minute = cal.get(12);
        if (hour < 10) {
            sb.append("0");
        }
        sb.append(hour).append(":");
        if (minute < 10) {
            sb.append("0");
        }
        sb.append(minute);
        return sb.toString();
    }
}

