/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.mail.util;

import com.sk_jp.mail.AttachmentsExtractor;
import com.sk_jp.mail.MailUtility;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;

public class ALAttachmentsExtractor
extends AttachmentsExtractor {
    private final int mode;
    private final List attachmentParts = new ArrayList();

    public ALAttachmentsExtractor() {
        this(0);
    }

    public ALAttachmentsExtractor(int mode) {
        this.mode = mode;
    }

    public boolean processPart(Part part, ContentType context) throws MessagingException, IOException {
        if (part.isMimeType("message/*")) {
            if ((this.mode & 1) != 0) {
                return true;
            }
            this.attachmentParts.add(part);
            return true;
        }
        if (part.isMimeType("text/html")) {
            this.attachmentParts.add(part);
            return true;
        }
        if (MailUtility.getFileName((Part)part) == null) {
            return true;
        }
        if ((this.mode & 2) != 0 && "inline".equalsIgnoreCase(part.getDisposition())) {
            return true;
        }
        this.attachmentParts.add(part);
        return true;
    }

    public String getFileName(int index) throws MessagingException {
        Part part = (Part)this.attachmentParts.get(index);
        String name = MailUtility.getFileName((Part)part);
        if (name == null) {
            name = part.isMimeType("message/*") ? "message" + index + ".eml" : (part.isMimeType("text/html") ? "message" + index + ".html" : "file" + index + ".tmp");
        }
        return name;
    }

    public int getCount() {
        return this.attachmentParts.size();
    }

    public String getContentType(int index) throws MessagingException {
        return MailUtility.unfold((String)((Part)this.attachmentParts.get(index)).getContentType());
    }

    public int getSize(int index) throws MessagingException {
        return ((Part)this.attachmentParts.get(index)).getSize();
    }

    public InputStream getInputStream(int index) throws MessagingException, IOException {
        return ((Part)this.attachmentParts.get(index)).getInputStream();
    }
}

