/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.mail.file;

import com.aimluck.eip.cayenne.om.portlet.EipTMail;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.ALAbstractFolder;
import com.aimluck.eip.mail.ALLocalMailMessage;
import com.aimluck.eip.mail.ALMailMessage;
import com.aimluck.eip.orm.DatabaseOrmService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class ALFileLocalFolder
extends ALAbstractFolder {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALFileLocalFolder.class.getName());
    public static final String DEFAULT_MAIL_FILENAME_DATE_FORMAT = "yyyyMMddHHmmssSSS";

    public ALFileLocalFolder(int type_mail, String org_id, int user_id, int account_id) {
        super(type_mail, org_id, user_id, account_id);
    }

    public ALLocalMailMessage getMail(int mailid) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTMail.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"MAIL_ID", (Object)mailid);
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)this.user_id);
            query.andQualifier(exp2);
            List mails = dataContext.performQuery((Query)query);
            if (mails == null || mails.size() == 0) {
                logger.debug((Object)"[Mail] Not found ID...");
                return null;
            }
            EipTMail email = (EipTMail)mails.get(0);
            ALLocalMailMessage msg = this.readMail(this.getFullName() + File.separator + email.getFilePath());
            email.setReadFlg("T");
            dataContext.commitChanges();
            return msg;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private ALLocalMailMessage readMail(String filepath) {
        System.setProperty("mail.mime.charset", "ISO-2022-JP");
        System.setProperty("mail.mime.decodetext.strict", "false");
        Properties prop = new Properties();
        prop.setProperty("mail.mime.address.strict", "false");
        ALLocalMailMessage localmsg = null;
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(filepath));
            localmsg = new ALLocalMailMessage(Session.getDefaultInstance((Properties)prop), input);
            input.close();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return localmsg;
    }

    public boolean saveMail(ALMailMessage mail) {
        boolean res = false;
        try {
            String tmpFileName = this.getNewFileName();
            res = this.saveMailToFile(mail, tmpFileName);
            if (res) {
                DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
                res = this.insertMailToDB(dataContext, (MimeMessage)mail, tmpFileName, false, false);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            res = false;
        }
        return res;
    }

    public boolean saveDefectiveMail(ALMailMessage mail) {
        boolean res = false;
        try {
            String tmpFileName = this.getNewFileName();
            res = this.saveMailToFile(mail, tmpFileName);
            if (res) {
                DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
                res = this.insertMailToDB(dataContext, (MimeMessage)mail, tmpFileName, false, false);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            res = false;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveMailToFile(ALMailMessage mail, String fileName) {
        boolean res = false;
        FilterOutputStream output = null;
        try {
            String pop3MailPath = this.getFullName() + File.separator + fileName;
            output = new BufferedOutputStream(new FileOutputStream(pop3MailPath));
            mail.writeTo(output);
            ((BufferedOutputStream)output).flush();
            output.close();
            mail.clearContents();
            res = true;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException ie) {
                logger.error((Object)"Exception", (Throwable)ie);
            }
            res = false;
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException ie) {
                logger.error((Object)"Exception", (Throwable)ie);
                res = false;
            }
        }
        return res;
    }

    public boolean deleteMail(int mailid) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTMail.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"MAIL_ID", (Object)mailid);
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)this.user_id);
            query.andQualifier(exp2);
            Expression exp3 = ExpressionFactory.matchExp((String)"accountId", (Object)this.account_id);
            query.andQualifier(exp3);
            List mails = dataContext.performQuery((Query)query);
            if (mails == null || mails.size() == 0) {
                logger.debug((Object)"[ALDbLocalFolder] Not found ID...");
                throw new ALPageNotFoundException();
            }
            EipTMail email = (EipTMail)mails.get(0);
            String filePath = email.getFilePath();
            dataContext.deleteObject((Persistent)email);
            dataContext.commitChanges();
            File file = new File(this.getFullName() + File.separator + filePath);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean deleteMails(List msgIndexes) {
        try {
            int i;
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTMail.class);
            Expression exp1 = ExpressionFactory.inDbExp((String)"MAIL_ID", (Collection)msgIndexes);
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)this.user_id);
            query.andQualifier(exp2);
            List mails = dataContext.performQuery((Query)query);
            if (mails == null || mails.size() == 0) {
                logger.debug((Object)"[ALFileLocalFolder] Not found ID...");
                throw new ALPageNotFoundException();
            }
            EipTMail email = null;
            int size = mails.size();
            String[] filePaths = new String[size];
            for (i = 0; i < size; ++i) {
                email = (EipTMail)mails.get(i);
                filePaths[i] = email.getFilePath();
            }
            dataContext.deleteObjects((Collection)mails);
            dataContext.commitChanges();
            for (i = 0; i < size; ++i) {
                File file = new File(this.getFullName() + File.separator + filePaths[i]);
                if (!file.exists()) continue;
                file.delete();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return false;
        }
        return true;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("read_flg", "readFlg");
        map.putValue("subject", "subject");
        map.putValue("person", "person");
        map.putValue("date", "eventDate");
        map.putValue("volume", "fileVolume");
        return map;
    }

    public int getNewMailNum() {
        return 0;
    }

    public void setNewMailNum(int num) {
    }

    public int getMailSum() {
        return 0;
    }

    public int getUnreadMailNum() {
        return 0;
    }

    public void close() {
    }

    public String getNewFileName() {
        int count = 0;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DEFAULT_MAIL_FILENAME_DATE_FORMAT);
        Date date = new Date();
        String tmpname = simpleDateFormat.format(date);
        String pop3MailPath = this.getFullName() + File.separator;
        File file = null;
        String newFileName = null;
        String newFilePath = null;
        while (true) {
            newFileName = tmpname + count;
            newFilePath = pop3MailPath + newFileName;
            file = new File(newFilePath);
            if (!file.exists()) break;
            ++count;
        }
        return newFileName;
    }
}

