/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.mail.db;

import com.aimluck.eip.cayenne.om.portlet.EipTMail;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.ALAbstractFolder;
import com.aimluck.eip.mail.ALLocalMailMessage;
import com.aimluck.eip.mail.ALMailMessage;
import com.aimluck.eip.orm.DatabaseOrmService;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class ALDbLocalFolder
extends ALAbstractFolder {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALDbLocalFolder.class.getName());

    public ALDbLocalFolder(int type_mail, String org_id, int user_id, int account_id) {
        super(type_mail, org_id, user_id, account_id);
    }

    public ALLocalMailMessage getMail(int mailid) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTMail.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"MAIL_ID", (Object)mailid);
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)this.user_id);
            query.andQualifier(exp2);
            List mails = dataContext.performQuery((Query)query);
            if (mails == null || mails.size() == 0) {
                logger.debug((Object)"[Mail] Not found ID...");
                return null;
            }
            EipTMail email = (EipTMail)mails.get(0);
            ALLocalMailMessage msg = this.readMail(new String(email.getMail()));
            email.setReadFlg("T");
            dataContext.commitChanges();
            return msg;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private ALLocalMailMessage readMail(String mail) {
        System.setProperty("mail.mime.charset", "ISO-2022-JP");
        System.setProperty("mail.mime.decodetext.strict", "false");
        Properties prop = new Properties();
        prop.setProperty("mail.mime.address.strict", "false");
        ALLocalMailMessage localmsg = null;
        ByteArrayInputStream input = null;
        try {
            input = new ByteArrayInputStream(mail.getBytes());
            localmsg = new ALLocalMailMessage(Session.getDefaultInstance((Properties)prop), input);
            input.close();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return localmsg;
    }

    public boolean saveMail(ALMailMessage mail) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            this.insertMailToDB(dataContext, (MimeMessage)mail, null, true, true);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean saveDefectiveMail(ALMailMessage mail) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            this.insertMailToDB(dataContext, (MimeMessage)mail, null, false, false);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean deleteMail(int mailid) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTMail.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"MAIL_ID", (Object)mailid);
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)this.user_id);
            query.andQualifier(exp2);
            Expression exp3 = ExpressionFactory.matchExp((String)"accountId", (Object)this.account_id);
            query.andQualifier(exp3);
            List mails = dataContext.performQuery((Query)query);
            if (mails == null || mails.size() == 0) {
                logger.debug((Object)"[ALDbLocalFolder] Not found ID...");
                throw new ALPageNotFoundException();
            }
            dataContext.deleteObject((Persistent)((EipTMail)mails.get(0)));
            dataContext.commitChanges();
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean deleteMails(List msgIndexes) {
        return false;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("subject", "subject");
        map.putValue("person", "person");
        map.putValue("date", "eventDate");
        map.putValue("volume", "fileVolume");
        return map;
    }

    public int getNewMailNum() {
        return 0;
    }

    public void setNewMailNum(int num) {
    }

    public int getMailSum() {
        return 0;
    }

    public int getUnreadMailNum() {
        return 0;
    }

    public void close() {
    }
}

