/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.mail;

import com.aimluck.eip.mail.ALFolder;
import com.aimluck.eip.mail.ALLocalMailMessage;
import com.aimluck.eip.mail.ALMailContext;
import com.aimluck.eip.mail.ALMailSender;
import com.aimluck.eip.mail.ALMailSenderContext;
import com.aimluck.eip.mail.ALPop3MailReceiver;
import com.aimluck.eip.mail.ALSmtpAuth;
import com.aimluck.eip.mail.ALSmtpMailContext;
import com.aimluck.eip.mail.ALSmtpMailSenderContext;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.sk_jp.mail.MailUtility;
import com.sun.mail.smtp.SMTPTransport;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public abstract class ALSmtpMailSender
implements ALMailSender {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALSmtpMailSender.class.getName());
    public static final int AUTH_SEND_NONE = 0;
    public static final int AUTH_SEND_POP_BEFORE_SMTP = 1;
    public static final int AUTH_SEND_SMTP_AUTH = 2;
    public static final int SEND_MSG_SUCCESS = 0;
    public static final int SEND_MSG_FAIL = 1;
    public static final int SEND_MSG_OVER_MAIL_MAX_SIZE = 2;
    public static final int SEND_MSG_LOCK = 3;
    public static final int SEND_MSG_FAIL_SMTP_AUTH = 4;
    public static final int MAIL_MAX_SIZE = 0xA00000;
    private final String CONNECTION_TIMEOUT = "120000";
    private final String TIMEOUT = "420000";
    public static final String MAIL_SMTP_HOST = "mail.smtp.host";
    public static final String MAIL_SMTP_PORT = "mail.smtp.port";
    public static final String MAIL_SMTP_CONNECTION_TIMEOUT = "mail.stmp.connectiontimeout";
    public static final String MAIL_SMTP_TIMEOUT = "mail.stmp.timeout";
    public static final String CHARSET_ISO2022JP = "iso-2022-jp";
    protected Properties smtpServerProp = null;
    protected Session session = null;
    protected ALSmtpMailSenderContext scontext = null;

    public ALSmtpMailSender(ALMailSenderContext scontext) {
        this.scontext = (ALSmtpMailSenderContext)scontext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ALLocalMailMessage createMessage(ALSmtpMailContext mcontext) {
        System.setProperty("mail.mime.charset", "ISO-2022-JP");
        System.setProperty("mail.mime.decodetext.strict", "false");
        ALLocalMailMessage msg = null;
        this.smtpServerProp = new Properties();
        this.smtpServerProp.setProperty(MAIL_SMTP_HOST, this.scontext.getSmtpHost());
        this.smtpServerProp.setProperty(MAIL_SMTP_PORT, this.scontext.getSmtpPort());
        this.smtpServerProp.put(MAIL_SMTP_CONNECTION_TIMEOUT, "120000");
        this.smtpServerProp.put(MAIL_SMTP_TIMEOUT, "420000");
        this.smtpServerProp.setProperty("mail.mime.address.strict", "false");
        this.smtpServerProp.put("mail.smtp.localhost", "localhost");
        if (this.scontext.getAuthSendFlag() == 2 && this.scontext.getAuthSendUserId() != null && !"".equals(this.scontext.getAuthSendUserId()) && this.scontext.getAuthSendUserPassword() != null && !"".equals(this.scontext.getAuthSendUserPassword())) {
            this.smtpServerProp.put("mail.smtp.auth", "true");
            this.session = Session.getInstance((Properties)this.smtpServerProp, (Authenticator)new ALSmtpAuth(this.scontext.getAuthSendUserId(), this.scontext.getAuthSendUserPassword()));
        } else {
            this.session = Session.getInstance((Properties)this.smtpServerProp, null);
        }
        try {
            msg = new ALLocalMailMessage(this.session);
            msg.setFrom((Address)new InternetAddress(mcontext.getFrom(), ALMailUtils.encodeWordJIS(mcontext.getName())));
            if (mcontext.getTo() == null) {
                throw new MessagingException();
            }
            this.setRecipient((Message)msg, Message.RecipientType.TO, mcontext.getTo());
            if (mcontext.getCc() != null) {
                this.setRecipient((Message)msg, Message.RecipientType.CC, mcontext.getCc());
            }
            if (mcontext.getBcc() != null) {
                this.setRecipient((Message)msg, Message.RecipientType.BCC, mcontext.getBcc());
            }
            msg.setHeader("Content-Type", "text/plain");
            msg.setHeader("Content-Transfer-Encoding", "7bit");
            msg.setHeader("X-Mailer", "Groupware Aipo");
            msg.setSubject(ALMailUtils.encodeWordJIS(mcontext.getSubject()));
            msg.setSentDate(new Date());
            Map headers = mcontext.getAdditionalHeaders();
            if (headers != null) {
                Map map = headers;
                synchronized (map) {
                    String key = null;
                    String value = null;
                    Map.Entry entry2 = null;
                    for (Map.Entry entry2 : headers.entrySet()) {
                        key = (String)entry2.getKey();
                        value = (String)entry2.getValue();
                        msg.setHeader(key, value);
                    }
                }
            }
            if (mcontext.getFilePaths() == null) {
                ALMailUtils.setTextContent((Part)msg, mcontext.getMsgText());
            } else {
                String[] checkedFilePaths = ALMailUtils.checkFilesExistance(mcontext.getFilePaths());
                int checkedFilePathsLength = checkedFilePaths.length;
                if (checkedFilePathsLength <= 0) {
                    ALMailUtils.setTextContent((Part)msg, mcontext.getMsgText());
                } else {
                    MimeMultipart multiPart = new MimeMultipart();
                    MimeBodyPart mimeText = new MimeBodyPart();
                    mimeText.setText(mcontext.getMsgText(), CHARSET_ISO2022JP);
                    multiPart.addBodyPart((BodyPart)mimeText);
                    MimeBodyPart mimeFile = null;
                    for (int i = 0; i < checkedFilePathsLength; ++i) {
                        mimeFile = new MimeBodyPart();
                        mimeFile.setDataHandler(new DataHandler((DataSource)new FileDataSource(checkedFilePaths[i])));
                        MailUtility.setFileName((Part)mimeFile, (String)ALMailUtils.getFileNameFromText(checkedFilePaths[i]), (String)"ISO-2022-JP", null);
                        multiPart.addBodyPart((BodyPart)mimeFile);
                    }
                    msg.setContent((Multipart)multiPart);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return null;
        }
        return msg;
    }

    public int send(ALMailContext context) {
        try {
            ALSmtpMailContext mcontext = (ALSmtpMailContext)context;
            ALLocalMailMessage msg = this.createMessage(mcontext);
            if (msg == null) {
                return 1;
            }
            int mailSize = msg.getSize();
            if (mailSize > 0xA00000) {
                return 2;
            }
            if (this.scontext.getAuthSendFlag() == 0) {
                Transport.send((Message)msg);
            } else if (this.scontext.getAuthSendFlag() == 1) {
                boolean success = ALPop3MailReceiver.isAuthenticatedUser(this.scontext.getPop3Host(), this.scontext.getPop3Port(), this.scontext.getPop3UserId(), this.scontext.getPop3UserPasswd());
                if (!success) {
                    return 1;
                }
                Transport.send((Message)msg);
            } else if (this.scontext.getAuthSendFlag() == 2) {
                Transport transport = this.session.getTransport("smtp");
                SMTPTransport smtpt = (SMTPTransport)transport;
                smtpt.setSASLRealm("localhost");
                smtpt.connect(this.scontext.getSmtpHost(), this.scontext.getAuthSendUserId(), this.scontext.getAuthSendUserPassword());
                smtpt.sendMessage((Message)msg, msg.getAllRecipients());
                smtpt.close();
            }
            ALFolder sendFolder = this.getALFolder();
            sendFolder.saveMail(msg);
        }
        catch (AuthenticationFailedException ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return 4;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return 1;
        }
        catch (Throwable e) {
            logger.error((Object)"Throwable", e);
            return 1;
        }
        return 0;
    }

    protected abstract ALFolder getALFolder();

    private void setRecipient(Message msg, Message.RecipientType recipientType, String[] addrString) throws AddressException, MessagingException {
        if (addrString == null) {
            return;
        }
        int addrStringLength = addrString.length;
        InternetAddress[] address = new InternetAddress[addrStringLength];
        for (int i = 0; i < addrStringLength; ++i) {
            address[i] = ALMailUtils.getInternetAddress(addrString[i]);
        }
        msg.setRecipients(recipientType, (Address[])address);
    }
}

