/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.mail;

import com.aimluck.eip.mail.ALFolder;
import com.aimluck.eip.mail.ALMailReceiver;
import com.aimluck.eip.mail.ALMailReceiverContext;
import com.aimluck.eip.mail.ALPop3MailReceiverContext;
import com.aimluck.eip.mail.ALPop3Message;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.sun.mail.pop3.POP3Folder;
import com.sun.mail.pop3.POP3Message;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.mail.AuthenticationFailedException;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMessage;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public abstract class ALPop3MailReceiver
implements ALMailReceiver {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALPop3MailReceiver.class.getName());
    public static final int AUTH_RECEIVE_NORMAL = 0;
    public static final int AUTH_RECEIVE_APOP = 1;
    public static final int RECEIVE_MSG_FAIL_LOCKED = -2;
    public static final int RECEIVE_MSG_FAIL_OVER_MAIL_MAX_SIZE = -3;
    public static final int RECEIVE_MSG_FAIL_CONNECT = -4;
    public static final int RECEIVE_MSG_FAIL_AUTH = -5;
    public static final int RECEIVE_MSG_FAIL_EXCEPTION = -6;
    public static final int RECEIVE_MSG_FAIL_OUTOFMEMORY = -7;
    public static final int MAIL_MAX_SIZE = 0xA00000;
    private static final String CONNECTION_TIMEOUT = "60000";
    private static final String TIMEOUT = "300000";
    protected ALPop3MailReceiverContext rcontext;

    public ALPop3MailReceiver(ALMailReceiverContext rcontext) {
        this.rcontext = (ALPop3MailReceiverContext)rcontext;
    }

    protected abstract ALFolder getALFolder();

    public int receive() throws Exception {
        Store pop3Store = null;
        POP3Folder pop3Folder = null;
        ALFolder receiveFolder = null;
        int newMailSum = 0;
        ArrayList<String> newUIDL = null;
        ArrayList receivedUIDL = new ArrayList();
        String nowReceivedUID = null;
        boolean overMailMaxSize = false;
        boolean finishedReceiving = false;
        try {
            int i;
            Session session = this.getSession(this.rcontext.getAuthReceiveFlag());
            pop3Store = session.getStore("pop3");
            pop3Store.connect(this.rcontext.getPop3Host(), Integer.parseInt(this.rcontext.getPop3Port()), this.rcontext.getPop3UserId(), this.rcontext.getPop3UserPasswd());
            pop3Folder = (POP3Folder)pop3Store.getFolder("INBOX");
            if (pop3Folder == null) {
                this.close(pop3Store, (Folder)pop3Folder, receiveFolder);
                return -1;
            }
            pop3Folder.open(2);
            receiveFolder = this.getALFolder();
            if (receiveFolder == null) {
                this.close(pop3Store, (Folder)pop3Folder, receiveFolder);
                return -1;
            }
            int totalMessages = pop3Folder.getMessageCount();
            if (totalMessages == 0) {
                receiveFolder.setNewMailNum(0);
                this.close(pop3Store, (Folder)pop3Folder, receiveFolder);
                return 0;
            }
            List oldUIDL = receiveFolder.loadUID();
            newUIDL = new ArrayList<String>();
            Message[] messages = pop3Folder.getMessages();
            String uid = null;
            totalMessages = messages.length;
            for (int i2 = 0; i2 < totalMessages; ++i2) {
                uid = pop3Folder.getUID((Message)((MimeMessage)messages[i2]));
                if (uid == null) {
                    String[] xuidls = messages[i2].getHeader("X-UIDL");
                    uid = xuidls != null && xuidls.length > 0 ? xuidls[0] : ((MimeMessage)messages[i2]).getMessageID();
                }
                newUIDL.add(uid);
            }
            BitSet retrieveFlags = new BitSet();
            if (this.rcontext.getDenyReceivedMail()) {
                for (i = 0; i < totalMessages; ++i) {
                    if (!oldUIDL.contains(newUIDL.get(i))) {
                        retrieveFlags.set(i);
                        continue;
                    }
                    receivedUIDL.add(newUIDL.get(i));
                }
            } else {
                for (i = 0; i < totalMessages; ++i) {
                    retrieveFlags.set(i);
                }
            }
            oldUIDL.clear();
            newUIDL.clear();
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.set(5, cal.get(5) - this.rcontext.getSavingDays());
            Date limitDate = cal.getTime();
            MimeMessage tmpMessage = null;
            ALPop3Message alPop3MailMessage = null;
            for (int i3 = 0; i3 < totalMessages; ++i3) {
                Date receivedDate;
                finishedReceiving = false;
                tmpMessage = (MimeMessage)pop3Folder.getMessage(i3 + 1);
                if (retrieveFlags.get(i3)) {
                    nowReceivedUID = pop3Folder.getUID((Message)tmpMessage);
                    if (nowReceivedUID == null) {
                        String[] xuidls = tmpMessage.getHeader("X-UIDL");
                        nowReceivedUID = xuidls != null && xuidls.length > 0 ? xuidls[0] : tmpMessage.getMessageID();
                    }
                    alPop3MailMessage = new ALPop3Message((POP3Message)tmpMessage, i3 + 1);
                    if (tmpMessage.getSize() <= 0xA00000) {
                        receiveFolder.saveMail(alPop3MailMessage);
                    } else {
                        receiveFolder.saveDefectiveMail(alPop3MailMessage);
                        overMailMaxSize = true;
                    }
                    receivedUIDL.add(nowReceivedUID);
                    ++newMailSum;
                }
                if (this.rcontext.getDelete()) {
                    tmpMessage.setFlag(Flags.Flag.DELETED, this.rcontext.getDelete());
                } else if (this.rcontext.getEnableSavingDays() && (receivedDate = ALMailUtils.getReceivedDate(tmpMessage)) != null && receivedDate.before(limitDate)) {
                    tmpMessage.setFlag(Flags.Flag.DELETED, true);
                }
                finishedReceiving = true;
            }
            this.close(pop3Store, (Folder)pop3Folder, null);
        }
        catch (AuthenticationFailedException ae) {
            logger.error((Object)"Exception", (Throwable)ae);
            if (!finishedReceiving) {
                receivedUIDL.remove(nowReceivedUID);
            }
            receiveFolder.saveUID(receivedUIDL);
            receivedUIDL.clear();
            receiveFolder.setNewMailNum(newMailSum);
            this.close(pop3Store, (Folder)pop3Folder, receiveFolder);
            return -5;
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            if (!finishedReceiving) {
                receivedUIDL.remove(nowReceivedUID);
            }
            receiveFolder.saveUID(receivedUIDL);
            receivedUIDL.clear();
            receiveFolder.setNewMailNum(newMailSum);
            this.close(pop3Store, (Folder)pop3Folder, receiveFolder);
            return -6;
        }
        catch (Throwable t) {
            logger.error((Object)"Throwable", t);
            if (!finishedReceiving) {
                receivedUIDL.remove(nowReceivedUID);
            }
            receiveFolder.saveUID(receivedUIDL);
            receivedUIDL.clear();
            receiveFolder.setNewMailNum(newMailSum);
            this.close(pop3Store, (Folder)pop3Folder, receiveFolder);
            return -7;
        }
        try {
            receiveFolder.saveUID(receivedUIDL);
            receivedUIDL.clear();
            receiveFolder.setNewMailNum(newMailSum);
            receiveFolder.close();
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return -6;
        }
        catch (Throwable t) {
            logger.error((Object)"Throwable", t);
            return -7;
        }
        if (overMailMaxSize) {
            return -3;
        }
        return 0;
    }

    public void close(Store pop3Store, Folder pop3Folder, ALFolder receiveFolder) {
        try {
            if (pop3Folder != null && pop3Folder.isOpen()) {
                pop3Folder.close(true);
            }
            if (pop3Store != null && pop3Store.isConnected()) {
                pop3Store.close();
            }
            if (receiveFolder != null) {
                receiveFolder.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAuthenticatedUser(String pop3Host, String pop3Port, String pop3UserId, String pop3UserPasswd) {
        boolean res = false;
        Store pop3Store = null;
        try {
            Session session = Session.getDefaultInstance((Properties)System.getProperties(), null);
            pop3Store = session.getStore("pop3");
            pop3Store.connect(pop3Host, Integer.parseInt(pop3Port), pop3UserId, pop3UserPasswd);
            res = pop3Store.isConnected();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            res = false;
        }
        finally {
            if (pop3Store != null && pop3Store.isConnected()) {
                try {
                    pop3Store.close();
                }
                catch (MessagingException ex) {
                    logger.error((Object)"Exception", (Throwable)ex);
                    res = false;
                }
            }
        }
        return res;
    }

    public int getNewMailSum() {
        Store pop3Store = null;
        POP3Folder pop3Folder = null;
        ALFolder receiveFolder = null;
        int newMailSum = -1;
        try {
            int i;
            Session session = this.getSession(this.rcontext.getAuthReceiveFlag());
            pop3Store = session.getStore("pop3");
            pop3Store.connect(this.rcontext.getPop3Host(), Integer.parseInt(this.rcontext.getPop3Port()), this.rcontext.getPop3UserId(), this.rcontext.getPop3UserPasswd());
            pop3Folder = (POP3Folder)pop3Store.getFolder("INBOX");
            if (pop3Folder == null) {
                this.close(pop3Store, (Folder)pop3Folder, receiveFolder);
                return -1;
            }
            pop3Folder.open(2);
            receiveFolder = this.getALFolder();
            if (receiveFolder == null) {
                this.close(pop3Store, (Folder)pop3Folder, receiveFolder);
                return -1;
            }
            int totalMessages = pop3Folder.getMessageCount();
            if (totalMessages == 0) {
                this.close(pop3Store, (Folder)pop3Folder, receiveFolder);
                return 0;
            }
            if (!this.rcontext.getDenyReceivedMail()) {
                this.close(pop3Store, (Folder)pop3Folder, receiveFolder);
                return totalMessages;
            }
            List oldUIDL = receiveFolder.loadUID();
            ArrayList<String> newUIDL = new ArrayList<String>();
            Message[] messages = pop3Folder.getMessages();
            String uid = null;
            totalMessages = messages.length;
            for (i = 0; i < totalMessages; ++i) {
                uid = pop3Folder.getUID((Message)((MimeMessage)messages[i]));
                if (uid == null) {
                    String[] xuidls = messages[i].getHeader("X-UIDL");
                    uid = xuidls != null && xuidls.length > 0 ? xuidls[0] : ((MimeMessage)messages[i]).getMessageID();
                }
                newUIDL.add(uid);
            }
            newMailSum = 0;
            for (i = 0; i < totalMessages; ++i) {
                if (oldUIDL.contains(newUIDL.get(i))) continue;
                ++newMailSum;
            }
            this.close(pop3Store, (Folder)pop3Folder, receiveFolder);
        }
        catch (MessagingException e) {
            logger.error((Object)"Exception", (Throwable)e);
            this.close(pop3Store, (Folder)pop3Folder, null);
            return -1;
        }
        return newMailSum;
    }

    private Session getSession(int authReceiveFlag) {
        Properties props = new Properties();
        props.put("mail.pop3.connectiontimeout", CONNECTION_TIMEOUT);
        props.put("mail.pop3.timeout", TIMEOUT);
        if (authReceiveFlag == 1) {
            props.put("mail.pop3.apop.enable", "true");
        }
        Session session = Session.getInstance((Properties)props, null);
        return session;
    }
}

