/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.mail;

import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.mail.ALMailFactoryService;
import com.aimluck.eip.mail.ALMailHandler;
import com.aimluck.eip.mail.ALMailReceiverContext;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.mail.util.ALStaticObject;
import com.aimluck.eip.orm.DatabaseOrmService;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.access.DataContext;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.om.security.User;

public class ALPop3MailReceiveThread
implements Runnable {
    public static final String KEY_THREAD_NAME = "tr_pop3mail_recieve";
    public static final Integer KEY_SYNCHRONIZED_LOCK = 1;
    public static final String KEY_THREAD_STAT = "tr_pop3mail_recieve_stat";
    public static final String KEY_THREAD_RESULT = "tr_pop3mail_recieve_res";
    public static final String KEY_THREAD_NEWMAILNUM = "tr_pop3mail_recieve_newmailnum";
    public static final int PROCESS_TYPE_RECEIVEMAIL = 1;
    public static final int PROCESS_TYPE_GET_NEWMAILNUM = 2;
    public static final int PROCESS_STAT_FINISHED = 0;
    public static final int PROCESS_STAT_PROCESSING = -100;
    public static final int PROCESS_STAT_NONPROCESSING = -101;
    private String orgId = null;
    private JetspeedUser user;
    private String userId = null;
    private int mailAccountId = 0;
    private int processType = 1;
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALPop3MailReceiveThread.class.getName());

    public ALPop3MailReceiveThread(String orgId, JetspeedUser user, int mailAccountId, int processType) {
        this.orgId = orgId;
        this.user = user;
        this.mailAccountId = mailAccountId;
        this.processType = processType;
        this.userId = user.getUserId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int res = 0;
        HashMap<Integer, Map<Integer, Map<String, Integer>>> result = null;
        Map<String, Integer> statMap = null;
        try {
            result = (HashMap<Integer, Map<Integer, Map<String, Integer>>>)this.user.getTemp(KEY_THREAD_NAME);
            if (result != null) {
                statMap = (Map)result.get(this.mailAccountId);
                if (statMap == null) {
                    statMap = new HashMap();
                    result.put(this.mailAccountId, statMap);
                }
                statMap.put(KEY_THREAD_STAT, -100);
                statMap.put(KEY_THREAD_NEWMAILNUM, -100);
            } else {
                statMap = new HashMap<String, Integer>();
                statMap.put(KEY_THREAD_STAT, -100);
                statMap.put(KEY_THREAD_NEWMAILNUM, -100);
                result = new HashMap<Integer, Map<Integer, Map<String, Integer>>>();
                result.put(this.mailAccountId, statMap);
                this.user.setTemp(KEY_THREAD_NAME, result);
            }
            EipMMailAccount account = ALMailUtils.getMailAccount(Integer.parseInt(this.userId), this.mailAccountId);
            if (this.processType == 1) {
                System.out.println("[ALFilePop3MailReceiveThread] start receivemail (orgId, userId, mailAccountId)=(" + this.orgId + "," + this.userId + "," + this.mailAccountId + ")");
                res = this.receiveMail(this.orgId, account);
            } else if (this.processType == 2) {
                System.out.println("[ALFilePop3MailReceiveThread] start newmailnum (orgId, userId, mailAccountId)=(" + this.orgId + "," + this.userId + "," + this.mailAccountId + ")");
                int num = this.checkNewMailNum(this.orgId, account);
                if (num > -1) {
                    statMap.put(KEY_THREAD_NEWMAILNUM, num);
                    res = 0;
                } else {
                    res = -1;
                }
            }
            statMap.put(KEY_THREAD_RESULT, res);
            statMap.put(KEY_THREAD_STAT, 0);
            ALStaticObject ob = ALStaticObject.getInstance();
            ob.removeId(this.mailAccountId);
        }
        catch (Exception e) {
            logger.error((Object)"[ALFilePop3MailReceiveThread]", (Throwable)e);
        }
    }

    private int receiveMail(String orgId, EipMMailAccount account) {
        int result = -1;
        if (account == null) {
            return result;
        }
        try {
            ALMailHandler handler = ALMailFactoryService.getInstance().getMailHandler();
            ALMailReceiverContext rcontext = ALMailUtils.getALPop3MailReceiverContext(orgId, account);
            result = handler.receive(rcontext);
            if (result != 0 && result != -3) {
                return result;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            account.setLastReceivedDate(new Date());
            dataContext.commitChanges();
        }
        catch (Exception ex) {
            logger.error((Object)"[ALFilePop3MailReceiveThread]", (Throwable)ex);
            result = -1;
            return result;
        }
        return result;
    }

    private int checkNewMailNum(String orgId, EipMMailAccount account) {
        int res = -1;
        if (account == null) {
            return res;
        }
        try {
            ALMailHandler handler = ALMailFactoryService.getInstance().getMailHandler();
            ALMailReceiverContext rcontext = ALMailUtils.getALPop3MailReceiverContext(orgId, account);
            res = handler.getNewMailSum(rcontext);
        }
        catch (Exception ex) {
            logger.error((Object)"[ALFilePop3MailReceiveThread]", (Throwable)ex);
            res = -1;
        }
        return res;
    }

    public static int getNewMailNum(User user, int mailAccountId) {
        if (user == null) {
            return -101;
        }
        Map result = (Map)user.getTemp(KEY_THREAD_NAME);
        if (result == null) {
            return -101;
        }
        Map statMap = (Map)result.get(mailAccountId);
        if (statMap == null) {
            return -101;
        }
        Integer res = (Integer)statMap.get(KEY_THREAD_RESULT);
        if (res == null) {
            return -101;
        }
        if (res != 0) {
            return res;
        }
        Integer mailNum = (Integer)statMap.get(KEY_THREAD_NEWMAILNUM);
        if (mailNum == null) {
            return -100;
        }
        return mailNum;
    }

    public static boolean isProcessing(User user, int mailAccountId) {
        int stat = ALPop3MailReceiveThread.getStat(user, mailAccountId);
        return stat == -100;
    }

    public static int getStat(User user, int mailAccountId) {
        Map result = (Map)user.getTemp(KEY_THREAD_NAME);
        if (result == null) {
            return -101;
        }
        Map statMap = (Map)result.get(mailAccountId);
        if (statMap == null) {
            return -101;
        }
        Integer stat = (Integer)statMap.get(KEY_THREAD_STAT);
        if (stat == null) {
            return -101;
        }
        return stat;
    }

    public static int getReceiveMailResult(User user, int mailAccountId) {
        Map result = (Map)user.getTemp(KEY_THREAD_NAME);
        if (result == null) {
            return -101;
        }
        Map statMap = (Map)result.get(mailAccountId);
        if (statMap == null) {
            return -101;
        }
        Integer res = (Integer)statMap.get(KEY_THREAD_RESULT);
        if (res == null) {
            return -101;
        }
        statMap.remove(KEY_THREAD_RESULT);
        return res;
    }

    public static String getReceiveMailResultStr(User user, int mailAccountId) {
        String msg = null;
        int stat = ALPop3MailReceiveThread.getStat(user, mailAccountId);
        if (stat == -100) {
            msg = "\u30e1\u30fc\u30eb\u3092\u53d7\u4fe1\u4e2d\u3067\u3059\u3002";
            return msg;
        }
        if (stat == -101) {
            msg = "";
            return msg;
        }
        int res = ALPop3MailReceiveThread.getReceiveMailResult(user, mailAccountId);
        msg = res == -101 ? "" : (res == -1 ? "\u30e1\u30fc\u30eb\u3092\u53d7\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u30e1\u30fc\u30eb\u30a2\u30ab\u30a6\u30f3\u30c8\u306e\u8a2d\u5b9a\u3092\u3054\u78ba\u8a8d\u304f\u3060\u3055\u3044\u3002" : (res == -2 ? "\u30e1\u30fc\u30eb\u306e\u53d7\u4fe1\u4e2d\u3001\u3082\u3057\u304f\u306f\u3001\u30e1\u30f3\u30c6\u30ca\u30f3\u30b9\u4e2d\u3067\u3059\u3002\u3057\u3070\u3089\u304f\u3057\u3066\u304b\u3089\u3001\u300e\u30e1\u30fc\u30eb\u4e00\u89a7\u300f\u30dc\u30bf\u30f3\u3092\u62bc\u3057\u3066\u304f\u3060\u3055\u3044\u3002" : (res == -3 ? "7MB \u3088\u308a\u3082\u5927\u304d\u3044\u30b5\u30a4\u30ba\u306e\u30e1\u30fc\u30eb\u304c\u3042\u308a\u307e\u3057\u305f\u30027MB\u3092\u8d85\u3048\u305f\u30e1\u30fc\u30eb\u306e\u5834\u5408\u306f\u3001\u9001\u4fe1\u8005\u306a\u3069\u306e\u60c5\u5831\u306e\u307f\u53d7\u4fe1\u3057\u3001\u672c\u6587\u306f\u53d7\u4fe1\u3057\u307e\u305b\u3093\u3002" : (res == -4 ? "\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u53d7\u4fe1\u30b5\u30fc\u30d0\uff08POP3\uff09\u3068\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" : (res == -5 ? "\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u53d7\u4fe1\u30b5\u30fc\u30d0\uff08POP3\uff09\u3078\u306e\u30ed\u30b0\u30a4\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" : (res == -6 ? "\u30b7\u30b9\u30c6\u30e0\u4e0a\u306e\u554f\u984c\u306b\u3088\u308a\u3001\u30e1\u30fc\u30eb\u3092\u53d7\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff08Exception \u30a8\u30e9\u30fc\uff09\u3002" : (res == -7 ? "\u30b7\u30b9\u30c6\u30e0\u4e0a\u306e\u554f\u984c\u306b\u3088\u308a\u3001\u30e1\u30fc\u30eb\u3092\u53d7\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff08OutOfMemory \u30a8\u30e9\u30fc\uff09\u3002" : "\u30e1\u30fc\u30eb\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f\u3002")))))));
        return msg;
    }
}

