/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.mail;

import com.aimluck.eip.cayenne.om.portlet.EipTMail;
import com.aimluck.eip.mail.ALFolder;
import com.aimluck.eip.mail.ALMailContext;
import com.aimluck.eip.mail.ALMailReceiver;
import com.aimluck.eip.mail.ALMailReceiverContext;
import com.aimluck.eip.mail.ALMailSender;
import com.aimluck.eip.mail.ALMailSenderContext;
import com.aimluck.eip.orm.DatabaseOrmService;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public abstract class ALMailHandler {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALMailHandler.class.getName());

    public int receive(ALMailReceiverContext rcontext) throws Exception {
        int result = 0;
        try {
            ALMailReceiver receiver = this.getALMailReceiver(rcontext);
            result = receiver.receive();
        }
        catch (Exception e) {
            result = -1;
            logger.error((Object)"Exception", (Throwable)e);
        }
        return result;
    }

    protected abstract ALMailReceiver getALMailReceiver(ALMailReceiverContext var1);

    public int send(ALMailSenderContext scontext, ALMailContext mcontext) throws Exception {
        int result = 0;
        try {
            ALMailSender sender = this.getALMailSender(scontext);
            result = sender.send(mcontext);
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            result = 1;
        }
        return result;
    }

    protected abstract ALMailSender getALMailSender(ALMailSenderContext var1);

    public abstract ALFolder getALFolder(int var1, String var2, int var3, int var4);

    public int getUnReadMailSum(ALMailReceiverContext rcontext) {
        int mailSum = 0;
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTMail.class);
            query.addCustomDbAttribute("MAIL_ID");
            Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)rcontext.getUserId());
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"accountId", (Object)rcontext.getAccountId());
            query.andQualifier(exp2);
            Expression exp3 = ExpressionFactory.matchExp((String)"readFlg", (Object)"F");
            query.andQualifier(exp3);
            List mails = dataContext.performQuery((Query)query);
            mailSum = mails != null && mails.size() > 0 ? mails.size() : 0;
        }
        catch (Exception e) {
            mailSum = 0;
        }
        return mailSum;
    }

    public int getNewMailSum(ALMailReceiverContext rcontext) throws Exception {
        int result = -1;
        boolean createLock = false;
        try {
            ALMailReceiver receiver = this.getALMailReceiver(rcontext);
            result = receiver != null ? receiver.getNewMailSum() : -1;
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            result = -1;
        }
        return result;
    }

    public abstract boolean removeAccount(String var1, int var2, int var3);
}

