/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.actions.account;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.modules.actions.common.ALBaseAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALCellularUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CellAccountLoginAction
extends ALBaseAction {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CellAccountLoginAction.class.getName());
    private String org_id;

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) throws Exception {
        String action_logout = rundata.getParameters().getString("logout", "").trim();
        if ("T".equals(action_logout)) {
            this.setTemplate(rundata, "accountlogout-info");
        }
        this.org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
        this.doAccount_login(rundata, context);
        this.setResultData((Object)this);
        this.putData(rundata, context);
    }

    public void doAccount_login(RunData rundata, Context context) throws Exception {
        boolean enableEasyLogin = false;
        String username = null;
        String key = rundata.getParameters().getString("key", "").trim();
        StringTokenizer st = new StringTokenizer(key, "_");
        if (st.countTokens() == 2) {
            username = st.nextToken();
            String base64value = st.nextToken();
            ALStringField tmpname = new ALStringField();
            tmpname.setTrim(true);
            tmpname.setNotNull(true);
            tmpname.setCharacterType(3);
            tmpname.limitMaxLength(16);
            tmpname.setValue(username);
            boolean valid = tmpname.validate(new ArrayList());
            if (valid) {
                Expression exp;
                SelectQuery query;
                DataContext dataContext = DataContext.createDataContext((String)this.org_id);
                List users = dataContext.performQuery((Query)(query = new SelectQuery(TurbineUser.class, exp = ExpressionFactory.matchExp((String)"loginName", (Object)username))));
                if (users.size() != 0) {
                    String uid;
                    TurbineUser tuser = (TurbineUser)users.get(0);
                    if (!ALCellularUtils.getCheckValueForCellLogin((String)username, (String)tuser.getUserId().toString()).equals(base64value)) {
                        username = "";
                    }
                    enableEasyLogin = (uid = tuser.getCellularUid()) != null && uid.length() > 0;
                } else {
                    username = "";
                }
            } else {
                username = "";
            }
        }
        context.put("username", (Object)username);
        context.put("key", (Object)key);
        context.put("enableEasyLogin", (Object)enableEasyLogin);
    }

    public void doAccount_info(RunData rundata, Context context) throws Exception {
        this.doAccount_login(rundata, context);
        this.setTemplate(rundata, "accountlogin-info");
    }

    public String getCompanyId() {
        return DatabaseOrmService.getInstance().getCompanyId(this.org_id);
    }
}

