/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.account.util;

import com.aimluck.eip.cayenne.om.account.EipMCompany;
import com.aimluck.eip.cayenne.om.account.EipMPosition;
import com.aimluck.eip.cayenne.om.account.EipMPost;
import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.cayenne.om.security.TurbineUserGroupRole;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.user.beans.UserGroupLiteBean;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.security.UnknownUserException;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccountUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccountUtils.class.getName());
    public static final String FOLDER_TMP_FOR_CSV_FILES = JetspeedResources.getString((String)"aipo.tmp.directory", (String)"");
    public static final String FOLDER_TMP_FOR_USERINFO_CSV_FILENAME = "user_info.csv";
    public static final int CSV_FILE_COL_COUNT = 11;

    public static ALBaseUser getBaseUser(RunData rundata, Context context) {
        String userid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (userid == null) {
                logger.debug((Object)"Empty ID...");
                return null;
            }
            ALBaseUser user = (ALBaseUser)JetspeedSecurity.getUser((String)userid);
            if (user.getDisabled()) {
                return null;
            }
            return (ALBaseUser)JetspeedSecurity.getUser((String)userid);
        }
        catch (UnknownUserException uex) {
            logger.error((Object)("UnknownUserException : UserID = " + userid));
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipMCompany getEipMCompany(RunData rundata, Context context) {
        EipMCompany result = null;
        String id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            Expression exp;
            SelectQuery query;
            if (id == null || Integer.valueOf(id) == null) {
                logger.debug((Object)"Empty ID...");
                return result;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            List list = dataContext.performQuery((Query)(query = new SelectQuery(EipMCompany.class, exp = ExpressionFactory.matchDbExp((String)"COMPANY_ID", (Object)Integer.valueOf(id)))));
            if (list == null || list.size() == 0) {
                logger.debug((Object)"Not found ID...");
                return result;
            }
            result = (EipMCompany)list.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return result;
    }

    public static EipMPost getEipMPost(RunData rundata, Context context) {
        EipMPost result = null;
        String id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            Expression exp;
            SelectQuery query;
            if (id == null || Integer.valueOf(id) == null) {
                logger.debug((Object)"Empty ID...");
                return result;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            List list = dataContext.performQuery((Query)(query = new SelectQuery(EipMPost.class, exp = ExpressionFactory.matchDbExp((String)"POST_ID", (Object)Integer.valueOf(id)))));
            if (list == null || list.size() == 0) {
                logger.debug((Object)"Not found ID...");
                return result;
            }
            result = (EipMPost)list.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return result;
    }

    public static EipMPosition getEipMPosition(RunData rundata, Context context) {
        EipMPosition result = null;
        String id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            Expression exp;
            SelectQuery query;
            if (id == null || Integer.valueOf(id) == null) {
                logger.debug((Object)"Empty ID...");
                return result;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            List list = dataContext.performQuery((Query)(query = new SelectQuery(EipMPosition.class, exp = ExpressionFactory.matchDbExp((String)"POSITION_ID", (Object)Integer.valueOf(id)))));
            if (list == null || list.size() == 0) {
                logger.debug((Object)"Not found ID...");
                return result;
            }
            result = (EipMPosition)list.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return result;
    }

    public static String[] getCsvSplitStrings(String line) {
        if (line == null || line.equals("")) {
            return null;
        }
        try {
            ArrayList<String> list = new ArrayList<String>();
            int count_comma = 0;
            StringBuffer token = new StringBuffer("");
            int len = line.length();
            for (int i = 0; i < len; ++i) {
                char c = line.charAt(i);
                if (c != ',' && i == len - 1) {
                    token.append(c);
                    list.add(token.toString());
                } else {
                    if (c == ',') {
                        list.add(token.toString());
                        token = new StringBuffer("");
                        ++count_comma;
                        continue;
                    }
                    token.append(c);
                }
                if (count_comma > 11) break;
            }
            if (line.endsWith(",")) {
                list.add("");
            }
            String[] strings = new String[list.size()];
            strings = list.toArray(strings);
            return strings;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List getPostBeanList(int uid) {
        SelectQuery query = new SelectQuery(TurbineUserGroupRole.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"turbineUser", (Object)uid);
        Expression exp2 = ExpressionFactory.greaterExp((String)"turbineGroup", (Object)3);
        Expression exp3 = ExpressionFactory.matchExp((String)"turbineGroup.ownerId", (Object)1);
        query.setQualifier(exp1);
        query.andQualifier(exp2);
        query.andQualifier(exp3);
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        List list = dataContext.performQuery((Query)query);
        if (list == null || list.size() < 0) {
            return null;
        }
        ArrayList<UserGroupLiteBean> resultList = new ArrayList<UserGroupLiteBean>();
        TurbineUserGroupRole ugr = null;
        TurbineGroup group = null;
        UserGroupLiteBean bean = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ugr = (TurbineUserGroupRole)list.get(i);
            group = ugr.getTurbineGroup();
            bean = new UserGroupLiteBean();
            bean.initField();
            bean.setGroupId(group.getName());
            bean.setName(group.getGroupAliasName());
            resultList.add(bean);
        }
        return resultList;
    }
}

