/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.account;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cellular.util.CellularUtils;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.util.ALCellularUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.security.Principal;
import java.util.ArrayList;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.UserNamePrincipal;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.JetspeedUserManagement;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CellAccountEasyLoginFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CellAccountEasyLoginFormData.class.getName());
    private ALStringField cellular_uid;
    private String key;
    private ALBaseUser baseUser;
    private boolean enableEasyLogin = false;
    private String cellular_url;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        try {
            JetspeedRunData jdata = (JetspeedRunData)rundata;
            try {
                this.baseUser = (ALBaseUser)JetspeedUserManagement.getUser((Principal)new UserNamePrincipal(jdata.getJetspeedUser().getUserName()));
            }
            catch (JetspeedSecurityException e) {
                this.baseUser = (ALBaseUser)rundata.getUser();
            }
            this.cellular_url = CellularUtils.getCellularUrl((RunData)rundata, (Context)context);
            String uid = this.baseUser.getCelluarUId();
            this.enableEasyLogin = uid != null && uid.length() > 0;
        }
        catch (Exception e) {
            logger.error((Object)"[CellAccountEasyLoginFormData]", (Throwable)e);
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return;
        }
    }

    public void initField() {
        this.cellular_uid = new ALStringField();
        this.cellular_uid.setFieldName("\u643a\u5e2f\u96fb\u8a71\u306e\u56fa\u6709 ID");
        this.cellular_uid.setTrim(true);
    }

    protected void setValidator() {
        this.cellular_uid.setNotNull(true);
        this.cellular_uid.setCharacterType(3);
        this.cellular_uid.limitMaxLength(50);
    }

    protected boolean validate(ArrayList msgList) {
        this.cellular_uid.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            this.baseUser.setCelluarUId(this.cellular_uid.getValue());
            JetspeedSecurity.saveUser((JetspeedUser)this.baseUser);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            this.baseUser.setCelluarUId("");
            JetspeedSecurity.saveUser((JetspeedUser)this.baseUser);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean setFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res) {
            String celluid = ALCellularUtils.getCellularUid((RunData)rundata);
            this.cellular_uid.setValue(celluid);
            this.key = this.baseUser.getUserName() + "_" + ALCellularUtils.getCheckValueForCellLogin((String)this.baseUser.getUserName(), (String)this.baseUser.getUserId());
        }
        return res;
    }

    public ALStringField getCellularUid() {
        return this.cellular_uid;
    }

    public boolean enableEasyLogin() {
        return this.enableEasyLogin;
    }

    public String getKey() {
        return this.key;
    }

    public String getCellularUrl() {
        return this.cellular_url;
    }
}

