/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.account;

import com.aimluck.eip.account.AccountResultData;
import com.aimluck.eip.account.util.AccountUtils;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPosition;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccountUserSelectData
extends ALAbstractSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccountUserSelectData.class.getName());
    private String currentPost;
    private int registeredUserNum = 0;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"userposition");
        }
        super.init(action, rundata, context);
    }

    protected List selectList(RunData rundata, Context context) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List list = dataContext.performQuery((Query)query);
            this.registeredUserNum = list.size();
            return this.buildPaginatedList(list);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        String filter;
        SelectQuery query = new SelectQuery(TurbineUser.class);
        ObjectId oid = new ObjectId("TurbineUser", "USER_ID", 3);
        Expression exp1 = ExpressionFactory.matchAllDbExp((Map)oid.getIdSnapshot(), (int)6);
        Expression exp2 = ExpressionFactory.matchExp((String)"companyId", (Object)1);
        Expression exp3 = ExpressionFactory.matchExp((String)"disabled", (Object)"F");
        query.setQualifier(exp1);
        query.andQualifier(exp2);
        query.andQualifier(exp3);
        this.current_filter = filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        Map gMap = ALEipManager.getInstance().getPostMap();
        if (filter == null || "".equals(filter) || !gMap.containsKey(Integer.valueOf(filter))) {
            return query;
        }
        String groupName = ((ALEipPost)ALEipManager.getInstance().getPostMap().get(Integer.valueOf(filter))).getGroupName().getValue();
        Expression exp4 = ExpressionFactory.matchExp((String)"turbineUserGroupRole.turbineGroup.groupName", (Object)groupName);
        query.andQualifier(exp4);
        return query;
    }

    protected SelectQuery buildSelectQueryForFilter(SelectQuery query, RunData rundata, Context context) {
        String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        Map gMap = ALEipManager.getInstance().getPostMap();
        if (filter != null && filter.trim().length() != 0 && !gMap.containsKey(Integer.valueOf(filter))) {
            filter = null;
        }
        String filter_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR);
        String crt_key = null;
        Attributes map = this.getColumnMap();
        if (filter == null || filter_type == null || filter.equals("")) {
            return query;
        }
        crt_key = map.getValue(filter_type);
        if (crt_key == null) {
            return query;
        }
        Expression exp = ExpressionFactory.matchDbExp((String)crt_key, (Object)filter);
        query.andQualifier(exp);
        this.current_filter = filter;
        this.current_filter_type = filter_type;
        return query;
    }

    private String getPostName(int id) {
        if (ALEipManager.getInstance().getPostMap().containsKey(id)) {
            return ((ALEipPost)ALEipManager.getInstance().getPostMap().get(id)).getPostName().getValue();
        }
        return null;
    }

    private String getPositionName(int id) {
        if (ALEipManager.getInstance().getPositionMap().containsKey(id)) {
            return ((ALEipPosition)ALEipManager.getInstance().getPositionMap().get(id)).getPositionName().getValue();
        }
        return null;
    }

    protected Object selectDetail(RunData rundata, Context context) {
        return AccountUtils.getBaseUser(rundata, context);
    }

    protected Object getResultData(Object obj) {
        try {
            TurbineUser record = (TurbineUser)obj;
            AccountResultData rd = new AccountResultData();
            rd.initField();
            rd.setUserId(record.getUserId());
            rd.setUserName(record.getLoginName());
            rd.setName(new StringBuffer().append(record.getLastName()).append(" ").append(record.getFirstName()).toString());
            rd.setPostNameList(ALEipUtils.getPostNameList((int)record.getUserId()));
            rd.setPositionName(ALEipUtils.getPositionName((int)record.getPositionId()));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(Object obj) {
        try {
            ALBaseUser record = (ALBaseUser)obj;
            Integer id = new Integer(record.getUserId());
            AccountResultData rd = new AccountResultData();
            rd.initField();
            rd.setUserId(Integer.valueOf(record.getUserId()));
            rd.setUserName(record.getUserName());
            rd.setName(new StringBuffer().append(record.getLastName()).append(" ").append(record.getFirstName()).toString());
            rd.setNameKana(new StringBuffer().append(record.getLastNameKana()).append(" ").append(record.getFirstNameKana()).toString());
            rd.setEmail(record.getEmail());
            rd.setOutTelephone(record.getOutTelephone());
            rd.setInTelephone(record.getInTelephone());
            rd.setCellularPhone(record.getCellularPhone());
            rd.setCellularMail(record.getCellularMail());
            rd.setPostNameList(ALEipUtils.getPostNameList((int)id));
            rd.setPositionName(ALEipUtils.getPositionName((int)record.getPositionId()));
            if (record.getPhoto() != null) {
                rd.setHasPhoto(true);
            } else {
                rd.setHasPhoto(false);
            }
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("post", "POST_ID");
        map.putValue("login_name", "loginName");
        map.putValue("name_kana", "lastNameKana");
        map.putValue("userposition", "eipMUserPosition.position");
        return map;
    }

    public String getCurrentPost() {
        return this.currentPost;
    }

    public Map getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public int getRegisteredUserNum() {
        return this.registeredUserNum;
    }

    public int getRandomNum() {
        SecureRandom random = new SecureRandom();
        return random.nextInt() * 100;
    }
}

